/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework;

import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.execution.Executor;
import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.junit2.info.MethodLocation;
import com.intellij.execution.stacktrace.StackTraceLine;
import com.intellij.execution.testframework.JavaSMTRunnerTestTreeView;
import com.intellij.execution.testframework.ResetConfigurationModuleAdapter;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerTestTreeView;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerTestTreeViewProvider;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.diff.LineTokenizer;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.util.config.AbstractProperty;
import com.intellij.util.config.BooleanProperty;
import com.intellij.util.config.DumbAwareToggleBooleanProperty;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JavaAwareTestConsoleProperties<T extends ModuleBasedConfiguration<JavaRunConfigurationModule, Element>>
extends SMTRunnerConsoleProperties
implements SMTRunnerTestTreeViewProvider {
    public static final BooleanProperty USE_WALL_TIME = new BooleanProperty("useWallTime", false);

    public JavaAwareTestConsoleProperties(String testFrameworkName, RunConfiguration configuration, Executor executor) {
        super(configuration, testFrameworkName, executor);
        this.setPrintTestingStartedTime(false);
    }

    public boolean isPaused() {
        DebuggerSession debuggerSession = this.getDebugSession();
        return debuggerSession != null && debuggerSession.isPaused();
    }

    @NotNull
    public T getConfiguration() {
        ModuleBasedConfiguration moduleBasedConfiguration = (ModuleBasedConfiguration)super.getConfiguration();
        if (moduleBasedConfiguration == null) {
            JavaAwareTestConsoleProperties.$$$reportNull$$$0(0);
        }
        return (T)moduleBasedConfiguration;
    }

    public int getSelectionMode() {
        return 4;
    }

    public boolean fixEmptySuite() {
        return ResetConfigurationModuleAdapter.tryWithAnotherModule(this.getConfiguration(), this.isDebug());
    }

    @Nullable
    public Navigatable getErrorNavigatable(@NotNull Location<?> location, @NotNull String stacktrace) {
        if (location == null) {
            JavaAwareTestConsoleProperties.$$$reportNull$$$0(1);
        }
        if (stacktrace == null) {
            JavaAwareTestConsoleProperties.$$$reportNull$$$0(2);
        }
        return JavaAwareTestConsoleProperties.getStackTraceErrorNavigatable(location, stacktrace);
    }

    @Nullable
    public static Navigatable getStackTraceErrorNavigatable(@NotNull Location<?> location, @NotNull String stacktrace) {
        String[] stackTrace;
        PsiLocation psiLocation;
        PsiClass containingClass;
        if (location == null) {
            JavaAwareTestConsoleProperties.$$$reportNull$$$0(3);
        }
        if (stacktrace == null) {
            JavaAwareTestConsoleProperties.$$$reportNull$$$0(4);
        }
        if ((containingClass = (PsiClass)(psiLocation = location.toPsiLocation()).getParentElement(PsiClass.class)) == null && location instanceof MethodLocation) {
            containingClass = ((MethodLocation)location).getContainingClass();
        }
        if (containingClass == null) {
            return null;
        }
        String qualifiedName = containingClass.getQualifiedName();
        if (qualifiedName == null) {
            return null;
        }
        PsiMethod containingMethod = null;
        Iterator iterator = psiLocation.getAncestors(PsiMethod.class, false);
        while (iterator.hasNext()) {
            PsiMethod psiMethod = (PsiMethod)((Location)iterator.next()).getPsiElement();
            if (!containingClass.equals((Object)psiMethod.getContainingClass())) continue;
            containingMethod = psiMethod;
        }
        if (containingMethod == null) {
            return null;
        }
        String methodName = containingMethod.getName();
        StackTraceLine lastLine = null;
        for (String aStackTrace : stackTrace = new LineTokenizer(stacktrace).execute()) {
            StackTraceLine line = new StackTraceLine(containingClass.getProject(), aStackTrace);
            if (!methodName.equals(line.getMethodName()) || !qualifiedName.equals(line.getClassName())) continue;
            lastLine = line;
            break;
        }
        if (lastLine != null) {
            try {
                int lineNumber = lastLine.getLineNumber();
                PsiFile psiFile = containingClass.getContainingFile();
                Document document = PsiDocumentManager.getInstance((Project)containingClass.getProject()).getDocument(psiFile);
                TextRange textRange = containingMethod.getTextRange();
                if (textRange == null || document == null || lineNumber >= 0 && lineNumber < document.getLineCount() && textRange.contains(document.getLineStartOffset(lineNumber))) {
                    return new OpenFileDescriptor(containingClass.getProject(), psiFile.getVirtualFile(), lineNumber, 0);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    public DebuggerSession getDebugSession() {
        DebuggerManagerEx debuggerManager = DebuggerManagerEx.getInstanceEx((Project)this.getProject());
        Collection sessions = debuggerManager.getSessions();
        for (DebuggerSession debuggerSession : sessions) {
            if (this.getConsole() != debuggerSession.getProcess().getExecutionResult().getExecutionConsole()) continue;
            return debuggerSession;
        }
        return null;
    }

    public boolean isEditable() {
        return Registry.is((String)"editable.java.test.console");
    }

    @NotNull
    public SMTRunnerTestTreeView createSMTRunnerTestTreeView() {
        return Registry.is((String)"java.test.enable.tree.live.time") ? new JavaSMTRunnerTestTreeView((TestConsoleProperties)this) : new SMTRunnerTestTreeView();
    }

    public void appendAdditionalActions(DefaultActionGroup actionGroup, JComponent parent, TestConsoleProperties target) {
        super.appendAdditionalActions(actionGroup, parent, target);
        if (Registry.is((String)"java.test.enable.tree.live.time")) {
            actionGroup.addSeparator();
            DumbAwareToggleBooleanProperty property = new DumbAwareToggleBooleanProperty(JavaBundle.message((String)"java.test.use.wall.time", (Object[])new Object[0]), null, null, (AbstractProperty.AbstractPropertyContainer)target, USE_WALL_TIME);
            actionGroup.add((AnAction)property);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/testframework/JavaAwareTestConsoleProperties";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stacktrace";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfiguration";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/testframework/JavaAwareTestConsoleProperties";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getErrorNavigatable";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getStackTraceErrorNavigatable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4 -> new IllegalArgumentException(string);
        };
    }
}

