/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework;

import com.intellij.execution.filters.ExceptionInfoCache;
import com.intellij.execution.filters.ExceptionLineParser;
import com.intellij.execution.filters.ExceptionLineParserFactory;
import com.intellij.execution.testframework.actions.TestDiffProvider;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.siyeh.ig.testFrameworks.UAssertHint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParameter;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UResolvable;
import org.jetbrains.uast.UResolvableKt;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.expressions.UInjectionHost;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001&B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\"\u0010\n\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\tH\u0016J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J$\u0010\u0017\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0002J(\u0010\u001e\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u001f2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010 \u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\u001bH\u0002J\u001a\u0010\"\u001a\u0004\u0018\u00010\u00072\u0006\u0010#\u001a\u00020$2\u0006\u0010\u000e\u001a\u00020\tH\u0002J\f\u0010%\u001a\u00020\t*\u00020\tH\u0002\u00a8\u0006'"}, d2={"Lcom/intellij/execution/testframework/JvmTestDiffProvider;", "Lcom/intellij/execution/testframework/actions/TestDiffProvider;", "<init>", "()V", "updateExpected", "", "element", "Lcom/intellij/psi/PsiElement;", "actual", "", "findExpected", "project", "Lcom/intellij/openapi/project/Project;", "stackTrace", "expected", "findExpectedEntryPoint", "Lcom/intellij/execution/testframework/JvmTestDiffProvider$ExpectedEntryPoint;", "exceptionCache", "Lcom/intellij/execution/filters/ExceptionInfoCache;", "findExpectedEntryPointParam", "Lorg/jetbrains/uast/UParameter;", "call", "Lorg/jetbrains/uast/UCallExpression;", "findFailedCall", "file", "Lcom/intellij/psi/PsiFile;", "lineNumber", "", "resolvedMethod", "Lorg/jetbrains/uast/UMethod;", "getCallElementsInRange", "", "startOffset", "endOffset", "getExpectedElement", "expression", "Lorg/jetbrains/uast/UExpression;", "withoutLineEndings", "ExpectedEntryPoint", "intellij.java.execution.impl"})
@SourceDebugExtension(value={"SMAP\nJvmTestDiffProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmTestDiffProvider.kt\ncom/intellij/execution/testframework/JvmTestDiffProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 6 UResolvable.kt\norg/jetbrains/uast/UResolvableKt\n*L\n1#1,157:1\n1915#2:158\n1642#2,10:160\n1915#2:170\n1916#2:172\n1652#2:173\n1916#2:176\n296#2:180\n297#2:182\n18#3:159\n18#3:175\n18#3:183\n1#4:171\n1#4:174\n1342#5,2:177\n43#6:179\n43#6:181\n*S KotlinDebug\n*F\n+ 1 JvmTestDiffProvider.kt\ncom/intellij/execution/testframework/JvmTestDiffProvider\n*L\n58#1:158\n66#1:160,10\n66#1:170\n66#1:172\n66#1:173\n58#1:176\n129#1:180\n129#1:182\n62#1:159\n80#1:175\n150#1:183\n66#1:171\n99#1:177,2\n116#1:179\n130#1:181\n*E\n"})
public final class JvmTestDiffProvider
implements TestDiffProvider {
    public void updateExpected(@NotNull PsiElement element, @NotNull String actual) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)actual, (String)"actual");
            ElementManipulator elementManipulator = ElementManipulators.getManipulator((PsiElement)element);
            if (elementManipulator == null) break block0;
            elementManipulator.handleContentChange(element, actual);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public PsiElement findExpected(@NotNull Project project, @NotNull String stackTrace, @NotNull String expected) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)stackTrace, (String)"stackTrace");
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        ExceptionInfoCache exceptionCache = new ExceptionInfoCache(project, GlobalSearchScope.allScope((Project)project));
        ExpectedEntryPoint expectedEntryPoint = this.findExpectedEntryPoint(stackTrace, exceptionCache);
        if (expectedEntryPoint == null) {
            return null;
        }
        ExpectedEntryPoint entryPoint = expectedEntryPoint;
        String searchStacktrace = entryPoint.getStackTrace();
        UParameter expectedParam = null;
        expectedParam = entryPoint.getParam();
        ExceptionLineParser lineParser = ExceptionLineParserFactory.getInstance().create(exceptionCache);
        List expectedArgCandidates = new ArrayList();
        Iterable $this$forEach$iv = StringsKt.lines((CharSequence)searchStacktrace);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UExpression expectedArg;
            UMethod containingMethod;
            JvmTestDiffProvider diffProvider;
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            UCallExpression failedCall;
            PsiFile file;
            String line = (String)element$iv;
            boolean bl = false;
            ProgressManager.checkCanceled();
            if (lineParser.execute(line, line.length()) == null) {
                return null;
            }
            if (lineParser.getFile() == null) {
                return null;
            }
            Object $this$asSafely$iv = TestDiffProvider.getProviderByLanguage((Language)file.getLanguage());
            boolean $i$f$asSafely = false;
            TestDiffProvider testDiffProvider = $this$asSafely$iv;
            if (!(testDiffProvider instanceof JvmTestDiffProvider)) {
                testDiffProvider = null;
            }
            if ((JvmTestDiffProvider)testDiffProvider == null) {
                return null;
            }
            UParameter uParameter = expectedParam;
            if (this.findFailedCall(file, lineParser.getInfo().lineNumber, (UMethod)(uParameter != null ? UastUtils.getContainingUMethod((UElement)((UElement)uParameter)) : null)) == null) {
                return null;
            }
            PsiElement psiElement = failedCall.getSourcePsi();
            boolean bl2 = psiElement != null ? psiElement.isValid() : false;
            if (!bl2) continue;
            $this$asSafely$iv = failedCall.getValueArguments();
            List list = expectedArgCandidates;
            boolean $i$f$mapNotNull = false;
            void var22_23 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach2 = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                PsiElement it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl3 = false;
                UExpression it = (UExpression)element$iv$iv;
                boolean bl4 = false;
                if (diffProvider.getExpectedElement(it, expected) == null) continue;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            list.addAll((List)destination$iv$iv);
            if (expectedParam == null) continue;
            if (UastUtils.getContainingUMethod((UElement)((UElement)expectedParam)) == null) {
                return null;
            }
            if (failedCall.getArgumentForParameter(containingMethod.getUastParameters().indexOf(expectedParam)) == null) {
                return null;
            }
            PsiElement psiElement2 = diffProvider.getExpectedElement(expectedArg, expected);
            if (psiElement2 != null) {
                PsiElement it = psiElement2;
                boolean bl6 = false;
                return it;
            }
            if (!(expectedArg instanceof UReferenceExpression)) continue;
            PsiElement psiElement3 = expectedArg.getSourcePsi();
            boolean bl7 = psiElement3 != null ? psiElement3.isValid() : false;
            if (bl7) {
                UParameter uParameter2;
                UElement resolved = UResolvableKt.resolveToUElement((UResolvable)((UResolvable)expectedArg));
                if (resolved instanceof UVariable) {
                    if (((UVariable)resolved).getUastInitializer() != null) {
                        UExpression initializer;
                        boolean bl8 = false;
                        PsiElement psiElement4 = diffProvider.getExpectedElement(initializer, expected);
                        if (psiElement4 != null) {
                            PsiElement it = psiElement4;
                            boolean bl9 = false;
                            return it;
                        }
                    }
                }
                if (resolved instanceof UParameter && ((UParameter)resolved).getUastParent() instanceof UMethod) {
                    UMethod method;
                    if (((UParameter)resolved).getUastParent() != null) {
                        UElement $this$asSafely$iv2;
                        boolean $i$f$asSafely2 = false;
                        UElement uElement = $this$asSafely$iv2;
                        if (!(uElement instanceof UMethod)) {
                            uElement = null;
                        }
                        v10 = (UMethod)uElement;
                    } else {
                        v10 = method = null;
                    }
                    uParameter2 = method != null && !method.isConstructor() ? (UParameter)resolved : null;
                } else {
                    uParameter2 = null;
                }
                expectedParam = uParameter2;
                continue;
            }
            expectedParam = null;
        }
        if (expectedArgCandidates.size() == 1) {
            return (PsiElement)CollectionsKt.first((List)expectedArgCandidates);
        }
        return null;
    }

    private final ExpectedEntryPoint findExpectedEntryPoint(String stackTrace, ExceptionInfoCache exceptionCache) {
        ExceptionLineParser lineParser = ExceptionLineParserFactory.getInstance().create(exceptionCache);
        Sequence $this$forEach$iv = StringsKt.lineSequence((CharSequence)stackTrace);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UCallExpression failedCall;
            PsiFile file;
            String line = (String)element$iv;
            boolean bl = false;
            ProgressManager.checkCanceled();
            if (lineParser.execute(line, line.length()) == null) continue;
            if (lineParser.getFile() == null) {
                return null;
            }
            if (this.findFailedCall(file, lineParser.getInfo().lineNumber, null) == null) continue;
            UParameter uParameter = this.findExpectedEntryPointParam(failedCall);
            if (uParameter == null) continue;
            UParameter entryParam = uParameter;
            return new ExpectedEntryPoint(line + StringsKt.substringAfter$default((String)stackTrace, (String)line, null, (int)2, null), entryParam);
        }
        return null;
    }

    private final UParameter findExpectedEntryPointParam(UCallExpression call) {
        PsiElement psiElement = call.getSourcePsi();
        if (psiElement == null) {
            return null;
        }
        PsiElement srcCall = psiElement;
        if (!srcCall.isValid()) {
            return null;
        }
        UAssertHint uAssertHint = UAssertHint.Companion.createAssertEqualsHint(call);
        if (uAssertHint == null) {
            return null;
        }
        UAssertHint assertHint = uAssertHint;
        PsiClassType psiClassType = PsiType.getJavaLangString((PsiManager)srcCall.getManager(), (GlobalSearchScope)srcCall.getResolveScope());
        Intrinsics.checkNotNullExpressionValue((Object)psiClassType, (String)"getJavaLangString(...)");
        PsiClassType stringType = psiClassType;
        if (!Intrinsics.areEqual((Object)((UExpression)assertHint.getExpected()).getExpressionType(), (Object)stringType) || !Intrinsics.areEqual((Object)((UExpression)assertHint.getActual()).getExpressionType(), (Object)stringType)) {
            return null;
        }
        UResolvable $this$resolveToUElementOfType$iv = (UResolvable)call;
        boolean $i$f$resolveToUElementOfType = false;
        UElement uElement = UResolvableKt.resolveToUElement((UResolvable)$this$resolveToUElementOfType$iv);
        if (!(uElement instanceof UMethod)) {
            uElement = null;
        }
        UMethod uMethod = (UMethod)((UElement)((UMethod)uElement));
        if (uMethod == null) {
            return null;
        }
        UMethod method = uMethod;
        if (!Intrinsics.areEqual((Object)method.getName(), (Object)"assertEquals")) {
            return null;
        }
        return (UParameter)CollectionsKt.firstOrNull((List)method.getUastParameters());
    }

    private final UCallExpression findFailedCall(PsiFile file, int lineNumber, UMethod resolvedMethod) {
        UCallExpression uCallExpression;
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile virtualFile2 = virtualFile;
        Document document = FileDocumentManager.getInstance().getDocument(virtualFile2);
        if (document == null) {
            return null;
        }
        Document document2 = document;
        if (lineNumber < 1 || lineNumber > document2.getLineCount()) {
            return null;
        }
        int startOffset = document2.getLineStartOffset(lineNumber - 1);
        int endOffset = document2.getLineEndOffset(lineNumber - 1);
        List<UCallExpression> list = this.getCallElementsInRange(file, startOffset, endOffset);
        if (list == null) {
            return null;
        }
        List<UCallExpression> candidateCalls = list;
        if (candidateCalls.size() != 1) {
            Object v7;
            block10: {
                Iterable $this$firstOrNull$iv = candidateCalls;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    boolean bl;
                    UMethod uMethod;
                    UCallExpression call = (UCallExpression)element$iv;
                    boolean bl2 = false;
                    UResolvable $this$resolveToUElementOfType$iv = (UResolvable)call;
                    boolean $i$f$resolveToUElementOfType = false;
                    UElement uElement = UResolvableKt.resolveToUElement((UResolvable)$this$resolveToUElementOfType$iv);
                    if (!(uElement instanceof UMethod)) {
                        uElement = null;
                    }
                    if ((uMethod = (UMethod)((UElement)((UMethod)uElement))) != null && (uMethod = uMethod.getSourcePsi()) != null) {
                        UMethod uMethod2 = resolvedMethod;
                        bl = uMethod.isEquivalentTo((PsiElement)(uMethod2 != null ? uMethod2.getSourcePsi() : null));
                    } else {
                        bl = false;
                    }
                    if (!bl) continue;
                    v7 = element$iv;
                    break block10;
                }
                v7 = null;
            }
            uCallExpression = v7;
        } else {
            uCallExpression = (UCallExpression)CollectionsKt.first(candidateCalls);
        }
        return uCallExpression;
    }

    private final List<UCallExpression> getCallElementsInRange(PsiFile file, int startOffset, int endOffset) {
        PsiElement psiElement = file.findElementAt(startOffset);
        if (psiElement == null) {
            return null;
        }
        PsiElement startElement = psiElement;
        int searchStartOffset = PsiTreeUtilKt.getStartOffset((PsiElement)startElement);
        List calls = new ArrayList();
        for (PsiElement curElement = startElement; curElement != null; curElement = curElement.getNextSibling()) {
            int n = PsiTreeUtilKt.getStartOffset((PsiElement)curElement);
            boolean bl = searchStartOffset <= n ? n <= endOffset : false;
            if (!bl) break;
            UCallExpression callExpression = UastUtils.getUCallExpression((UElement)UastContextKt.toUElement((PsiElement)curElement), (int)2);
            if (callExpression == null) continue;
            calls.add(callExpression);
        }
        return calls;
    }

    private final PsiElement getExpectedElement(UExpression expression, String expected) {
        Object object;
        UExpression $this$asSafely$iv = expression;
        boolean $i$f$asSafely = false;
        UExpression uExpression = $this$asSafely$iv;
        if (!(uExpression instanceof UInjectionHost)) {
            uExpression = null;
        }
        if (Intrinsics.areEqual((object = (UInjectionHost)uExpression) != null && (object = UastUtils.evaluateString((UExpression)((UExpression)object))) != null ? this.withoutLineEndings((String)object) : null, (Object)expected)) {
            return expression.getSourcePsi();
        }
        return null;
    }

    private final String withoutLineEndings(String $this$withoutLineEndings) {
        return StringsKt.replace$default((String)StringsKt.replace$default((String)$this$withoutLineEndings, (String)"\n", (String)"", (boolean)false, (int)4, null), (String)"\r", (String)"", (boolean)false, (int)4, null);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0014\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0012\u001a\u00020\u0013H\u00d6\u0081\u0004J\n\u0010\u0014\u001a\u00020\u0003H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/intellij/execution/testframework/JvmTestDiffProvider$ExpectedEntryPoint;", "", "stackTrace", "", "param", "Lorg/jetbrains/uast/UParameter;", "<init>", "(Ljava/lang/String;Lorg/jetbrains/uast/UParameter;)V", "getStackTrace", "()Ljava/lang/String;", "getParam", "()Lorg/jetbrains/uast/UParameter;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.java.execution.impl"})
    private static final class ExpectedEntryPoint {
        @NotNull
        private final String stackTrace;
        @NotNull
        private final UParameter param;

        public ExpectedEntryPoint(@NotNull String stackTrace, @NotNull UParameter param) {
            Intrinsics.checkNotNullParameter((Object)stackTrace, (String)"stackTrace");
            Intrinsics.checkNotNullParameter((Object)param, (String)"param");
            this.stackTrace = stackTrace;
            this.param = param;
        }

        @NotNull
        public final String getStackTrace() {
            return this.stackTrace;
        }

        @NotNull
        public final UParameter getParam() {
            return this.param;
        }

        @NotNull
        public final String component1() {
            return this.stackTrace;
        }

        @NotNull
        public final UParameter component2() {
            return this.param;
        }

        @NotNull
        public final ExpectedEntryPoint copy(@NotNull String stackTrace, @NotNull UParameter param) {
            Intrinsics.checkNotNullParameter((Object)stackTrace, (String)"stackTrace");
            Intrinsics.checkNotNullParameter((Object)param, (String)"param");
            return new ExpectedEntryPoint(stackTrace, param);
        }

        public static /* synthetic */ ExpectedEntryPoint copy$default(ExpectedEntryPoint expectedEntryPoint, String string, UParameter uParameter, int n, Object object) {
            if ((n & 1) != 0) {
                string = expectedEntryPoint.stackTrace;
            }
            if ((n & 2) != 0) {
                uParameter = expectedEntryPoint.param;
            }
            return expectedEntryPoint.copy(string, uParameter);
        }

        @NotNull
        public String toString() {
            return "ExpectedEntryPoint(stackTrace=" + this.stackTrace + ", param=" + this.param + ")";
        }

        public int hashCode() {
            int result = this.stackTrace.hashCode();
            result = result * 31 + this.param.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ExpectedEntryPoint)) {
                return false;
            }
            ExpectedEntryPoint expectedEntryPoint = (ExpectedEntryPoint)other;
            if (!Intrinsics.areEqual((Object)this.stackTrace, (Object)expectedEntryPoint.stackTrace)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.param, (Object)expectedEntryPoint.param);
        }
    }
}

