/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework;

import com.intellij.execution.CommonJavaRunConfigurationParameters;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.JavaTestConfigurationBase;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.testframework.TestSearchScope;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.util.Function;
import com.intellij.util.ui.UIUtil;
import java.util.HashSet;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class ResetConfigurationModuleAdapter
extends HyperlinkAdapter {
    private static final Logger LOG = Logger.getInstance(ResetConfigurationModuleAdapter.class);
    private final Project myProject;
    private final boolean myIsDebug;
    private final ToolWindowManager myToolWindowManager;
    private final String myTestRunDebugId;
    private final ModuleBasedConfiguration myConfiguration;

    public ResetConfigurationModuleAdapter(ModuleBasedConfiguration configuration, Project project, boolean isDebug, ToolWindowManager toolWindowManager, String testRunDebugId) {
        this.myProject = project;
        this.myIsDebug = isDebug;
        this.myToolWindowManager = toolWindowManager;
        this.myTestRunDebugId = testRunDebugId;
        this.myConfiguration = configuration;
    }

    public static <T extends ModuleBasedConfiguration<JavaRunConfigurationModule, Element>> boolean tryWithAnotherModule(final T configuration, boolean isDebug) {
        PsiDirectory[] directories;
        String packageName = ((CommonJavaRunConfigurationParameters)configuration).getPackage();
        if (packageName == null) {
            return false;
        }
        Project project = configuration.getProject();
        PsiPackage aPackage = JavaPsiFacade.getInstance((Project)project).findPackage(packageName);
        if (aPackage == null) {
            return false;
        }
        Module module = ((JavaRunConfigurationModule)configuration.getConfigurationModule()).getModule();
        if (module == null) {
            return false;
        }
        String testRunDebugId = isDebug ? "Debug" : "Run";
        ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)project);
        if (configuration instanceof JavaTestConfigurationBase && ((JavaTestConfigurationBase)configuration).getTestSearchScope() == TestSearchScope.SINGLE_MODULE && (directories = (PsiDirectory[])ReadAction.compute(() -> aPackage.getDirectories(GlobalSearchScope.moduleWithDependenciesScope((Module)module)))).length > ((PsiDirectory[])ReadAction.compute(() -> aPackage.getDirectories(GlobalSearchScope.moduleScope((Module)module)))).length) {
            String message = new HtmlBuilder().append(JavaBundle.message((String)"popup.content.tests.were.not.found.in.module", (Object[])new Object[]{module.getName()})).appendLink("scope", JavaBundle.message((String)"popup.content.tests.were.not.found.in.module.search.in.dependencies", (Object[])new Object[0])).toString();
            ResetConfigurationModuleAdapter listener = new ResetConfigurationModuleAdapter(configuration, project, isDebug, toolWindowManager, testRunDebugId){

                @Override
                protected void hyperlinkActivated(@NotNull HyperlinkEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    ((JavaTestConfigurationBase)configuration).setSearchScope(TestSearchScope.MODULE_WITH_DEPENDENCIES);
                    this.restart();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/execution/testframework/ResetConfigurationModuleAdapter$1", "hyperlinkActivated"));
                }
            };
            UIUtil.invokeLaterIfNeeded(() -> toolWindowManager.notifyByBalloon(testRunDebugId, MessageType.WARNING, message, null, (HyperlinkListener)((Object)listener)));
            return true;
        }
        HashSet modulesWithPackage = new HashSet();
        ReadAction.run(() -> {
            PsiDirectory[] directories;
            for (PsiDirectory directory : directories = (PsiDirectory[])ReadAction.compute(() -> aPackage.getDirectories())) {
                Module currentModule = ModuleUtilCore.findModuleForFile((VirtualFile)directory.getVirtualFile(), (Project)project);
                if (module == currentModule || currentModule == null) continue;
                modulesWithPackage.add(currentModule);
            }
        });
        if (!modulesWithPackage.isEmpty()) {
            Function moduleNameRef = module1 -> {
                String moduleName = module1.getName();
                return "<a href=\"" + moduleName + "\">" + moduleName + "</a>";
            };
            String message = JavaBundle.message((String)"popup.content.tests.were.not.found.in.module", (Object[])new Object[]{module.getName()}) + JavaBundle.message((String)"popup.content.tests.were.not.found.in.module.use.instead", (Object[])new Object[]{modulesWithPackage.size() == 1 ? 0 : 1, moduleNameRef.fun((Object)((Module)modulesWithPackage.iterator().next())), StringUtil.join(modulesWithPackage, (Function)moduleNameRef, (String)"\n")});
            UIUtil.invokeLaterIfNeeded(() -> toolWindowManager.notifyByBalloon(testRunDebugId, MessageType.WARNING, message, null, (HyperlinkListener)((Object)new ResetConfigurationModuleAdapter(configuration, project, isDebug, toolWindowManager, testRunDebugId))));
            return true;
        }
        return false;
    }

    protected void hyperlinkActivated(@NotNull HyperlinkEvent e) {
        Module moduleByName;
        if (e == null) {
            ResetConfigurationModuleAdapter.$$$reportNull$$$0(0);
        }
        if ((moduleByName = ModuleManager.getInstance((Project)this.myProject).findModuleByName(e.getDescription())) != null) {
            this.myConfiguration.getConfigurationModule().setModule(moduleByName);
            this.restart();
        }
    }

    protected void restart() {
        try {
            Executor executor = this.myIsDebug ? DefaultDebugExecutor.getDebugExecutorInstance() : DefaultRunExecutor.getRunExecutorInstance();
            ExecutionEnvironmentBuilder.create((Project)this.myProject, (Executor)executor, (RunProfile)this.myConfiguration).contentToReuse(null).buildAndExecute();
            Balloon balloon = this.myToolWindowManager.getToolWindowBalloon(this.myTestRunDebugId);
            if (balloon != null) {
                balloon.hide();
            }
        }
        catch (ExecutionException e1) {
            LOG.error((Throwable)e1);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/execution/testframework/ResetConfigurationModuleAdapter", "hyperlinkActivated"));
    }
}

