/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui;

import com.intellij.application.options.ModuleDescriptionsComboBox;
import com.intellij.execution.ShortenCommandLine;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.ui.JrePathEditor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ObjectUtils;
import java.awt.event.ActionListener;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShortenCommandLineModeCombo
extends ComboBox<ShortenCommandLine> {
    private final Supplier<ShortenCommandLine> myDefaultMethodSupplier = () -> ShortenCommandLine.getDefaultMethod((Project)project, (String)this.getJdkRoot(pathEditor, (Module)component.get()));

    public ShortenCommandLineModeCombo(Project project, JrePathEditor pathEditor, ModuleDescriptionsComboBox component) {
        this(project, pathEditor, () -> ((ModuleDescriptionsComboBox)component).getSelectedModule(), arg_0 -> component.addActionListener(arg_0));
    }

    public ShortenCommandLineModeCombo(Project project, JrePathEditor pathEditor, Supplier<? extends Module> component, Consumer<? super ActionListener> listenerConsumer) {
        this.initModel(this.myDefaultMethodSupplier.get(), pathEditor, component.get());
        this.setRenderer((ListCellRenderer)new ColoredListCellRenderer<ShortenCommandLine>(){

            protected void customizeCellRenderer(@NotNull JList<? extends ShortenCommandLine> list, ShortenCommandLine value, int index, boolean selected, boolean hasFocus) {
                if (list == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.append(value.getPresentableName()).append(" - " + value.getDescription(), SimpleTextAttributes.GRAYED_ATTRIBUTES);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/execution/ui/ShortenCommandLineModeCombo$1", "customizeCellRenderer"));
            }
        });
        ActionListener updateModelListener = e -> {
            ShortenCommandLine item = this.getSelectedItem();
            this.initModel(item, pathEditor, (Module)component.get());
        };
        pathEditor.addActionListener(updateModelListener);
        listenerConsumer.accept(updateModelListener);
    }

    private void initModel(ShortenCommandLine preselection, JrePathEditor pathEditor, Module module) {
        this.removeAllItems();
        String jdkRoot = this.getJdkRoot(pathEditor, module);
        for (ShortenCommandLine mode : ShortenCommandLine.values()) {
            if (!mode.isApplicable(jdkRoot)) continue;
            this.addItem(mode);
        }
        this.setSelectedItem(preselection);
    }

    @Nullable
    private String getJdkRoot(JrePathEditor pathEditor, Module module) {
        if (!pathEditor.isAlternativeJreSelected()) {
            if (module != null) {
                Sdk sdk = JavaParameters.getJdkToRunModule((Module)module, (boolean)this.productionOnly());
                return sdk != null ? sdk.getHomePath() : null;
            }
            return null;
        }
        String jrePathOrName = pathEditor.getJrePathOrName();
        if (jrePathOrName != null) {
            Sdk configuredJdk = ProjectJdkTable.getInstance().findJdk(jrePathOrName);
            if (configuredJdk != null) {
                return configuredJdk.getHomePath();
            }
            return jrePathOrName;
        }
        return null;
    }

    protected boolean productionOnly() {
        return true;
    }

    @Nullable
    public ShortenCommandLine getSelectedItem() {
        return (ShortenCommandLine)super.getSelectedItem();
    }

    public void setSelectedItem(Object anObject) {
        super.setSelectedItem(ObjectUtils.notNull((Object)anObject, (Object)this.myDefaultMethodSupplier.get()));
    }
}

