/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui;

import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.TailTypes;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.impl.CamelHumpMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.codeInsight.lookup.TailTypeDecorator;
import com.intellij.execution.JavaRunConfigurationBase;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.ui.VmOptionsEditor;
import com.intellij.execution.vmOptions.JdkOptionsData;
import com.intellij.execution.vmOptions.VMOption;
import com.intellij.execution.vmOptions.VMOptionKind;
import com.intellij.execution.vmOptions.VMOptionLookupElementDecorator;
import com.intellij.execution.vmOptions.VMOptionVariant;
import com.intellij.execution.vmOptions.VMOptionsService;
import com.intellij.ide.actions.EditCustomVmOptionsAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.ex.PathUtilEx;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VmOptionsCompletionContributor
extends CompletionContributor
implements DumbAware {
    private static final Pattern OPTION_SEPARATOR = Pattern.compile("\\s+");
    private static final Pattern OPTION_MATCHER = Pattern.compile("^-XX:[+\\-]?(\\w+)(=.+)?$");
    private static final char OPTION_VALUE_SEPRATOR = '=';

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        int offset;
        Document document;
        String jrePath;
        if (parameters == null) {
            VmOptionsCompletionContributor.$$$reportNull$$$0(0);
        }
        if (result == null) {
            VmOptionsCompletionContributor.$$$reportNull$$$0(1);
        }
        if ((jrePath = VmOptionsCompletionContributor.getJrePathForVmOptionsDocument(document = parameters.getEditor().getDocument())) == null) {
            return;
        }
        CompletableFuture<JdkOptionsData> jdk = VMOptionsService.getInstance().getOrComputeOptionsForJdk(jrePath);
        JdkOptionsData data = (JdkOptionsData)ProgressIndicatorUtils.awaitWithCheckCanceled(jdk);
        if (data == null) {
            return;
        }
        String currentText = document.getText();
        for (offset = parameters.getOffset(); offset > 0 && Character.isAlphabetic(currentText.charAt(offset - 1)); --offset) {
        }
        JavaRunConfigurationBase settings = (JavaRunConfigurationBase)document.getUserData(VmOptionsEditor.SETTINGS_KEY);
        if (VmOptionsCompletionContributor.addXxCompletion(result, data, offset, currentText) || VmOptionsCompletionContributor.addSimpleOptions(result, settings, data, parameters.getOffset(), currentText)) {
            result.stopHere();
        }
    }

    private static boolean addSimpleOptions(@NotNull CompletionResultSet result, @Nullable JavaRunConfigurationBase settings, @NotNull JdkOptionsData data, int offset, @NotNull String text) {
        int optionStart;
        if (result == null) {
            VmOptionsCompletionContributor.$$$reportNull$$$0(2);
        }
        if (data == null) {
            VmOptionsCompletionContributor.$$$reportNull$$$0(3);
        }
        if (text == null) {
            VmOptionsCompletionContributor.$$$reportNull$$$0(4);
        }
        for (optionStart = offset; optionStart > 0 && !Character.isWhitespace(text.charAt(optionStart - 1)); --optionStart) {
            if (text.charAt(optionStart - 1) != '=') continue;
            return false;
        }
        String optionText = text.substring(optionStart, offset);
        result = result.withPrefixMatcher(result.getPrefixMatcher().cloneWithPrefix(optionText));
        VmOptionsCompletionContributor.addDashOptions(result, settings, data);
        return true;
    }

    private static void addDashOptions(@NotNull CompletionResultSet result, @Nullable JavaRunConfigurationBase settings, @NotNull JdkOptionsData data) {
        if (result == null) {
            VmOptionsCompletionContributor.$$$reportNull$$$0(5);
        }
        if (data == null) {
            VmOptionsCompletionContributor.$$$reportNull$$$0(6);
        }
        Stream.of(data.getOptions().stream().filter(option1 -> option1.getVariant() != VMOptionVariant.XX), settings == null ? null : settings.getKnownVMOptions().stream()).flatMap(Function.identity()).forEach(option -> {
            String fullLookup = option.getVariant().prefix() + option.getOptionName();
            LookupElementBuilder builder = LookupElementBuilder.create(option.createPointer(), (String)fullLookup).withTypeText(option.getType()).withPresentableText(fullLookup);
            VMOptionLookupElementDecorator decorator = option.getDecorator();
            if (decorator != null) {
                result.addElement(decorator.tune((LookupElement)builder));
            } else {
                Character suffix = option.getVariant().suffix();
                TailType tailType = suffix == null ? null : TailTypes.charType((char)suffix.charValue());
                result.addElement((LookupElement)TailTypeDecorator.withTail((LookupElement)builder, (TailType)tailType));
            }
        });
    }

    private static boolean addXxCompletion(@NotNull CompletionResultSet result, @NotNull JdkOptionsData data, int offset, @NotNull String text) {
        if (result == null) {
            VmOptionsCompletionContributor.$$$reportNull$$$0(7);
        }
        if (data == null) {
            VmOptionsCompletionContributor.$$$reportNull$$$0(8);
        }
        if (text == null) {
            VmOptionsCompletionContributor.$$$reportNull$$$0(9);
        }
        boolean booleanStart = false;
        if (offset > 0 && (text.charAt(offset - 1) == '+' || text.charAt(offset - 1) == '-')) {
            --offset;
            booleanStart = true;
        }
        if (!VmOptionsCompletionContributor.hasOptionPrefix(text, offset, "-XX:")) {
            return false;
        }
        ArrayList<TailTypeDecorator> elements = new ArrayList<TailTypeDecorator>();
        Set existingOptions = OPTION_SEPARATOR.splitAsStream(text).map(OPTION_MATCHER::matcher).filter(Matcher::matches).map(matcher -> matcher.group(1)).collect(Collectors.toSet());
        for (VMOption option : data.getOptions()) {
            if (option.getVariant() != VMOptionVariant.XX || existingOptions.contains(option.getOptionName())) continue;
            String type = option.getType();
            LookupElementBuilder e = null;
            TailType tailType = null;
            Icon icon = option.getKind().icon();
            if ("bool".equals(type)) {
                String lookupString = (booleanStart ? "" : (Boolean.parseBoolean(option.getDefaultValue()) ? "-" : "+")) + option.getOptionName();
                tailType = TailTypes.spaceType();
                e = LookupElementBuilder.create(option.createPointer(), (String)lookupString);
            } else if (!booleanStart) {
                String tailText = " = " + option.getDefaultValue();
                tailType = TailTypes.equalsType();
                e = LookupElementBuilder.create(option.createPointer(), (String)option.getOptionName()).withTailText(tailText, true);
            }
            if (e == null) continue;
            TailTypeDecorator element = TailTypeDecorator.withTail((LookupElement)e.withTypeText(type).withIcon(icon), (TailType)tailType);
            InsertHandler<LookupElement> handler = VmOptionsCompletionContributor.getInsertHandler(option.getKind());
            if (handler != null) {
                element = LookupElementDecorator.withDelegateInsertHandler((LookupElement)element, handler);
            }
            elements.add(element);
        }
        result = result.withPrefixMatcher((PrefixMatcher)new CamelHumpMatcher(result.getPrefixMatcher().getPrefix(), false));
        result.addAllElements(elements);
        return true;
    }

    private static InsertHandler<LookupElement> getInsertHandler(VMOptionKind kind) {
        String unlockOption = kind.unlockOption();
        return unlockOption == null ? null : (context, item) -> VmOptionsCompletionContributor.unlock(context, unlockOption);
    }

    private static void unlock(InsertionContext context, String option) {
        Document document = context.getDocument();
        if (document.getCharsSequence().toString().contains(option)) {
            return;
        }
        document.insertString(0, (CharSequence)(option + (context.getEditor().isOneLineMode() ? " " : "\n")));
    }

    private static boolean hasOptionPrefix(@NotNull CharSequence sequence, int offset, @NotNull String xxPrefix) {
        if (sequence == null) {
            VmOptionsCompletionContributor.$$$reportNull$$$0(10);
        }
        if (xxPrefix == null) {
            VmOptionsCompletionContributor.$$$reportNull$$$0(11);
        }
        return offset >= xxPrefix.length() && sequence.subSequence(offset - xxPrefix.length(), offset).toString().equals(xxPrefix) && (offset == xxPrefix.length() || Character.isWhitespace(sequence.charAt(offset - xxPrefix.length() - 1)));
    }

    @Nullable
    private static String getJrePathForVmOptionsDocument(Document document) {
        String path = (String)document.getUserData(EditCustomVmOptionsAction.JRE_PATH_KEY);
        if (path != null) {
            return path;
        }
        JavaRunConfigurationBase settings = (JavaRunConfigurationBase)document.getUserData(VmOptionsEditor.SETTINGS_KEY);
        if (settings == null) {
            return null;
        }
        return VmOptionsCompletionContributor.getJrePath(settings);
    }

    @Nullable
    private static String getJrePath(JavaRunConfigurationBase settings) {
        Module module;
        String jrePath = null;
        Sdk sdk = settings.isAlternativeJrePathEnabled() ? ((jrePath = settings.getAlternativeJrePath()) == null ? null : ProjectJdkTable.getInstance().findJdk(jrePath)) : ((module = ((JavaRunConfigurationModule)settings.getConfigurationModule()).getModule()) != null ? JavaParameters.getJdkToRunModule((Module)module, (boolean)false) : PathUtilEx.getAnyJdk((Project)settings.getProject()));
        if (sdk != null) {
            jrePath = sdk.getHomePath();
        }
        return jrePath;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xxPrefix";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/ui/VmOptionsCompletionContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "fillCompletionVariants";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "addSimpleOptions";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "addDashOptions";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "addXxCompletion";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "hasOptionPrefix";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

