/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.JavaRunConfigurationBase;
import com.intellij.execution.ui.CommandLinePanel;
import com.intellij.execution.ui.CommonParameterFragments;
import com.intellij.execution.ui.FragmentWrapper;
import com.intellij.openapi.editor.SpellCheckingEditorCustomizationProvider;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.util.Key;
import com.intellij.ui.EditorCustomization;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.Expandable;
import com.intellij.ui.ExpandableEditorSupport;
import com.intellij.ui.LanguageTextField;
import com.intellij.util.execution.ParametersListUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class VmOptionsEditor
extends JPanel
implements FragmentWrapper,
Expandable {
    public static final Key<JavaRunConfigurationBase> SETTINGS_KEY = Key.create((String)"JavaRunConfigurationSettings");
    private final LanguageTextField myEditor;
    private LanguageTextField myPopupEditor;
    private final ExpandableEditorSupport mySupport;

    @ApiStatus.Internal
    public VmOptionsEditor(final JavaRunConfigurationBase settings) {
        super(new BorderLayout());
        this.myEditor = new LanguageTextField(FileTypes.PLAIN_TEXT.getLanguage(), settings.getProject(), "", true);
        String message = ExecutionBundle.message((String)"run.configuration.java.vm.parameters.empty.text", (Object[])new Object[0]);
        this.myEditor.getAccessibleContext().setAccessibleName(message);
        this.myEditor.setPlaceholder((CharSequence)message);
        this.setupEditor(this.myEditor, settings);
        this.myEditor.setCaretPosition(0);
        this.add((Component)this.myEditor, "Center");
        CommandLinePanel.setMinimumWidth((Component)this, (int)400);
        this.mySupport = new ExpandableEditorSupport((EditorTextField)this.myEditor, ParametersListUtil.DEFAULT_LINE_PARSER, ParametersListUtil.DEFAULT_LINE_JOINER){

            @NotNull
            protected EditorTextField createPopupEditor(@NotNull EditorTextField field, @NotNull String text) {
                if (field == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (text == null) {
                    1.$$$reportNull$$$0(1);
                }
                LanguageTextField popupEditor = new LanguageTextField(FileTypes.PLAIN_TEXT.getLanguage(), settings.getProject(), text);
                VmOptionsEditor.this.setupEditor(popupEditor, settings);
                VmOptionsEditor.this.myPopupEditor = popupEditor;
                if (VmOptionsEditor.this.myEditor.getCaretModel().getOffset() <= 0) {
                    VmOptionsEditor.this.myPopupEditor.setCaretPosition(0);
                }
                LanguageTextField languageTextField = popupEditor;
                if (languageTextField == null) {
                    1.$$$reportNull$$$0(2);
                }
                return languageTextField;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "field";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "text";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/execution/ui/VmOptionsEditor$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/execution/ui/VmOptionsEditor$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createPopupEditor";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "createPopupEditor";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2 -> new IllegalStateException(string);
                };
            }
        };
    }

    void setupEditor(LanguageTextField popupEditor, JavaRunConfigurationBase settings) {
        CommonParameterFragments.setMonospaced((Component)popupEditor);
        EditorCustomization disableSpellChecking = SpellCheckingEditorCustomizationProvider.getInstance().getDisabledCustomization();
        if (disableSpellChecking != null) {
            popupEditor.addSettingsProvider(editor -> disableSpellChecking.customize(editor));
        }
        popupEditor.getDocument().putUserData(SETTINGS_KEY, (Object)settings);
    }

    public EditorTextField getTextField() {
        return this.mySupport.isExpanded() ? (EditorTextField)Objects.requireNonNull(this.myPopupEditor) : this.myEditor;
    }

    public JComponent getComponentToRegister() {
        return this.myEditor;
    }

    public void expand() {
        this.mySupport.expand();
    }

    public void collapse() {
        this.mySupport.collapse();
    }

    public boolean isExpanded() {
        return this.mySupport.isExpanded();
    }
}

