/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.util;

import com.intellij.execution.CantRunException;
import com.intellij.execution.CommonJavaRunConfigurationParameters;
import com.intellij.execution.CommonProgramRunConfigurationParameters;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.ModuleBasedConfigurationOptions;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.RunConfigurationModule;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.execution.configurations.SimpleProgramParameters;
import com.intellij.execution.util.ProgramParametersConfigurator;
import com.intellij.execution.util.ProgramParametersUtil;
import com.intellij.execution.util.UnknownAlternativeSdkResolver;
import com.intellij.java.codeserver.core.JavaPsiModuleUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.ex.PathUtilEx;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ExportableOrderEntry;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiProvidesStatement;
import com.intellij.psi.PsiUsesStatement;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.java.stubs.index.JavaModuleNameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.PathsList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.lang.JavaVersion;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaParametersUtil {
    private JavaParametersUtil() {
    }

    public static void configureConfiguration(SimpleJavaParameters parameters, CommonJavaRunConfigurationParameters configuration) {
        String vmParameters;
        ProgramParametersUtil.configureConfiguration((SimpleProgramParameters)parameters, (CommonProgramRunConfigurationParameters)configuration);
        Project project = configuration.getProject();
        Module module = ProgramParametersUtil.getModule((CommonProgramRunConfigurationParameters)configuration);
        String alternativeJrePath = configuration.getAlternativeJrePath();
        if (alternativeJrePath != null) {
            configuration.setAlternativeJrePath(ProgramParametersUtil.expandPath((String)alternativeJrePath, null, (Project)project));
        }
        if ((vmParameters = configuration.getVMParameters()) != null) {
            vmParameters = ProgramParametersUtil.expandPath((String)vmParameters, (Module)module, (Project)project);
            for (Map.Entry each : parameters.getEnv().entrySet()) {
                vmParameters = StringUtil.replace((String)vmParameters, (String)("$" + (String)each.getKey() + "$"), (String)((String)each.getValue()), (boolean)false);
            }
            List vmParametersList = ProgramParametersConfigurator.expandMacrosAndParseParameters((String)vmParameters);
            parameters.getVMParametersList().addAll(vmParametersList);
        }
    }

    public static int getClasspathType(@NotNull RunConfigurationModule configurationModule, @NotNull String mainClassName, boolean classMustHaveSource) throws CantRunException {
        if (configurationModule == null) {
            JavaParametersUtil.$$$reportNull$$$0(0);
        }
        if (mainClassName == null) {
            JavaParametersUtil.$$$reportNull$$$0(1);
        }
        return JavaParametersUtil.getClasspathType(configurationModule, mainClassName, classMustHaveSource, false);
    }

    public static int getClasspathType(@NotNull RunConfigurationModule configurationModule, @NotNull String mainClassName, boolean classMustHaveSource, boolean includeProvidedDependencies) throws CantRunException {
        Module module;
        if (configurationModule == null) {
            JavaParametersUtil.$$$reportNull$$$0(2);
        }
        if (mainClassName == null) {
            JavaParametersUtil.$$$reportNull$$$0(3);
        }
        if ((module = configurationModule.getModule()) == null) {
            throw CantRunException.noModuleConfigured((String)configurationModule.getModuleName());
        }
        Boolean inProduction = JavaParametersUtil.isClassInProductionSources(mainClassName, module);
        if (inProduction == null) {
            if (!classMustHaveSource) {
                return 7;
            }
            throw CantRunException.classNotFound((String)mainClassName, (Module)module);
        }
        return inProduction.booleanValue() ? (includeProvidedDependencies ? 11 : 3) : 7;
    }

    @Nullable(value="null if class not found")
    public static @Nullable(value="null if class not found") Boolean isClassInProductionSources(@NotNull String mainClassName, @NotNull Module module) {
        ModuleRootManager rootManager;
        ModuleFileIndex fileIndex;
        Module classModule;
        PsiClass psiClass;
        if (mainClassName == null) {
            JavaParametersUtil.$$$reportNull$$$0(4);
        }
        if (module == null) {
            JavaParametersUtil.$$$reportNull$$$0(5);
        }
        if ((psiClass = JavaExecutionUtil.findMainClass((Module)module, (String)mainClassName)) == null) {
            return null;
        }
        PsiFile psiFile = psiClass.getContainingFile();
        if (psiFile == null) {
            return null;
        }
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        Module module2 = classModule = psiClass.isValid() ? ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass) : null;
        if (classModule == null) {
            classModule = module;
        }
        if ((fileIndex = (rootManager = ModuleRootManager.getInstance((Module)classModule)).getFileIndex()).isInSourceContent(virtualFile)) {
            return !fileIndex.isInTestSourceContent(virtualFile);
        }
        for (OrderEntry entry : fileIndex.getOrderEntriesForFile(virtualFile)) {
            if (!(entry instanceof ExportableOrderEntry) || ((ExportableOrderEntry)entry).getScope() != DependencyScope.TEST) continue;
            return false;
        }
        if (rootManager.getSourceRoots(false).length == 0) {
            return false;
        }
        return true;
    }

    public static void configureModule(RunConfigurationModule runConfigurationModule, JavaParameters parameters, int classPathType, @Nullable String jreHome) throws CantRunException {
        Module module = runConfigurationModule.getModule();
        if (module == null) {
            throw CantRunException.noModuleConfigured((String)runConfigurationModule.getModuleName());
        }
        JavaParametersUtil.configureModule(module, parameters, classPathType, jreHome);
    }

    public static void configureModule(Module module, JavaParameters parameters, int classPathType, @Nullable String jreHome) throws CantRunException {
        parameters.configureByModule(module, classPathType, JavaParametersUtil.createModuleJdk(module, (classPathType & 4) == 0, jreHome));
    }

    public static void configureProject(Project project, JavaParameters parameters, int classPathType, @Nullable String jreHome) throws CantRunException {
        parameters.configureByProject(project, classPathType, JavaParametersUtil.createProjectJdk(project, jreHome));
    }

    public static Sdk createModuleJdk(Module module, boolean productionOnly, @Nullable String jreHome) throws CantRunException {
        return jreHome == null ? JavaParameters.getValidJdkToRunModule((Module)module, (boolean)productionOnly) : JavaParametersUtil.createAlternativeJdk(module.getProject(), jreHome);
    }

    public static Sdk createProjectJdk(@NotNull Project project, @Nullable String jreHome) throws CantRunException {
        if (project == null) {
            JavaParametersUtil.$$$reportNull$$$0(6);
        }
        return jreHome == null ? JavaParametersUtil.createProjectJdk(project) : JavaParametersUtil.createAlternativeJdk(project, jreHome);
    }

    private static Sdk createProjectJdk(@NotNull Project project) throws CantRunException {
        Sdk jdk;
        if (project == null) {
            JavaParametersUtil.$$$reportNull$$$0(7);
        }
        if ((jdk = PathUtilEx.getAnyJdk((Project)project)) == null) {
            throw CantRunException.noJdkConfigured();
        }
        return jdk;
    }

    @Nullable
    public static JavaVersion getJavaVersion(@NotNull String jreHome) {
        Sdk configuredJdk;
        if (jreHome == null) {
            JavaParametersUtil.$$$reportNull$$$0(8);
        }
        if ((configuredJdk = ProjectJdkTable.getInstance().findJdk(jreHome)) != null) {
            return JavaVersion.tryParse((String)configuredJdk.getVersionString());
        }
        if (JdkUtil.checkForJre((String)jreHome)) {
            JavaSdk javaSdk = JavaSdk.getInstance();
            return JavaVersion.tryParse((String)javaSdk.getVersionString(jreHome));
        }
        return null;
    }

    private static Sdk createAlternativeJdk(@NotNull Project project, @NotNull String jreHome) throws CantRunException {
        Sdk configuredJdk;
        if (project == null) {
            JavaParametersUtil.$$$reportNull$$$0(9);
        }
        if (jreHome == null) {
            JavaParametersUtil.$$$reportNull$$$0(10);
        }
        if ((configuredJdk = ProjectJdkTable.getInstance().findJdk(jreHome)) != null) {
            return configuredJdk;
        }
        if (JdkUtil.checkForJre((String)jreHome)) {
            JavaSdk javaSdk = JavaSdk.getInstance();
            return javaSdk.createJdk((String)ObjectUtils.notNull((Object)javaSdk.getVersionString(jreHome), (Object)""), jreHome);
        }
        UnknownAlternativeSdkResolver.getInstance(project).notifyUserToResolveJreAndFail(jreHome);
        throw new IllegalStateException();
    }

    public static void checkAlternativeJRE(@NotNull CommonJavaRunConfigurationParameters configuration) throws RuntimeConfigurationWarning {
        if (configuration == null) {
            JavaParametersUtil.$$$reportNull$$$0(11);
        }
        if (configuration.isAlternativeJrePathEnabled()) {
            JavaParametersUtil.checkAlternativeJRE(configuration.getAlternativeJrePath());
        }
    }

    public static void checkAlternativeJRE(@Nullable String jrePath) throws RuntimeConfigurationWarning {
        if (StringUtil.isEmptyOrSpaces((String)jrePath) || ProjectJdkTable.getInstance().findJdk(jrePath) == null && !JdkUtil.checkForJre((String)jrePath)) {
            throw new RuntimeConfigurationWarning(ExecutionBundle.message((String)"jre.path.is.not.valid.jre.home.error.message", (Object[])new Object[]{jrePath}));
        }
    }

    @NotNull
    public static Predicate<Field> getFilter(@NotNull CommonJavaRunConfigurationParameters parameters) {
        if (parameters == null) {
            JavaParametersUtil.$$$reportNull$$$0(12);
        }
        Predicate<Field> predicate = field -> {
            String name = field.getName();
            return (!name.equals("ALTERNATIVE_JRE_PATH_ENABLED") || parameters.isAlternativeJrePathEnabled()) && (!name.equals("ALTERNATIVE_JRE_PATH") || !StringUtil.isEmpty((String)parameters.getAlternativeJrePath()));
        };
        if (predicate == null) {
            JavaParametersUtil.$$$reportNull$$$0(13);
        }
        return predicate;
    }

    public static void putDependenciesOnModulePath(JavaParameters javaParameters, PsiJavaModule module, boolean includeTests) {
        Project project = module.getProject();
        LinkedHashSet<PsiJavaModule> explicitModules = new LinkedHashSet<PsiJavaModule>();
        explicitModules.add(module);
        JavaParametersUtil.collectExplicitlyAddedModules(project, javaParameters, explicitModules);
        HashSet<PsiJavaModule> forModulePath = new HashSet<PsiJavaModule>(explicitModules);
        for (PsiJavaModule explicitModule : explicitModules) {
            forModulePath.addAll(JavaPsiModuleUtil.getAllDependencies((PsiJavaModule)explicitModule));
        }
        if (!includeTests) {
            JavaParametersUtil.putProvidersOnModulePath(project, forModulePath, forModulePath);
        }
        JarFileSystem jarFS = JarFileSystem.getInstance();
        ProjectFileIndex fileIndex = ProjectFileIndex.getInstance((Project)project);
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
        PathsList classPath = javaParameters.getClassPath();
        PathsList modulePath = javaParameters.getModulePath();
        forModulePath.stream().filter(javaModule -> !"java.base".equals(javaModule.getName())).flatMap(javaModule -> psiFacade.findModules(javaModule.getName(), GlobalSearchScope.allScope((Project)project)).stream()).map(javaModule -> JavaParametersUtil.getClasspathEntry(javaModule, fileIndex, jarFS)).filter(Objects::nonNull).forEach(file -> JavaParametersUtil.putOnModulePath(modulePath, classPath, file));
        VirtualFile productionOutput = JavaParametersUtil.getClasspathEntry(module, fileIndex, jarFS);
        if (productionOutput != null) {
            JavaParametersUtil.putOnModulePath(modulePath, classPath, productionOutput);
        }
    }

    private static void collectExplicitlyAddedModules(Project project, JavaParameters javaParameters, Set<PsiJavaModule> explicitModules) {
        String addedModules;
        ParametersList parametersList = javaParameters.getVMParametersList();
        List parameters = parametersList.getParameters();
        int additionalModulesIdx = parameters.indexOf("--add-modules") + 1;
        String string = addedModules = additionalModulesIdx > 0 && additionalModulesIdx < parameters.size() ? (String)parameters.get(additionalModulesIdx) : null;
        if (addedModules != null) {
            JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
            for (String additionalModule : addedModules.split(",")) {
                ContainerUtil.addIfNotNull(explicitModules, (Object)psiFacade.findModule(additionalModule.trim(), GlobalSearchScope.allScope((Project)project)));
            }
        }
    }

    private static void putProvidersOnModulePath(Project project, Set<PsiJavaModule> initialModules, Set<PsiJavaModule> forModulePath) {
        HashSet<String> interfaces = new HashSet<String>();
        for (PsiJavaModule explicitModule : initialModules) {
            for (PsiUsesStatement use : explicitModule.getUses()) {
                PsiClassType useClassType = use.getClassType();
                if (useClassType == null) continue;
                interfaces.add(useClassType.getCanonicalText());
            }
        }
        if (interfaces.isEmpty()) {
            return;
        }
        HashSet<PsiJavaModule> added = new HashSet<PsiJavaModule>();
        Consumer<PsiJavaModule> registerProviders = javaModule -> {
            if (forModulePath.add((PsiJavaModule)javaModule)) {
                added.add((PsiJavaModule)javaModule);
            }
        };
        JavaModuleNameIndex index = JavaModuleNameIndex.getInstance();
        for (String key : index.getAllKeys(project)) {
            block3: for (PsiJavaModule aModule : index.getModules(key, project, GlobalSearchScope.allScope((Project)project))) {
                if (forModulePath.contains(aModule)) continue;
                for (PsiProvidesStatement provide : aModule.getProvides()) {
                    PsiClassType provideInterfaceType = provide.getInterfaceType();
                    if (provideInterfaceType == null || !interfaces.contains(provideInterfaceType.getCanonicalText())) continue;
                    registerProviders.accept(aModule);
                    JavaPsiModuleUtil.getAllDependencies((PsiJavaModule)aModule).forEach(registerProviders);
                    continue block3;
                }
            }
        }
        if (!added.isEmpty()) {
            JavaParametersUtil.putProvidersOnModulePath(project, added, forModulePath);
        }
    }

    private static void putOnModulePath(PathsList modulePath, PathsList classPath, VirtualFile virtualFile) {
        String path = PathUtil.getLocalPath((String)virtualFile.getPath());
        if (classPath.getPathList().contains(path)) {
            classPath.remove(path);
            modulePath.add(path);
        }
    }

    private static VirtualFile getClasspathEntry(PsiJavaModule javaModule, ProjectFileIndex fileIndex, JarFileSystem jarFileSystem) {
        CompilerModuleExtension moduleExtension;
        VirtualFile moduleFile = PsiImplUtil.getModuleVirtualFile((PsiJavaModule)javaModule);
        Module moduleDependency = fileIndex.getModuleForFile(moduleFile);
        if (moduleDependency != null && (moduleExtension = CompilerModuleExtension.getInstance((Module)moduleDependency)) != null) {
            boolean inTests = fileIndex.isInTestSourceContent(moduleFile);
            return inTests ? moduleExtension.getCompilerOutputPathForTests() : moduleExtension.getCompilerOutputPath();
        }
        return jarFileSystem.getLocalByEntry(moduleFile);
    }

    public static void applyModifications(JavaParameters parameters, List<ModuleBasedConfigurationOptions.ClasspathModification> modifications) {
        for (ModuleBasedConfigurationOptions.ClasspathModification modification : modifications) {
            if (modification.getPath() == null) continue;
            if (modification.getExclude()) {
                parameters.getClassPath().remove(modification.getPath());
                parameters.getModulePath().remove(modification.getPath());
                continue;
            }
            parameters.getClassPath().addFirst(modification.getPath());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationModule";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainClassName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 6: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jreHome";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/util/JavaParametersUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/util/JavaParametersUtil";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getClasspathType";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isClassInProductionSources";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createProjectJdk";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getJavaVersion";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createAlternativeJdk";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "checkAlternativeJRE";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getFilter";
                break;
            }
            case 13: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 13 -> new IllegalStateException(string);
        };
    }
}

