/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.vmOptions;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.CapturingProcessRunner;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessNotCreatedException;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.vmOptions.JdkOptionsData;
import com.intellij.execution.vmOptions.VMOption;
import com.intellij.execution.vmOptions.VMOptionKind;
import com.intellij.execution.vmOptions.VMOptionVariant;
import com.intellij.execution.vmOptions.VMOptionsBundle;
import com.intellij.execution.vmOptions.VMOptionsParser;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.CollectionFactory;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b \u0018\u00002\u00020\u0001:\u0002\u001b\u001cB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0006H$J\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0011\u001a\u00020\u0006J\u0010\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0006H\u0004J\u0010\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0006H\u0002J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0006H\u0004J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0011\u001a\u00020\u0006H\u0004R \u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00020\u0006X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0018\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\rX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001d"}, d2={"Lcom/intellij/execution/vmOptions/CommandOptionsExtractor;", "", "<init>", "()V", "commandData", "Ljava/util/concurrent/ConcurrentMap;", "", "Ljava/util/concurrent/CompletableFuture;", "Lcom/intellij/execution/vmOptions/JdkOptionsData;", "commandName", "getCommandName", "()Ljava/lang/String;", "commandOptions", "", "getCommandOptions", "()Ljava/util/List;", "getOptions", "javaHome", "getOrComputeOptions", "getCommandExecutablePath", "getConvertedPath", "opt", "Lcom/intellij/execution/vmOptions/VMOption;", "name", "doc", "getProcessOutput", "Lcom/intellij/execution/process/ProcessOutput;", "Java", "Javac", "intellij.java.execution.impl"})
public abstract class CommandOptionsExtractor {
    @NotNull
    private final ConcurrentMap<String, CompletableFuture<JdkOptionsData>> commandData;

    public CommandOptionsExtractor() {
        ConcurrentMap concurrentMap = CollectionFactory.createConcurrentSoftValueMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"createConcurrentSoftValueMap(...)");
        this.commandData = concurrentMap;
    }

    @NotNull
    protected abstract String getCommandName();

    @NotNull
    protected abstract List<String> getCommandOptions();

    @NotNull
    protected abstract JdkOptionsData getOptions(@NotNull String var1);

    @NotNull
    public final CompletableFuture<JdkOptionsData> getOrComputeOptions(@NotNull String javaHome) {
        JdkOptionsData data;
        Intrinsics.checkNotNullParameter((Object)javaHome, (String)"javaHome");
        CompletableFuture future = this.commandData.computeIfAbsent(javaHome, arg_0 -> CommandOptionsExtractor.getOrComputeOptions$lambda$1(arg_0 -> CommandOptionsExtractor.getOrComputeOptions$lambda$0(this, arg_0), arg_0));
        if (future.isDone() && (data = (JdkOptionsData)future.get()) == null) {
            this.commandData.remove(javaHome);
        }
        Intrinsics.checkNotNull((Object)future);
        return future;
    }

    @NotNull
    protected final String getCommandExecutablePath(@NotNull String javaHome) {
        Intrinsics.checkNotNullParameter((Object)javaHome, (String)"javaHome");
        Object vmExeName = SystemInfo.isWindows ? this.getCommandName() + ".exe" : this.getCommandName();
        String[] stringArray = new String[]{"bin", vmExeName};
        return ((Object)Path.of(this.getConvertedPath(javaHome), stringArray)).toString();
    }

    private final String getConvertedPath(String javaHome) {
        String string = FileUtil.toSystemDependentName((String)javaHome);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toSystemDependentName(...)");
        Object systemDependentName = string;
        String string2 = File.separator;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"separator");
        if (StringsKt.endsWith$default((String)javaHome, (String)string2, (boolean)false, (int)2, null)) {
            systemDependentName = (String)systemDependentName + File.separator;
        }
        return systemDependentName;
    }

    @NotNull
    protected final VMOption opt(@NotNull String name, @NotNull String doc) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        return new VMOption(name, null, null, VMOptionKind.Standard, doc, VMOptionVariant.DASH, null);
    }

    @Nullable
    protected final ProcessOutput getProcessOutput(@NotNull String javaHome) {
        OSProcessHandler oSProcessHandler;
        Intrinsics.checkNotNullParameter((Object)javaHome, (String)"javaHome");
        String vmPath = this.getCommandExecutablePath(javaHome);
        String[] stringArray = new String[]{vmPath};
        GeneralCommandLine generalCommandLine = new GeneralCommandLine(stringArray);
        generalCommandLine.addParameters(this.getCommandOptions());
        try {
            oSProcessHandler = new OSProcessHandler(generalCommandLine);
        }
        catch (ProcessNotCreatedException processNotCreatedException) {
            return null;
        }
        OSProcessHandler handler = oSProcessHandler;
        CapturingProcessRunner runner = new CapturingProcessRunner((BaseProcessHandler)handler);
        ProcessOutput processOutput = runner.runProcess(1000);
        Intrinsics.checkNotNullExpressionValue((Object)processOutput, (String)"runProcess(...)");
        ProcessOutput output = processOutput;
        if (output.isTimeout()) {
            return null;
        }
        return output;
    }

    private static final JdkOptionsData getOrComputeOptions$lambda$0$0(CommandOptionsExtractor this$0, String $it) {
        Intrinsics.checkNotNull((Object)$it);
        return this$0.getOptions($it);
    }

    private static final CompletableFuture getOrComputeOptions$lambda$0(CommandOptionsExtractor this$0, String it) {
        return CompletableFuture.supplyAsync(() -> CommandOptionsExtractor.getOrComputeOptions$lambda$0$0(this$0, it));
    }

    private static final CompletableFuture getOrComputeOptions$lambda$1(Function1 $tmp0, Object p0) {
        return (CompletableFuture)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000bH\u0014J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0012\u001a\u00020\u000bH\u0002R \u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0007\u0010\u0003\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\t\u00a8\u0006\u0014"}, d2={"Lcom/intellij/execution/vmOptions/CommandOptionsExtractor$Java;", "Lcom/intellij/execution/vmOptions/CommandOptionsExtractor;", "<init>", "()V", "STANDARD_OPTION_LIST", "", "Lcom/intellij/execution/vmOptions/VMOption;", "getStandardOptionList$annotations", "getStandardOptionList", "()Ljava/util/List;", "commandName", "", "getCommandName", "()Ljava/lang/String;", "commandOptions", "getCommandOptions", "getOptions", "Lcom/intellij/execution/vmOptions/JdkOptionsData;", "javaHome", "getOptionsForJava", "intellij.java.execution.impl"})
    public static final class Java
    extends CommandOptionsExtractor {
        @NotNull
        public static final Java INSTANCE = new Java();
        @NotNull
        private static final List<VMOption> STANDARD_OPTION_LIST;
        @NotNull
        private static final String commandName;
        @NotNull
        private static final List<String> commandOptions;

        private Java() {
        }

        @JvmName(name="getStandardOptionList")
        @NotNull
        public static final List<VMOption> getStandardOptionList() {
            return STANDARD_OPTION_LIST;
        }

        @JvmStatic
        public static /* synthetic */ void getStandardOptionList$annotations() {
        }

        @Override
        @NotNull
        protected String getCommandName() {
            return commandName;
        }

        @Override
        @NotNull
        protected List<String> getCommandOptions() {
            return commandOptions;
        }

        @Override
        @NotNull
        protected JdkOptionsData getOptions(@NotNull String javaHome) {
            Intrinsics.checkNotNullParameter((Object)javaHome, (String)"javaHome");
            List<VMOption> options = this.getOptionsForJava(javaHome);
            return new JdkOptionsData(options);
        }

        private final List<VMOption> getOptionsForJava(String javaHome) {
            ProcessOutput processOutput = this.getProcessOutput(javaHome);
            if (processOutput == null) {
                return STANDARD_OPTION_LIST;
            }
            ProcessOutput output = processOutput;
            String string = output.getStdout();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStdout(...)");
            List<VMOption> xxOptions = VMOptionsParser.INSTANCE.parseJavaXXOptions$intellij_java_execution_impl(string);
            String string2 = output.getStderr();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getStderr(...)");
            List<VMOption> xOptions = VMOptionsParser.INSTANCE.parseJavaXOptions$intellij_java_execution_impl(string2);
            if (xOptions != null) {
                return CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)xOptions, (Iterable)xxOptions), (Iterable)STANDARD_OPTION_LIST);
            }
            return CollectionsKt.plus((Collection)xxOptions, (Iterable)STANDARD_OPTION_LIST);
        }

        static {
            Object[] objectArray = new VMOption[]{INSTANCE.opt("ea", VMOptionsBundle.message("vm.option.enable.assertions.description", new Object[0])), INSTANCE.opt("enableassertions", VMOptionsBundle.message("vm.option.enable.assertions.description", new Object[0])), INSTANCE.opt("da", VMOptionsBundle.message("vm.option.disable.assertions.description", new Object[0])), INSTANCE.opt("disableassertions", VMOptionsBundle.message("vm.option.disable.assertions.description", new Object[0])), INSTANCE.opt("esa", VMOptionsBundle.message("vm.option.enable.system.assertions.description", new Object[0])), INSTANCE.opt("enablesystemassertions", VMOptionsBundle.message("vm.option.enable.system.assertions.description", new Object[0])), INSTANCE.opt("dsa", VMOptionsBundle.message("vm.option.disable.system.assertions.description", new Object[0])), INSTANCE.opt("disablesystemassertions", VMOptionsBundle.message("vm.option.disable.system.assertions.description", new Object[0])), INSTANCE.opt("agentpath:", VMOptionsBundle.message("vm.option.agentpath.description", new Object[0])), INSTANCE.opt("agentlib:", VMOptionsBundle.message("vm.option.agentlib.description", new Object[0])), INSTANCE.opt("javaagent:", VMOptionsBundle.message("vm.option.javaagent.description", new Object[0])), INSTANCE.opt("D", VMOptionsBundle.message("vm.option.system.property.description", new Object[0])), INSTANCE.opt("XX:", VMOptionsBundle.message("vm.option.advanced.option.description", new Object[0]))};
            STANDARD_OPTION_LIST = CollectionsKt.listOf((Object[])objectArray);
            commandName = "java";
            objectArray = new String[]{"-XX:+PrintFlagsFinal", "-XX:+UnlockDiagnosticVMOptions", "-XX:+UnlockExperimentalVMOptions", "-X"};
            commandOptions = CollectionsKt.listOf((Object[])objectArray);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\nH\u0014J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0011\u001a\u00020\nH\u0002R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u00058TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\b\u00a8\u0006\u0013"}, d2={"Lcom/intellij/execution/vmOptions/CommandOptionsExtractor$Javac;", "Lcom/intellij/execution/vmOptions/CommandOptionsExtractor;", "<init>", "()V", "STANDARD_OPTIONS_LIST", "", "Lcom/intellij/execution/vmOptions/VMOption;", "getSTANDARD_OPTIONS_LIST", "()Ljava/util/List;", "commandName", "", "getCommandName", "()Ljava/lang/String;", "commandOptions", "getCommandOptions", "getOptions", "Lcom/intellij/execution/vmOptions/JdkOptionsData;", "javaHome", "getOptionsForJavac", "intellij.java.execution.impl"})
    @SourceDebugExtension(value={"SMAP\nCommandOptionsExtractor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommandOptionsExtractor.kt\ncom/intellij/execution/vmOptions/CommandOptionsExtractor$Javac\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,165:1\n1#2:166\n*E\n"})
    public static final class Javac
    extends CommandOptionsExtractor {
        @NotNull
        public static final Javac INSTANCE = new Javac();
        @NotNull
        private static final List<VMOption> STANDARD_OPTIONS_LIST;
        @NotNull
        private static final String commandName;

        private Javac() {
        }

        @NotNull
        public final List<VMOption> getSTANDARD_OPTIONS_LIST() {
            return STANDARD_OPTIONS_LIST;
        }

        @Override
        @NotNull
        protected String getCommandName() {
            return commandName;
        }

        @Override
        @NotNull
        protected List<String> getCommandOptions() {
            Object[] objectArray = new String[]{"-help", "-X"};
            return CollectionsKt.listOf((Object[])objectArray);
        }

        @Override
        @NotNull
        protected JdkOptionsData getOptions(@NotNull String javaHome) {
            Intrinsics.checkNotNullParameter((Object)javaHome, (String)"javaHome");
            return new JdkOptionsData(this.getOptionsForJavac(javaHome));
        }

        private final List<VMOption> getOptionsForJavac(String javaHome) {
            List result;
            block2: {
                List<VMOption> it;
                ProcessOutput processOutput = this.getProcessOutput(javaHome);
                if (processOutput == null) {
                    return CollectionsKt.emptyList();
                }
                ProcessOutput processOutput2 = processOutput;
                result = new ArrayList();
                result.addAll((Collection)STANDARD_OPTIONS_LIST);
                String string = processOutput2.getStdout();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStdout(...)");
                List<VMOption> list = VMOptionsParser.INSTANCE.parseJavacDoubleDashedOptions$intellij_java_execution_impl(string);
                if (list != null) {
                    it = list;
                    boolean bl = false;
                    result.addAll((Collection)it);
                }
                String string2 = processOutput2.getStdout();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getStdout(...)");
                List<VMOption> list2 = VMOptionsParser.INSTANCE.parseJavacXOptions$intellij_java_execution_impl(string2);
                if (list2 == null) break block2;
                it = list2;
                boolean bl = false;
                result.addAll((Collection)it);
            }
            return result;
        }

        static {
            Object[] objectArray = new VMOption[]{INSTANCE.opt("A", "vm.option.annotation.processing.description"), INSTANCE.opt("g", "vm.option.generate.debug.information.description"), INSTANCE.opt("g:", "vm.option.generate.choice.debug.information.description"), INSTANCE.opt("g:none", "vm.option.generate.none.debug.information.description"), INSTANCE.opt("h", "vm.option.native.header.description"), INSTANCE.opt("J", "vm.option.j.description"), INSTANCE.opt("d", "vm.option.directory.description"), INSTANCE.opt("nowarn", "vm.option.nowarn.description"), INSTANCE.opt("parameters", "vm.option.parameters.description"), INSTANCE.opt("processor", "vm.option.processor.description"), INSTANCE.opt("profile", "vm.option.profile.description"), INSTANCE.opt("s", "vm.option.source.output.description"), INSTANCE.opt("verbose", "vm.option.verbose.description"), INSTANCE.opt("Werror", "vm.option.werror.description"), INSTANCE.opt("proc:", "vm.option.proc.description"), INSTANCE.opt("implicit:", "vm.option.implicit.description"), INSTANCE.opt("encoding", "vm.option.encoding.description"), INSTANCE.opt("endorseddirs", "vm.option.endorsed.dirs.description"), INSTANCE.opt("extdirs", "vm.option.extension.dirs.description")};
            STANDARD_OPTIONS_LIST = CollectionsKt.listOf((Object[])objectArray);
            commandName = "javac";
        }
    }
}

