/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.vmOptions;

import com.intellij.execution.vmOptions.VMOption;
import com.intellij.execution.vmOptions.VMOptionKind;
import com.intellij.execution.vmOptions.VMOptionVariant;
import com.intellij.execution.vmOptions.VMOptionsBundle;
import com.intellij.openapi.diagnostic.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0019\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0002\u001e\u001fB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\fJ\u001d\u0010\r\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b2\u0006\u0010\u000e\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\u000fJ\u001d\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b2\u0006\u0010\u0011\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\u0012J\u001d\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b2\u0006\u0010\u0011\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\u0014J@\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000b0\b2\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/execution/vmOptions/VMOptionsParser;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "parseJavaXXOptions", "", "Lcom/intellij/execution/vmOptions/VMOption;", "text", "", "parseJavaXXOptions$intellij_java_execution_impl", "parseJavaXOptions", "stderr", "parseJavaXOptions$intellij_java_execution_impl", "parseJavacXOptions", "input", "parseJavacXOptions$intellij_java_execution_impl", "parseJavacDoubleDashedOptions", "parseJavacDoubleDashedOptions$intellij_java_execution_impl", "parseLines", "type", "Lcom/intellij/execution/vmOptions/VMOptionsParser$ParsingType;", "lines", "allowedOptionsStart", "", "Lcom/intellij/execution/vmOptions/VMOptionVariant;", "separators", "", "OptionBuilder", "ParsingType", "intellij.java.execution.impl"})
@SourceDebugExtension(value={"SMAP\nVMOptionsParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VMOptionsParser.kt\ncom/intellij/execution/vmOptions/VMOptionsParser\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,275:1\n777#2:276\n873#2,2:277\n*S KotlinDebug\n*F\n+ 1 VMOptionsParser.kt\ncom/intellij/execution/vmOptions/VMOptionsParser\n*L\n30#1:276\n30#1:277,2\n*E\n"})
public final class VMOptionsParser {
    @NotNull
    public static final VMOptionsParser INSTANCE = new VMOptionsParser();
    @NotNull
    private static final Logger LOG;

    private VMOptionsParser() {
    }

    @NotNull
    public final List<VMOption> parseJavaXXOptions$intellij_java_execution_impl(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Sequence lines = SequencesKt.drop((Sequence)StringsKt.lineSequence((CharSequence)text), (int)1);
        List options = SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)lines, VMOptionsParser::parseJavaXXOptions$lambda$0));
        return options;
    }

    @Nullable
    public final List<VMOption> parseJavaXOptions$intellij_java_execution_impl(@NotNull String stderr) {
        Intrinsics.checkNotNullParameter((Object)stderr, (String)"stderr");
        int tailIndex = StringsKt.indexOf$default((CharSequence)stderr, (String)"These extra options are subject to change without notice.", (int)0, (boolean)false, (int)6, null);
        if (tailIndex == -1) {
            tailIndex = StringsKt.indexOf$default((CharSequence)stderr, (String)"The -X options are non-standard and subject to change without notice.", (int)0, (boolean)false, (int)6, null);
        }
        if (tailIndex == -1) {
            return null;
        }
        Object[] objectArray = new char[]{' ', '<'};
        char[] separators = objectArray;
        ParsingType parsingType = ParsingType.JavaExtraOptions.INSTANCE;
        String string = stderr.substring(0, tailIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        objectArray = new Pair[2];
        objectArray[0] = (char)TuplesKt.to((Object)"-X", (Object)((Object)VMOptionVariant.X));
        objectArray[1] = (char)TuplesKt.to((Object)"--", (Object)((Object)VMOptionVariant.DASH_DASH));
        return this.parseLines(parsingType, StringsKt.lines((CharSequence)((Object)StringsKt.trimStart((CharSequence)string)).toString()), MapsKt.mapOf((Pair[])objectArray), separators);
    }

    @Nullable
    public final List<VMOption> parseJavacXOptions$intellij_java_execution_impl(@NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        List lines = StringsKt.lines((CharSequence)input);
        int beforeStartLine = lines.indexOf("");
        if (beforeStartLine == -1) {
            return null;
        }
        int afterEndLine = lines.indexOf("These extra options are subject to change without notice.");
        if (afterEndLine == -1) {
            return null;
        }
        if (beforeStartLine + 1 >= afterEndLine - 1) {
            return null;
        }
        Object[] objectArray = new Pair[]{TuplesKt.to((Object)"-X", (Object)((Object)VMOptionVariant.X)), TuplesKt.to((Object)"--", (Object)((Object)VMOptionVariant.DASH_DASH))};
        Map map = MapsKt.mapOf((Pair[])objectArray);
        objectArray = new char[1];
        objectArray[0] = (Pair)32;
        return this.parseLines(ParsingType.JavacExtraOptions.INSTANCE, lines.subList(beforeStartLine + 1, afterEndLine - 1), map, (char[])objectArray);
    }

    @Nullable
    public final List<VMOption> parseJavacDoubleDashedOptions$intellij_java_execution_impl(@NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        List lines = StringsKt.lines((CharSequence)input);
        int lastLine = lines.indexOf("");
        if (lastLine == -1) {
            return null;
        }
        int beforeStartLine = lines.indexOf("where possible options include:");
        if (beforeStartLine == -1) {
            return null;
        }
        char[] cArray = new char[]{' '};
        return this.parseLines(ParsingType.JavacStandardOptions.INSTANCE, lines.subList(beforeStartLine + 1, lastLine), MapsKt.mapOf((Pair)TuplesKt.to((Object)"--", (Object)((Object)VMOptionVariant.DASH_DASH))), cArray);
    }

    private final List<VMOption> parseLines(ParsingType type, List<String> lines, Map<String, ? extends VMOptionVariant> allowedOptionsStart, char[] separators) {
        ArrayList<VMOption> options = new ArrayList<VMOption>();
        OptionBuilder currentOption = null;
        for (String line : lines) {
            String trimmed = ((Object)StringsKt.trim((CharSequence)line)).toString();
            VMOptionVariant variant = null;
            for (Map.Entry<String, ? extends VMOptionVariant> entry : allowedOptionsStart.entrySet()) {
                String startString = entry.getKey();
                VMOptionVariant value = entry.getValue();
                if (!StringsKt.startsWith$default((String)trimmed, (String)startString, (boolean)false, (int)2, null)) continue;
                variant = value;
                break;
            }
            if (variant != null) {
                int indexOfSeparator;
                if (currentOption != null) {
                    options.add(currentOption.build());
                }
                if ((indexOfSeparator = StringsKt.indexOfAny$default((CharSequence)trimmed, (char[])separators, (int)0, (boolean)false, (int)6, null)) != -1) {
                    String string = trimmed.substring(variant.prefix().length(), indexOfSeparator);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    currentOption = new OptionBuilder(type, variant, string);
                    String string2 = trimmed.substring(indexOfSeparator);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                    String docCandidate = ((Object)StringsKt.trim((CharSequence)string2)).toString();
                    boolean bl = StringsKt.startsWith$default((String)docCandidate, (String)"<", (boolean)false, (int)2, null) ? currentOption.getDoc().add(docCandidate) : currentOption.getDoc().add(docCandidate);
                    continue;
                }
                String string = trimmed.substring(variant.prefix().length());
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                currentOption = new OptionBuilder(type, variant, string);
                continue;
            }
            Object object = currentOption;
            if (object == null || (object = ((OptionBuilder)object).getDoc()) == null) continue;
            ((ArrayList)object).add(trimmed);
        }
        if (currentOption != null) {
            options.add(currentOption.build());
        }
        return options;
    }

    /*
     * WARNING - void declaration
     */
    private static final VMOption parseJavaXXOptions$lambda$0(String it) {
        void $this$filterTo$iv$iv;
        VMOptionKind vMOptionKind;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        int lbraceIndex = StringsKt.indexOf$default((CharSequence)it, (String)"{", (int)0, (boolean)false, (int)6, null);
        if (lbraceIndex == -1) {
            return null;
        }
        int rbraceIndex = StringsKt.indexOf$default((CharSequence)it, (String)"}", (int)0, (boolean)false, (int)6, null);
        if (rbraceIndex == -1) {
            return null;
        }
        String string = it.substring(lbraceIndex, rbraceIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String kind = string;
        if (StringsKt.contains$default((CharSequence)kind, (CharSequence)"product", (boolean)false, (int)2, null)) {
            vMOptionKind = VMOptionKind.Product;
        } else if (StringsKt.contains$default((CharSequence)kind, (CharSequence)"experimental", (boolean)false, (int)2, null)) {
            vMOptionKind = VMOptionKind.Experimental;
        } else if (StringsKt.contains$default((CharSequence)kind, (CharSequence)"diagnostic", (boolean)false, (int)2, null)) {
            vMOptionKind = VMOptionKind.Diagnostic;
        } else {
            return null;
        }
        VMOptionKind optionKind = vMOptionKind;
        String[] stringArray = new String[]{" "};
        Iterable $this$filter$iv = StringsKt.split$default((CharSequence)it, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String part = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = !StringsKt.isBlank((CharSequence)part);
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List fragments = (List)destination$iv$iv;
        if (fragments.isEmpty()) {
            return null;
        }
        int indexOfEq = fragments.indexOf("=");
        String string2 = (String)CollectionsKt.getOrNull((List)fragments, (int)(indexOfEq + 1));
        if (string2 == null) {
            return null;
        }
        String maybeDefault = string2;
        String string3 = StringsKt.startsWith$default((String)maybeDefault, (String)"{", (boolean)false, (int)2, null) ? null : maybeDefault;
        return new VMOption((String)fragments.get(1), (String)fragments.get(0), string3, optionKind, null, VMOptionVariant.XX, null, 64, null);
    }

    static {
        Logger logger = Logger.getInstance(VMOptionsParser.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u0013\u001a\u00020\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR!\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u000fj\b\u0012\u0004\u0012\u00020\u0007`\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0015"}, d2={"Lcom/intellij/execution/vmOptions/VMOptionsParser$OptionBuilder;", "", "type", "Lcom/intellij/execution/vmOptions/VMOptionsParser$ParsingType;", "variant", "Lcom/intellij/execution/vmOptions/VMOptionVariant;", "name", "", "<init>", "(Lcom/intellij/execution/vmOptions/VMOptionsParser$ParsingType;Lcom/intellij/execution/vmOptions/VMOptionVariant;Ljava/lang/String;)V", "getVariant", "()Lcom/intellij/execution/vmOptions/VMOptionVariant;", "getName", "()Ljava/lang/String;", "doc", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "getDoc", "()Ljava/util/ArrayList;", "build", "Lcom/intellij/execution/vmOptions/VMOption;", "intellij.java.execution.impl"})
    private static final class OptionBuilder {
        @NotNull
        private final ParsingType type;
        @NotNull
        private final VMOptionVariant variant;
        @NotNull
        private final String name;
        @NotNull
        private final ArrayList<String> doc;

        public OptionBuilder(@NotNull ParsingType type, @NotNull VMOptionVariant variant, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)((Object)variant), (String)"variant");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.type = type;
            this.variant = variant;
            this.name = this.type.parseName(name);
            this.doc = new ArrayList();
        }

        @NotNull
        public final VMOptionVariant getVariant() {
            return this.variant;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final ArrayList<String> getDoc() {
            return this.doc;
        }

        @NotNull
        public final VMOption build() {
            String string;
            String vmOptionMapKey = this.variant.prefix() + this.name;
            String key = this.type.getOptionDescriptionPropertyKey().get(vmOptionMapKey);
            if (key != null) {
                string = VMOptionsBundle.message(key, new Object[0]);
            } else {
                LOG.warn("Option " + vmOptionMapKey + " is not localized. Output of java command will be used instead. Please, localize it in VMOptionsBundle");
                string = CollectionsKt.joinToString$default((Iterable)this.doc, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
            }
            String description = string;
            return new VMOption(this.name, null, null, this.type.getKind(), description, this.variant, null, 64, null);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\bb\u0018\u00002\u00020\u0001:\u0004\u0010\u0011\u0012\u0013J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0004H&R-\u0010\u0002\u001a\u001d\u0012\u0004\u0012\u00020\u0004\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u00070\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u00020\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0014\u00c0\u0006\u0001"}, d2={"Lcom/intellij/execution/vmOptions/VMOptionsParser$ParsingType;", "", "optionDescriptionPropertyKey", "", "", "Lorg/jetbrains/annotations/PropertyKey;", "resourceBundle", "messages.VMOptionsBundle", "getOptionDescriptionPropertyKey", "()Ljava/util/Map;", "kind", "Lcom/intellij/execution/vmOptions/VMOptionKind;", "getKind", "()Lcom/intellij/execution/vmOptions/VMOptionKind;", "parseName", "input", "JavaExtraOptions", "JavacOptionsBase", "JavacStandardOptions", "JavacExtraOptions", "intellij.java.execution.impl"})
    private static interface ParsingType {
        @NotNull
        public Map<String, String> getOptionDescriptionPropertyKey();

        @NotNull
        public VMOptionKind getKind();

        @NotNull
        public String parseName(@NotNull String var1);

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0006H\u0016R/\u0010\u0004\u001a\u001d\u0012\u0004\u0012\u00020\u0006\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t0\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0012"}, d2={"Lcom/intellij/execution/vmOptions/VMOptionsParser$ParsingType$JavaExtraOptions;", "Lcom/intellij/execution/vmOptions/VMOptionsParser$ParsingType;", "<init>", "()V", "optionDescriptionPropertyKey", "", "", "Lorg/jetbrains/annotations/PropertyKey;", "resourceBundle", "messages.VMOptionsBundle", "getOptionDescriptionPropertyKey", "()Ljava/util/Map;", "kind", "Lcom/intellij/execution/vmOptions/VMOptionKind;", "getKind", "()Lcom/intellij/execution/vmOptions/VMOptionKind;", "parseName", "input", "intellij.java.execution.impl"})
        public static final class JavaExtraOptions
        implements ParsingType {
            @NotNull
            public static final JavaExtraOptions INSTANCE = new JavaExtraOptions();
            @NotNull
            private static final Map<String, String> optionDescriptionPropertyKey;
            @NotNull
            private static final VMOptionKind kind;

            private JavaExtraOptions() {
            }

            @Override
            @NotNull
            public Map<String, String> getOptionDescriptionPropertyKey() {
                return optionDescriptionPropertyKey;
            }

            @Override
            @NotNull
            public VMOptionKind getKind() {
                return kind;
            }

            @Override
            @NotNull
            public String parseName(@NotNull String input) {
                Intrinsics.checkNotNullParameter((Object)input, (String)"input");
                String[] stringArray = new String[]{"<"};
                return (String)CollectionsKt.first((List)StringsKt.split$default((CharSequence)input, (String[])stringArray, (boolean)false, (int)0, (int)6, null));
            }

            static {
                Pair[] pairArray = new Pair[]{new Pair((Object)"-Xbatch", (Object)"vm.option.batch.description"), new Pair((Object)"-Xbootclasspath:", (Object)"vm.option.bootclasspath.description"), new Pair((Object)"-Xbootclasspath/p:", (Object)"vm.option.bootclasspath.p.description"), new Pair((Object)"-Xbootclasspath/a:", (Object)"vm.option.bootclasspath.a.description"), new Pair((Object)"-Xdebug", (Object)"vm.option.debug.description"), new Pair((Object)"-Xcheck:jni", (Object)"vm.option.check.jni.description"), new Pair((Object)"-Xcomp", (Object)"vm.option.comp.description"), new Pair((Object)"-Xdiag", (Object)"vm.option.diag.description"), new Pair((Object)"-Xfuture", (Object)"vm.option.future.description"), new Pair((Object)"-Xinternalversion", (Object)"vm.option.internalversion.description"), new Pair((Object)"-Xlog:", (Object)"vm.option.log.description"), new Pair((Object)"-Xloggc:", (Object)"vm.option.loggc.description"), new Pair((Object)"-Xmixed", (Object)"vm.option.mixed.description"), new Pair((Object)"-Xmn", (Object)"vm.option.mn.description"), new Pair((Object)"-Xms", (Object)"vm.option.ms.description"), new Pair((Object)"-Xmx", (Object)"vm.option.mx.description"), new Pair((Object)"-Xrs", (Object)"vm.option.rs.description"), new Pair((Object)"-Xnoclassgc", (Object)"vm.option.noclassgc.description"), new Pair((Object)"-Xshare:auto", (Object)"vm.option.share.auto.description"), new Pair((Object)"-Xshare:off", (Object)"vm.option.share.off.description"), new Pair((Object)"-Xshare:on", (Object)"vm.option.share.on.description"), new Pair((Object)"-XshowSettings", (Object)"vm.option.showSettings.description"), new Pair((Object)"-XshowSettings:all", (Object)"vm.option.showSettings.all.description"), new Pair((Object)"-XshowSettings:locale", (Object)"vm.option.showSettings.locale.description"), new Pair((Object)"-XshowSettings:properties", (Object)"vm.option.showSettings.properties.description"), new Pair((Object)"-XshowSettings:vm", (Object)"vm.option.showSettings.vm.description"), new Pair((Object)"-XshowSettings:system", (Object)"vm.option.showSettings.system.description"), new Pair((Object)"-Xss", (Object)"vm.option.ss.description"), new Pair((Object)"-Xverify", (Object)"vm.option.verify.description"), new Pair((Object)"-Xincgc", (Object)"vm.option.incgc.description"), new Pair((Object)"-Xprof", (Object)"vm.option.prof.description"), new Pair((Object)"-Xint", (Object)"vm.option.int.description"), new Pair((Object)"--add-reads", (Object)"vm.option.add.reads.description"), new Pair((Object)"--add-opens", (Object)"vm.option.add.opens.description"), new Pair((Object)"--limit-modules", (Object)"vm.option.limit.modules.description"), new Pair((Object)"--patch-module", (Object)"vm.option.patch.module.description"), new Pair((Object)"--finalization=", (Object)"vm.option.finalization.description"), new Pair((Object)"--add-exports", (Object)"vm.option.add.exports.description"), new Pair((Object)"--source", (Object)"vm.option.source.description"), new Pair((Object)"--disable-@files", (Object)"vm.option.disable.files.description"), new Pair((Object)"--illegal-access=", (Object)"vm.option.illegal.access.description")};
                optionDescriptionPropertyKey = MapsKt.mapOf((Pair[])pairArray);
                kind = VMOptionKind.Product;
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R/\u0010\u0004\u001a\u001d\u0012\u0004\u0012\u00020\u0006\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t0\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/intellij/execution/vmOptions/VMOptionsParser$ParsingType$JavacExtraOptions;", "Lcom/intellij/execution/vmOptions/VMOptionsParser$ParsingType$JavacOptionsBase;", "<init>", "()V", "optionDescriptionPropertyKey", "", "", "Lorg/jetbrains/annotations/PropertyKey;", "resourceBundle", "messages.VMOptionsBundle", "getOptionDescriptionPropertyKey", "()Ljava/util/Map;", "kind", "Lcom/intellij/execution/vmOptions/VMOptionKind;", "getKind", "()Lcom/intellij/execution/vmOptions/VMOptionKind;", "intellij.java.execution.impl"})
        public static final class JavacExtraOptions
        implements JavacOptionsBase {
            @NotNull
            public static final JavacExtraOptions INSTANCE = new JavacExtraOptions();
            @NotNull
            private static final Map<String, String> optionDescriptionPropertyKey;

            private JavacExtraOptions() {
            }

            @Override
            @NotNull
            public Map<String, String> getOptionDescriptionPropertyKey() {
                return optionDescriptionPropertyKey;
            }

            @Override
            @NotNull
            public VMOptionKind getKind() {
                return VMOptionKind.Product;
            }

            static {
                Pair[] pairArray = new Pair[]{new Pair((Object)"--add-exports", (Object)"vm.option.add.exports.description"), new Pair((Object)"--add-reads", (Object)"vm.option.add.reads.description"), new Pair((Object)"--default-module-for-created-files", (Object)"vm.option.default.module.for.created.files.description"), new Pair((Object)"--disable-line-doc-comments", (Object)"vm.option.disable.line.doc.comments.description"), new Pair((Object)"--help-lint", (Object)"vm.option.help.lint.description"), new Pair((Object)"--patch-module", (Object)"vm.option.patch.module.javac.description"), new Pair((Object)"-Xbootclasspath:", (Object)"vm.option.bootclasspath.javac.description"), new Pair((Object)"-Xbootclasspath/a:", (Object)"vm.option.bootclasspath.a.javac.description"), new Pair((Object)"-Xbootclasspath/p:", (Object)"vm.option.bootclasspath.p.javac.description"), new Pair((Object)"-Xdiags:", (Object)"vm.option.diags.description"), new Pair((Object)"-Xdoclint", (Object)"vm.option.doclint.description"), new Pair((Object)"-Xdoclint:", (Object)"vm.option.doclint.groups.description"), new Pair((Object)"-Xdoclint/package:", (Object)"vm.option.doclint.package.description"), new Pair((Object)"-Xlint", (Object)"vm.option.xlint.description"), new Pair((Object)"-Xlint:", (Object)"vm.option.xlint.keys.description"), new Pair((Object)"-Xmaxerrs", (Object)"vm.option.maxerrs.description"), new Pair((Object)"-Xmaxwarns", (Object)"vm.option.maxwarns.description"), new Pair((Object)"-Xpkginfo:", (Object)"vm.option.pkginfo.description"), new Pair((Object)"-Xplugin:", (Object)"vm.option.plugin.description"), new Pair((Object)"-Xprefer:", (Object)"vm.option.prefer.description"), new Pair((Object)"-Xprint", (Object)"vm.option.print.description"), new Pair((Object)"-XprintProcessorInfo", (Object)"vm.option.print.processor.info.description"), new Pair((Object)"-XprintRounds", (Object)"vm.option.print.rounds.description"), new Pair((Object)"-Xstdout", (Object)"vm.option.stdout.description")};
                optionDescriptionPropertyKey = MapsKt.mapOf((Pair[])pairArray);
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0016J*\u0010\u0005\u001a\u0004\u0018\u00010\u0003*\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00032\b\b\u0002\u0010\t\u001a\u00020\nH\u0002\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000b\u00c0\u0006\u0001"}, d2={"Lcom/intellij/execution/vmOptions/VMOptionsParser$ParsingType$JavacOptionsBase;", "Lcom/intellij/execution/vmOptions/VMOptionsParser$ParsingType;", "parseName", "", "input", "extractPrefix", "delimiter", "Lkotlin/text/Regex;", "suffix", "shouldHaveTwoParts", "", "intellij.java.execution.impl"})
        @SourceDebugExtension(value={"SMAP\nVMOptionsParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VMOptionsParser.kt\ncom/intellij/execution/vmOptions/VMOptionsParser$ParsingType$JavacOptionsBase\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,275:1\n1#2:276\n*E\n"})
        public static interface JavacOptionsBase
        extends ParsingType {
            @Override
            @NotNull
            default public String parseName(@NotNull String input) {
                Intrinsics.checkNotNullParameter((Object)input, (String)"input");
                String string = JavacOptionsBase.extractPrefix$default(this, input, new Regex(":[\"\\[{(]"), ":", false, 4, null);
                if (string != null) {
                    String it = string;
                    boolean bl = false;
                    return it;
                }
                String string2 = JavacOptionsBase.extractPrefix$default(this, input, new Regex("\\["), "", false, 4, null);
                if (string2 != null) {
                    String it = string2;
                    boolean bl = false;
                    return it;
                }
                String string3 = JavacOptionsBase.extractPrefix$default(this, input, new Regex("<"), null, false, 2, null);
                if (string3 == null) {
                    throw new IllegalArgumentException("Cannot parse option name: " + input);
                }
                return string3;
            }

            private String extractPrefix(String $this$extractPrefix, Regex delimiter, String suffix, boolean shouldHaveTwoParts) {
                String string;
                Object object = $this$extractPrefix;
                int n = 0;
                List parts = delimiter.split((CharSequence)object, n);
                if (parts.size() == 2 || !shouldHaveTwoParts) {
                    object = new char[1];
                    object[0] = 44;
                    string = StringsKt.trimEnd((String)((String)CollectionsKt.first((List)parts)), (char[])object) + suffix;
                } else {
                    string = null;
                }
                return string;
            }

            public static /* synthetic */ String extractPrefix$default(JavacOptionsBase javacOptionsBase, String string, Regex regex, String string2, boolean bl, int n, Object object) {
                if (object != null) {
                    throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: extractPrefix");
                }
                if ((n & 2) != 0) {
                    string2 = "";
                }
                if ((n & 4) != 0) {
                    bl = true;
                }
                return javacOptionsBase.extractPrefix(string, regex, string2, bl);
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R/\u0010\u0004\u001a\u001d\u0012\u0004\u0012\u00020\u0006\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t0\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/intellij/execution/vmOptions/VMOptionsParser$ParsingType$JavacStandardOptions;", "Lcom/intellij/execution/vmOptions/VMOptionsParser$ParsingType$JavacOptionsBase;", "<init>", "()V", "optionDescriptionPropertyKey", "", "", "Lorg/jetbrains/annotations/PropertyKey;", "resourceBundle", "messages.VMOptionsBundle", "getOptionDescriptionPropertyKey", "()Ljava/util/Map;", "kind", "Lcom/intellij/execution/vmOptions/VMOptionKind;", "getKind", "()Lcom/intellij/execution/vmOptions/VMOptionKind;", "intellij.java.execution.impl"})
        public static final class JavacStandardOptions
        implements JavacOptionsBase {
            @NotNull
            public static final JavacStandardOptions INSTANCE = new JavacStandardOptions();
            @NotNull
            private static final Map<String, String> optionDescriptionPropertyKey;
            @NotNull
            private static final VMOptionKind kind;

            private JavacStandardOptions() {
            }

            @Override
            @NotNull
            public Map<String, String> getOptionDescriptionPropertyKey() {
                return optionDescriptionPropertyKey;
            }

            @Override
            @NotNull
            public VMOptionKind getKind() {
                return kind;
            }

            static {
                Pair[] pairArray = new Pair[]{new Pair((Object)"--add-modules", (Object)"vm.option.add.modules.description"), new Pair((Object)"--boot-class-path", (Object)"vm.option.boot.classpath.description"), new Pair((Object)"--class-path", (Object)"vm.option.classpath.description"), new Pair((Object)"-deprecation", (Object)"vm.option.deprecation.description"), new Pair((Object)"--enable-preview", (Object)"vm.option.enable.preview.description"), new Pair((Object)"--help,", (Object)"vm.option.help.description"), new Pair((Object)"--help-extra,", (Object)"vm.option.help.extra.description"), new Pair((Object)"--limit-modules", (Object)"vm.option.limit.modules.javac.description"), new Pair((Object)"--module", (Object)"vm.option.module.description"), new Pair((Object)"--module-path", (Object)"vm.option.module.path.description"), new Pair((Object)"--module-source-path", (Object)"vm.option.module.source.path.description"), new Pair((Object)"--module-version", (Object)"vm.option.module.version.description"), new Pair((Object)"--processor-module-path", (Object)"vm.option.processor.module.path.description"), new Pair((Object)"--processor-path", (Object)"vm.option.processor.path.description"), new Pair((Object)"--release", (Object)"vm.option.release.description"), new Pair((Object)"--source", (Object)"vm.option.source.release.description"), new Pair((Object)"--source-path", (Object)"vm.option.source.path.description"), new Pair((Object)"--system", (Object)"vm.option.system.description"), new Pair((Object)"--target", (Object)"vm.option.target.description"), new Pair((Object)"--upgrade-module-path", (Object)"vm.option.upgrade.module.path.description"), new Pair((Object)"--version,", (Object)"vm.option.version.description")};
                optionDescriptionPropertyKey = MapsKt.mapOf((Pair[])pairArray);
                kind = VMOptionKind.Standard;
            }
        }
    }
}

