/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.execution;

import com.intellij.build.BuildView;
import com.intellij.debugger.DebugEnvironment;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.DefaultDebugEnvironment;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JavaDebugProcess;
import com.intellij.debugger.engine.RemoteConnectionStub;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.GenericDebuggerRunner;
import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunnableState;
import com.intellij.openapi.externalSystem.service.execution.ForkedDebuggerThread;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import java.net.ServerSocket;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemTaskDebugRunner
extends GenericDebuggerRunner {
    static final Logger LOG = Logger.getInstance(ExternalSystemTaskDebugRunner.class);
    private static final String ATTACH_VM_FAILED = "ATTACH_VM_FAILED";

    @NotNull
    public String getRunnerId() {
        return "ExternalSystemTaskDebugRunner";
    }

    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
        if (executorId == null) {
            ExternalSystemTaskDebugRunner.$$$reportNull$$$0(0);
        }
        if (profile == null) {
            ExternalSystemTaskDebugRunner.$$$reportNull$$$0(1);
        }
        return profile instanceof ExternalSystemRunConfiguration && "Debug".equals(executorId) && !((ExternalSystemRunConfiguration)profile).isDebuggingDisabled();
    }

    @Nullable
    protected RunContentDescriptor createContentDescriptor(@NotNull RunProfileState state, @NotNull ExecutionEnvironment environment) throws ExecutionException {
        if (state == null) {
            ExternalSystemTaskDebugRunner.$$$reportNull$$$0(2);
        }
        if (environment == null) {
            ExternalSystemTaskDebugRunner.$$$reportNull$$$0(3);
        }
        if (state instanceof ExternalSystemRunnableState) {
            ExternalSystemRunnableState runnableState = (ExternalSystemRunnableState)state;
            int port = runnableState.getDebugPort();
            if (port > 0) {
                RunContentDescriptor runContentDescriptor = ExternalSystemTaskDebugRunner.doGetRunContentDescriptor(runnableState, environment);
                if (runContentDescriptor == null) {
                    return null;
                }
                ProcessHandler processHandler = runContentDescriptor.getProcessHandler();
                ServerSocket socket = runnableState.getForkSocket();
                if (socket != null && processHandler != null) {
                    new ForkedDebuggerThread(processHandler, runContentDescriptor, socket, environment, runnableState).start();
                }
                return runContentDescriptor;
            }
            LOG.warn("Can't attach debugger to external system task execution. Reason: target debug port is unknown");
        } else {
            LOG.warn(String.format("Can't attach debugger to external system task execution. Reason: invalid run profile state is provided- expected '%s' but got '%s'", ExternalSystemRunnableState.class.getName(), state.getClass().getName()));
        }
        return null;
    }

    @Nullable
    private static RunContentDescriptor doGetRunContentDescriptor(@NotNull ExternalSystemRunnableState state, @NotNull ExecutionEnvironment environment) throws ExecutionException {
        RunContentDescriptor runContentDescriptor;
        if (state == null) {
            ExternalSystemTaskDebugRunner.$$$reportNull$$$0(4);
        }
        if (environment == null) {
            ExternalSystemTaskDebugRunner.$$$reportNull$$$0(5);
        }
        if ((runContentDescriptor = ExternalSystemTaskDebugRunner.createProcessToDebug(state, environment)) == null) {
            return null;
        }
        state.setContentDescriptor(runContentDescriptor);
        ExecutionConsole executionConsole = runContentDescriptor.getExecutionConsole();
        if (executionConsole instanceof BuildView) {
            return runContentDescriptor;
        }
        RunContentDescriptor descriptor = new RunContentDescriptor(runContentDescriptor.getExecutionConsole(), runContentDescriptor.getProcessHandler(), runContentDescriptor.getComponent(), runContentDescriptor.getDisplayName(), runContentDescriptor.getIcon(), null, runContentDescriptor.getRestartActions()){

            public boolean isHiddenContent() {
                return true;
            }
        };
        descriptor.setRunnerLayoutUi(runContentDescriptor.getRunnerLayoutUi());
        return descriptor;
    }

    @NotNull
    private static XDebugProcess jvmProcessToDebug(@NotNull XDebugSession session, ExternalSystemRunnableState state, @NotNull ExecutionEnvironment env) throws ExecutionException {
        if (session == null) {
            ExternalSystemTaskDebugRunner.$$$reportNull$$$0(6);
        }
        if (env == null) {
            ExternalSystemTaskDebugRunner.$$$reportNull$$$0(7);
        }
        String debugPort = String.valueOf(state.getDebugPort());
        RemoteConnection connection = state.isDebugServerProcess() ? new RemoteConnection(true, "127.0.0.1", debugPort, true) : new RemoteConnectionStub(true, "127.0.0.1", debugPort, true);
        DefaultDebugEnvironment environment = new DefaultDebugEnvironment(env, (RunProfileState)state, connection, 30000L);
        DebuggerSession debuggerSession = DebuggerManagerEx.getInstanceEx((Project)env.getProject()).attachVirtualMachine((DebugEnvironment)environment);
        if (debuggerSession == null) {
            throw new ExecutionException(ATTACH_VM_FAILED);
        }
        DebugProcessImpl debugProcess = debuggerSession.getProcess();
        XDebugSessionImpl sessionImpl = (XDebugSessionImpl)session;
        ExecutionResult executionResult = debugProcess.getExecutionResult();
        sessionImpl.addExtraActions(executionResult.getActions());
        if (executionResult instanceof DefaultExecutionResult) {
            sessionImpl.addRestartActions(((DefaultExecutionResult)executionResult).getRestartActions());
        }
        JavaDebugProcess javaDebugProcess = JavaDebugProcess.create((XDebugSession)session, (DebuggerSession)debuggerSession);
        if (javaDebugProcess == null) {
            ExternalSystemTaskDebugRunner.$$$reportNull$$$0(8);
        }
        return javaDebugProcess;
    }

    @Nullable
    private static RunContentDescriptor createProcessToDebug(final ExternalSystemRunnableState state, final @NotNull ExecutionEnvironment env) throws ExecutionException {
        RunContentDescriptor result;
        if (env == null) {
            ExternalSystemTaskDebugRunner.$$$reportNull$$$0(9);
        }
        try {
            XDebugProcessStarter starter = new XDebugProcessStarter(){

                @NotNull
                public XDebugProcess start(@NotNull XDebugSession session) throws ExecutionException {
                    if (session == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    XDebugProcess xDebugProcess = ExternalSystemTaskDebugRunner.jvmProcessToDebug(session, state, env);
                    if (xDebugProcess == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    return xDebugProcess;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[switch (n) {
                        default -> 3;
                        case 1 -> 2;
                    }];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "session";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/openapi/externalSystem/service/execution/ExternalSystemTaskDebugRunner$2";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/openapi/externalSystem/service/execution/ExternalSystemTaskDebugRunner$2";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "start";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "start";
                            break;
                        }
                        case 1: {
                            break;
                        }
                    }
                    String string = String.format(v0, objectArray);
                    throw switch (n) {
                        default -> new IllegalArgumentException(string);
                        case 1 -> new IllegalStateException(string);
                    };
                }
            };
            result = XDebuggerManager.getInstance((Project)env.getProject()).newSessionBuilder(starter).environment(env).startSession().getRunContentDescriptor();
        }
        catch (ExecutionException e) {
            if (!e.getMessage().equals(ATTACH_VM_FAILED)) {
                throw e;
            }
            result = null;
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executorId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profile";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/execution/ExternalSystemTaskDebugRunner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/execution/ExternalSystemTaskDebugRunner";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "jvmProcessToDebug";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canRun";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createContentDescriptor";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doGetRunContentDescriptor";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "jvmProcessToDebug";
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createProcessToDebug";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8 -> new IllegalStateException(string);
        };
    }
}

