/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testIntegration;

import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.TestStateStorage;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.testIntegration.ConfigurationByRecordProvider;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;

final class RunConfigurationByRecordProvider
implements ConfigurationByRecordProvider {
    private final Project myProject;
    private final Int2ObjectMap<RunnerAndConfigurationSettings> myConfigurationsMap = new Int2ObjectOpenHashMap();

    RunConfigurationByRecordProvider(Project project) {
        this.myProject = project;
        this.initRunConfigurationsMap();
    }

    @Override
    public RunnerAndConfigurationSettings getConfiguration(TestStateStorage.Record record) {
        return (RunnerAndConfigurationSettings)this.myConfigurationsMap.get((int)record.configurationHash);
    }

    private void initRunConfigurationsMap() {
        for (RunnerAndConfigurationSettings settings : RunManagerImpl.getInstanceImpl((Project)this.myProject).getAllSettings()) {
            this.myConfigurationsMap.put(settings.getName().hashCode(), (Object)settings);
        }
    }
}

