/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testIntegration;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.testIntegration.RecentTestRunner;
import com.intellij.testIntegration.RecentTestsPopupEntry;
import com.intellij.testIntegration.SelectConfigurationStep;
import com.intellij.testIntegration.SingleTestEntry;
import com.intellij.testIntegration.TestConfigurationCollector;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B)\u0012\n\b\u0001\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0002H\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0002H\u0016J \u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0010H\u0016J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0002H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/testIntegration/SelectTestStep;", "Lcom/intellij/openapi/ui/popup/util/BaseListPopupStep;", "Lcom/intellij/testIntegration/RecentTestsPopupEntry;", "title", "", "tests", "", "runner", "Lcom/intellij/testIntegration/RecentTestRunner;", "<init>", "(Ljava/lang/String;Ljava/util/List;Lcom/intellij/testIntegration/RecentTestRunner;)V", "getIconFor", "Ljavax/swing/Icon;", "value", "getTextFor", "isSpeedSearchEnabled", "", "hasSubstep", "selectedValue", "onChosen", "Lcom/intellij/openapi/ui/popup/PopupStep;", "entry", "finalChoice", "getConfigurations", "intellij.java.execution.impl"})
public final class SelectTestStep
extends BaseListPopupStep<RecentTestsPopupEntry> {
    @NotNull
    private final RecentTestRunner runner;

    public SelectTestStep(@NlsContexts.PopupTitle @Nullable String title, @NotNull List<? extends RecentTestsPopupEntry> tests, @NotNull RecentTestRunner runner) {
        Intrinsics.checkNotNullParameter(tests, (String)"tests");
        Intrinsics.checkNotNullParameter((Object)runner, (String)"runner");
        super(title, tests);
        this.runner = runner;
    }

    @NotNull
    public Icon getIconFor(@NotNull RecentTestsPopupEntry value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (value instanceof SingleTestEntry) {
            Icon icon = AllIcons.RunConfigurations.TestFailed;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"TestFailed");
            return icon;
        }
        Icon icon = AllIcons.RunConfigurations.TestPassed;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"TestPassed");
        return icon;
    }

    @NotNull
    public String getTextFor(@NotNull RecentTestsPopupEntry value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return value.getPresentation();
    }

    public boolean isSpeedSearchEnabled() {
        return true;
    }

    public boolean hasSubstep(@NotNull RecentTestsPopupEntry selectedValue) {
        Intrinsics.checkNotNullParameter((Object)selectedValue, (String)"selectedValue");
        return !((Collection)this.getConfigurations(selectedValue)).isEmpty();
    }

    @Nullable
    public PopupStep<RecentTestsPopupEntry> onChosen(@NotNull RecentTestsPopupEntry entry, boolean finalChoice) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        if (finalChoice) {
            this.runner.run(entry);
            return null;
        }
        List<RecentTestsPopupEntry> configurations = this.getConfigurations(entry);
        return (PopupStep)new SelectConfigurationStep(configurations, this.runner);
    }

    private final List<RecentTestsPopupEntry> getConfigurations(RecentTestsPopupEntry entry) {
        TestConfigurationCollector collector = new TestConfigurationCollector();
        entry.accept(collector);
        return collector.getEnclosingConfigurations();
    }
}

