/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal.backend;

import com.intellij.openapi.diagnostic.Logger;
import com.jediterm.core.typeahead.TerminalTypeAheadManager;
import com.jediterm.terminal.TerminalDataStream;
import com.jediterm.terminal.TerminalExecutorServiceManager;
import com.jediterm.terminal.TerminalStarter;
import com.jediterm.terminal.TtyConnector;
import com.jediterm.terminal.model.JediTerminal;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.TimeMark;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.fus.BatchLatencyReporter;
import org.jetbrains.plugins.terminal.fus.BatchLatencyReporterKt;
import org.jetbrains.plugins.terminal.fus.ReworkedTerminalUsageCollector;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0016\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ\b\u0010\u0014\u001a\u00020\u000fH\u0016J\u0019\u0010\u001f\u001a\u00020\u00192\u000e\b\u0004\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00190!H\u0082\bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/terminal/backend/TerminalStarterEx;", "Lcom/jediterm/terminal/TerminalStarter;", "terminal", "Lcom/jediterm/terminal/model/JediTerminal;", "ttyConnector", "Lcom/jediterm/terminal/TtyConnector;", "dataStream", "Lcom/jediterm/terminal/TerminalDataStream;", "typeAheadManager", "Lcom/jediterm/core/typeahead/TerminalTypeAheadManager;", "executorServiceManager", "Lcom/jediterm/terminal/TerminalExecutorServiceManager;", "<init>", "(Lcom/jediterm/terminal/model/JediTerminal;Lcom/jediterm/terminal/TtyConnector;Lcom/jediterm/terminal/TerminalDataStream;Lcom/jediterm/core/typeahead/TerminalTypeAheadManager;Lcom/jediterm/terminal/TerminalExecutorServiceManager;)V", "value", "", "isStopped", "()Z", "singleThreadScheduledExecutor", "Ljava/util/concurrent/ScheduledExecutorService;", "isLastSentByteEscape", "typingLatencyReporter", "Lorg/jetbrains/plugins/terminal/fus/BatchLatencyReporter;", "Lkotlin/time/Duration;", "requestEmulatorStop", "", "sendTypedBytes", "bytes", "", "eventTime", "Lkotlin/time/TimeMark;", "execute", "action", "Lkotlin/Function0;", "intellij.terminal.backend"})
@SourceDebugExtension(value={"SMAP\nTerminalStarterEx.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalStarterEx.kt\ncom/intellij/terminal/backend/TerminalStarterEx\n*L\n1#1,81:1\n76#1,4:82\n*S KotlinDebug\n*F\n+ 1 TerminalStarterEx.kt\ncom/intellij/terminal/backend/TerminalStarterEx\n*L\n58#1:82,4\n*E\n"})
public final class TerminalStarterEx
extends TerminalStarter {
    @NotNull
    private final TtyConnector ttyConnector;
    private volatile boolean isStopped;
    @NotNull
    private final ScheduledExecutorService singleThreadScheduledExecutor;
    private volatile boolean isLastSentByteEscape;
    @NotNull
    private final BatchLatencyReporter<Duration> typingLatencyReporter;

    public TerminalStarterEx(@NotNull JediTerminal terminal, @NotNull TtyConnector ttyConnector, @NotNull TerminalDataStream dataStream, @NotNull TerminalTypeAheadManager typeAheadManager, @NotNull TerminalExecutorServiceManager executorServiceManager) {
        Intrinsics.checkNotNullParameter((Object)terminal, (String)"terminal");
        Intrinsics.checkNotNullParameter((Object)ttyConnector, (String)"ttyConnector");
        Intrinsics.checkNotNullParameter((Object)dataStream, (String)"dataStream");
        Intrinsics.checkNotNullParameter((Object)typeAheadManager, (String)"typeAheadManager");
        Intrinsics.checkNotNullParameter((Object)executorServiceManager, (String)"executorServiceManager");
        super(terminal, ttyConnector, dataStream, typeAheadManager, executorServiceManager);
        this.ttyConnector = ttyConnector;
        ScheduledExecutorService scheduledExecutorService = executorServiceManager.getSingleThreadScheduledExecutor();
        Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService, (String)"getSingleThreadScheduledExecutor(...)");
        this.singleThreadScheduledExecutor = scheduledExecutorService;
        this.typingLatencyReporter = new BatchLatencyReporter(50, TerminalStarterEx::typingLatencyReporter$lambda$0);
    }

    public final boolean isStopped() {
        return this.isStopped;
    }

    public void requestEmulatorStop() {
        super.requestEmulatorStop();
        this.isStopped = true;
    }

    public final void sendTypedBytes(@NotNull byte[] bytes, @NotNull TimeMark eventTime) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        Intrinsics.checkNotNullParameter((Object)eventTime, (String)"eventTime");
        int length = bytes.length;
        if (length > 0) {
            this.isLastSentByteEscape = bytes[length - 1] == 27;
        }
        TerminalStarterEx this_$iv = this;
        boolean $i$f$execute = false;
        if (!this_$iv.singleThreadScheduledExecutor.isShutdown()) {
            this_$iv.singleThreadScheduledExecutor.execute(new Runnable(this, bytes, eventTime){
                final /* synthetic */ TerminalStarterEx this$0;
                final /* synthetic */ byte[] $bytes$inlined;
                final /* synthetic */ TimeMark $eventTime$inlined;
                {
                    this.this$0 = terminalStarterEx;
                    this.$bytes$inlined = byArray;
                    this.$eventTime$inlined = timeMark;
                }

                public final void run() {
                    boolean bl = false;
                    try {
                        TerminalStarterEx.access$getTtyConnector$p(this.this$0).write(this.$bytes$inlined);
                        long latency = this.$eventTime$inlined.elapsedNow-UwyO8pc();
                        TerminalStarterEx.access$getTypingLatencyReporter$p(this.this$0).update(Duration.box-impl((long)latency));
                    }
                    catch (IOException e) {
                        TerminalStarterEx $this$thisLogger$iv = this.this$0;
                        boolean $i$f$thisLogger = false;
                        Logger logger = Logger.getInstance(TerminalStarterEx.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                        logger.info("Cannot write to TtyConnector " + TerminalStarterEx.access$getTtyConnector$p(this.this$0).getClass().getName() + ", connected: " + TerminalStarterEx.access$getTtyConnector$p(this.this$0).isConnected(), (Throwable)e);
                    }
                }
            });
        }
    }

    public boolean isLastSentByteEscape() {
        return this.isLastSentByteEscape || super.isLastSentByteEscape();
    }

    private final void execute(Function0<Unit> action) {
        boolean $i$f$execute = false;
        if (!this.singleThreadScheduledExecutor.isShutdown()) {
            this.singleThreadScheduledExecutor.execute(new Runnable(action){
                final /* synthetic */ Function0<Unit> $action;
                {
                    this.$action = $action;
                }

                public final void run() {
                    this.$action.invoke();
                }
            });
        }
    }

    private static final Unit typingLatencyReporter$lambda$0(List samples) {
        Intrinsics.checkNotNullParameter((Object)samples, (String)"samples");
        ReworkedTerminalUsageCollector.INSTANCE.logBackendTypingLatency-WzaCiaA(BatchLatencyReporterKt.totalDuration(samples), ((Duration)BatchLatencyReporterKt.percentile(samples, 90)).unbox-impl(), ((Duration)BatchLatencyReporterKt.secondLargest(samples)).unbox-impl());
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ TtyConnector access$getTtyConnector$p(TerminalStarterEx $this) {
        return $this.ttyConnector;
    }

    public static final /* synthetic */ BatchLatencyReporter access$getTypingLatencyReporter$p(TerminalStarterEx $this) {
        return $this.typingLatencyReporter;
    }
}

