/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal.frontend.toolwindow.impl;

import com.intellij.openapi.fileEditor.FileEditorManagerKeys;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.fileEditor.impl.FileEditorOpenOptions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.impl.content.ToolWindowInEditorSupport;
import com.intellij.terminal.frontend.editor.TerminalViewVirtualFile;
import com.intellij.terminal.frontend.toolwindow.TerminalToolWindowTab;
import com.intellij.terminal.frontend.toolwindow.TerminalToolWindowTabsManager;
import com.intellij.terminal.frontend.toolwindow.TerminalToolWindowTabsManagerKt;
import com.intellij.terminal.frontend.toolwindow.impl.TerminalToolWindowTabsManagerImpl;
import com.intellij.ui.content.Content;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\rH\u0002\u00a8\u0006\u0012"}, d2={"Lcom/intellij/terminal/frontend/toolwindow/impl/TerminalInEditorSupport;", "Lcom/intellij/openapi/wm/impl/content/ToolWindowInEditorSupport;", "<init>", "()V", "canOpenInEditor", "", "project", "Lcom/intellij/openapi/project/Project;", "content", "Lcom/intellij/ui/content/Content;", "openInEditor", "", "targetWindow", "Lcom/intellij/openapi/fileEditor/impl/EditorWindow;", "openReworkedTerminalInEditor", "tab", "Lcom/intellij/terminal/frontend/toolwindow/TerminalToolWindowTab;", "editorWindow", "intellij.terminal.frontend"})
public final class TerminalInEditorSupport
implements ToolWindowInEditorSupport {
    public boolean canOpenInEditor(@NotNull Project project, @NotNull Content content) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        return TerminalToolWindowTabsManagerKt.findTabByContent(TerminalToolWindowTabsManager.Companion.getInstance(project), content) != null;
    }

    public void openInEditor(@NotNull Content content, @NotNull EditorWindow targetWindow) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)targetWindow, (String)"targetWindow");
        Project project = targetWindow.getOwner().getManager().getProject();
        TerminalToolWindowTab terminalToolWindowTab = TerminalToolWindowTabsManagerKt.findTabByContent(TerminalToolWindowTabsManager.Companion.getInstance(project), content);
        if (terminalToolWindowTab == null) {
            return;
        }
        TerminalToolWindowTab terminalTab = terminalToolWindowTab;
        this.openReworkedTerminalInEditor(terminalTab, targetWindow);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void openReworkedTerminalInEditor(TerminalToolWindowTab tab, EditorWindow editorWindow) {
        tab.getContent().putUserData(TerminalToolWindowTabsManagerImpl.Companion.getTAB_DETACHED_KEY(), (Object)Unit.INSTANCE);
        TerminalViewVirtualFile file = new TerminalViewVirtualFile(tab.getView());
        file.putUserData(FileEditorManagerKeys.CLOSING_TO_REOPEN, true);
        try {
            FileEditorManagerImpl manager = editorWindow.getManager();
            manager.openFile((VirtualFile)file, editorWindow, new FileEditorOpenOptions(false, false, false, true, false, 0, false, null, false, false, false, null, 4087, null));
        }
        finally {
            file.putUserData(FileEditorManagerKeys.CLOSING_TO_REOPEN, null);
        }
    }
}

