/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal.frontend.view.completion;

import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import com.intellij.terminal.frontend.view.TerminalView;
import com.intellij.terminal.frontend.view.completion.TerminalCommandCompletionService;
import com.intellij.terminal.frontend.view.completion.TerminalCommandCompletionTypingListener;
import com.intellij.terminal.frontend.view.impl.TerminalEventsHandlerImplKt;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.DebugProbesKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CancellableContinuation;
import kotlinx.coroutines.CancellableContinuationImpl;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.TimeoutKt;
import kotlinx.coroutines.channels.Channel;
import kotlinx.coroutines.channels.ChannelKt;
import kotlinx.coroutines.channels.ChannelResult;
import kotlinx.coroutines.channels.ReceiveChannel;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.TerminalOptionsProvider;
import org.jetbrains.plugins.terminal.block.reworked.TerminalCommandCompletion;
import org.jetbrains.plugins.terminal.session.ShellName;
import org.jetbrains.plugins.terminal.session.TerminalStartupOptions;
import org.jetbrains.plugins.terminal.session.TerminalStartupOptionsKt;
import org.jetbrains.plugins.terminal.util.TerminalCoroutineKt;
import org.jetbrains.plugins.terminal.view.TerminalContentChangeEvent;
import org.jetbrains.plugins.terminal.view.TerminalCursorOffsetChangeEvent;
import org.jetbrains.plugins.terminal.view.TerminalOffset;
import org.jetbrains.plugins.terminal.view.TerminalOutputModel;
import org.jetbrains.plugins.terminal.view.TerminalOutputModelListener;
import org.jetbrains.plugins.terminal.view.shellIntegration.TerminalOutputStatus;
import org.jetbrains.plugins.terminal.view.shellIntegration.TerminalShellIntegration;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001:\u0001\"B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\t\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0016\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\b\u0010\u001d\u001a\u00020\u0015H\u0002J\u001e\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0082@\u00a2\u0006\u0002\u0010\u001fJ\u001e\u0010 \u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0082@\u00a2\u0006\u0002\u0010\u001fJ\u0010\u0010!\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/terminal/frontend/view/completion/TerminalCommandCompletionTypingListener;", "", "terminalView", "Lcom/intellij/terminal/frontend/view/TerminalView;", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "outputModel", "Lorg/jetbrains/plugins/terminal/view/TerminalOutputModel;", "shellIntegrationDeferred", "Lkotlinx/coroutines/Deferred;", "Lorg/jetbrains/plugins/terminal/view/shellIntegration/TerminalShellIntegration;", "startupOptionsDeferred", "Lorg/jetbrains/plugins/terminal/session/TerminalStartupOptions;", "<init>", "(Lcom/intellij/terminal/frontend/view/TerminalView;Lcom/intellij/openapi/editor/ex/EditorEx;Lorg/jetbrains/plugins/terminal/view/TerminalOutputModel;Lkotlinx/coroutines/Deferred;Lkotlinx/coroutines/Deferred;)V", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "typingEventsChannel", "Lkotlinx/coroutines/channels/Channel;", "Lcom/intellij/terminal/frontend/view/completion/TerminalCommandCompletionTypingListener$TypingEvent;", "onCharTyped", "", "beforeTypingCursorOffset", "Lorg/jetbrains/plugins/terminal/view/TerminalOffset;", "char", "", "isTypingHappened", "", "canInvokeCompletion", "invokeCompletion", "awaitTypingHappenedAndInvokeCompletion", "(Lorg/jetbrains/plugins/terminal/view/TerminalOffset;CLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "awaitTypingHappened", "canTriggerCompletionForChar", "TypingEvent", "intellij.terminal.frontend"})
@SourceDebugExtension(value={"SMAP\nTerminalCommandCompletionTypingListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalCommandCompletionTypingListener.kt\ncom/intellij/terminal/frontend/view/completion/TerminalCommandCompletionTypingListener\n+ 2 CancellableContinuation.kt\nkotlinx/coroutines/CancellableContinuationKt\n*L\n1#1,158:1\n426#2,11:159\n*S KotlinDebug\n*F\n+ 1 TerminalCommandCompletionTypingListener.kt\ncom/intellij/terminal/frontend/view/completion/TerminalCommandCompletionTypingListener\n*L\n125#1:159,11\n*E\n"})
public final class TerminalCommandCompletionTypingListener {
    @NotNull
    private final TerminalView terminalView;
    @NotNull
    private final EditorEx editor;
    @NotNull
    private final TerminalOutputModel outputModel;
    @NotNull
    private final Deferred<TerminalShellIntegration> shellIntegrationDeferred;
    @NotNull
    private final Deferred<TerminalStartupOptions> startupOptionsDeferred;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final Channel<TypingEvent> typingEventsChannel;

    public TerminalCommandCompletionTypingListener(@NotNull TerminalView terminalView, @NotNull EditorEx editor, @NotNull TerminalOutputModel outputModel, @NotNull Deferred<? extends TerminalShellIntegration> shellIntegrationDeferred, @NotNull Deferred<? extends TerminalStartupOptions> startupOptionsDeferred) {
        Intrinsics.checkNotNullParameter((Object)terminalView, (String)"terminalView");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)outputModel, (String)"outputModel");
        Intrinsics.checkNotNullParameter(shellIntegrationDeferred, (String)"shellIntegrationDeferred");
        Intrinsics.checkNotNullParameter(startupOptionsDeferred, (String)"startupOptionsDeferred");
        this.terminalView = terminalView;
        this.editor = editor;
        this.outputModel = outputModel;
        this.shellIntegrationDeferred = shellIntegrationDeferred;
        this.startupOptionsDeferred = startupOptionsDeferred;
        this.coroutineScope = CoroutineScopeKt.childScope$default((CoroutineScope)this.terminalView.getCoroutineScope(), (String)"TerminalCommandCompletionTypingListener", null, (boolean)false, (int)6, null);
        this.typingEventsChannel = ChannelKt.Channel$default((int)-1, null, null, (int)6, null);
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, (CoroutineContext)CoroutinesKt.getUI((Dispatchers)Dispatchers.INSTANCE), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ TerminalCommandCompletionTypingListener this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                CoroutineScope coroutineScope = (CoroutineScope)this.L$0;
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$launch;
                        ResultKt.throwOnFailure((Object)$result);
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$launch);
                        this.label = 1;
                        Object object2 = FlowKt.collectLatest((Flow)FlowKt.consumeAsFlow((ReceiveChannel)((ReceiveChannel)this.this$0.typingEventsChannel)), (Function2)((Function2)new Function2<TypingEvent, Continuation<? super Unit>, Object>((CoroutineScope)$this$launch, this.this$0, null){
                            int label;
                            /* synthetic */ Object L$0;
                            final /* synthetic */ CoroutineScope $$this$launch;
                            final /* synthetic */ TerminalCommandCompletionTypingListener this$0;
                            {
                                this.$$this$launch = $$this$launch;
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            /*
                             * Unable to fully structure code
                             */
                            public final Object invokeSuspend(Object $result) {
                                var2_2 = (TypingEvent)this.L$0;
                                var6_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)it);
                                        this.label = 1;
                                        v0 = TimeoutKt.withTimeoutOrNull-KLykuaI((long)DurationKt.toDuration((int)1000, (DurationUnit)DurationUnit.MILLISECONDS), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, (TypingEvent)it, null){
                                            int label;
                                            final /* synthetic */ TerminalCommandCompletionTypingListener this$0;
                                            final /* synthetic */ TypingEvent $it;
                                            {
                                                this.this$0 = $receiver;
                                                this.$it = $it;
                                                super(2, $completion);
                                            }

                                            /*
                                             * Enabled force condition propagation
                                             * Lifted jumps to return sites
                                             */
                                            public final Object invokeSuspend(Object $result) {
                                                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                switch (this.label) {
                                                    case 0: {
                                                        ResultKt.throwOnFailure((Object)$result);
                                                        this.label = 1;
                                                        Object object2 = this.this$0.awaitTypingHappenedAndInvokeCompletion(this.$it.getBeforeTypingCursorOffset(), this.$it.getChar(), (Continuation<? super Unit>)((Continuation)this));
                                                        if (object2 != object) return Unit.INSTANCE;
                                                        return object;
                                                    }
                                                    case 1: {
                                                        ResultKt.throwOnFailure((Object)$result);
                                                        Object object2 = $result;
                                                        return Unit.INSTANCE;
                                                    }
                                                }
                                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                            }

                                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                            }

                                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                            }
                                        }), (Continuation)((Continuation)this));
                                        ** if (v0 != var6_3) goto lbl14
lbl13:
                                        // 1 sources

                                        return var6_3;
lbl14:
                                        // 1 sources

                                        ** GOTO lbl20
                                    }
                                    case 1: {
                                        try {
                                            ResultKt.throwOnFailure((Object)$result);
                                            v0 = $result;
lbl20:
                                            // 2 sources

                                            (Unit)v0;
                                        }
                                        catch (CancellationException e) {
                                            throw e;
                                        }
                                        catch (Exception e) {
                                            $this$thisLogger$iv = this.$$this$launch;
                                            $i$f$thisLogger = false;
                                            v1 = Logger.getInstance(CoroutineScope.class);
                                            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getInstance(...)");
                                            v1.error("Exception during completion scheduling", (Throwable)e);
                                        }
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                var3_3.L$0 = value;
                                return (Continuation)var3_3;
                            }

                            public final Object invoke(TypingEvent p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    public final void onCharTyped(@NotNull TerminalOffset beforeTypingCursorOffset, char c) {
        Intrinsics.checkNotNullParameter((Object)beforeTypingCursorOffset, (String)"beforeTypingCursorOffset");
        if (!this.canInvokeCompletion(c)) {
            return;
        }
        if (this.isTypingHappened(beforeTypingCursorOffset, c)) {
            this.invokeCompletion();
        } else {
            ChannelResult.box-impl((Object)this.typingEventsChannel.trySend-JP2dKIU((Object)new TypingEvent(beforeTypingCursorOffset, c)));
        }
    }

    private final boolean isTypingHappened(TerminalOffset beforeTypingCursorOffset, char c) {
        TerminalOffset newCursorOffset = beforeTypingCursorOffset.plus(1L);
        TerminalOffset startOffset = (TerminalOffset)RangesKt.coerceIn((Comparable)beforeTypingCursorOffset, (Comparable)this.outputModel.getStartOffset(), (Comparable)this.outputModel.getEndOffset());
        TerminalOffset endOffset = (TerminalOffset)RangesKt.coerceIn((Comparable)newCursorOffset, (Comparable)this.outputModel.getStartOffset(), (Comparable)this.outputModel.getEndOffset());
        String typedText = ((Object)this.outputModel.getText(startOffset, endOffset)).toString();
        Character c2 = StringsKt.singleOrNull((CharSequence)typedText);
        char c3 = c;
        return c2 != null && c2.charValue() == c3 && this.outputModel.getCursorOffset().compareTo(newCursorOffset) >= 0;
    }

    private final boolean canInvokeCompletion(char c) {
        Project project = this.editor.getProject();
        if (project == null) {
            return false;
        }
        Project project2 = project;
        Object object = TerminalCoroutineKt.getNow(this.startupOptionsDeferred);
        if (object == null || (object = TerminalStartupOptionsKt.guessShellName((TerminalStartupOptions)object)) == null) {
            return false;
        }
        Object shellName = object;
        TerminalShellIntegration terminalShellIntegration = TerminalCoroutineKt.getNow(this.shellIntegrationDeferred);
        if (terminalShellIntegration == null) {
            return false;
        }
        TerminalShellIntegration shellIntegration = terminalShellIntegration;
        return TerminalCommandCompletion.INSTANCE.isEnabled(project2) && TerminalCommandCompletion.INSTANCE.isSupportedForShell((ShellName)shellName) && TerminalOptionsProvider.Companion.getInstance().getShowCompletionPopupAutomatically() && Intrinsics.areEqual((Object)shellIntegration.getOutputStatus().getValue(), (Object)TerminalOutputStatus.TypingCommand.INSTANCE) && LookupManager.getActiveLookup((Editor)((Editor)this.editor)) == null && this.canTriggerCompletionForChar(c);
    }

    private final void invokeCompletion() {
        Project project = this.editor.getProject();
        Intrinsics.checkNotNull((Object)project);
        Project project2 = project;
        TerminalShellIntegration terminalShellIntegration = TerminalCoroutineKt.getNow(this.shellIntegrationDeferred);
        Intrinsics.checkNotNull((Object)terminalShellIntegration);
        TerminalShellIntegration shellIntegration = terminalShellIntegration;
        TerminalCommandCompletionService.Companion.getInstance(project2).invokeCompletion(this.terminalView, (Editor)this.editor, this.outputModel, shellIntegration, true);
    }

    /*
     * Unable to fully structure code
     */
    private final Object awaitTypingHappenedAndInvokeCompletion(TerminalOffset beforeTypingCursorOffset, char char, Continuation<? super Unit> $completion) {
        if (!($completion instanceof awaitTypingHappenedAndInvokeCompletion.1)) ** GOTO lbl-1000
        var5_4 = $completion;
        if ((var5_4.label & -2147483648) != 0) {
            var5_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                char C$0;
                /* synthetic */ Object result;
                final /* synthetic */ TerminalCommandCompletionTypingListener this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return TerminalCommandCompletionTypingListener.access$awaitTypingHappenedAndInvokeCompletion(this.this$0, null, '\u0000', (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var6_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)beforeTypingCursorOffset);
                $continuation.C$0 = char;
                $continuation.label = 1;
                v0 = this.awaitTypingHappened(beforeTypingCursorOffset, char, (Continuation<? super Unit>)$continuation);
                if (v0 == var6_6) {
                    return var6_6;
                }
                ** GOTO lbl24
            }
            case 1: {
                char = $continuation.C$0;
                beforeTypingCursorOffset = (TerminalOffset)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl24:
                // 2 sources

                if (this.canInvokeCompletion(char)) {
                    TerminalEventsHandlerImplKt.syncEditorCaretWithModel(this.editor, this.outputModel);
                    this.invokeCompletion();
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final Object awaitTypingHappened(TerminalOffset beforeTypingCursorOffset, char c, Continuation<? super Unit> $completion) {
        boolean $i$f$suspendCancellableCoroutine = false;
        Continuation<? super Unit> uCont$iv = $completion;
        boolean bl = false;
        CancellableContinuationImpl cancellable$iv = new CancellableContinuationImpl(IntrinsicsKt.intercepted(uCont$iv), 1);
        cancellable$iv.initCancellability();
        CancellableContinuation continuation = (CancellableContinuation)cancellable$iv;
        boolean bl2 = false;
        if (this.isTypingHappened(beforeTypingCursorOffset, c)) {
            ((Continuation)continuation).resumeWith(Result.constructor-impl((Object)Unit.INSTANCE));
        } else {
            Disposable disposable = Disposer.newDisposable();
            Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
            Disposable disposable2 = disposable;
            continuation.invokeOnCancellation((Function1)new Function1<Throwable, Unit>(disposable2){
                final /* synthetic */ Disposable $disposable;
                {
                    this.$disposable = $disposable;
                }

                public final void invoke(Throwable it) {
                    Disposer.dispose((Disposable)this.$disposable);
                }
            });
            this.outputModel.addListener(disposable2, new TerminalOutputModelListener(this, beforeTypingCursorOffset, c, disposable2, (CancellableContinuation<? super Unit>)continuation){
                final /* synthetic */ TerminalCommandCompletionTypingListener this$0;
                final /* synthetic */ TerminalOffset $beforeTypingCursorOffset;
                final /* synthetic */ char $char;
                final /* synthetic */ Disposable $disposable;
                final /* synthetic */ CancellableContinuation<Unit> $continuation;
                {
                    this.this$0 = $receiver;
                    this.$beforeTypingCursorOffset = $beforeTypingCursorOffset;
                    this.$char = $char;
                    this.$disposable = $disposable;
                    this.$continuation = $continuation;
                }

                public void afterContentChanged(TerminalContentChangeEvent event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    this.check();
                }

                public void cursorOffsetChanged(TerminalCursorOffsetChangeEvent event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    this.check();
                }

                private final void check() {
                    if (TerminalCommandCompletionTypingListener.access$isTypingHappened(this.this$0, this.$beforeTypingCursorOffset, this.$char)) {
                        Disposer.dispose((Disposable)this.$disposable);
                        ((Continuation)this.$continuation).resumeWith(Result.constructor-impl((Object)Unit.INSTANCE));
                    }
                }
            });
        }
        Object object = cancellable$iv.getResult();
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            DebugProbesKt.probeCoroutineSuspended($completion);
        }
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final boolean canTriggerCompletionForChar(char c) {
        return Character.isLetterOrDigit(c);
    }

    public static final /* synthetic */ Object access$awaitTypingHappened(TerminalCommandCompletionTypingListener $this, TerminalOffset beforeTypingCursorOffset, char c, Continuation $completion) {
        return $this.awaitTypingHappened(beforeTypingCursorOffset, c, (Continuation<? super Unit>)$completion);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0014\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0012\u001a\u00020\u0013H\u00d6\u0081\u0004J\n\u0010\u0014\u001a\u00020\u0015H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/intellij/terminal/frontend/view/completion/TerminalCommandCompletionTypingListener$TypingEvent;", "", "beforeTypingCursorOffset", "Lorg/jetbrains/plugins/terminal/view/TerminalOffset;", "char", "", "<init>", "(Lorg/jetbrains/plugins/terminal/view/TerminalOffset;C)V", "getBeforeTypingCursorOffset", "()Lorg/jetbrains/plugins/terminal/view/TerminalOffset;", "getChar", "()C", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.terminal.frontend"})
    private static final class TypingEvent {
        @NotNull
        private final TerminalOffset beforeTypingCursorOffset;
        private final char char;

        public TypingEvent(@NotNull TerminalOffset beforeTypingCursorOffset, char c) {
            Intrinsics.checkNotNullParameter((Object)beforeTypingCursorOffset, (String)"beforeTypingCursorOffset");
            this.beforeTypingCursorOffset = beforeTypingCursorOffset;
            this.char = c;
        }

        @NotNull
        public final TerminalOffset getBeforeTypingCursorOffset() {
            return this.beforeTypingCursorOffset;
        }

        public final char getChar() {
            return this.char;
        }

        @NotNull
        public final TerminalOffset component1() {
            return this.beforeTypingCursorOffset;
        }

        public final char component2() {
            return this.char;
        }

        @NotNull
        public final TypingEvent copy(@NotNull TerminalOffset beforeTypingCursorOffset, char c) {
            Intrinsics.checkNotNullParameter((Object)beforeTypingCursorOffset, (String)"beforeTypingCursorOffset");
            return new TypingEvent(beforeTypingCursorOffset, c);
        }

        public static /* synthetic */ TypingEvent copy$default(TypingEvent typingEvent, TerminalOffset terminalOffset, char c, int n, Object object) {
            if ((n & 1) != 0) {
                terminalOffset = typingEvent.beforeTypingCursorOffset;
            }
            if ((n & 2) != 0) {
                c = typingEvent.char;
            }
            return typingEvent.copy(terminalOffset, c);
        }

        @NotNull
        public String toString() {
            return "TypingEvent(beforeTypingCursorOffset=" + this.beforeTypingCursorOffset + ", char=" + this.char + ")";
        }

        public int hashCode() {
            int result2 = this.beforeTypingCursorOffset.hashCode();
            result2 = result2 * 31 + Character.hashCode(this.char);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TypingEvent)) {
                return false;
            }
            TypingEvent typingEvent = (TypingEvent)other;
            if (!Intrinsics.areEqual((Object)this.beforeTypingCursorOffset, (Object)typingEvent.beforeTypingCursorOffset)) {
                return false;
            }
            return this.char == typingEvent.char;
        }
    }
}

