/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.block.output;

import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.event.SelectionEvent;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.MathUtil;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntProgression;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.block.TerminalFocusModel;
import org.jetbrains.plugins.terminal.block.output.CommandBlock;
import org.jetbrains.plugins.terminal.block.output.TerminalOutputModel;
import org.jetbrains.plugins.terminal.block.output.TerminalOutputModelKt;
import org.jetbrains.plugins.terminal.block.output.TerminalSelectionModel;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u0007\u0018\u0000 22\u00020\u00012\u00020\u00022\u00020\u0003:\u00012B\u001f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001eH\u0007J\b\u0010 \u001a\u00020\u001cH\u0007J\b\u0010!\u001a\u00020\u001cH\u0007J\u0010\u0010\"\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020$H\u0016J\u0010\u0010&\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020$H\u0016J\u0010\u0010'\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020$H\u0016J\u0010\u0010(\u001a\u00020\u001c2\u0006\u0010)\u001a\u00020$H\u0016J$\u0010*\u001a\u00020\u001c2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J\u0010\u0010-\u001a\u00020\u001c2\u0006\u0010.\u001a\u00020\u000eH\u0002J\u0012\u0010/\u001a\u0004\u0018\u00010\u000e2\u0006\u0010#\u001a\u00020$H\u0002J\u0010\u00100\u001a\u00020\u001c2\u0006\u00101\u001a\u00020\u000eH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0011\u001a\u0004\u0018\u00010\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001a\u00a8\u00063"}, d2={"Lorg/jetbrains/plugins/terminal/block/output/TerminalSelectionController;", "Lcom/intellij/openapi/editor/event/EditorMouseListener;", "Lcom/intellij/openapi/editor/event/EditorMouseMotionListener;", "Lorg/jetbrains/plugins/terminal/block/output/TerminalSelectionModel$TerminalSelectionListener;", "focusModel", "Lorg/jetbrains/plugins/terminal/block/TerminalFocusModel;", "selectionModel", "Lorg/jetbrains/plugins/terminal/block/output/TerminalSelectionModel;", "outputModel", "Lorg/jetbrains/plugins/terminal/block/output/TerminalOutputModel;", "<init>", "(Lorg/jetbrains/plugins/terminal/block/TerminalFocusModel;Lorg/jetbrains/plugins/terminal/block/output/TerminalSelectionModel;Lorg/jetbrains/plugins/terminal/block/output/TerminalOutputModel;)V", "selectedBlocks", "", "Lorg/jetbrains/plugins/terminal/block/output/CommandBlock;", "getSelectedBlocks", "()Ljava/util/List;", "primarySelection", "getPrimarySelection", "()Lorg/jetbrains/plugins/terminal/block/output/CommandBlock;", "textSelectionModel", "Lcom/intellij/openapi/editor/SelectionModel;", "getTextSelectionModel", "()Lcom/intellij/openapi/editor/SelectionModel;", "rangeSelectionInitialIndex", "", "Ljava/lang/Integer;", "selectRelativeBlock", "", "isBelow", "", "dropCurrentSelection", "selectLastBlock", "clearSelection", "mouseClicked", "event", "Lcom/intellij/openapi/editor/event/EditorMouseEvent;", "mousePressed", "mouseEntered", "mouseExited", "mouseMoved", "e", "selectionChanged", "oldSelection", "newSelection", "selectBlockRange", "targetBlock", "getBlockUnderMouse", "makeBlockVisible", "block", "Companion", "intellij.terminal"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nTerminalSelectionController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalSelectionController.kt\norg/jetbrains/plugins/terminal/block/output/TerminalSelectionController\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,227:1\n1#2:228\n1586#3:229\n1661#3,3:230\n*S KotlinDebug\n*F\n+ 1 TerminalSelectionController.kt\norg/jetbrains/plugins/terminal/block/output/TerminalSelectionController\n*L\n173#1:229\n173#1:230,3\n*E\n"})
public final class TerminalSelectionController
implements EditorMouseListener,
EditorMouseMotionListener,
TerminalSelectionModel.TerminalSelectionListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TerminalFocusModel focusModel;
    @NotNull
    private final TerminalSelectionModel selectionModel;
    @NotNull
    private final TerminalOutputModel outputModel;
    @Nullable
    private Integer rangeSelectionInitialIndex;
    @NotNull
    private static final DataKey<TerminalSelectionController> KEY = DataKey.Companion.create("TerminalSelectionController");

    public TerminalSelectionController(@NotNull TerminalFocusModel focusModel, @NotNull TerminalSelectionModel selectionModel, @NotNull TerminalOutputModel outputModel) {
        Intrinsics.checkNotNullParameter((Object)focusModel, (String)"focusModel");
        Intrinsics.checkNotNullParameter((Object)selectionModel, (String)"selectionModel");
        Intrinsics.checkNotNullParameter((Object)outputModel, (String)"outputModel");
        this.focusModel = focusModel;
        this.selectionModel = selectionModel;
        this.outputModel = outputModel;
        this.outputModel.getEditor().addEditorMouseListener((EditorMouseListener)this);
        this.outputModel.getEditor().addEditorMouseMotionListener((EditorMouseMotionListener)this);
        TerminalSelectionModel.addListener$default(this.selectionModel, this, null, 2, null);
        TerminalFocusModel.addListener$default(this.focusModel, new TerminalFocusModel.TerminalFocusListener(){

            @Override
            public void promptFocused() {
                this.clearSelection();
            }
        }, null, 2, null);
        this.getTextSelectionModel().addSelectionListener(new SelectionListener(){

            public void selectionChanged(SelectionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (!e.getNewRange().isEmpty()) {
                    selectionModel.setSelectedBlocks(CollectionsKt.emptyList());
                }
            }
        });
    }

    @NotNull
    public final List<CommandBlock> getSelectedBlocks() {
        return this.selectionModel.getSelectedBlocks();
    }

    @Nullable
    public final CommandBlock getPrimarySelection() {
        return this.selectionModel.getPrimarySelection();
    }

    private final SelectionModel getTextSelectionModel() {
        SelectionModel selectionModel = this.outputModel.getEditor().getSelectionModel();
        Intrinsics.checkNotNullExpressionValue((Object)selectionModel, (String)"getSelectionModel(...)");
        return selectionModel;
    }

    @RequiresEdt
    public final void selectRelativeBlock(boolean isBelow, boolean dropCurrentSelection) {
        int newIndex;
        CommandBlock commandBlock = this.selectionModel.getPrimarySelection();
        if (commandBlock == null) {
            return;
        }
        CommandBlock primaryBlock = commandBlock;
        Integer n = this.outputModel.getBlocks().indexOf(primaryBlock);
        int it = ((Number)n).intValue();
        boolean bl = false;
        Integer n2 = it >= 0 ? n : null;
        if (n2 == null) {
            return;
        }
        int curIndex = n2;
        int n3 = newIndex = isBelow ? curIndex + 1 : curIndex - 1;
        boolean bl2 = 0 <= newIndex ? newIndex < ((Collection)this.outputModel.getBlocks()).size() : false;
        if (bl2) {
            CommandBlock newBlock = this.outputModel.getBlocks().get(newIndex);
            if (dropCurrentSelection) {
                this.selectionModel.setSelectedBlocks(CollectionsKt.listOf((Object)newBlock));
            } else {
                this.selectBlockRange(newBlock);
            }
            this.makeBlockVisible(newBlock);
        } else if (isBelow) {
            EditorEx editor = this.outputModel.getEditor();
            int visibleHeight = editor.getScrollingModel().getVisibleArea().height;
            editor.getScrollingModel().scrollVertically(editor.getContentComponent().getHeight() - visibleHeight);
        }
    }

    @RequiresEdt
    public final void selectLastBlock() {
        CommandBlock commandBlock = (CommandBlock)CollectionsKt.lastOrNull(this.outputModel.getBlocks());
        if (commandBlock == null) {
            return;
        }
        CommandBlock block = commandBlock;
        this.selectionModel.setSelectedBlocks(CollectionsKt.listOf((Object)block));
        this.makeBlockVisible(block);
    }

    @RequiresEdt
    public final void clearSelection() {
        this.selectionModel.setSelectedBlocks(CollectionsKt.emptyList());
        this.getTextSelectionModel().removeSelection();
        this.focusModel.focusPrompt();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void mouseClicked(@NotNull EditorMouseEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getMouseEvent().getClickCount() != 1) {
            return;
        }
        CommandBlock block = this.getBlockUnderMouse(event);
        if (block != null) {
            MouseEvent mouseEvent = event.getMouseEvent();
            Intrinsics.checkNotNullExpressionValue((Object)mouseEvent, (String)"getMouseEvent(...)");
            if (TerminalSelectionController.Companion.isSelectAdditionalBlock(mouseEvent)) {
                this.selectionModel.setSelectedBlocks(this.getSelectedBlocks().contains(block) ? CollectionsKt.minus((Iterable)this.getSelectedBlocks(), (Object)block) : CollectionsKt.plus((Collection)this.getSelectedBlocks(), (Object)block));
                return;
            }
        }
        if (block != null) {
            this.selectionModel.setSelectedBlocks(CollectionsKt.listOf((Object)block));
            return;
        }
        this.clearSelection();
    }

    public void mousePressed(@NotNull EditorMouseEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        MouseEvent mouseEvent = event.getMouseEvent();
        Intrinsics.checkNotNullExpressionValue((Object)mouseEvent, (String)"getMouseEvent(...)");
        if (TerminalSelectionController.Companion.isSelectBlockRange(mouseEvent)) {
            event.consume();
        }
        CommandBlock commandBlock = this.getBlockUnderMouse(event);
        if (commandBlock == null) {
            return;
        }
        CommandBlock block = commandBlock;
        if (SwingUtilities.isRightMouseButton(event.getMouseEvent())) {
            SelectionModel it = this.getTextSelectionModel();
            boolean bl = false;
            int n = it.getSelectionStart();
            int n2 = it.getSelectionEnd();
            int n3 = event.getOffset();
            boolean insideTextSelection = n <= n3 ? n3 <= n2 : false;
            if (!this.selectionModel.getSelectedBlocks().contains(block) && !insideTextSelection) {
                this.selectionModel.setSelectedBlocks(CollectionsKt.listOf((Object)block));
            }
        } else {
            MouseEvent mouseEvent2 = event.getMouseEvent();
            Intrinsics.checkNotNullExpressionValue((Object)mouseEvent2, (String)"getMouseEvent(...)");
            if (TerminalSelectionController.Companion.isSelectBlockRange(mouseEvent2)) {
                this.selectBlockRange(block);
            }
        }
    }

    public void mouseEntered(@NotNull EditorMouseEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.mouseMoved(event);
    }

    public void mouseExited(@NotNull EditorMouseEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.selectionModel.setHoveredBlock(null);
    }

    public void mouseMoved(@NotNull EditorMouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        CommandBlock block = this.getBlockUnderMouse(e);
        if (block != null && this.selectionModel.getSelectedBlocks().contains(block)) {
            block = null;
        }
        this.selectionModel.setHoveredBlock(block);
    }

    @Override
    public void selectionChanged(@NotNull List<? extends CommandBlock> oldSelection, @NotNull List<? extends CommandBlock> newSelection) {
        Intrinsics.checkNotNullParameter(oldSelection, (String)"oldSelection");
        Intrinsics.checkNotNullParameter(newSelection, (String)"newSelection");
        if (!((Collection)newSelection).isEmpty()) {
            this.getTextSelectionModel().removeSelection();
            this.focusModel.focusOutput();
        } else if (!this.getTextSelectionModel().hasSelection()) {
            this.focusModel.focusPrompt();
        }
        this.rangeSelectionInitialIndex = null;
    }

    /*
     * WARNING - void declaration
     */
    private final void selectBlockRange(CommandBlock targetBlock) {
        CommandBlock primaryBlock = this.getPrimarySelection();
        if (primaryBlock == null) {
            this.selectionModel.setSelectedBlocks(CollectionsKt.listOf((Object)targetBlock));
            return;
        }
        int curBlockIndex = this.outputModel.getBlocks().indexOf(primaryBlock);
        Integer n = this.rangeSelectionInitialIndex;
        int initialBlockIndex = n != null ? n : curBlockIndex;
        int newBlockIndex = this.outputModel.getBlocks().indexOf(targetBlock);
        if (curBlockIndex != -1 && newBlockIndex != -1) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            IntProgression indexRange = initialBlockIndex <= newBlockIndex ? (IntProgression)new IntRange(initialBlockIndex, newBlockIndex) : RangesKt.downTo((int)initialBlockIndex, (int)newBlockIndex);
            Iterable iterable = (Iterable)indexRange;
            TerminalSelectionModel terminalSelectionModel = this.selectionModel;
            boolean $i$f$map = false;
            void var9_10 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void it;
                int item$iv$iv;
                int n2 = item$iv$iv = ((IntIterator)iterator).nextInt();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(this.outputModel.getBlocks().get((int)it));
            }
            terminalSelectionModel.setSelectedBlocks((List)destination$iv$iv);
            this.rangeSelectionInitialIndex = initialBlockIndex;
        } else {
            this.selectionModel.setSelectedBlocks(CollectionsKt.listOf((Object)targetBlock));
        }
    }

    private final CommandBlock getBlockUnderMouse(EditorMouseEvent event) {
        Rectangle bounds;
        CommandBlock block = TerminalOutputModelKt.getByOffset(this.outputModel, event.getOffset());
        if (block != null && (bounds = TerminalOutputModelKt.getBlockBounds(this.outputModel, block)).contains(event.getMouseEvent().getPoint())) {
            return block;
        }
        return null;
    }

    private final void makeBlockVisible(CommandBlock block) {
        EditorEx editor = this.outputModel.getEditor();
        Rectangle bounds = TerminalOutputModelKt.getBlockBounds(this.outputModel, block);
        Rectangle rectangle = editor.getScrollingModel().getVisibleArea();
        Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"getVisibleArea(...)");
        Rectangle visibleArea = rectangle;
        int n = visibleArea.y;
        int n2 = visibleArea.y + visibleArea.height;
        int n3 = bounds.y;
        if (!(n <= n3 ? n3 < n2 : false)) {
            int n4;
            if (bounds.y < visibleArea.y) {
                n4 = bounds.y - 0;
            } else {
                int blockMaxHeight = Math.min(bounds.height + 0, visibleArea.height);
                n4 = bounds.y + blockMaxHeight - visibleArea.height;
            }
            int scrollOffset = n4;
            int offset = MathUtil.clamp((int)scrollOffset, (int)0, (int)editor.getContentComponent().getHeight());
            editor.getScrollingModel().scrollVertically(offset);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0018\u0010\t\u001a\u00020\n*\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\fR\u0018\u0010\r\u001a\u00020\n*\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\fR\u0018\u0010\u000e\u001a\u00020\n*\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\fR\u0018\u0010\u000f\u001a\u00020\n*\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\f\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/plugins/terminal/block/output/TerminalSelectionController$Companion;", "", "<init>", "()V", "KEY", "Lcom/intellij/openapi/actionSystem/DataKey;", "Lorg/jetbrains/plugins/terminal/block/output/TerminalSelectionController;", "getKEY", "()Lcom/intellij/openapi/actionSystem/DataKey;", "isSelectBlockRange", "", "Ljava/awt/event/MouseEvent;", "(Ljava/awt/event/MouseEvent;)Z", "isSelectAdditionalBlock", "isOnlyMetaDown", "isOnlyControlDown", "intellij.terminal"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DataKey<TerminalSelectionController> getKEY() {
            return KEY;
        }

        private final boolean isSelectBlockRange(MouseEvent $this$isSelectBlockRange) {
            return $this$isSelectBlockRange.isShiftDown() && !$this$isSelectBlockRange.isControlDown() && !$this$isSelectBlockRange.isAltDown() && !$this$isSelectBlockRange.isMetaDown();
        }

        private final boolean isSelectAdditionalBlock(MouseEvent $this$isSelectAdditionalBlock) {
            return SystemInfo.isMac ? this.isOnlyMetaDown($this$isSelectAdditionalBlock) : this.isOnlyControlDown($this$isSelectAdditionalBlock);
        }

        private final boolean isOnlyMetaDown(MouseEvent $this$isOnlyMetaDown) {
            return $this$isOnlyMetaDown.isMetaDown() && !$this$isOnlyMetaDown.isControlDown() && !$this$isOnlyMetaDown.isAltDown() && !$this$isOnlyMetaDown.isShiftDown();
        }

        private final boolean isOnlyControlDown(MouseEvent $this$isOnlyControlDown) {
            return $this$isOnlyControlDown.isControlDown() && !$this$isOnlyControlDown.isAltDown() && !$this$isOnlyControlDown.isShiftDown() && !$this$isOnlyControlDown.isMetaDown();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

