/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.starter;

import com.intellij.execution.wsl.WslPath;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import com.intellij.platform.eel.EelDescriptor;
import com.intellij.platform.eel.EelOsFamily;
import com.intellij.platform.eel.EelPathBoundDescriptor;
import com.intellij.platform.eel.EelPlatformKt;
import com.intellij.platform.eel.path.EelPath;
import com.intellij.platform.eel.path.EelPathException;
import com.intellij.platform.eel.provider.EelNioBridgeServiceKt;
import com.intellij.platform.eel.provider.LocalEelDescriptor;
import com.intellij.util.PathUtil;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000 $2\u00020\u0001:\u0001$B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J,\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\b\u0010\t\u001a\u0004\u0018\u00010\u00072\u0006\u0010\n\u001a\u00020\u00072\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\fJ,\u0010\r\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00072\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\fJ\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0007H\u0002J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0013\u001a\u00020\u0007J\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0019\u001a\u00020\u0007H\u0002J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u001b\u001a\u00020\u0017H\u0002J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u001d\u001a\u00020\u0007H\u0002J\n\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0002J\u001d\u0010 \u001a\u00020\u00072\u0006\u0010!\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b#R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/jetbrains/plugins/terminal/starter/TerminalLocalPathTranslator;", "", "descriptor", "Lcom/intellij/platform/eel/EelDescriptor;", "<init>", "(Lcom/intellij/platform/eel/EelDescriptor;)V", "translateEnvValue", "", "envName", "prevEnvValue", "newEnvValue", "requester", "Ljava/lang/Class;", "translateMultiPathEnv", "prevValue", "newValue", "translateLocalPathEntriesToRemote", "localPathEntries", "translateAbsoluteLocalPathStringToRemote", "absolutePathString", "translateAbsoluteLocalPathToRemote", "Lcom/intellij/platform/eel/path/EelPath;", "absolutePath", "Ljava/nio/file/Path;", "toEelPathOrNull", "remotePathString", "translateWindowsDrivePathToMountedWslPath", "path", "translateWslUncPathWithSamePrefix", "pathString", "asWslEelDescriptorSafely", "Lcom/intellij/platform/eel/EelPathBoundDescriptor;", "joinEntries", "entriesLeft", "entriesRight", "joinEntries$intellij_terminal", "Companion", "intellij.terminal"})
@SourceDebugExtension(value={"SMAP\nTerminalLocalPathTranslator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalLocalPathTranslator.kt\norg/jetbrains/plugins/terminal/starter/TerminalLocalPathTranslator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,248:1\n2829#2,7:249\n1586#2:256\n1661#2,3:257\n61#3,4:260\n60#3,5:264\n61#3,4:269\n61#3,4:273\n13#3:278\n18#4:277\n*S KotlinDebug\n*F\n+ 1 TerminalLocalPathTranslator.kt\norg/jetbrains/plugins/terminal/starter/TerminalLocalPathTranslator\n*L\n76#1:249,7\n86#1:256\n86#1:257,3\n105#1:260,4\n120#1:264,5\n133#1:269,4\n195#1:273,4\n218#1:278\n203#1:277\n*E\n"})
public final class TerminalLocalPathTranslator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EelDescriptor descriptor;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final Set<String> MULTI_PATH_ENV_NAMES;
    @NotNull
    private static final Set<String> SINGLE_PATH_ENV_NAMES;

    public TerminalLocalPathTranslator(@NotNull EelDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        this.descriptor = descriptor;
    }

    @NotNull
    public final String translateEnvValue(@NotNull String envName, @Nullable String prevEnvValue, @NotNull String newEnvValue, @NotNull Class<?> requester) {
        Intrinsics.checkNotNullParameter((Object)envName, (String)"envName");
        Intrinsics.checkNotNullParameter((Object)newEnvValue, (String)"newEnvValue");
        Intrinsics.checkNotNullParameter(requester, (String)"requester");
        if (!Intrinsics.areEqual((Object)this.descriptor, (Object)LocalEelDescriptor.INSTANCE)) {
            if (SINGLE_PATH_ENV_NAMES.contains(envName)) {
                String string = this.translateAbsoluteLocalPathStringToRemote(newEnvValue);
                if (string == null) {
                    string = newEnvValue;
                }
                return string;
            }
            if (MULTI_PATH_ENV_NAMES.contains(envName)) {
                String string;
                String string2 = prevEnvValue;
                if (string2 == null) {
                    string2 = "";
                }
                if ((string = this.translateMultiPathEnv(envName, string2, newEnvValue, requester)) == null) {
                    string = newEnvValue;
                }
                return string;
            }
        }
        return newEnvValue;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final String translateMultiPathEnv(@NotNull String envName, @NotNull String prevValue, @NotNull String newValue, @NotNull Class<?> requester) {
        Intrinsics.checkNotNullParameter((Object)envName, (String)"envName");
        Intrinsics.checkNotNullParameter((Object)prevValue, (String)"prevValue");
        Intrinsics.checkNotNullParameter((Object)newValue, (String)"newValue");
        Intrinsics.checkNotNullParameter(requester, (String)"requester");
        int ind = StringsKt.indexOf$default((CharSequence)newValue, (String)prevValue, (int)0, (boolean)false, (int)6, null);
        if (ind >= 0) {
            String prepended = StringsKt.take((String)newValue, (int)ind);
            String string = newValue.substring(ind + prevValue.length());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String appended = string;
            if (TerminalLocalPathTranslator.Companion.canJoinWithoutSeparator(prepended, prevValue, (EelDescriptor)LocalEelDescriptor.INSTANCE) && TerminalLocalPathTranslator.Companion.canJoinWithoutSeparator(prevValue, appended, (EelDescriptor)LocalEelDescriptor.INSTANCE)) {
                Object[] objectArray = new String[]{this.translateLocalPathEntriesToRemote(prepended), prevValue, this.translateLocalPathEntriesToRemote(appended)};
                List remoteEntries = CollectionsKt.listOf((Object[])objectArray);
                Iterable $this$reduce$iv = remoteEntries;
                boolean $i$f$reduce = false;
                Iterator iterator$iv = $this$reduce$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    throw new UnsupportedOperationException("Empty collection can't be reduced.");
                }
                Object accumulator$iv = iterator$iv.next();
                while (iterator$iv.hasNext()) {
                    void entries;
                    String string2 = (String)iterator$iv.next();
                    String result2 = (String)accumulator$iv;
                    boolean bl = false;
                    accumulator$iv = this.joinEntries$intellij_terminal(result2, (String)entries);
                }
                return (String)accumulator$iv;
            }
        }
        LOG.info(requester.getName() + " changed " + envName + " in unexpected way, keeping it as is");
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final String translateLocalPathEntriesToRemote(String localPathEntries) {
        void $this$mapTo$iv$iv;
        String[] stringArray = new String[]{EelPlatformKt.getPathSeparator((EelOsFamily)LocalEelDescriptor.INSTANCE.getOsFamily())};
        Iterable $this$map$iv = StringsKt.split$default((CharSequence)localPathEntries, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string2 = this.translateAbsoluteLocalPathStringToRemote((String)it);
            if (string2 == null) {
                string2 = it;
            }
            collection.add(string2);
        }
        List remotePaths = (List)destination$iv$iv;
        return CollectionsKt.joinToString$default((Iterable)remotePaths, (CharSequence)EelPlatformKt.getPathSeparator((EelOsFamily)this.descriptor.getOsFamily()), null, null, (int)0, null, null, (int)62, null);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final String translateAbsoluteLocalPathStringToRemote(@NotNull String absolutePathString) {
        Path path;
        Intrinsics.checkNotNullParameter((Object)absolutePathString, (String)"absolutePathString");
        if (StringsKt.isBlank((CharSequence)absolutePathString)) {
            return null;
        }
        try {
            path = Path.of(absolutePathString, new String[0]);
            Intrinsics.checkNotNull((Object)path);
        }
        catch (InvalidPathException e) {
            void $this$debug$iv;
            Logger logger = LOG;
            Throwable t$iv = e;
            boolean $i$f$debug = false;
            if ($this$debug$iv.isDebugEnabled()) {
                void var9_7 = $this$debug$iv;
                boolean bl = false;
                var9_7.debug("Failed to create Path from " + absolutePathString + ", skipping translation", t$iv);
            }
            return null;
        }
        Path path2 = path;
        EelPath eelPath = this.translateAbsoluteLocalPathToRemote(path2);
        return eelPath != null ? eelPath.toString() : null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final EelPath translateAbsoluteLocalPathToRemote(@NotNull Path absolutePath) {
        Intrinsics.checkNotNullParameter((Object)absolutePath, (String)"absolutePath");
        if (!absolutePath.isAbsolute()) {
            Logger $this$debug_u24default$iv = LOG;
            Throwable t$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug("Failed to translate not absolute " + absolutePath + ", skipping", t$iv);
            }
            return null;
        }
        try {
            return EelNioBridgeServiceKt.asEelPath((Path)absolutePath, (EelDescriptor)this.descriptor);
        }
        catch (Exception e) {
            void $this$debug$iv;
            String $i$f$debug = this.translateWindowsDrivePathToMountedWslPath(absolutePath);
            if ($i$f$debug != null) {
                String it = $i$f$debug;
                boolean bl = false;
                return this.toEelPathOrNull(it);
            }
            $i$f$debug = this.translateWslUncPathWithSamePrefix(((Object)absolutePath).toString());
            if ($i$f$debug != null) {
                String it = $i$f$debug;
                boolean bl = false;
                return this.toEelPathOrNull(it);
            }
            $i$f$debug = LOG;
            Throwable t$iv = e;
            boolean $i$f$debug2 = false;
            if ($this$debug$iv.isDebugEnabled()) {
                void var8_8 = $this$debug$iv;
                boolean bl = false;
                var8_8.debug("Failed to translate " + absolutePath + " to EelPath (" + this.descriptor + "), skipping", t$iv);
            }
            return null;
        }
    }

    private final EelPath toEelPathOrNull(String remotePathString) {
        try {
            return EelPath.Companion.parse(remotePathString, this.descriptor);
        }
        catch (EelPathException e) {
            LOG.warn("Failed to translate " + remotePathString + " to EelPath (" + this.descriptor + ")", (Throwable)e);
            return null;
        }
    }

    private final String translateWindowsDrivePathToMountedWslPath(Path path) {
        EelPathBoundDescriptor eelPathBoundDescriptor = this.asWslEelDescriptorSafely();
        if (eelPathBoundDescriptor == null) {
            return null;
        }
        EelPathBoundDescriptor wslEelDescriptor = eelPathBoundDescriptor;
        if (OSAgnosticPathUtil.isAbsoluteDosPath((String)((Object)path).toString())) {
            WslPath wslPath = WslPath.Companion.parseWindowsUncPath(((Object)wslEelDescriptor.getRootPath()).toString());
            if (wslPath == null) {
                TerminalLocalPathTranslator $this$translateWindowsDrivePathToMountedWslPath_u24lambda_u240 = this;
                boolean bl = false;
                LOG.warn("Failed to parse " + wslEelDescriptor.getRootPath() + " as WSL UNC path");
                return null;
            }
            WslPath wslPath2 = wslPath;
            return wslPath2.getDistribution().getWslPath(path);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final String translateWslUncPathWithSamePrefix(String pathString) {
        EelPathBoundDescriptor eelPathBoundDescriptor = this.asWslEelDescriptorSafely();
        if (eelPathBoundDescriptor == null) {
            return null;
        }
        EelPathBoundDescriptor wslEelDescriptor = eelPathBoundDescriptor;
        WslPath wslPath = WslPath.Companion.parseWindowsUncPath(pathString);
        if (wslPath == null) {
            return null;
        }
        WslPath path = wslPath;
        WslPath wslPath2 = WslPath.Companion.parseWindowsUncPath(((Object)wslEelDescriptor.getRootPath()).toString());
        if (wslPath2 == null) {
            return null;
        }
        WslPath eelRootPath = wslPath2;
        if (Intrinsics.areEqual((Object)path.getDistributionId(), (Object)eelRootPath.getDistributionId()) && !Intrinsics.areEqual((Object)path.getWslRoot(), (Object)eelRootPath.getWslRoot())) {
            String winPathString = PathUtil.toSystemDependentName((String)pathString);
            Intrinsics.checkNotNull((Object)winPathString);
            if (!StringsKt.startsWith$default((String)winPathString, (String)path.getWslRoot(), (boolean)false, (int)2, null)) {
                throw new IllegalStateException("Check failed.");
            }
            String string = eelRootPath.getWslRoot();
            String string2 = winPathString.substring(path.getWslRoot().length());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            String newPathString = string + string2;
            try {
                Path newPath = Path.of(newPathString, new String[0]);
                Intrinsics.checkNotNull((Object)newPath);
                return EelNioBridgeServiceKt.asEelPath((Path)newPath, (EelDescriptor)this.descriptor).toString();
            }
            catch (Exception e) {
                void $this$debug$iv;
                Logger logger = LOG;
                Throwable t$iv = e;
                boolean $i$f$debug = false;
                if ($this$debug$iv.isDebugEnabled()) {
                    void var13_12 = $this$debug$iv;
                    boolean bl = false;
                    var13_12.debug("Failed to translate " + newPathString + " after changing wsl prefix", t$iv);
                }
                return pathString;
            }
        }
        return null;
    }

    private final EelPathBoundDescriptor asWslEelDescriptorSafely() {
        Object object;
        EelDescriptor $this$asSafely$iv = this.descriptor;
        boolean $i$f$asSafely = false;
        EelDescriptor eelDescriptor = $this$asSafely$iv;
        if (!(eelDescriptor instanceof EelPathBoundDescriptor)) {
            eelDescriptor = null;
        }
        EelPathBoundDescriptor eelPathBoundDescriptor = (EelPathBoundDescriptor)eelDescriptor;
        if (eelPathBoundDescriptor != null) {
            EelPathBoundDescriptor eelPathBoundDescriptor2;
            EelPathBoundDescriptor it = eelPathBoundDescriptor2 = eelPathBoundDescriptor;
            boolean bl = false;
            object = Intrinsics.areEqual((Object)it.getClass().getName(), (Object)"com.intellij.platform.ide.impl.wsl.WslEelDescriptor") ? eelPathBoundDescriptor2 : null;
        } else {
            object = null;
        }
        return object;
    }

    @NotNull
    public final String joinEntries$intellij_terminal(@NotNull String entriesLeft, @NotNull String entriesRight) {
        Intrinsics.checkNotNullParameter((Object)entriesLeft, (String)"entriesLeft");
        Intrinsics.checkNotNullParameter((Object)entriesRight, (String)"entriesRight");
        return TerminalLocalPathTranslator.Companion.canJoinWithoutSeparator(entriesLeft, entriesRight, this.descriptor) ? entriesLeft + entriesRight : entriesLeft + EelPlatformKt.getPathSeparator((EelOsFamily)this.descriptor.getOsFamily()) + entriesRight;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(TerminalLocalPathTranslator.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        Object[] objectArray = new String[]{"PATH", "GOPATH"};
        List list = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"_INTELLIJ_FORCE_PREPEND_", "_INTELLIJ_FORCE_SET_"};
        MULTI_PATH_ENV_NAMES = CollectionsKt.toSet((Iterable)TerminalLocalPathTranslator.Companion.duplicateWithPrefixes(list, (String[])objectArray));
        objectArray = new String[]{"GOROOT", "GOBIN"};
        List list2 = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"_INTELLIJ_FORCE_SET_"};
        SINGLE_PATH_ENV_NAMES = CollectionsKt.toSet((Iterable)CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)"JEDITERM_SOURCE"), (Iterable)TerminalLocalPathTranslator.Companion.duplicateWithPrefixes(list2, (String[])objectArray)));
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J1\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u000e*\b\u0012\u0004\u0012\u00020\b0\u000e2\u0012\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0010\"\u00020\bH\u0002\u00a2\u0006\u0002\u0010\u0011J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\n\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/plugins/terminal/starter/TerminalLocalPathTranslator$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "MULTI_PATH_ENV_NAMES", "", "", "getMULTI_PATH_ENV_NAMES$intellij_terminal", "()Ljava/util/Set;", "SINGLE_PATH_ENV_NAMES", "getSINGLE_PATH_ENV_NAMES$intellij_terminal", "duplicateWithPrefixes", "", "prefixes", "", "(Ljava/util/List;[Ljava/lang/String;)Ljava/util/List;", "canJoinWithoutSeparator", "", "entriesLeft", "entriesRight", "descriptor", "Lcom/intellij/platform/eel/EelDescriptor;", "intellij.terminal"})
    @SourceDebugExtension(value={"SMAP\nTerminalLocalPathTranslator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalLocalPathTranslator.kt\norg/jetbrains/plugins/terminal/starter/TerminalLocalPathTranslator$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,248:1\n10574#2:249\n11007#2,2:250\n11009#2,3:256\n1586#3:252\n1661#3,3:253\n*S KotlinDebug\n*F\n+ 1 TerminalLocalPathTranslator.kt\norg/jetbrains/plugins/terminal/starter/TerminalLocalPathTranslator$Companion\n*L\n233#1:249\n233#1:250,2\n233#1:256,3\n234#1:252\n234#1:253,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<String> getMULTI_PATH_ENV_NAMES$intellij_terminal() {
            return MULTI_PATH_ENV_NAMES;
        }

        @NotNull
        public final Set<String> getSINGLE_PATH_ENV_NAMES$intellij_terminal() {
            return SINGLE_PATH_ENV_NAMES;
        }

        /*
         * WARNING - void declaration
         */
        private final List<String> duplicateWithPrefixes(List<String> $this$duplicateWithPrefixes, String ... prefixes) {
            void $this$flatMapTo$iv$iv;
            void $this$flatMap$iv;
            String[] stringArray = prefixes;
            Collection collection = $this$duplicateWithPrefixes;
            boolean $i$f$flatMap = false;
            void var5_6 = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            int n = ((void)$this$flatMapTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void $this$mapTo$iv$iv;
                void element$iv$iv;
                void prefix = element$iv$iv = $this$flatMapTo$iv$iv[i];
                boolean bl = false;
                Iterable $this$map$iv = $this$duplicateWithPrefixes;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string = (String)item$iv$iv;
                    Collection collection2 = destination$iv$iv2;
                    boolean bl2 = false;
                    collection2.add((String)prefix + (String)it);
                }
                Iterable list$iv$iv = (List)destination$iv$iv2;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            return CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv));
        }

        private final boolean canJoinWithoutSeparator(String entriesLeft, String entriesRight, EelDescriptor descriptor) {
            return ((CharSequence)entriesLeft).length() == 0 || ((CharSequence)entriesRight).length() == 0 || StringsKt.endsWith$default((String)entriesLeft, (String)EelPlatformKt.getPathSeparator((EelOsFamily)descriptor.getOsFamily()), (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)entriesRight, (String)EelPlatformKt.getPathSeparator((EelOsFamily)descriptor.getOsFamily()), (boolean)false, (int)2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

