/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.util;

import com.intellij.application.options.schemes.SchemeNameGenerator;
import com.intellij.diagnostic.PluginException;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.keymap.KeyMapBundle;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.ex.KeymapManagerEx;
import com.intellij.openapi.util.Disposer;
import com.jediterm.terminal.ProcessTtyConnector;
import com.jediterm.terminal.TtyConnector;
import com.jediterm.terminal.model.TerminalModelListener;
import com.jediterm.terminal.model.TerminalTextBuffer;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.future.FutureKt;
import kotlinx.coroutines.time.TimeKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.ShellTerminalWidget;
import org.jetbrains.plugins.terminal.util.TerminalCoroutineKt;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000^\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001c\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a\"\u0010\u0007\u001a\u00020\u0001*\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00010\fH\u0007\u001a\u0011\u0010\r\u001a\u00070\u000e\u00a2\u0006\u0002\b\u000f*\u00020\bH\u0000\u001aD\u0010\u0011\u001a\u00020\u0001\"\b\b\u0000\u0010\u0012*\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00120\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u000e2\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u0002H\u0012\u0012\u0004\u0012\u00020\u00010\u001aH\u0007\u001a\u001a\u0010\u001b\u001a\u00020\u00012\u0006\u0010\u001c\u001a\u00020\u000e2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0007\u001a\n\u0010\u001f\u001a\u0004\u0018\u00010 H\u0002\"\u0010\u0010\u0010\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"addModelListener", "", "Lcom/jediterm/terminal/model/TerminalTextBuffer;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "listener", "Lcom/jediterm/terminal/model/TerminalModelListener;", "waitFor", "Lcom/jediterm/terminal/TtyConnector;", "timeout", "Ljava/time/Duration;", "callback", "Lkotlin/Function0;", "getDebugName", "", "Lorg/jetbrains/annotations/NonNls;", "STOP_EMULATOR_TIMEOUT", "fireListenersAndLogAllExceptions", "T", "", "listeners", "", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "message", "callListener", "Lkotlin/Function1;", "updateActionShortcut", "actionId", "value", "Lcom/intellij/openapi/actionSystem/KeyboardShortcut;", "getKeymapToModify", "Lcom/intellij/openapi/keymap/Keymap;", "intellij.terminal"})
@SourceDebugExtension(value={"SMAP\nTerminalUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalUtil.kt\norg/jetbrains/plugins/terminal/util/TerminalUtilKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,132:1\n13225#2,2:133\n*S KotlinDebug\n*F\n+ 1 TerminalUtil.kt\norg/jetbrains/plugins/terminal/util/TerminalUtilKt\n*L\n123#1:133,2\n*E\n"})
public final class TerminalUtilKt {
    @ApiStatus.Internal
    @JvmField
    @NotNull
    public static final Duration STOP_EMULATOR_TIMEOUT;

    public static final void addModelListener(@NotNull TerminalTextBuffer $this$addModelListener, @NotNull Disposable parentDisposable, @NotNull TerminalModelListener listener2) {
        Intrinsics.checkNotNullParameter((Object)$this$addModelListener, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        $this$addModelListener.addModelListener(listener2);
        Disposer.register((Disposable)parentDisposable, () -> TerminalUtilKt.addModelListener$lambda$0($this$addModelListener, listener2));
    }

    @ApiStatus.Internal
    public static final void waitFor(@NotNull TtyConnector $this$waitFor, @NotNull Duration timeout, @NotNull Function0<Unit> callback) {
        Intrinsics.checkNotNullParameter((Object)$this$waitFor, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        if (!$this$waitFor.isConnected()) {
            callback.invoke();
            return;
        }
        ProcessTtyConnector processTtyConnector = ShellTerminalWidget.getProcessTtyConnector($this$waitFor);
        if (processTtyConnector != null) {
            CompletableFuture<Process> onExit = processTtyConnector.getProcess().onExit();
            v0 = BuildersKt.launch$default((CoroutineScope)TerminalCoroutineKt.terminalApplicationScope(), (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(timeout, callback, onExit, null){
                int label;
                final /* synthetic */ Duration $timeout;
                final /* synthetic */ Function0<Unit> $callback;
                final /* synthetic */ CompletableFuture<Process> $onExit;
                {
                    this.$timeout = $timeout;
                    this.$callback = $callback;
                    this.$onExit = $onExit;
                    super(2, $completion);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object $result) {
                    var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            v0 = TimeKt.withTimeout((Duration)this.$timeout, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Process>, Object>(this.$onExit, null){
                                int label;
                                final /* synthetic */ CompletableFuture<Process> $onExit;
                                {
                                    this.$onExit = $onExit;
                                    super(2, $completion);
                                }

                                /*
                                 * Enabled force condition propagation
                                 * Lifted jumps to return sites
                                 */
                                public final Object invokeSuspend(Object $result) {
                                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            CompletableFuture<Process> completableFuture = this.$onExit;
                                            Intrinsics.checkNotNull(completableFuture);
                                            this.label = 1;
                                            Object object2 = FutureKt.await((CompletionStage)completableFuture, (Continuation)((Continuation)this));
                                            if (object2 != object) return object2;
                                            return object;
                                        }
                                        case 1: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            Object object2 = $result;
                                            return object2;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Process> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (Continuation)((Continuation)this));
                            ** if (v0 != var3_2) goto lbl11
lbl10:
                            // 1 sources

                            return var3_2;
lbl11:
                            // 1 sources

                            ** GOTO lbl17
                        }
                        case 1: {
                            try {
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl17:
                                // 2 sources

                                (Process)v0;
                            }
                            catch (Throwable var2_3) {
                                throw var2_3;
                            }
                            finally {
                                this.$callback.invoke();
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
        } else {
            TtyConnector connector = $this$waitFor;
            v0 = BuildersKt.launch$default((CoroutineScope)TerminalCoroutineKt.terminalApplicationScope(), (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(timeout, callback, connector, null){
                int label;
                final /* synthetic */ Duration $timeout;
                final /* synthetic */ Function0<Unit> $callback;
                final /* synthetic */ TtyConnector $connector;
                {
                    this.$timeout = $timeout;
                    this.$callback = $callback;
                    this.$connector = $connector;
                    super(2, $completion);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object $result) {
                    var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            v0 = TimeKt.withTimeout((Duration)this.$timeout, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Integer>, Object>(this.$connector, null){
                                int label;
                                final /* synthetic */ TtyConnector $connector;
                                {
                                    this.$connector = $connector;
                                    super(2, $completion);
                                }

                                public final Object invokeSuspend(Object $result) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            return Boxing.boxInt((int)this.$connector.waitFor());
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Integer> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (Continuation)((Continuation)this));
                            ** if (v0 != var3_2) goto lbl11
lbl10:
                            // 1 sources

                            return var3_2;
lbl11:
                            // 1 sources

                            ** GOTO lbl17
                        }
                        case 1: {
                            try {
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl17:
                                // 2 sources

                                ((Number)v0).intValue();
                            }
                            catch (Throwable var2_3) {
                                throw var2_3;
                            }
                            finally {
                                this.$callback.invoke();
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
        }
    }

    @NotNull
    public static final String getDebugName(@NotNull TtyConnector $this$getDebugName) {
        Intrinsics.checkNotNullParameter((Object)$this$getDebugName, (String)"<this>");
        ProcessTtyConnector processTtyConnector = ShellTerminalWidget.getProcessTtyConnector($this$getDebugName);
        if (processTtyConnector != null) {
            List list = processTtyConnector.getCommandLine();
            String commandLineText = list != null ? CollectionsKt.joinToString$default((Iterable)list, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null) : null;
            String string = processTtyConnector.getProcess().getClass().getSimpleName();
            String string2 = commandLineText;
            if (string2 == null) {
                string2 = "<no command line>";
            }
            return string + string2;
        }
        String string = $this$getDebugName.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    @ApiStatus.Internal
    public static final <T> void fireListenersAndLogAllExceptions(@NotNull List<? extends T> listeners, @NotNull Logger logger, @NotNull String message, @NotNull Function1<? super T, Unit> callListener) {
        Intrinsics.checkNotNullParameter(listeners, (String)"listeners");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter(callListener, (String)"callListener");
        for (T listener2 : listeners) {
            try {
                callListener.invoke(listener2);
            }
            catch (Exception e) {
                PluginException.logPluginError((Logger)logger, (String)message, (Throwable)e, listener2.getClass());
            }
        }
    }

    @ApiStatus.Internal
    public static final void updateActionShortcut(@NotNull String actionId, @Nullable KeyboardShortcut value) {
        Intrinsics.checkNotNullParameter((Object)actionId, (String)"actionId");
        Keymap keymap = TerminalUtilKt.getKeymapToModify();
        if (keymap == null) {
            return;
        }
        Keymap keymapToModify = keymap;
        keymapToModify.removeAllActionShortcuts(actionId);
        if (value != null) {
            keymapToModify.addShortcut(actionId, (Shortcut)value);
        }
    }

    private static final Keymap getKeymapToModify() {
        Keymap keymap;
        KeymapManager keymapManager = KeymapManager.getInstance();
        KeymapManagerEx keymapManagerEx = keymapManager instanceof KeymapManagerEx ? (KeymapManagerEx)keymapManager : null;
        if (keymapManagerEx == null) {
            return null;
        }
        KeymapManagerEx keymapManager2 = keymapManagerEx;
        Keymap keymap2 = keymapManager2.getActiveKeymap();
        Intrinsics.checkNotNullExpressionValue((Object)keymap2, (String)"getActiveKeymap(...)");
        Keymap keymapToModify = keymap2;
        if (!keymapToModify.canModify()) {
            Keymap[] allKeymaps = keymapManager2.getAllKeymaps();
            Object[] objectArray = new Object[]{keymapToModify.getPresentableName()};
            String name = SchemeNameGenerator.getUniqueName((String)KeyMapBundle.message((String)"new.keymap.name", (Object[])objectArray), arg_0 -> TerminalUtilKt.getKeymapToModify$lambda$1(arg_0 -> TerminalUtilKt.getKeymapToModify$lambda$0(allKeymaps, arg_0), arg_0));
            Keymap keymap3 = keymapToModify.deriveKeymap(name);
            Intrinsics.checkNotNullExpressionValue((Object)keymap3, (String)"deriveKeymap(...)");
            Keymap newKeymap = keymap3;
            keymapManager2.getSchemeManager().addScheme((Object)newKeymap);
            keymapManager2.setActiveKeymap(newKeymap);
            keymap = newKeymap;
        } else {
            keymap = keymapToModify;
        }
        return keymap;
    }

    private static final void addModelListener$lambda$0(TerminalTextBuffer $this_addModelListener, TerminalModelListener $listener) {
        $this_addModelListener.removeModelListener($listener);
    }

    private static final boolean getKeymapToModify$lambda$0(Keymap[] $allKeymaps, String newName) {
        boolean bl;
        block1: {
            Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
            Intrinsics.checkNotNull((Object)$allKeymaps);
            Keymap[] $this$any$iv = $allKeymaps;
            boolean $i$f$any = false;
            int n = $this$any$iv.length;
            for (int i = 0; i < n; ++i) {
                Keymap element$iv;
                Keymap it = element$iv = $this$any$iv[i];
                boolean bl2 = false;
                if (!(Intrinsics.areEqual((Object)it.getName(), (Object)newName) || Intrinsics.areEqual((Object)it.getPresentableName(), (Object)newName))) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    private static final boolean getKeymapToModify$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    static {
        Duration duration = Duration.ofMillis(1500L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMillis(...)");
        STOP_EMULATOR_TIMEOUT = duration;
    }
}

