/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.java.promo;

import com.intellij.java.promo.Framework;
import com.intellij.java.promo.FrameworkPluginSuggestion;
import com.intellij.java.promo.FrameworkSuggestionProviderKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginSuggestion;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginSuggestionProvider;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u000e"}, d2={"Lcom/intellij/java/promo/LiquibaseSuggestionProvider;", "Lcom/intellij/openapi/updateSettings/impl/pluginsAdvertisement/PluginSuggestionProvider;", "<init>", "()V", "getSuggestion", "Lcom/intellij/openapi/updateSettings/impl/pluginsAdvertisement/PluginSuggestion;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "isLiquibaseFile", "", "xmlFile", "Lcom/intellij/psi/xml/XmlFile;", "intellij.java.promo"})
public final class LiquibaseSuggestionProvider
implements PluginSuggestionProvider {
    @Nullable
    public PluginSuggestion getSuggestion(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        XmlFile xmlFile = psiFile instanceof XmlFile ? (XmlFile)psiFile : null;
        if (xmlFile == null) {
            return null;
        }
        XmlFile xmlFile2 = xmlFile;
        if (!this.isLiquibaseFile(xmlFile2)) {
            return null;
        }
        Framework framework = new Framework("liquibase", "com.intellij.liquibase", "Liquibase");
        if (FrameworkSuggestionProviderKt.isPluginSuggestionDismissed(framework)) {
            return null;
        }
        return new FrameworkPluginSuggestion(project, framework);
    }

    private final boolean isLiquibaseFile(XmlFile xmlFile) {
        XmlTag rootTag;
        XmlTag xmlTag = rootTag = xmlFile.getRootTag();
        return Intrinsics.areEqual((Object)(xmlTag != null ? xmlTag.getName() : null), (Object)"databaseChangeLog");
    }
}

