/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.lang.Language;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.IdFilter;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CompositeShortNamesCache
extends PsiShortNamesCache {
    private final Project myProject;
    private final Set<Language> myExcludeLanguages;

    public CompositeShortNamesCache(Project project) {
        this(project, Collections.emptySet());
    }

    private CompositeShortNamesCache(Project project, Set<Language> excludeLanguages) {
        this.myProject = project;
        this.myExcludeLanguages = excludeLanguages;
    }

    @NotNull
    public PsiShortNamesCache withoutLanguages(Set<Language> excludeLanguages) {
        if (excludeLanguages.isEmpty()) {
            CompositeShortNamesCache compositeShortNamesCache = this;
            if (compositeShortNamesCache == null) {
                CompositeShortNamesCache.$$$reportNull$$$0(0);
            }
            return compositeShortNamesCache;
        }
        Set newExcludeLanguages = CollectionsKt.union(this.myExcludeLanguages, excludeLanguages);
        return new CompositeShortNamesCache(this.myProject, newExcludeLanguages);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @NotNull
    private List<PsiShortNamesCache> getCaches() {
        if (this.myProject.isDefault()) {
            List<PsiShortNamesCache> list = Collections.emptyList();
            if (list == null) {
                CompositeShortNamesCache.$$$reportNull$$$0(1);
            }
            return list;
        }
        @NotNull List extensionList = EP_NAME.getExtensionList((AreaInstance)this.myProject);
        if (!this.myExcludeLanguages.isEmpty()) {
            List<PsiShortNamesCache> list = extensionList.stream().filter(cache -> !this.myExcludeLanguages.contains(cache.getLanguage())).toList();
            if (list == null) {
                CompositeShortNamesCache.$$$reportNull$$$0(2);
            }
            return list;
        }
        List list = extensionList;
        if (list == null) {
            CompositeShortNamesCache.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    public @NotNull PsiFile @NotNull [] getFilesByName(@NotNull String name) {
        if (name == null) {
            CompositeShortNamesCache.$$$reportNull$$$0(4);
        }
        Merger<PsiFile> merger = null;
        for (PsiShortNamesCache cache : this.getCaches()) {
            PsiFile[] classes = cache.getFilesByName(name);
            if (classes.length == 0) continue;
            if (merger == null) {
                merger = new Merger<PsiFile>();
            }
            merger.add(classes);
        }
        return CompositeShortNamesCache.getMergerResult(merger, PsiFile.EMPTY_ARRAY);
    }

    @NotNull
    public @NotNull String @NotNull [] getAllFileNames() {
        Merger<String> merger = new Merger<String>();
        for (PsiShortNamesCache cache : this.getCaches()) {
            merger.add(cache.getAllFileNames());
        }
        return CompositeShortNamesCache.getMergerResult(merger, ArrayUtilRt.EMPTY_STRING_ARRAY);
    }

    @NotNull
    private static <T> @NotNull T @NotNull [] getMergerResult(@Nullable Merger<T> merger, T[] emptyArray) {
        if (merger == null || merger.myAllItems == null && merger.mySingleItem == null) {
            if (emptyArray == null) {
                CompositeShortNamesCache.$$$reportNull$$$0(5);
            }
            return emptyArray;
        }
        T[] TArray = merger.myAllItems == null ? merger.mySingleItem : merger.myAllItems.toArray(emptyArray);
        if (TArray == null) {
            CompositeShortNamesCache.$$$reportNull$$$0(6);
        }
        return TArray;
    }

    @NotNull
    public @NotNull PsiClass @NotNull [] getClassesByName(@NotNull String name, @NotNull GlobalSearchScope scope) {
        if (name == null) {
            CompositeShortNamesCache.$$$reportNull$$$0(7);
        }
        if (scope == null) {
            CompositeShortNamesCache.$$$reportNull$$$0(8);
        }
        Merger<PsiClass> merger = null;
        for (PsiShortNamesCache cache : this.getCaches()) {
            PsiClass[] classes = cache.getClassesByName(name, scope);
            if (classes.length == 0) continue;
            if (merger == null) {
                merger = new Merger<PsiClass>();
            }
            merger.add(classes);
        }
        return CompositeShortNamesCache.getMergerResult(merger, PsiClass.EMPTY_ARRAY);
    }

    @NotNull
    public @NotNull String @NotNull [] getAllClassNames() {
        Merger<String> merger = new Merger<String>();
        for (PsiShortNamesCache cache : this.getCaches()) {
            String[] names = cache.getAllClassNames();
            merger.add(names);
        }
        return CompositeShortNamesCache.getMergerResult(merger, ArrayUtilRt.EMPTY_STRING_ARRAY);
    }

    public boolean processAllClassNames(@NotNull Processor<? super String> processor) {
        if (processor == null) {
            CompositeShortNamesCache.$$$reportNull$$$0(9);
        }
        CommonProcessors.UniqueProcessor uniqueProcessor = new CommonProcessors.UniqueProcessor(processor);
        for (PsiShortNamesCache cache : this.getCaches()) {
            if (cache.processAllClassNames((Processor)uniqueProcessor)) continue;
            return false;
        }
        return true;
    }

    public boolean processAllClassNames(@NotNull Processor<? super String> processor, @NotNull GlobalSearchScope scope, IdFilter filter) {
        if (processor == null) {
            CompositeShortNamesCache.$$$reportNull$$$0(10);
        }
        if (scope == null) {
            CompositeShortNamesCache.$$$reportNull$$$0(11);
        }
        for (PsiShortNamesCache cache : this.getCaches()) {
            if (cache.processAllClassNames(processor, scope, filter)) continue;
            return false;
        }
        return true;
    }

    public boolean processAllMethodNames(@NotNull Processor<? super String> processor, @NotNull GlobalSearchScope scope, IdFilter filter) {
        if (processor == null) {
            CompositeShortNamesCache.$$$reportNull$$$0(12);
        }
        if (scope == null) {
            CompositeShortNamesCache.$$$reportNull$$$0(13);
        }
        for (PsiShortNamesCache cache : this.getCaches()) {
            if (cache.processAllMethodNames(processor, scope, filter)) continue;
            return false;
        }
        return true;
    }

    public boolean processAllFieldNames(@NotNull Processor<? super String> processor, @NotNull GlobalSearchScope scope, IdFilter filter) {
        if (processor == null) {
            CompositeShortNamesCache.$$$reportNull$$$0(14);
        }
        if (scope == null) {
            CompositeShortNamesCache.$$$reportNull$$$0(15);
        }
        for (PsiShortNamesCache cache : this.getCaches()) {
            if (cache.processAllFieldNames(processor, scope, filter)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public @NotNull PsiMethod @NotNull [] getMethodsByName(@NotNull String name, @NotNull GlobalSearchScope scope) {
        if (name == null) {
            CompositeShortNamesCache.$$$reportNull$$$0(16);
        }
        if (scope == null) {
            CompositeShortNamesCache.$$$reportNull$$$0(17);
        }
        Merger<PsiMethod> merger = null;
        for (PsiShortNamesCache cache : this.getCaches()) {
            PsiMethod[] methods = cache.getMethodsByName(name, scope);
            if (methods.length == 0) continue;
            if (merger == null) {
                merger = new Merger<PsiMethod>();
            }
            merger.add(methods);
        }
        return CompositeShortNamesCache.getMergerResult(merger, PsiMethod.EMPTY_ARRAY);
    }

    @NotNull
    public @NotNull PsiMethod @NotNull [] getMethodsByNameIfNotMoreThan(@NonNls @NotNull String name, @NotNull GlobalSearchScope scope, int maxCount) {
        if (name == null) {
            CompositeShortNamesCache.$$$reportNull$$$0(18);
        }
        if (scope == null) {
            CompositeShortNamesCache.$$$reportNull$$$0(19);
        }
        Merger<PsiMethod> merger = null;
        for (PsiShortNamesCache cache : this.getCaches()) {
            PsiMethod[] methods = cache.getMethodsByNameIfNotMoreThan(name, scope, maxCount);
            if (methods.length == maxCount) {
                if (methods == null) {
                    CompositeShortNamesCache.$$$reportNull$$$0(20);
                }
                return methods;
            }
            if (methods.length == 0) continue;
            if (merger == null) {
                merger = new Merger<PsiMethod>();
            }
            merger.add(methods);
        }
        return CompositeShortNamesCache.getMergerResult(merger, PsiMethod.EMPTY_ARRAY);
    }

    @NotNull
    public @NotNull PsiField @NotNull [] getFieldsByNameIfNotMoreThan(@NonNls @NotNull String name, @NotNull GlobalSearchScope scope, int maxCount) {
        if (name == null) {
            CompositeShortNamesCache.$$$reportNull$$$0(21);
        }
        if (scope == null) {
            CompositeShortNamesCache.$$$reportNull$$$0(22);
        }
        Merger<PsiField> merger = null;
        for (PsiShortNamesCache cache : this.getCaches()) {
            PsiField[] fields = cache.getFieldsByNameIfNotMoreThan(name, scope, maxCount);
            if (fields.length == maxCount) {
                if (fields == null) {
                    CompositeShortNamesCache.$$$reportNull$$$0(23);
                }
                return fields;
            }
            if (fields.length == 0) continue;
            if (merger == null) {
                merger = new Merger<PsiField>();
            }
            merger.add(fields);
        }
        return CompositeShortNamesCache.getMergerResult(merger, PsiField.EMPTY_ARRAY);
    }

    public boolean processMethodsWithName(@NonNls @NotNull String name, @NotNull GlobalSearchScope scope, @NotNull Processor<? super PsiMethod> processor) {
        if (name == null) {
            CompositeShortNamesCache.$$$reportNull$$$0(24);
        }
        if (scope == null) {
            CompositeShortNamesCache.$$$reportNull$$$0(25);
        }
        if (processor == null) {
            CompositeShortNamesCache.$$$reportNull$$$0(26);
        }
        return this.processMethodsWithName(name, processor, scope, null);
    }

    public boolean processMethodsWithName(@NonNls @NotNull String name, @NotNull Processor<? super PsiMethod> processor, @NotNull GlobalSearchScope scope, @Nullable IdFilter idFilter) {
        if (name == null) {
            CompositeShortNamesCache.$$$reportNull$$$0(27);
        }
        if (processor == null) {
            CompositeShortNamesCache.$$$reportNull$$$0(28);
        }
        if (scope == null) {
            CompositeShortNamesCache.$$$reportNull$$$0(29);
        }
        for (PsiShortNamesCache cache : this.getCaches()) {
            if (cache.processMethodsWithName(name, processor, scope, idFilter)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public @NotNull String @NotNull [] getAllMethodNames() {
        Merger<String> merger = new Merger<String>();
        for (PsiShortNamesCache cache : this.getCaches()) {
            merger.add(cache.getAllMethodNames());
        }
        return CompositeShortNamesCache.getMergerResult(merger, ArrayUtilRt.EMPTY_STRING_ARRAY);
    }

    @NotNull
    public @NotNull PsiField @NotNull [] getFieldsByName(@NotNull String name, @NotNull GlobalSearchScope scope) {
        if (name == null) {
            CompositeShortNamesCache.$$$reportNull$$$0(30);
        }
        if (scope == null) {
            CompositeShortNamesCache.$$$reportNull$$$0(31);
        }
        Merger<PsiField> merger = null;
        for (PsiShortNamesCache cache : this.getCaches()) {
            PsiField[] classes = cache.getFieldsByName(name, scope);
            if (classes.length == 0) continue;
            if (merger == null) {
                merger = new Merger<PsiField>();
            }
            merger.add(classes);
        }
        return CompositeShortNamesCache.getMergerResult(merger, PsiField.EMPTY_ARRAY);
    }

    @NotNull
    public @NotNull String @NotNull [] getAllFieldNames() {
        Merger<String> merger = null;
        for (PsiShortNamesCache cache : this.getCaches()) {
            String[] classes = cache.getAllFieldNames();
            if (classes.length == 0) continue;
            if (merger == null) {
                merger = new Merger<String>();
            }
            merger.add(classes);
        }
        return CompositeShortNamesCache.getMergerResult(merger, ArrayUtilRt.EMPTY_STRING_ARRAY);
    }

    public boolean processFieldsWithName(@NotNull String key, @NotNull Processor<? super PsiField> processor, @NotNull GlobalSearchScope scope, @Nullable IdFilter filter) {
        if (key == null) {
            CompositeShortNamesCache.$$$reportNull$$$0(32);
        }
        if (processor == null) {
            CompositeShortNamesCache.$$$reportNull$$$0(33);
        }
        if (scope == null) {
            CompositeShortNamesCache.$$$reportNull$$$0(34);
        }
        for (PsiShortNamesCache cache : this.getCaches()) {
            if (cache.processFieldsWithName(key, processor, scope, filter)) continue;
            return false;
        }
        return true;
    }

    public boolean processClassesWithName(@NotNull String key, @NotNull Processor<? super PsiClass> processor, @NotNull GlobalSearchScope scope, @Nullable IdFilter filter) {
        if (key == null) {
            CompositeShortNamesCache.$$$reportNull$$$0(35);
        }
        if (processor == null) {
            CompositeShortNamesCache.$$$reportNull$$$0(36);
        }
        if (scope == null) {
            CompositeShortNamesCache.$$$reportNull$$$0(37);
        }
        for (PsiShortNamesCache cache : this.getCaches()) {
            if (cache.processClassesWithName(key, processor, scope, filter)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "Composite cache: " + String.valueOf(Collections.singletonList(this.getCaches()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 4, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 21, 22, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/CompositeShortNamesCache";
                break;
            }
            case 4: 
            case 7: 
            case 16: 
            case 18: 
            case 21: 
            case 24: 
            case 27: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 8: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 22: 
            case 25: 
            case 29: 
            case 31: 
            case 34: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 26: 
            case 28: 
            case 33: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 32: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "withoutLanguages";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCaches";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/CompositeShortNamesCache";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getMergerResult";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodsByNameIfNotMoreThan";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getFieldsByNameIfNotMoreThan";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getFilesByName";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getClassesByName";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "processAllClassNames";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "processAllMethodNames";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "processAllFieldNames";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getMethodsByName";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getMethodsByNameIfNotMoreThan";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getFieldsByNameIfNotMoreThan";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "processMethodsWithName";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getFieldsByName";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "processFieldsWithName";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "processClassesWithName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 4, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 21, 22, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37 -> new IllegalArgumentException(string);
        };
    }

    private static class Merger<T> {
        private T[] mySingleItem;
        private Set<T> myAllItems;

        private Merger() {
        }

        void add(T @NotNull [] items) {
            if (items == null) {
                Merger.$$$reportNull$$$0(0);
            }
            if (items.length == 0) {
                return;
            }
            if (this.mySingleItem == null) {
                this.mySingleItem = items;
                return;
            }
            if (this.myAllItems == null) {
                Object[] elements = this.mySingleItem;
                this.myAllItems = (Set)ContainerUtil.addAll(new HashSet(elements.length), (Object[])elements);
            }
            ContainerUtil.addAll(this.myAllItems, (Object[])items);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/intellij/psi/impl/CompositeShortNamesCache$Merger", "add"));
        }
    }
}

