/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java;

import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.LighterASTTokenNode;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.DataInputOutputUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.impl.java.FunExprOccurrence;
import com.intellij.psi.impl.java.ReferenceChainLink;
import com.intellij.psi.impl.java.stubs.FunctionalExpressionKey;
import com.intellij.psi.impl.source.Constants;
import com.intellij.psi.impl.source.FileLocalResolver;
import com.intellij.psi.impl.source.JavaFileElementType;
import com.intellij.psi.impl.source.JavaLightTreeUtil;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.LightTreeUtil;
import com.intellij.psi.impl.source.tree.RecursiveLighterASTNodeWalkingVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.PsiDependentFileContent;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.text.StringSearcher;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaFunctionalExpressionIndex
extends FileBasedIndexExtension<FunctionalExpressionKey, List<IndexEntry>> {
    public static final ID<FunctionalExpressionKey, List<IndexEntry>> INDEX_ID = ID.create((String)"java.fun.expression");
    private static final KeyDescriptor<FunctionalExpressionKey> KEY_DESCRIPTOR = new KeyDescriptor<FunctionalExpressionKey>(){

        public int getHashCode(FunctionalExpressionKey value) {
            return value.hashCode();
        }

        public boolean isEqual(FunctionalExpressionKey val1, FunctionalExpressionKey val2) {
            return val1.equals((Object)val2);
        }

        public void save(@NotNull DataOutput out, FunctionalExpressionKey value) throws IOException {
            if (out == null) {
                1.$$$reportNull$$$0(0);
            }
            value.serializeKey(out);
        }

        public FunctionalExpressionKey read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                1.$$$reportNull$$$0(1);
            }
            return FunctionalExpressionKey.deserializeKey((DataInput)in);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/psi/impl/java/JavaFunctionalExpressionIndex$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };

    @NotNull
    private static List<ReferenceChainLink> createCallChain(FileLocalResolver resolver, @Nullable LighterASTNode expr) {
        ArrayList<ReferenceChainLink> chain = new ArrayList<ReferenceChainLink>();
        while (expr != null) {
            if (expr.getTokenType() == JavaElementType.PARENTH_EXPRESSION) {
                expr = LightTreeUtil.firstChildOfType((LighterAST)resolver.getLightTree(), (LighterASTNode)expr, (TokenSet)ElementType.EXPRESSION_BIT_SET);
                continue;
            }
            if (expr.getTokenType() == JavaElementType.TYPE_CAST_EXPRESSION) {
                String typeName = resolver.getShortClassTypeName(expr);
                ContainerUtil.addIfNotNull(chain, (Object)(typeName != null ? new ReferenceChainLink(typeName, false, -1) : null));
                return JavaFunctionalExpressionIndex.reversedChain(chain);
            }
            boolean isCall = expr.getTokenType() == JavaElementType.METHOD_CALL_EXPRESSION || expr.getTokenType() == JavaElementType.NEW_EXPRESSION;
            String referenceName = JavaFunctionalExpressionIndex.getReferencedMemberName(resolver.getLightTree(), expr, isCall);
            if (referenceName == null) {
                return JavaFunctionalExpressionIndex.reversedChain(chain);
            }
            LighterASTNode qualifier = JavaFunctionalExpressionIndex.getQualifier(resolver.getLightTree(), expr, isCall);
            if (qualifier == null) {
                ContainerUtil.addIfNotNull(chain, (Object)JavaFunctionalExpressionIndex.createChainStart(resolver, expr, isCall, referenceName));
                return JavaFunctionalExpressionIndex.reversedChain(chain);
            }
            chain.add(new ReferenceChainLink(referenceName, isCall, JavaFunctionalExpressionIndex.getArgCount(resolver.getLightTree(), expr)));
            expr = qualifier;
        }
        return JavaFunctionalExpressionIndex.reversedChain(chain);
    }

    @NotNull
    private static List<ReferenceChainLink> reversedChain(List<ReferenceChainLink> chain) {
        Collections.reverse(chain);
        List<ReferenceChainLink> list = chain;
        if (list == null) {
            JavaFunctionalExpressionIndex.$$$reportNull$$$0(0);
        }
        return list;
    }

    private static int getArgCount(LighterAST tree, LighterASTNode expr) {
        List args = JavaLightTreeUtil.getArgList((LighterAST)tree, (LighterASTNode)expr);
        return args == null ? -1 : args.size();
    }

    @Nullable
    private static LighterASTNode getQualifier(LighterAST tree, LighterASTNode expr, boolean isCall) {
        LighterASTNode qualifier = (LighterASTNode)tree.getChildren(expr).get(0);
        if (isCall) {
            List children = tree.getChildren(qualifier);
            qualifier = children.isEmpty() ? null : (LighterASTNode)children.get(0);
        }
        return qualifier != null && ElementType.EXPRESSION_BIT_SET.contains(qualifier.getTokenType()) ? qualifier : null;
    }

    @Nullable
    private static String getReferencedMemberName(LighterAST tree, LighterASTNode expr, boolean isCall) {
        if (isCall) {
            return JavaFunctionalExpressionIndex.getCalledMethodName(tree, expr);
        }
        if (expr.getTokenType() == JavaElementType.REFERENCE_EXPRESSION) {
            return JavaLightTreeUtil.getNameIdentifierText((LighterAST)tree, (LighterASTNode)expr);
        }
        return null;
    }

    @Nullable
    private static ReferenceChainLink createChainStart(FileLocalResolver resolver, LighterASTNode expr, boolean isCall, String referenceName) {
        if (!isCall) {
            FileLocalResolver.LightResolveResult result = resolver.resolveLocally(expr);
            if (result == FileLocalResolver.LightResolveResult.UNKNOWN) {
                return null;
            }
            LighterASTNode target = result.getTarget();
            if (target != null) {
                String typeName = resolver.getShortClassTypeName(target);
                return typeName != null ? new ReferenceChainLink(typeName, false, -1) : null;
            }
        }
        return new ReferenceChainLink(referenceName, isCall, JavaFunctionalExpressionIndex.getArgCount(resolver.getLightTree(), expr));
    }

    @NotNull
    private static String calcExprType(LighterASTNode funExpr, FileLocalResolver resolver) {
        LighterAST tree = resolver.getLightTree();
        LighterASTNode scope = JavaFunctionalExpressionIndex.skipExpressionsUp(tree, funExpr, TokenSet.create((IElementType[])new IElementType[]{JavaElementType.LOCAL_VARIABLE, JavaElementType.FIELD, JavaElementType.TYPE_CAST_EXPRESSION, JavaElementType.RETURN_STATEMENT, JavaElementType.ASSIGNMENT_EXPRESSION, JavaElementType.ARRAY_INITIALIZER_EXPRESSION}));
        int arrayDepth = 0;
        while (scope != null && scope.getTokenType() == JavaElementType.ARRAY_INITIALIZER_EXPRESSION) {
            scope = tree.getParent(scope);
            ++arrayDepth;
        }
        if (scope != null) {
            if (scope.getTokenType() == JavaElementType.ASSIGNMENT_EXPRESSION) {
                LighterASTNode lValue = JavaFunctionalExpressionIndex.findExpressionChild(scope, tree);
                scope = lValue == null ? null : resolver.resolveLocally(lValue).getTarget();
            } else if (scope.getTokenType() == JavaElementType.RETURN_STATEMENT) {
                scope = LightTreeUtil.getParentOfType((LighterAST)tree, (LighterASTNode)scope, (TokenSet)TokenSet.create((IElementType[])new IElementType[]{JavaElementType.METHOD}), (TokenSet)TokenSet.orSet((TokenSet[])new TokenSet[]{ElementType.MEMBER_BIT_SET, TokenSet.create((IElementType[])new IElementType[]{JavaElementType.LAMBDA_EXPRESSION})}));
            } else if (scope.getTokenType() == JavaElementType.NEW_EXPRESSION) {
                assert (arrayDepth > 0);
                if (arrayDepth != LightTreeUtil.getChildrenOfType((LighterAST)tree, (LighterASTNode)scope, (IElementType)JavaTokenType.LBRACKET).size()) {
                    return "";
                }
                LighterASTNode typeRef = LightTreeUtil.firstChildOfType((LighterAST)tree, (LighterASTNode)scope, (IElementType)JavaElementType.JAVA_CODE_REFERENCE);
                String refName = JavaLightTreeUtil.getNameIdentifierText((LighterAST)tree, (LighterASTNode)typeRef);
                String string = StringUtil.notNullize((String)refName);
                if (string == null) {
                    JavaFunctionalExpressionIndex.$$$reportNull$$$0(1);
                }
                return string;
            }
        }
        String string = StringUtil.notNullize(scope == null ? null : resolver.getShortClassTypeName(scope, arrayDepth));
        if (string == null) {
            JavaFunctionalExpressionIndex.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static int getArgIndex(List<? extends LighterASTNode> args, LighterASTNode expr) {
        for (int i = 0; i < args.size(); ++i) {
            if (args.get(i).getEndOffset() < expr.getEndOffset()) continue;
            return i;
        }
        return -1;
    }

    private static FunctionalExpressionKey.CoarseType calcReturnType(final LighterAST tree, LighterASTNode funExpr) {
        if (funExpr.getTokenType() == JavaElementType.METHOD_REF_EXPRESSION) {
            return FunctionalExpressionKey.CoarseType.UNKNOWN;
        }
        LighterASTNode block = LightTreeUtil.firstChildOfType((LighterAST)tree, (LighterASTNode)funExpr, (IElementType)JavaElementType.CODE_BLOCK);
        if (block == null) {
            LighterASTNode expr = JavaFunctionalExpressionIndex.findExpressionChild(funExpr, tree);
            return JavaFunctionalExpressionIndex.isBooleanExpression(tree, expr) ? FunctionalExpressionKey.CoarseType.BOOLEAN : FunctionalExpressionKey.CoarseType.UNKNOWN;
        }
        final Ref returnsSomething = Ref.create(null);
        final AtomicBoolean isBoolean = new AtomicBoolean();
        final AtomicBoolean hasStatements = new AtomicBoolean();
        new RecursiveLighterASTNodeWalkingVisitor(tree){

            public void visitNode(@NotNull LighterASTNode element) {
                IElementType type;
                if (element == null) {
                    2.$$$reportNull$$$0(0);
                }
                if ((type = element.getTokenType()) == JavaElementType.LAMBDA_EXPRESSION || ElementType.MEMBER_BIT_SET.contains(type)) {
                    return;
                }
                if (type == JavaElementType.RETURN_STATEMENT) {
                    LighterASTNode expr = JavaFunctionalExpressionIndex.findExpressionChild(element, tree);
                    returnsSomething.set((Object)(expr != null ? 1 : 0));
                    if (JavaFunctionalExpressionIndex.isBooleanExpression(tree, expr)) {
                        isBoolean.set(true);
                    }
                    return;
                }
                if (type == JavaElementType.EXPRESSION_STATEMENT) {
                    hasStatements.set(true);
                }
                super.visitNode(element);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/java/JavaFunctionalExpressionIndex$2", "visitNode"));
            }
        }.visitNode(block);
        if (isBoolean.get()) {
            return FunctionalExpressionKey.CoarseType.BOOLEAN;
        }
        if (returnsSomething.isNull()) {
            return hasStatements.get() ? FunctionalExpressionKey.CoarseType.VOID : FunctionalExpressionKey.CoarseType.UNKNOWN;
        }
        return (Boolean)returnsSomething.get() != false ? FunctionalExpressionKey.CoarseType.NON_VOID : FunctionalExpressionKey.CoarseType.VOID;
    }

    @Nullable
    private static LighterASTNode findExpressionChild(@NotNull LighterASTNode element, LighterAST tree) {
        if (element == null) {
            JavaFunctionalExpressionIndex.$$$reportNull$$$0(3);
        }
        return LightTreeUtil.firstChildOfType((LighterAST)tree, (LighterASTNode)element, (TokenSet)ElementType.EXPRESSION_BIT_SET);
    }

    private static boolean isBooleanExpression(LighterAST tree, @Nullable LighterASTNode expr) {
        if (expr == null) {
            return false;
        }
        IElementType type = expr.getTokenType();
        if (type == JavaElementType.LITERAL_EXPRESSION) {
            IElementType child = ((LighterASTNode)tree.getChildren(expr).get(0)).getTokenType();
            return child == JavaTokenType.TRUE_KEYWORD || child == JavaTokenType.FALSE_KEYWORD;
        }
        if (type == JavaElementType.POLYADIC_EXPRESSION || type == JavaElementType.BINARY_EXPRESSION) {
            return LightTreeUtil.firstChildOfType((LighterAST)tree, (LighterASTNode)expr, (TokenSet)PsiBinaryExpression.BOOLEAN_OPERATION_TOKENS) != null;
        }
        if (type == JavaElementType.PREFIX_EXPRESSION) {
            return ((LighterASTNode)tree.getChildren(expr).get(0)).getTokenType() == JavaTokenType.EXCL;
        }
        if (type == JavaElementType.PARENTH_EXPRESSION) {
            return JavaFunctionalExpressionIndex.isBooleanExpression(tree, JavaFunctionalExpressionIndex.findExpressionChild(expr, tree));
        }
        if (type == JavaElementType.CONDITIONAL_EXPRESSION) {
            List children = LightTreeUtil.getChildrenOfType((LighterAST)tree, (LighterASTNode)expr, (TokenSet)ElementType.EXPRESSION_BIT_SET);
            return children.size() == 3 && (JavaFunctionalExpressionIndex.isBooleanExpression(tree, (LighterASTNode)children.get(1)) || JavaFunctionalExpressionIndex.isBooleanExpression(tree, (LighterASTNode)children.get(2)));
        }
        return false;
    }

    private static int getFunExprParameterCount(LighterAST tree, LighterASTNode funExpr) {
        if (funExpr.getTokenType() == JavaElementType.METHOD_REF_EXPRESSION) {
            return -1;
        }
        assert (funExpr.getTokenType() == JavaElementType.LAMBDA_EXPRESSION);
        LighterASTNode paramList = LightTreeUtil.firstChildOfType((LighterAST)tree, (LighterASTNode)funExpr, (IElementType)JavaElementType.PARAMETER_LIST);
        assert (paramList != null);
        return LightTreeUtil.getChildrenOfType((LighterAST)tree, (LighterASTNode)paramList, (TokenSet)Constants.PARAMETER_BIT_SET).size();
    }

    @Nullable
    private static String getCalledMethodName(LighterAST tree, LighterASTNode call) {
        if (call.getTokenType() == JavaElementType.NEW_EXPRESSION) {
            LighterASTNode anonClass = LightTreeUtil.firstChildOfType((LighterAST)tree, (LighterASTNode)call, (IElementType)JavaElementType.ANONYMOUS_CLASS);
            LighterASTNode ref = LightTreeUtil.firstChildOfType((LighterAST)tree, (LighterASTNode)(anonClass != null ? anonClass : call), (IElementType)JavaElementType.JAVA_CODE_REFERENCE);
            return ref == null ? null : JavaLightTreeUtil.getNameIdentifierText((LighterAST)tree, (LighterASTNode)ref);
        }
        LighterASTNode methodExpr = (LighterASTNode)tree.getChildren(call).get(0);
        if (LightTreeUtil.firstChildOfType((LighterAST)tree, (LighterASTNode)methodExpr, (IElementType)JavaTokenType.SUPER_KEYWORD) != null) {
            return JavaFunctionalExpressionIndex.getSuperClassName(tree, call);
        }
        if (LightTreeUtil.firstChildOfType((LighterAST)tree, (LighterASTNode)methodExpr, (IElementType)JavaTokenType.THIS_KEYWORD) != null) {
            return JavaLightTreeUtil.getNameIdentifierText((LighterAST)tree, (LighterASTNode)JavaFunctionalExpressionIndex.findClass(tree, call));
        }
        return JavaLightTreeUtil.getNameIdentifierText((LighterAST)tree, (LighterASTNode)methodExpr);
    }

    @Nullable
    private static String getSuperClassName(LighterAST tree, LighterASTNode call) {
        LighterASTNode aClass = JavaFunctionalExpressionIndex.findClass(tree, call);
        return JavaFunctionalExpressionIndex.getReferenceName(tree, LightTreeUtil.firstChildOfType((LighterAST)tree, (LighterASTNode)aClass, (IElementType)JavaElementType.EXTENDS_LIST));
    }

    @Nullable
    private static String getReferenceName(LighterAST tree, LighterASTNode refParent) {
        return JavaLightTreeUtil.getNameIdentifierText((LighterAST)tree, (LighterASTNode)LightTreeUtil.firstChildOfType((LighterAST)tree, (LighterASTNode)refParent, (IElementType)JavaElementType.JAVA_CODE_REFERENCE));
    }

    @Nullable
    private static LighterASTNode getContainingCall(LighterAST tree, LighterASTNode node) {
        LighterASTNode expressionList = JavaFunctionalExpressionIndex.skipExpressionsUp(tree, node, TokenSet.create((IElementType[])new IElementType[]{JavaElementType.EXPRESSION_LIST}));
        if (expressionList != null) {
            LighterASTNode parent = tree.getParent(expressionList);
            if (parent != null && parent.getTokenType() == JavaElementType.ANONYMOUS_CLASS) {
                parent = tree.getParent(parent);
            }
            if (parent != null && (parent.getTokenType() == JavaElementType.METHOD_CALL_EXPRESSION || parent.getTokenType() == JavaElementType.NEW_EXPRESSION)) {
                return parent;
            }
        }
        return null;
    }

    private static LighterASTNode skipExpressionsUp(LighterAST tree, @NotNull LighterASTNode node, TokenSet types) {
        if (node == null) {
            JavaFunctionalExpressionIndex.$$$reportNull$$$0(4);
        }
        node = tree.getParent(node);
        while (node != null) {
            IElementType type = node.getTokenType();
            if (types.contains(type)) {
                return node;
            }
            if (type != JavaElementType.PARENTH_EXPRESSION && type != JavaElementType.CONDITIONAL_EXPRESSION) {
                return null;
            }
            node = tree.getParent(node);
        }
        return null;
    }

    private static LighterASTNode findClass(LighterAST tree, LighterASTNode node) {
        return (LighterASTNode)JBIterable.generate((Object)node, arg_0 -> ((LighterAST)tree).getParent(arg_0)).find(n -> n.getTokenType() == JavaElementType.CLASS);
    }

    @NotNull
    public KeyDescriptor<FunctionalExpressionKey> getKeyDescriptor() {
        KeyDescriptor<FunctionalExpressionKey> keyDescriptor = KEY_DESCRIPTOR;
        if (keyDescriptor == null) {
            JavaFunctionalExpressionIndex.$$$reportNull$$$0(5);
        }
        return keyDescriptor;
    }

    public int getVersion() {
        return 6;
    }

    @NotNull
    public ID<FunctionalExpressionKey, List<IndexEntry>> getName() {
        ID<FunctionalExpressionKey, List<IndexEntry>> iD = INDEX_ID;
        if (iD == null) {
            JavaFunctionalExpressionIndex.$$$reportNull$$$0(6);
        }
        return iD;
    }

    public boolean hasSnapshotMapping() {
        return true;
    }

    @NotNull
    public DataIndexer<FunctionalExpressionKey, List<IndexEntry>, FileContent> getIndexer() {
        DataIndexer dataIndexer = inputData -> {
            ProgressManager.checkCanceled();
            CharSequence text = inputData.getContentAsText();
            ProgressManager.checkCanceled();
            int[] offsets = ArrayUtil.mergeArrays((int[])new StringSearcher("->", true, true).findAllOccurrences(text), (int[])new StringSearcher("::", true, true).findAllOccurrences(text));
            if (offsets.length == 0) {
                return Collections.emptyMap();
            }
            final HashMap result = new HashMap();
            final LighterAST tree = ((PsiDependentFileContent)inputData).getLighterAST();
            final FileLocalResolver resolver = new FileLocalResolver(tree);
            ProgressManager.checkCanceled();
            LightTreeUtil.processLeavesAtOffsets((int[])offsets, (LighterAST)tree, (BiConsumer)new BiConsumer<LighterASTTokenNode, Integer>(this){
                int index = 0;

                @Override
                public void accept(LighterASTTokenNode leaf, Integer offset) {
                    LighterASTNode element = tree.getParent((LighterASTNode)leaf);
                    if (element == null) {
                        return;
                    }
                    if (element.getTokenType() == JavaElementType.METHOD_REF_EXPRESSION || element.getTokenType() == JavaElementType.LAMBDA_EXPRESSION) {
                        FunctionalExpressionKey key = new FunctionalExpressionKey(JavaFunctionalExpressionIndex.getFunExprParameterCount(tree, element), JavaFunctionalExpressionIndex.calcReturnType(tree, element), JavaFunctionalExpressionIndex.calcExprType(element, resolver));
                        LighterASTNode context = LightTreeUtil.getParentOfType((LighterAST)tree, (LighterASTNode)element, (TokenSet)ElementType.MEMBER_BIT_SET, (TokenSet)TokenSet.EMPTY);
                        if (context != null) {
                            List list = result.computeIfAbsent(key, __ -> new ArrayList());
                            list.add(new IndexEntry(element.getStartOffset(), this.index, context.getStartOffset(), context.getEndOffset(), JavaFunctionalExpressionIndex.createOccurrence(element, resolver)));
                        }
                        ++this.index;
                    }
                }
            });
            return result;
        };
        if (dataIndexer == null) {
            JavaFunctionalExpressionIndex.$$$reportNull$$$0(7);
        }
        return dataIndexer;
    }

    @NotNull
    private static FunExprOccurrence createOccurrence(@NotNull LighterASTNode funExpr, FileLocalResolver resolver) {
        LighterASTNode assignment;
        LighterASTNode containingCall;
        LighterAST tree;
        List args;
        if (funExpr == null) {
            JavaFunctionalExpressionIndex.$$$reportNull$$$0(8);
        }
        int argIndex = (args = JavaLightTreeUtil.getArgList((LighterAST)(tree = resolver.getLightTree()), (LighterASTNode)(containingCall = JavaFunctionalExpressionIndex.getContainingCall(tree, funExpr)))) == null ? -1 : JavaFunctionalExpressionIndex.getArgIndex(args, funExpr);
        LighterASTNode chainExpr = containingCall;
        if (chainExpr == null && (assignment = JavaFunctionalExpressionIndex.skipExpressionsUp(tree, funExpr, TokenSet.create((IElementType[])new IElementType[]{JavaElementType.ASSIGNMENT_EXPRESSION}))) != null) {
            chainExpr = JavaFunctionalExpressionIndex.findExpressionChild(assignment, tree);
        }
        return new FunExprOccurrence(argIndex, JavaFunctionalExpressionIndex.createCallChain(resolver, chainExpr));
    }

    @NotNull
    public DataExternalizer<List<IndexEntry>> getValueExternalizer() {
        return new DataExternalizer<List<IndexEntry>>(this){

            public void save(@NotNull DataOutput out, List<IndexEntry> value) throws IOException {
                if (out == null) {
                    4.$$$reportNull$$$0(0);
                }
                DataInputOutputUtilRt.writeSeq((DataOutput)out, value, entry -> entry.serialize(out));
            }

            public List<IndexEntry> read(@NotNull DataInput in) throws IOException {
                if (in == null) {
                    4.$$$reportNull$$$0(1);
                }
                return DataInputOutputUtilRt.readSeq((DataInput)in, () -> IndexEntry.deserialize(in));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "out";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "in";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/psi/impl/java/JavaFunctionalExpressionIndex$4";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "save";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "read";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        return new DefaultFileTypeSpecificInputFilter(this, new FileType[]{JavaFileType.INSTANCE}){

            public boolean acceptInput(@NotNull VirtualFile file) {
                if (file == null) {
                    5.$$$reportNull$$$0(0);
                }
                return super.acceptInput(file) && JavaFileElementType.isInSourceContent((VirtualFile)file);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/java/JavaFunctionalExpressionIndex$5", "acceptInput"));
            }
        };
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3, 4, 8 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/java/JavaFunctionalExpressionIndex";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "funExpr";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "reversedChain";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "calcExprType";
                break;
            }
            case 3: 
            case 4: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/java/JavaFunctionalExpressionIndex";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyDescriptor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexer";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findExpressionChild";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "skipExpressionsUp";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createOccurrence";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3, 4, 8 -> new IllegalArgumentException(string);
        };
    }

    public static class IndexEntry {
        public final int exprStart;
        public final int exprIndex;
        public final int contextStart;
        public final int contextEnd;
        public final FunExprOccurrence occurrence;

        IndexEntry(int exprStart, int exprIndex, int contextStart, int contextEnd, FunExprOccurrence occurrence) {
            this.exprStart = exprStart;
            this.exprIndex = exprIndex;
            this.contextStart = contextStart;
            this.contextEnd = contextEnd;
            this.occurrence = occurrence;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof IndexEntry)) {
                return false;
            }
            IndexEntry entry = (IndexEntry)o;
            return this.exprStart == entry.exprStart && this.exprIndex == entry.exprIndex && this.contextStart == entry.contextStart && this.contextEnd == entry.contextEnd && this.occurrence.equals(entry.occurrence);
        }

        public String toString() {
            return "IndexEntry{exprStart=" + this.exprStart + ", exprIndex=" + this.exprIndex + ", contextStart=" + this.contextStart + ", contextEnd=" + this.contextEnd + "}";
        }

        public int hashCode() {
            return Objects.hash(this.exprStart, this.exprIndex, this.contextStart, this.contextEnd, this.occurrence);
        }

        void serialize(DataOutput out) throws IOException {
            DataInputOutputUtil.writeINT((DataOutput)out, (int)this.exprStart);
            DataInputOutputUtil.writeINT((DataOutput)out, (int)this.exprIndex);
            DataInputOutputUtil.writeINT((DataOutput)out, (int)this.contextStart);
            DataInputOutputUtil.writeINT((DataOutput)out, (int)this.contextEnd);
            this.occurrence.serialize(out);
        }

        static IndexEntry deserialize(DataInput in) throws IOException {
            return new IndexEntry(DataInputOutputUtil.readINT((DataInput)in), DataInputOutputUtil.readINT((DataInput)in), DataInputOutputUtil.readINT((DataInput)in), DataInputOutputUtil.readINT((DataInput)in), FunExprOccurrence.deserialize(in));
        }
    }
}

