/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UnfairTextRange;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.impl.light.LightMemberReference;
import com.intellij.psi.impl.search.JavaFilesSearchScope;
import com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.psi.search.SearchRequestCollector;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.JavaPsiConstructorUtil;
import com.intellij.util.PairProcessor;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;

class ConstructorReferencesSearchHelper {
    private final PsiManager myManager;

    ConstructorReferencesSearchHelper(@NotNull PsiManager manager) {
        if (manager == null) {
            ConstructorReferencesSearchHelper.$$$reportNull$$$0(0);
        }
        this.myManager = manager;
    }

    boolean processConstructorReferences(@NotNull Processor<? super PsiReference> processor, @NotNull PsiMethod constructor, @NotNull PsiClass containingClass, @NotNull SearchScope searchScope, @NotNull Project project, boolean ignoreAccessScope, boolean isStrictSignatureSearch, @NotNull SearchRequestCollector collector) {
        SearchScope searchScope2;
        if (processor == null) {
            ConstructorReferencesSearchHelper.$$$reportNull$$$0(1);
        }
        if (constructor == null) {
            ConstructorReferencesSearchHelper.$$$reportNull$$$0(2);
        }
        if (containingClass == null) {
            ConstructorReferencesSearchHelper.$$$reportNull$$$0(3);
        }
        if (searchScope == null) {
            ConstructorReferencesSearchHelper.$$$reportNull$$$0(4);
        }
        if (project == null) {
            ConstructorReferencesSearchHelper.$$$reportNull$$$0(5);
        }
        if (collector == null) {
            ConstructorReferencesSearchHelper.$$$reportNull$$$0(6);
        }
        boolean[] constructorCanBeCalledImplicitly = new boolean[1];
        boolean[] isEnum = new boolean[1];
        boolean[] isUnder18 = new boolean[1];
        DumbService.getInstance((Project)project).runReadActionInSmartMode(() -> {
            PsiParameter[] parameters = constructor.getParameterList().getParameters();
            constructorCanBeCalledImplicitly[0] = parameters.length == 0 || parameters.length == 1 && parameters[0].isVarArgs();
            isEnum[0] = containingClass.isEnum();
            isUnder18[0] = PsiUtil.getLanguageLevel((PsiElement)containingClass).isAtLeast(LanguageLevel.JDK_1_8);
            return null;
        });
        if (isEnum[0] && !ConstructorReferencesSearchHelper.processEnumReferences(processor, constructor, project, containingClass, searchScope)) {
            return false;
        }
        PairProcessor processor1 = (reference, collector1) -> {
            PsiNewExpression expression;
            PsiMethod constructor1;
            PsiElement parent = reference.getElement().getParent();
            if (parent instanceof PsiAnonymousClass) {
                parent = parent.getParent();
            }
            if (parent instanceof PsiNewExpression && (constructor1 = (expression = (PsiNewExpression)parent).resolveConstructor()) != null && (isStrictSignatureSearch ? this.myManager.areElementsEquivalent((PsiElement)constructor, (PsiElement)constructor1) : this.myManager.areElementsEquivalent((PsiElement)containingClass, (PsiElement)constructor1.getContainingClass()))) {
                return processor.process(reference);
            }
            return true;
        };
        if (searchScope instanceof GlobalSearchScope) {
            GlobalSearchScope scope = (GlobalSearchScope)searchScope;
            searchScope2 = scope.intersectWith((GlobalSearchScope)new JavaFilesSearchScope(project));
        } else {
            searchScope2 = searchScope;
        }
        SearchScope restrictedScope = searchScope2;
        ReferencesSearch.searchOptimized((PsiElement)containingClass, (SearchScope)restrictedScope, (boolean)ignoreAccessScope, (SearchRequestCollector)collector, (boolean)true, (PairProcessor)processor1);
        if (isUnder18[0] && !ConstructorReferencesSearchHelper.process18MethodPointers(processor, constructor, project, containingClass, restrictedScope)) {
            return false;
        }
        if (!((Boolean)DumbService.getInstance((Project)project).runReadActionInSmartMode(() -> this.processSuperOrThis(containingClass, constructor, constructorCanBeCalledImplicitly[0], searchScope, project, isStrictSignatureSearch, "this", processor))).booleanValue()) {
            return false;
        }
        Processor processor2 = inheritor -> {
            PsiElement patt0$temp = inheritor.getNavigationElement();
            if (patt0$temp instanceof PsiClass) {
                PsiClass aClass = (PsiClass)patt0$temp;
                return this.processSuperOrThis(aClass, constructor, constructorCanBeCalledImplicitly[0], searchScope, project, isStrictSignatureSearch, "super", processor);
            }
            return true;
        };
        return ClassInheritorsSearch.search((PsiClass)containingClass, (SearchScope)searchScope, (boolean)false).allowParallelProcessing().forEach(processor2);
    }

    private static boolean processEnumReferences(@NotNull Processor<? super PsiReference> processor, @NotNull PsiMethod constructor, @NotNull Project project, @NotNull PsiClass aClass, @NotNull SearchScope searchScope) {
        if (processor == null) {
            ConstructorReferencesSearchHelper.$$$reportNull$$$0(7);
        }
        if (constructor == null) {
            ConstructorReferencesSearchHelper.$$$reportNull$$$0(8);
        }
        if (project == null) {
            ConstructorReferencesSearchHelper.$$$reportNull$$$0(9);
        }
        if (aClass == null) {
            ConstructorReferencesSearchHelper.$$$reportNull$$$0(10);
        }
        if (searchScope == null) {
            ConstructorReferencesSearchHelper.$$$reportNull$$$0(11);
        }
        return (Boolean)DumbService.getInstance((Project)project).runReadActionInSmartMode(() -> {
            for (PsiField field : aClass.getFields()) {
                PsiReference reference;
                if (!(field instanceof PsiEnumConstant) || !PsiSearchScopeUtil.isInScope((SearchScope)searchScope, (PsiElement)field) || (reference = field.getReference()) == null || !reference.isReferenceTo((PsiElement)constructor) || processor.process((Object)reference)) continue;
                return false;
            }
            return true;
        });
    }

    private static boolean process18MethodPointers(@NotNull Processor<? super PsiReference> processor, @NotNull PsiMethod constructor, @NotNull Project project, @NotNull PsiClass aClass, SearchScope searchScope) {
        if (processor == null) {
            ConstructorReferencesSearchHelper.$$$reportNull$$$0(12);
        }
        if (constructor == null) {
            ConstructorReferencesSearchHelper.$$$reportNull$$$0(13);
        }
        if (project == null) {
            ConstructorReferencesSearchHelper.$$$reportNull$$$0(14);
        }
        if (aClass == null) {
            ConstructorReferencesSearchHelper.$$$reportNull$$$0(15);
        }
        return ReferencesSearch.search((PsiElement)aClass, (SearchScope)searchScope).forEach(reference -> {
            PsiElement element = reference.getElement();
            return (Boolean)DumbService.getInstance((Project)project).runReadActionInSmartMode(() -> {
                PsiMethodReferenceExpression ref;
                PsiElement patt0$temp = element.getParent();
                if (patt0$temp instanceof PsiMethodReferenceExpression && (ref = (PsiMethodReferenceExpression)patt0$temp).getReferenceNameElement() instanceof PsiKeyword && ref.isReferenceTo((PsiElement)constructor)) {
                    return processor.process((Object)ref);
                }
                return true;
            });
        });
    }

    private boolean processSuperOrThis(@NotNull PsiClass inheritor, @NotNull PsiMethod constructor, boolean constructorCanBeCalledImplicitly, @NotNull SearchScope searchScope, @NotNull Project project, boolean isStrictSignatureSearch, @NotNull String superOrThisKeyword, @NotNull Processor<? super PsiReference> processor) {
        PsiMethod[] constructors;
        if (inheritor == null) {
            ConstructorReferencesSearchHelper.$$$reportNull$$$0(16);
        }
        if (constructor == null) {
            ConstructorReferencesSearchHelper.$$$reportNull$$$0(17);
        }
        if (searchScope == null) {
            ConstructorReferencesSearchHelper.$$$reportNull$$$0(18);
        }
        if (project == null) {
            ConstructorReferencesSearchHelper.$$$reportNull$$$0(19);
        }
        if (superOrThisKeyword == null) {
            ConstructorReferencesSearchHelper.$$$reportNull$$$0(20);
        }
        if (processor == null) {
            ConstructorReferencesSearchHelper.$$$reportNull$$$0(21);
        }
        if ((constructors = inheritor.getConstructors()).length == 0 && constructorCanBeCalledImplicitly && !this.processImplicitConstructorCall((PsiMember)inheritor, processor, constructor, project, inheritor)) {
            return false;
        }
        for (PsiMethod method : constructors) {
            if (method == constructor && isStrictSignatureSearch || method instanceof SyntheticElement) continue;
            PsiMethodCallExpression thisOrSuperCall = JavaPsiConstructorUtil.findThisOrSuperCallInConstructor((PsiMethod)method);
            if (thisOrSuperCall != null) {
                boolean match;
                PsiElement psiElement;
                PsiReferenceExpression ref;
                if (!PsiSearchScopeUtil.isInScope((SearchScope)searchScope, (PsiElement)thisOrSuperCall) || !(ref = thisOrSuperCall.getMethodExpression()).textMatches((CharSequence)superOrThisKeyword) || !((psiElement = ref.resolve()) instanceof PsiMethod)) continue;
                PsiMethod referencedConstructor = (PsiMethod)psiElement;
                boolean bl = match = isStrictSignatureSearch ? this.myManager.areElementsEquivalent((PsiElement)referencedConstructor, (PsiElement)constructor) : this.myManager.areElementsEquivalent((PsiElement)constructor.getContainingClass(), (PsiElement)referencedConstructor.getContainingClass());
                if (!match || processor.process((Object)ref)) continue;
                return false;
            }
            if (!constructorCanBeCalledImplicitly || !PsiSearchScopeUtil.isInScope((SearchScope)searchScope, (PsiElement)method) || this.processImplicitConstructorCall((PsiMember)method, processor, constructor, project, inheritor)) continue;
            return false;
        }
        return true;
    }

    private boolean processImplicitConstructorCall(final @NotNull PsiMember usage, @NotNull Processor<? super PsiReference> processor, @NotNull PsiMethod constructor, @NotNull Project project, @NotNull PsiClass containingClass) {
        if (usage == null) {
            ConstructorReferencesSearchHelper.$$$reportNull$$$0(22);
        }
        if (processor == null) {
            ConstructorReferencesSearchHelper.$$$reportNull$$$0(23);
        }
        if (constructor == null) {
            ConstructorReferencesSearchHelper.$$$reportNull$$$0(24);
        }
        if (project == null) {
            ConstructorReferencesSearchHelper.$$$reportNull$$$0(25);
        }
        if (containingClass == null) {
            ConstructorReferencesSearchHelper.$$$reportNull$$$0(26);
        }
        if (containingClass instanceof PsiAnonymousClass) {
            return true;
        }
        PsiClass ctrClass = constructor.getContainingClass();
        if (ctrClass == null) {
            return true;
        }
        boolean isImplicitSuper = (Boolean)DumbService.getInstance((Project)project).runReadActionInSmartMode(() -> this.myManager.areElementsEquivalent((PsiElement)ctrClass, (PsiElement)containingClass.getSuperClass()));
        if (!isImplicitSuper) {
            return true;
        }
        PsiElement resolved = JavaResolveUtil.resolveImaginarySuperCallInThisPlace((PsiMember)usage, (Project)project, (PsiClass)ctrClass);
        boolean resolvesToThisConstructor = (Boolean)DumbService.getInstance((Project)project).runReadActionInSmartMode(() -> this.myManager.areElementsEquivalent((PsiElement)constructor, resolved));
        if (!resolvesToThisConstructor) {
            return true;
        }
        return processor.process((Object)new LightMemberReference(this.myManager, usage, PsiSubstitutor.EMPTY){

            @NotNull
            public PsiElement getElement() {
                PsiMember psiMember = usage;
                if (psiMember == null) {
                    1.$$$reportNull$$$0(0);
                }
                return psiMember;
            }

            @NotNull
            public TextRange getRangeInElement() {
                PsiNameIdentifierOwner owner;
                PsiElement identifier;
                if (usage instanceof PsiNameIdentifierOwner && (identifier = (owner = (PsiNameIdentifierOwner)usage).getNameIdentifier()) != null) {
                    int startOffsetInParent = identifier.getStartOffsetInParent();
                    if (startOffsetInParent >= 0) {
                        TextRange textRange = TextRange.from((int)startOffsetInParent, (int)identifier.getTextLength());
                        if (textRange == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        return textRange;
                    }
                    return new UnfairTextRange(-1, -1);
                }
                TextRange textRange = super.getRangeInElement();
                if (textRange == null) {
                    1.$$$reportNull$$$0(2);
                }
                return textRange;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/psi/impl/search/ConstructorReferencesSearchHelper$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getElement";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getRangeInElement";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 1: 
            case 7: 
            case 12: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 2: 
            case 8: 
            case 13: 
            case 17: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructor";
                break;
            }
            case 3: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingClass";
                break;
            }
            case 4: 
            case 11: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 5: 
            case 9: 
            case 14: 
            case 19: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collector";
                break;
            }
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inheritor";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superOrThisKeyword";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usage";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/impl/search/ConstructorReferencesSearchHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "processConstructorReferences";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "processEnumReferences";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "process18MethodPointers";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[2] = "processSuperOrThis";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[2] = "processImplicitConstructorCall";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

