/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.impl.AnyPsiChangeListener;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashingStrategy;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
final class HighlightingCaches {
    private final List<Map<?, ?>> allCaches;
    final ConcurrentMap<PsiClass, PsiClass[]> DIRECT_SUB_CLASSES;
    final ConcurrentMap<PsiClass, Iterable<PsiClass>> ALL_SUB_CLASSES;
    final ConcurrentMap<PsiClass, Iterable<PsiClass>> ALL_SUB_CLASSES_NO_ANONYMOUS;
    final Map<PsiMethod, Iterable<PsiMethod>> OVERRIDING_METHODS;

    public static HighlightingCaches getInstance(Project project) {
        return (HighlightingCaches)project.getService(HighlightingCaches.class);
    }

    HighlightingCaches(@NotNull Project project) {
        if (project == null) {
            HighlightingCaches.$$$reportNull$$$0(0);
        }
        this.allCaches = ContainerUtil.createConcurrentList();
        this.DIRECT_SUB_CLASSES = this.createWeakCache();
        this.ALL_SUB_CLASSES = this.createWeakCache();
        this.ALL_SUB_CLASSES_NO_ANONYMOUS = this.createWeakCache();
        this.OVERRIDING_METHODS = this.createWeakCache();
        project.getMessageBus().connect().subscribe(PsiManagerImpl.ANY_PSI_CHANGE_TOPIC, (Object)new AnyPsiChangeListener(){

            public void beforePsiChanged(boolean isPhysical) {
                if (isPhysical) {
                    HighlightingCaches.this.allCaches.forEach(Map::clear);
                }
            }
        });
    }

    @NotNull
    private <T, V> ConcurrentMap<T, V> createWeakCache() {
        ConcurrentMap map = CollectionFactory.createConcurrentWeakKeySoftValueMap((int)10, (float)0.7f, (int)Runtime.getRuntime().availableProcessors(), (HashingStrategy)HashingStrategy.canonical());
        this.allCaches.add(map);
        ConcurrentMap concurrentMap = map;
        if (concurrentMap == null) {
            HighlightingCaches.$$$reportNull$$$0(1);
        }
        return concurrentMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/search/HighlightingCaches";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/search/HighlightingCaches";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createWeakCache";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

