/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.impl.search.HighlightingCaches;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaOverridingMethodsSearcher
implements QueryExecutor<PsiMethod, OverridingMethodsSearch.SearchParameters> {
    public boolean execute(@NotNull OverridingMethodsSearch.SearchParameters parameters, @NotNull Processor<? super PsiMethod> consumer) {
        VirtualFile[] files;
        if (parameters == null) {
            JavaOverridingMethodsSearcher.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            JavaOverridingMethodsSearcher.$$$reportNull$$$0(1);
        }
        PsiMethod method = parameters.getMethod();
        Project project = (Project)ReadAction.compute(() -> ((PsiMethod)method).getProject());
        SearchScope searchScope = parameters.getScope();
        if (searchScope instanceof LocalSearchScope && JavaOverridingMethodsSearcher.isJavaOnlyScope(files = ((LocalSearchScope)searchScope).getVirtualFiles())) {
            return JavaOverridingMethodsSearcher.processLocalScope((LocalSearchScope)searchScope, method, project, consumer);
        }
        Iterable<PsiMethod> cached = HighlightingCaches.getInstance((Project)project).OVERRIDING_METHODS.get(method);
        if (cached == null) {
            cached = JavaOverridingMethodsSearcher.compute(method, parameters, project);
            if (((Boolean)ReadAction.compute(() -> ((PsiMethod)method).isPhysical())).booleanValue()) {
                HighlightingCaches.getInstance((Project)project).OVERRIDING_METHODS.put(method, cached);
            }
        }
        for (PsiMethod subMethod : cached) {
            ProgressManager.checkCanceled();
            if (!((Boolean)ReadAction.compute(() -> PsiSearchScopeUtil.isInScope((SearchScope)searchScope, (PsiElement)subMethod))).booleanValue()) continue;
            if (!consumer.process((Object)subMethod)) {
                return false;
            }
            if (parameters.isCheckDeep()) continue;
            return true;
        }
        return true;
    }

    static boolean isJavaOnlyScope(VirtualFile @NotNull [] files) {
        if (files == null) {
            JavaOverridingMethodsSearcher.$$$reportNull$$$0(2);
        }
        return ContainerUtil.and((Object[])files, file -> FileTypeRegistry.getInstance().isFileOfType(file, (FileType)JavaFileType.INSTANCE));
    }

    private static boolean processLocalScope(@NotNull LocalSearchScope searchScope, final @NotNull PsiMethod method, final @NotNull Project project, final @NotNull Processor<? super PsiMethod> consumer) {
        if (searchScope == null) {
            JavaOverridingMethodsSearcher.$$$reportNull$$$0(3);
        }
        if (method == null) {
            JavaOverridingMethodsSearcher.$$$reportNull$$$0(4);
        }
        if (project == null) {
            JavaOverridingMethodsSearcher.$$$reportNull$$$0(5);
        }
        if (consumer == null) {
            JavaOverridingMethodsSearcher.$$$reportNull$$$0(6);
        }
        VirtualFile[] virtualFiles = searchScope.getVirtualFiles();
        final PsiClass methodContainingClass = (PsiClass)ReadAction.compute(() -> ((PsiMethod)method).getContainingClass());
        if (methodContainingClass == null) {
            return true;
        }
        final boolean[] success = new boolean[]{true};
        for (final VirtualFile virtualFile : virtualFiles) {
            ProgressManager.checkCanceled();
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(virtualFile);
                    if (psiFile != null) {
                        psiFile.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                            public void visitClass(@NotNull PsiClass candidate) {
                                PsiMethod overridingMethod;
                                if (candidate == null) {
                                    1.$$$reportNull$$$0(0);
                                }
                                ProgressManager.checkCanceled();
                                PsiMethod psiMethod = overridingMethod = candidate.isInheritor(methodContainingClass, true) ? JavaOverridingMethodsSearcher.findOverridingMethod(candidate, method, methodContainingClass) : null;
                                if (overridingMethod != null && !consumer.process((Object)overridingMethod)) {
                                    success[0] = false;
                                    this.stopWalking();
                                } else {
                                    super.visitClass(candidate);
                                }
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidate", "com/intellij/psi/impl/search/JavaOverridingMethodsSearcher$1$1", "visitClass"));
                            }
                        });
                    }
                }
            });
        }
        return success[0];
    }

    @NotNull
    private static Iterable<PsiMethod> compute(@NotNull PsiMethod method, OverridingMethodsSearch.SearchParameters parameters, @NotNull Project project) {
        if (method == null) {
            JavaOverridingMethodsSearcher.$$$reportNull$$$0(7);
        }
        if (project == null) {
            JavaOverridingMethodsSearcher.$$$reportNull$$$0(8);
        }
        PsiClass containingClass = (PsiClass)ReadAction.compute(() -> ((PsiMethod)method).getContainingClass());
        assert (containingClass != null);
        HashSet<PsiMethod> result = new HashSet<PsiMethod>();
        Processor inheritorsProcessor = inheritor -> {
            PsiMethod found = (PsiMethod)ReadAction.compute(() -> JavaOverridingMethodsSearcher.findOverridingMethod(inheritor, method, containingClass));
            if (found != null) {
                Collection collection = result;
                synchronized (collection) {
                    result.add(found);
                }
            }
            return true;
        };
        GlobalSearchScope allScope = GlobalSearchScope.allScope((Project)project);
        boolean success = ClassInheritorsSearch.search((ClassInheritorsSearch.SearchParameters)new ClassInheritanceSearchFromJavaOverridingMethodsParameters(containingClass, (SearchScope)allScope, parameters)).allowParallelProcessing().forEach(inheritorsProcessor);
        assert (success);
        HashSet<PsiMethod> hashSet = result;
        if (hashSet == null) {
            JavaOverridingMethodsSearcher.$$$reportNull$$$0(9);
        }
        return hashSet;
    }

    @Nullable
    public static PsiMethod findOverridingMethod(@NotNull PsiClass inheritor, @NotNull PsiMethod method, @NotNull PsiClass methodContainingClass) {
        MethodSignature signature;
        PsiMethod derived;
        PsiClass superClass;
        PsiMethod found;
        String name;
        if (inheritor == null) {
            JavaOverridingMethodsSearcher.$$$reportNull$$$0(10);
        }
        if (method == null) {
            JavaOverridingMethodsSearcher.$$$reportNull$$$0(11);
        }
        if (methodContainingClass == null) {
            JavaOverridingMethodsSearcher.$$$reportNull$$$0(12);
        }
        if (inheritor.findMethodsByName(name = method.getName(), false).length > 0 && (found = MethodSignatureUtil.findMethodBySuperSignature((PsiClass)inheritor, (MethodSignature)JavaOverridingMethodsSearcher.getSuperSignature(inheritor, methodContainingClass, method), (boolean)false)) != null && JavaOverridingMethodsSearcher.isAcceptable(found, inheritor, method, methodContainingClass)) {
            return found;
        }
        if (methodContainingClass.isInterface() && !inheritor.isInterface() && (superClass = inheritor.getSuperClass()) != null && !superClass.isInheritor(methodContainingClass, true) && superClass.findMethodsByName(name, true).length > 0 && (derived = MethodSignatureUtil.findMethodInSuperClassBySignatureInDerived((PsiClass)inheritor, (PsiClass)superClass, (MethodSignature)(signature = JavaOverridingMethodsSearcher.getSuperSignature(inheritor, methodContainingClass, method)), (boolean)true)) != null && JavaOverridingMethodsSearcher.isAcceptable(derived, inheritor, method, methodContainingClass)) {
            return derived;
        }
        return null;
    }

    @NotNull
    private static MethodSignature getSuperSignature(PsiClass inheritor, @NotNull PsiClass parentClass, PsiMethod method) {
        PsiSubstitutor substitutor;
        if (parentClass == null) {
            JavaOverridingMethodsSearcher.$$$reportNull$$$0(13);
        }
        MethodSignature methodSignature = method.getSignature((substitutor = TypeConversionUtil.getMaybeSuperClassSubstitutor((PsiClass)parentClass, (PsiClass)inheritor, (PsiSubstitutor)PsiSubstitutor.EMPTY)) != null ? substitutor : PsiSubstitutor.EMPTY);
        if (methodSignature == null) {
            JavaOverridingMethodsSearcher.$$$reportNull$$$0(14);
        }
        return methodSignature;
    }

    private static boolean isAcceptable(@NotNull PsiMethod found, @NotNull PsiClass foundContainingClass, @NotNull PsiMethod method, @NotNull PsiClass methodContainingClass) {
        if (found == null) {
            JavaOverridingMethodsSearcher.$$$reportNull$$$0(15);
        }
        if (foundContainingClass == null) {
            JavaOverridingMethodsSearcher.$$$reportNull$$$0(16);
        }
        if (method == null) {
            JavaOverridingMethodsSearcher.$$$reportNull$$$0(17);
        }
        if (methodContainingClass == null) {
            JavaOverridingMethodsSearcher.$$$reportNull$$$0(18);
        }
        return !found.hasModifierProperty("static") && (!method.hasModifierProperty("packageLocal") || JavaPsiFacade.getInstance((Project)found.getProject()).arePackagesTheSame((PsiElement)methodContainingClass, (PsiElement)foundContainingClass));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 4: 
            case 7: 
            case 11: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/search/JavaOverridingMethodsSearcher";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inheritor";
                break;
            }
            case 12: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodContainingClass";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentClass";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "found";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "foundContainingClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/search/JavaOverridingMethodsSearcher";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "compute";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperSignature";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isJavaOnlyScope";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processLocalScope";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "compute";
                break;
            }
            case 9: 
            case 14: {
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findOverridingMethod";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getSuperSignature";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9, 14 -> new IllegalStateException(string);
        };
    }

    public static class ClassInheritanceSearchFromJavaOverridingMethodsParameters
    extends ClassInheritorsSearch.SearchParameters {
        private final OverridingMethodsSearch.SearchParameters myOriginalParameters;

        public ClassInheritanceSearchFromJavaOverridingMethodsParameters(@NotNull PsiClass aClass, @NotNull SearchScope scope, OverridingMethodsSearch.SearchParameters parameters) {
            if (aClass == null) {
                ClassInheritanceSearchFromJavaOverridingMethodsParameters.$$$reportNull$$$0(0);
            }
            if (scope == null) {
                ClassInheritanceSearchFromJavaOverridingMethodsParameters.$$$reportNull$$$0(1);
            }
            super(aClass, scope, true, true, true);
            this.myOriginalParameters = parameters;
        }

        public OverridingMethodsSearch.SearchParameters getOriginalParameters() {
            return this.myOriginalParameters;
        }

        public boolean shouldSearchInLanguage(@NotNull Language language) {
            PsiClass aClass;
            if (language == null) {
                ClassInheritanceSearchFromJavaOverridingMethodsParameters.$$$reportNull$$$0(2);
            }
            if (((Boolean)ReadAction.compute(() -> ClassInheritanceSearchFromJavaOverridingMethodsParameters.lambda$shouldSearchInLanguage$0(aClass = this.getClassToProcess()))).booleanValue()) {
                return language == aClass.getLanguage();
            }
            return super.shouldSearchInLanguage(language);
        }

        private static /* synthetic */ Boolean lambda$shouldSearchInLanguage$0(PsiClass aClass) throws RuntimeException {
            return aClass.isEnum();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aClass";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "language";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/psi/impl/search/JavaOverridingMethodsSearcher$ClassInheritanceSearchFromJavaOverridingMethodsParameters";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "shouldSearchInLanguage";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

