/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.java.codeserver.core.JavaPsiModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.impl.light.LightJavaModule;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.NotNull;

public class JavaPlatformModuleSystemScope
extends DelegatingGlobalSearchScope {
    @NotNull
    private final PsiJavaModule myModule;

    private JavaPlatformModuleSystemScope(@NotNull Project project, @NotNull PsiJavaModule module, @NotNull GlobalSearchScope baseScope) {
        if (project == null) {
            JavaPlatformModuleSystemScope.$$$reportNull$$$0(0);
        }
        if (module == null) {
            JavaPlatformModuleSystemScope.$$$reportNull$$$0(1);
        }
        if (baseScope == null) {
            JavaPlatformModuleSystemScope.$$$reportNull$$$0(2);
        }
        super(project, baseScope);
        this.myModule = module;
    }

    @NotNull
    public static GlobalSearchScope create(@NotNull Project project, @NotNull VirtualFile file, @NotNull GlobalSearchScope baseScope) {
        PsiJavaModule module;
        if (project == null) {
            JavaPlatformModuleSystemScope.$$$reportNull$$$0(3);
        }
        if (file == null) {
            JavaPlatformModuleSystemScope.$$$reportNull$$$0(4);
        }
        if (baseScope == null) {
            JavaPlatformModuleSystemScope.$$$reportNull$$$0(5);
        }
        if ((module = JavaPsiModuleUtil.findDescriptorByFile((VirtualFile)file, (Project)project)) == null) {
            GlobalSearchScope globalSearchScope = baseScope;
            if (globalSearchScope == null) {
                JavaPlatformModuleSystemScope.$$$reportNull$$$0(6);
            }
            return globalSearchScope;
        }
        if (module instanceof LightJavaModule) {
            GlobalSearchScope globalSearchScope = baseScope;
            if (globalSearchScope == null) {
                JavaPlatformModuleSystemScope.$$$reportNull$$$0(7);
            }
            return globalSearchScope;
        }
        return new JavaPlatformModuleSystemScope(project, module, baseScope);
    }

    public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
        if (file1 == null) {
            JavaPlatformModuleSystemScope.$$$reportNull$$$0(8);
        }
        if (file2 == null) {
            JavaPlatformModuleSystemScope.$$$reportNull$$$0(9);
        }
        if (!this.myModule.isValid()) {
            return this.getDelegate().compare(file1, file2);
        }
        PsiJavaModule module1 = JavaPsiModuleUtil.findDescriptorByFile((VirtualFile)file1, (Project)this.myModule.getProject());
        PsiJavaModule module2 = JavaPsiModuleUtil.findDescriptorByFile((VirtualFile)file2, (Project)this.myModule.getProject());
        if (module1 == null && module2 == null) {
            return this.getDelegate().compare(file1, file2);
        }
        if (module1 == null) {
            return 1;
        }
        if (module2 == null) {
            return -1;
        }
        if (JavaPlatformModuleSystemScope.isModuleFile(module1, file1) && JavaPlatformModuleSystemScope.isModuleFile(module2, file2)) {
            return this.getDelegate().compare(file1, file2);
        }
        if (JavaPlatformModuleSystemScope.isModuleFile(module1, file1)) {
            return 1;
        }
        if (JavaPlatformModuleSystemScope.isModuleFile(module2, file2)) {
            return -1;
        }
        if (module1.equals((Object)module2) || module1.getName().equals(module2.getName())) {
            return this.getDelegate().compare(file1, file2);
        }
        int result = Boolean.compare(JavaPsiModuleUtil.reads((PsiJavaModule)this.myModule, (PsiJavaModule)module1), JavaPsiModuleUtil.reads((PsiJavaModule)this.myModule, (PsiJavaModule)module2));
        if (result != 0) {
            return result;
        }
        if (module1.equals((Object)this.myModule)) {
            return -1;
        }
        if (module2.equals((Object)this.myModule)) {
            return 1;
        }
        return this.getDelegate().compare(file1, file2);
    }

    private static boolean isModuleFile(@NotNull PsiJavaModule module, @NotNull VirtualFile file) {
        if (module == null) {
            JavaPlatformModuleSystemScope.$$$reportNull$$$0(10);
        }
        if (file == null) {
            JavaPlatformModuleSystemScope.$$$reportNull$$$0(11);
        }
        if (module instanceof LightJavaModule) {
            return false;
        }
        return module.getContainingFile().getVirtualFile().equals(file);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JavaPlatformModuleSystemScope scope = (JavaPlatformModuleSystemScope)((Object)o);
        return this.myModule.equals((Object)scope.myModule);
    }

    public int hashCode() {
        return 31 * super.hashCode() + this.myModule.hashCode();
    }

    public String toString() {
        return "Java module: " + this.myModule.getName() + " @ " + String.valueOf(this.myBaseScope);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseScope";
                break;
            }
            case 4: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/search/JavaPlatformModuleSystemScope";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file1";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/search/JavaPlatformModuleSystemScope";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "compare";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isModuleFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7 -> new IllegalStateException(string);
        };
    }
}

