/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.codeInsight.multiverse.CodeInsightContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.search.ActualCodeInsightContextInfo;
import com.intellij.psi.search.CodeInsightContextAwareSearchScopes;
import com.intellij.psi.search.CodeInsightContextFileInfo;
import com.intellij.psi.search.CodeInsightContextInfo;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.DoesNotContainFileInfo;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.NoContextInformation;
import com.intellij.psi.util.JavaMultiReleaseUtil;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public final class JavaVersionBasedScope
extends DelegatingGlobalSearchScope {
    private final LanguageLevel myLevel;

    public JavaVersionBasedScope(@NotNull Project project, @NotNull GlobalSearchScope baseScope, @NotNull LanguageLevel desiredLevel) {
        if (project == null) {
            JavaVersionBasedScope.$$$reportNull$$$0(0);
        }
        if (baseScope == null) {
            JavaVersionBasedScope.$$$reportNull$$$0(1);
        }
        if (desiredLevel == null) {
            JavaVersionBasedScope.$$$reportNull$$$0(2);
        }
        super(project, baseScope);
        this.myLevel = desiredLevel.isLessThan(JavaMultiReleaseUtil.MIN_MULTI_RELEASE_VERSION) ? JavaMultiReleaseUtil.MAX_NON_MULTI_RELEASE_VERSION : desiredLevel;
    }

    public boolean contains(@NotNull VirtualFile file) {
        if (file == null) {
            JavaVersionBasedScope.$$$reportNull$$$0(3);
        }
        return super.contains(file) && this.checkMultiReleaseJar(file);
    }

    private boolean checkMultiReleaseJar(@NotNull VirtualFile file) {
        if (file == null) {
            JavaVersionBasedScope.$$$reportNull$$$0(4);
        }
        if (file.isDirectory()) {
            return true;
        }
        VirtualFile baseFile = JavaMultiReleaseUtil.findBaseFile((VirtualFile)file);
        if (this.myLevel.isLessThan(JavaMultiReleaseUtil.MIN_MULTI_RELEASE_VERSION)) {
            return baseFile == null;
        }
        if (baseFile == null) {
            baseFile = file;
        }
        VirtualFile specificFile = JavaMultiReleaseUtil.findVersionSpecificFile((VirtualFile)baseFile, (LanguageLevel)this.myLevel);
        return file.equals(specificFile);
    }

    @ApiStatus.Experimental
    @NotNull
    public CodeInsightContextInfo getCodeInsightContextInfo() {
        CodeInsightContextInfo info = super.getCodeInsightContextInfo();
        if (info instanceof NoContextInformation) {
            CodeInsightContextInfo codeInsightContextInfo = info;
            if (codeInsightContextInfo == null) {
                JavaVersionBasedScope.$$$reportNull$$$0(5);
            }
            return codeInsightContextInfo;
        }
        final ActualCodeInsightContextInfo actualInfo = (ActualCodeInsightContextInfo)info;
        return new ActualCodeInsightContextInfo(){

            public boolean contains(@NotNull VirtualFile file, @NotNull CodeInsightContext context) {
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    1.$$$reportNull$$$0(1);
                }
                return actualInfo.contains(file, context) && JavaVersionBasedScope.this.checkMultiReleaseJar(file);
            }

            @NotNull
            public CodeInsightContextFileInfo getFileInfo(@NotNull VirtualFile file) {
                CodeInsightContextFileInfo fileInfo;
                if (file == null) {
                    1.$$$reportNull$$$0(2);
                }
                if ((fileInfo = actualInfo.getFileInfo(file)) instanceof DoesNotContainFileInfo) {
                    CodeInsightContextFileInfo codeInsightContextFileInfo = fileInfo;
                    if (codeInsightContextFileInfo == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    return codeInsightContextFileInfo;
                }
                if (!JavaVersionBasedScope.this.checkMultiReleaseJar(file)) {
                    DoesNotContainFileInfo doesNotContainFileInfo = CodeInsightContextAwareSearchScopes.DoesNotContainFileInfo();
                    if (doesNotContainFileInfo == null) {
                        1.$$$reportNull$$$0(4);
                    }
                    return doesNotContainFileInfo;
                }
                CodeInsightContextFileInfo codeInsightContextFileInfo = fileInfo;
                if (codeInsightContextFileInfo == null) {
                    1.$$$reportNull$$$0(5);
                }
                return codeInsightContextFileInfo;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 3, 4, 5 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/psi/impl/search/JavaVersionBasedScope$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/psi/impl/search/JavaVersionBasedScope$1";
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFileInfo";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "contains";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "getFileInfo";
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 3, 4, 5 -> new IllegalStateException(string);
                };
            }
        };
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JavaVersionBasedScope scope = (JavaVersionBasedScope)((Object)o);
        return this.myLevel == scope.myLevel;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.myLevel);
        return result;
    }

    public String toString() {
        return "Java " + this.myLevel.feature() + " @ " + String.valueOf(this.myBaseScope);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseScope";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "desiredLevel";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/search/JavaVersionBasedScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/search/JavaVersionBasedScope";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCodeInsightContextInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkMultiReleaseJar";
                break;
            }
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }
}

