/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.openapi.application.CachedSingletonsRegistry;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.ReferenceRange;
import com.intellij.psi.ResolvingHint;
import com.intellij.psi.search.RequestResultProcessor;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Processor;
import java.util.Arrays;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodTextOccurrenceProcessor
extends RequestResultProcessor {
    private static final Supplier<PsiReferenceService> ourReferenceService = CachedSingletonsRegistry.lazy(() -> PsiReferenceService.getService());
    private final PsiMethod[] myMethods;
    protected final PsiClass myContainingClass;
    private final boolean myStrictSignatureSearch;

    public MethodTextOccurrenceProcessor(@NotNull PsiClass aClass, boolean strictSignatureSearch, PsiMethod ... methods) {
        if (aClass == null) {
            MethodTextOccurrenceProcessor.$$$reportNull$$$0(0);
        }
        if (methods == null) {
            MethodTextOccurrenceProcessor.$$$reportNull$$$0(1);
        }
        super(new Object[]{strictSignatureSearch, Arrays.asList(methods)});
        this.myMethods = methods;
        this.myContainingClass = aClass;
        this.myStrictSignatureSearch = strictSignatureSearch;
    }

    public final boolean processTextOccurrence(@NotNull PsiElement element, int offsetInElement, @NotNull Processor<? super PsiReference> consumer) {
        if (element == null) {
            MethodTextOccurrenceProcessor.$$$reportNull$$$0(2);
        }
        if (consumer == null) {
            MethodTextOccurrenceProcessor.$$$reportNull$$$0(3);
        }
        for (PsiReference ref : ourReferenceService.get().getReferences(element, new PsiReferenceService.Hints((PsiElement)this.myMethods[0], Integer.valueOf(offsetInElement)))) {
            if (!ReferenceRange.containsOffsetInElement((PsiReference)ref, (int)offsetInElement) || this.processReference(consumer, ref)) continue;
            return false;
        }
        return true;
    }

    private boolean processReference(@NotNull Processor<? super PsiReference> consumer, @NotNull PsiReference ref) {
        if (consumer == null) {
            MethodTextOccurrenceProcessor.$$$reportNull$$$0(4);
        }
        if (ref == null) {
            MethodTextOccurrenceProcessor.$$$reportNull$$$0(5);
        }
        for (PsiMethod method : this.myMethods) {
            if (!method.isValid()) continue;
            if (ref instanceof ResolvingHint && !((ResolvingHint)ref).canResolveTo(PsiMethod.class)) {
                return true;
            }
            if (ref.isReferenceTo((PsiElement)method)) {
                return consumer.process((Object)ref);
            }
            if (this.processInexactReference(ref, ref.resolve(), method, consumer)) continue;
            return false;
        }
        return true;
    }

    protected boolean processInexactReference(@NotNull PsiReference ref, @Nullable PsiElement refElement, @NotNull PsiMethod method, @NotNull Processor<? super PsiReference> consumer) {
        if (ref == null) {
            MethodTextOccurrenceProcessor.$$$reportNull$$$0(6);
        }
        if (method == null) {
            MethodTextOccurrenceProcessor.$$$reportNull$$$0(7);
        }
        if (consumer == null) {
            MethodTextOccurrenceProcessor.$$$reportNull$$$0(8);
        }
        if (refElement instanceof PsiMethod) {
            PsiManager manager;
            MethodSignature refSignature;
            MethodSignature superSignature;
            PsiSubstitutor substitutor;
            PsiMethod refMethod = (PsiMethod)refElement;
            PsiClass refMethodClass = refMethod.getContainingClass();
            if (refMethodClass == null) {
                return true;
            }
            if (!refMethod.hasModifierProperty("static") && (substitutor = TypeConversionUtil.getClassSubstitutor((PsiClass)this.myContainingClass, (PsiClass)refMethodClass, (PsiSubstitutor)PsiSubstitutor.EMPTY)) != null && MethodSignatureUtil.isSubsignature((MethodSignature)(superSignature = method.getSignature(substitutor)), (MethodSignature)(refSignature = refMethod.getSignature(PsiSubstitutor.EMPTY))) && !consumer.process((Object)ref)) {
                return false;
            }
            if (!this.myStrictSignatureSearch && (manager = method.getManager()).areElementsEquivalent((PsiElement)refMethodClass, (PsiElement)this.myContainingClass)) {
                return consumer.process((Object)ref);
            }
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methods";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/impl/search/MethodTextOccurrenceProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "processTextOccurrence";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "processReference";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "processInexactReference";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

