/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler;

import com.intellij.compiler.CompilerConfiguration;
import com.intellij.compiler.CompilerWorkspaceConfiguration;
import com.intellij.compiler.ParallelCompilationOption;
import com.intellij.compiler.server.CompilerConfigurationUtils;
import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.openapi.project.Project;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0014R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/compiler/CompilerSettingsCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/ProjectUsagesCollector;", "<init>", "()V", "getGroup", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "getMetrics", "", "Lcom/intellij/internal/statistic/beans/MetricEvent;", "project", "Lcom/intellij/openapi/project/Project;", "GROUP", "AUTO_SHOW_ERRORS_IN_EDITOR", "Lcom/intellij/internal/statistic/eventLog/events/EventId1;", "", "DISPLAY_NOTIFICATION_POPUP", "CLEAR_OUTPUT_DIRECTORY", "MAKE_PROJECT_ON_SAVE", "PARALLEL_COMPILATION_OPTION", "Lcom/intellij/compiler/ParallelCompilationOption;", "IS_PARALLEL_COMPILATION_ALLOWED_IN_AUTOMATIC_MODE", "REBUILD_ON_DEPENDENCY_CHANGE", "COMPILE_AFFECTED_UNLOADED_MODULES_BEFORE_COMMIT", "intellij.java.compiler.impl"})
public final class CompilerSettingsCollector
extends ProjectUsagesCollector {
    @NotNull
    private final EventLogGroup GROUP = new EventLogGroup("java.compiler.settings.project", 3, null, 4, null);
    @NotNull
    private final EventId1<Boolean> AUTO_SHOW_ERRORS_IN_EDITOR = this.GROUP.registerEvent("AUTO_SHOW_ERRORS_IN_EDITOR", (EventField)EventFields.Enabled);
    @NotNull
    private final EventId1<Boolean> DISPLAY_NOTIFICATION_POPUP = this.GROUP.registerEvent("DISPLAY_NOTIFICATION_POPUP", (EventField)EventFields.Enabled);
    @NotNull
    private final EventId1<Boolean> CLEAR_OUTPUT_DIRECTORY = this.GROUP.registerEvent("CLEAR_OUTPUT_DIRECTORY", (EventField)EventFields.Enabled);
    @NotNull
    private final EventId1<Boolean> MAKE_PROJECT_ON_SAVE = this.GROUP.registerEvent("MAKE_PROJECT_ON_SAVE", (EventField)EventFields.Enabled);
    @NotNull
    private final EventId1<ParallelCompilationOption> PARALLEL_COMPILATION_OPTION = this.GROUP.registerEvent("PARALLEL_COMPILATION_OPTION", (EventField)EventFields.Enum$default((String)"value", ParallelCompilationOption.class, null, (int)4, null));
    @NotNull
    private final EventId1<Boolean> IS_PARALLEL_COMPILATION_ALLOWED_IN_AUTOMATIC_MODE = this.GROUP.registerEvent("IS_PARALLEL_COMPILATION_ALLOWED_IN_AUTOMATIC_MODE", (EventField)EventFields.Boolean((String)"isAllowed"));
    @NotNull
    private final EventId1<Boolean> REBUILD_ON_DEPENDENCY_CHANGE = this.GROUP.registerEvent("REBUILD_ON_DEPENDENCY_CHANGE", (EventField)EventFields.Enabled);
    @NotNull
    private final EventId1<Boolean> COMPILE_AFFECTED_UNLOADED_MODULES_BEFORE_COMMIT = this.GROUP.registerEvent("COMPILE_AFFECTED_UNLOADED_MODULES_BEFORE_COMMIT", (EventField)EventFields.Enabled);

    @NotNull
    public EventLogGroup getGroup() {
        return this.GROUP;
    }

    @NotNull
    protected Set<MetricEvent> getMetrics(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Set usages = new LinkedHashSet();
        CompilerWorkspaceConfiguration workspaceConfig = CompilerWorkspaceConfiguration.getInstance((Project)project);
        CompilerConfiguration config = CompilerConfiguration.getInstance((Project)project);
        usages.add(this.AUTO_SHOW_ERRORS_IN_EDITOR.metric((Object)workspaceConfig.AUTO_SHOW_ERRORS_IN_EDITOR));
        usages.add(this.DISPLAY_NOTIFICATION_POPUP.metric((Object)workspaceConfig.DISPLAY_NOTIFICATION_POPUP));
        usages.add(this.CLEAR_OUTPUT_DIRECTORY.metric((Object)workspaceConfig.CLEAR_OUTPUT_DIRECTORY));
        usages.add(this.MAKE_PROJECT_ON_SAVE.metric((Object)workspaceConfig.MAKE_PROJECT_ON_SAVE));
        ParallelCompilationOption parallelCompilationOption = config.getParallelCompilationOption();
        Intrinsics.checkNotNullExpressionValue((Object)parallelCompilationOption, (String)"getParallelCompilationOption(...)");
        usages.add(this.PARALLEL_COMPILATION_OPTION.metric((Object)parallelCompilationOption));
        usages.add(this.IS_PARALLEL_COMPILATION_ALLOWED_IN_AUTOMATIC_MODE.metric((Object)CompilerConfigurationUtils.isParallelCompilationAllowedWithCurrentSpecs()));
        usages.add(this.REBUILD_ON_DEPENDENCY_CHANGE.metric((Object)workspaceConfig.REBUILD_ON_DEPENDENCY_CHANGE));
        usages.add(this.COMPILE_AFFECTED_UNLOADED_MODULES_BEFORE_COMMIT.metric((Object)workspaceConfig.COMPILE_AFFECTED_UNLOADED_MODULES_BEFORE_COMMIT));
        return usages;
    }
}

