/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler;

import com.intellij.compiler.CompilerConfiguration;
import com.intellij.compiler.CompilerConfigurationImpl;
import com.intellij.compiler.ExternalCompilerConfigurationStorageKt;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtilCore;
import com.intellij.openapi.roots.ExternalProjectSystemRegistry;
import com.intellij.openapi.roots.ProjectModelElement;
import com.intellij.openapi.roots.ProjectModelExternalSource;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="ExternalCompilerConfiguration", storages={@Storage(value="compiler.xml")}, externalStorageOnly=true)
@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u0000 \u00142\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001\u0014B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u000e\u001a\u00020\u0002H\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0002H\u0016J\n\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R:\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t2\u0014\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0015"}, d2={"Lcom/intellij/compiler/ExternalCompilerConfigurationStorage;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lorg/jdom/Element;", "Lcom/intellij/openapi/roots/ProjectModelElement;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "value", "", "", "loadedState", "getLoadedState", "()Ljava/util/Map;", "getState", "loadState", "", "state", "getExternalSource", "Lcom/intellij/openapi/roots/ProjectModelExternalSource;", "Companion", "intellij.java.compiler.impl"})
public final class ExternalCompilerConfigurationStorage
implements PersistentStateComponent<Element>,
ProjectModelElement {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @Nullable
    private Map<String, String> loadedState;

    public ExternalCompilerConfigurationStorage(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @Nullable
    public final Map<String, String> getLoadedState() {
        return this.loadedState;
    }

    @NotNull
    public Element getState() {
        Map<String, String> map;
        Element result = new Element("state");
        if (!ProjectUtilCore.isExternalStorageEnabled((Project)this.project)) {
            return result;
        }
        if (this.project.isDefault()) {
            map = MapsKt.emptyMap();
        } else {
            CompilerConfiguration compilerConfiguration = CompilerConfiguration.getInstance((Project)this.project);
            Intrinsics.checkNotNull((Object)compilerConfiguration, (String)"null cannot be cast to non-null type com.intellij.compiler.CompilerConfigurationImpl");
            map = ((CompilerConfigurationImpl)compilerConfiguration).getModulesBytecodeTargetMap();
        }
        Map<String, String> map2 = map;
        Intrinsics.checkNotNull((Object)map2);
        List<String> moduleNames = ExternalCompilerConfigurationStorageKt.getFilteredModuleNameList(this.project, map2, true);
        if (!((Collection)moduleNames).isEmpty()) {
            Element element = new Element("bytecodeTargetLevel");
            ExternalCompilerConfigurationStorageKt.writeBytecodeTarget(moduleNames, map2, element);
            result.addContent(element);
        }
        return result;
    }

    public void loadState(@NotNull Element state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        HashMap result = new HashMap();
        ExternalCompilerConfigurationStorageKt.readByteTargetLevel(state, result);
        this.loadedState = result;
    }

    @Nullable
    public ProjectModelExternalSource getExternalSource() {
        ExternalProjectSystemRegistry externalProjectSystemRegistry = ExternalProjectSystemRegistry.getInstance();
        for (Module module : ModuleManager.Companion.getInstance(this.project).getModules()) {
            ProjectModelExternalSource projectModelExternalSource = externalProjectSystemRegistry.getExternalSource(module);
            if (projectModelExternalSource == null) continue;
            ProjectModelExternalSource it = projectModelExternalSource;
            boolean bl = false;
            return it;
        }
        return null;
    }

    @JvmStatic
    @NotNull
    public static final ExternalCompilerConfigurationStorage getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/compiler/ExternalCompilerConfigurationStorage$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/compiler/ExternalCompilerConfigurationStorage;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.java.compiler.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ExternalCompilerConfigurationStorage getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(ExternalCompilerConfigurationStorage.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (ExternalCompilerConfigurationStorage)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

