/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler;

import com.intellij.compiler.progress.CompilerTask;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerMessage;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.util.ArrayUtilRt;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ProblemsView {
    protected final Project myProject;

    public static ProblemsView getInstance(@NotNull Project project) {
        if (project == null) {
            ProblemsView.$$$reportNull$$$0(0);
        }
        return (ProblemsView)project.getService(ProblemsView.class);
    }

    @Nullable
    public static ProblemsView getInstanceIfCreated(@NotNull Project project) {
        if (project == null) {
            ProblemsView.$$$reportNull$$$0(1);
        }
        return (ProblemsView)project.getServiceIfCreated(ProblemsView.class);
    }

    protected ProblemsView(@NotNull Project project) {
        if (project == null) {
            ProblemsView.$$$reportNull$$$0(2);
        }
        this.myProject = project;
    }

    public abstract void clearOldMessages(CompileScope var1, UUID var2);

    public abstract void addMessage(int var1, String @NotNull [] var2, @Nullable String var3, @Nullable Navigatable var4, @Nullable String var5, @Nullable String var6, @NotNull UUID var7);

    public final void addMessage(CompilerMessage message, @NotNull UUID sessionId) {
        if (sessionId == null) {
            ProblemsView.$$$reportNull$$$0(3);
        }
        VirtualFile file = message.getVirtualFile();
        Navigatable navigatable = message.getNavigatable();
        if (navigatable == null && file != null && !file.getFileType().isBinary()) {
            navigatable = new OpenFileDescriptor(this.myProject, file, -1, -1);
        }
        CompilerMessageCategory category = message.getCategory();
        int type = CompilerTask.translateCategory(category);
        String[] text = ProblemsView.convertMessage(message);
        String groupName = file != null ? file.getPresentableUrl() : category.getPresentableText();
        this.addMessage(type, text, groupName, navigatable, message.getExportTextPrefix(), message.getRenderTextPrefix(), sessionId);
    }

    public void buildStarted(@NotNull UUID sessionId) {
        if (sessionId == null) {
            ProblemsView.$$$reportNull$$$0(4);
        }
        this.clearProgress();
    }

    public abstract void setProgress(String var1, float var2);

    public abstract void setProgress(String var1);

    public abstract void clearProgress();

    private static String[] convertMessage(CompilerMessage message) {
        String text = message.getMessage();
        if (!text.contains("\n")) {
            return new String[]{text};
        }
        ArrayList<String> lines = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(text, "\n", false);
        while (tokenizer.hasMoreTokens()) {
            lines.add(tokenizer.nextToken());
        }
        return ArrayUtilRt.toStringArray(lines);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sessionId";
                break;
            }
        }
        objectArray2[1] = "com/intellij/compiler/ProblemsView";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getInstanceIfCreated";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "addMessage";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "buildStarted";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    @Deprecated(forRemoval=true)
    public static final class SERVICE {
        private SERVICE() {
        }

        public static ProblemsView getInstance(@NotNull Project project) {
            if (project == null) {
                SERVICE.$$$reportNull$$$0(0);
            }
            return ProblemsView.getInstance(project);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/compiler/ProblemsView$SERVICE", "getInstance"));
        }
    }
}

