/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.backwardRefs;

import com.intellij.compiler.CompilerDirectHierarchyInfo;
import com.intellij.compiler.CompilerReferenceService;
import com.intellij.compiler.backwardRefs.CompilerHierarchyInfoImpl;
import com.intellij.compiler.backwardRefs.CompilerHierarchySearchType;
import com.intellij.compiler.backwardRefs.CompilerReferenceReader;
import com.intellij.compiler.backwardRefs.CompilerReferenceReaderFactory;
import com.intellij.compiler.backwardRefs.DirtyScopeHolder;
import com.intellij.compiler.backwardRefs.IsUpToDateCheckConsumer;
import com.intellij.compiler.backwardRefs.LanguageCompilerRefAdapter;
import com.intellij.compiler.backwardRefs.SearchId;
import com.intellij.compiler.backwardRefs.view.CompilerReferenceFindUsagesTestInfo;
import com.intellij.compiler.backwardRefs.view.CompilerReferenceHierarchyTestInfo;
import com.intellij.compiler.backwardRefs.view.DirtyScopeTestInfo;
import com.intellij.compiler.server.BuildManager;
import com.intellij.compiler.server.PortableCachesLoadListener;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.io.FileSystemUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSet;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.messages.MessageBusConnection;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import kotlin.collections.ArraysKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.jps.backwardRefs.CompilerRef;
import org.jetbrains.jps.backwardRefs.NameEnumerator;
import org.jetbrains.jps.backwardRefs.index.CompilerReferenceIndex;

public abstract class CompilerReferenceServiceBase<Reader extends CompilerReferenceReader<?>>
implements CompilerReferenceService,
ModificationTracker,
Disposable {
    private static final Logger LOG = Logger.getInstance(CompilerReferenceServiceBase.class);
    private final Set<FileType> myFileTypes;
    private final DirtyScopeHolder myDirtyScopeHolder;
    private final ProjectFileIndex myProjectFileIndex;
    private final LongAdder myCompilationCount = new LongAdder();
    protected final ReentrantReadWriteLock myLock = new ReentrantReadWriteLock();
    protected final Lock myReadDataLock = this.myLock.readLock();
    private final Lock myOpenCloseLock = this.myLock.writeLock();
    protected final Project project;
    private final CompilerReferenceReaderFactory<? extends Reader> myReaderFactory;
    private int myActiveBuilds = 0;
    private boolean initialized = false;
    protected volatile Reader myReader;
    private final ThreadLocal<Boolean> myIsInsideLibraryScope = ThreadLocal.withInitial(() -> false);

    public CompilerReferenceServiceBase(Project project, CompilerReferenceReaderFactory<? extends Reader> readerFactory, BiConsumer<? super MessageBusConnection, ? super Set<String>> compilationAffectedModulesSubscription) {
        this.project = project;
        this.myReaderFactory = readerFactory;
        this.myProjectFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        this.myFileTypes = LanguageCompilerRefAdapter.EP_NAME.getExtensionList().stream().flatMap(a -> a.getFileTypes().stream()).collect(Collectors.toSet());
        Set<FileType> affectedFileTypes = LanguageCompilerRefAdapter.EP_NAME.getExtensionList().stream().flatMap(a -> a.getAffectedFileTypes().stream()).collect(Collectors.toSet());
        this.myDirtyScopeHolder = new DirtyScopeHolder(project, affectedFileTypes, this.myProjectFileIndex, this, this, compilationAffectedModulesSubscription);
        if (!CompilerReferenceServiceBase.isEnabled()) {
            return;
        }
        this.myDirtyScopeHolder.installVFSListener(this);
        Application app = ApplicationManager.getApplication();
        if (app.isUnitTestMode()) {
            return;
        }
        MessageBusConnection connection = project.getMessageBus().connect((Disposable)this);
        connection.subscribe(PortableCachesLoadListener.TOPIC, (Object)new PortableCachesLoadListener(){

            @Override
            public void loadingStarted() {
                CompilerReferenceServiceBase.this.closeReaderIfNeeded(IndexCloseReason.SHUTDOWN);
            }
        });
    }

    private boolean hasIndex() {
        Path buildDir = BuildManager.getInstance().getProjectSystemDir(this.project);
        return !CompilerReferenceIndex.versionDiffers((Path)buildDir, (int)this.myReaderFactory.expectedIndexVersion());
    }

    private static CompilerReferenceServiceBase<?> getInstanceIfEnabled(Project project) {
        CompilerReferenceService service = CompilerReferenceService.getInstanceIfEnabled((Project)project);
        if (service instanceof CompilerReferenceServiceBase) {
            return (CompilerReferenceServiceBase)service;
        }
        return null;
    }

    public static boolean isEnabled() {
        return RegistryManager.getInstance().is("compiler.ref.index");
    }

    @ApiStatus.Experimental
    public static boolean isCaseSensitiveFS(@NotNull Project project) {
        if (project == null) {
            CompilerReferenceServiceBase.$$$reportNull$$$0(0);
        }
        FsCompilerReferenceType fsCompilerReferenceType = FsCompilerReferenceType.from(Registry.stringValue((String)"java.jps.backward.ref.index.builder.fs.case.sensitive"));
        switch (fsCompilerReferenceType.ordinal()) {
            case 0: {
                return true;
            }
            case 1: {
                return false;
            }
            case 2: {
                return SystemInfo.isFileSystemCaseSensitive;
            }
            case 3: {
                String basePath;
                VirtualFile guessedProjectDir = ProjectUtil.guessProjectDir((Project)project);
                String string = basePath = guessedProjectDir == null ? project.getBasePath() : guessedProjectDir.getCanonicalPath();
                if (basePath == null) break;
                File file = new File(basePath);
                FileAttributes.CaseSensitivity sensitivity = FileSystemUtil.readParentCaseSensitivity((File)file);
                return sensitivity.toBooleanWithDefault(SystemInfo.isFileSystemCaseSensitive);
            }
        }
        return SystemInfo.isFileSystemCaseSensitive;
    }

    @Nullable
    public GlobalSearchScope getScopeWithCodeReferences(@NotNull PsiElement element) {
        if (element == null) {
            CompilerReferenceServiceBase.$$$reportNull$$$0(1);
        }
        if (!this.isServiceEnabledFor(element)) {
            return null;
        }
        try {
            return (GlobalSearchScope)CachedValuesManager.getCachedValue((PsiElement)element, () -> CachedValueProvider.Result.create((Object)this.buildScopeWithReferences(this.getReferentFiles(element), element), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT, this}));
        }
        catch (RuntimeException e1) {
            return (GlobalSearchScope)this.onException(e1, "scope without code references");
        }
    }

    @Nullable
    public GlobalSearchScope getScopeWithImplicitToStringCodeReferences(@NotNull PsiElement aClass) {
        if (aClass == null) {
            CompilerReferenceServiceBase.$$$reportNull$$$0(2);
        }
        if (!this.isServiceEnabledFor(aClass)) {
            return null;
        }
        try {
            return (GlobalSearchScope)CachedValuesManager.getCachedValue((PsiElement)aClass, () -> CachedValueProvider.Result.create((Object)this.buildScopeWithReferences(this.getReferentFileIdsViaImplicitToString(aClass), aClass), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT, this}));
        }
        catch (RuntimeException e) {
            return (GlobalSearchScope)this.onException(e, "scope without implicit toString references");
        }
    }

    @Nullable
    public CompilerDirectHierarchyInfo getDirectInheritors(@NotNull PsiNamedElement aClass, @NotNull GlobalSearchScope searchScope, @NotNull FileType searchFileType) {
        if (aClass == null) {
            CompilerReferenceServiceBase.$$$reportNull$$$0(3);
        }
        if (searchScope == null) {
            CompilerReferenceServiceBase.$$$reportNull$$$0(4);
        }
        if (searchFileType == null) {
            CompilerReferenceServiceBase.$$$reportNull$$$0(5);
        }
        return this.getHierarchyInfo(aClass, searchScope, searchFileType, CompilerHierarchySearchType.DIRECT_INHERITOR);
    }

    @Nullable
    public CompilerDirectHierarchyInfo getFunExpressions(@NotNull PsiNamedElement functionalInterface, @NotNull GlobalSearchScope searchScope, @NotNull FileType searchFileType) {
        if (functionalInterface == null) {
            CompilerReferenceServiceBase.$$$reportNull$$$0(6);
        }
        if (searchScope == null) {
            CompilerReferenceServiceBase.$$$reportNull$$$0(7);
        }
        if (searchFileType == null) {
            CompilerReferenceServiceBase.$$$reportNull$$$0(8);
        }
        return this.getHierarchyInfo(functionalInterface, searchScope, searchFileType, CompilerHierarchySearchType.FUNCTIONAL_EXPRESSION);
    }

    @Nullable
    public Integer getCompileTimeOccurrenceCount(@NotNull PsiElement element, boolean isConstructorSuggestion) {
        if (element == null) {
            CompilerReferenceServiceBase.$$$reportNull$$$0(9);
        }
        if (!this.isServiceEnabledFor(element)) {
            return null;
        }
        try {
            return (Integer)((ConcurrentMap)CachedValuesManager.getCachedValue((PsiElement)element, () -> CachedValueProvider.Result.create((Object)ConcurrentFactoryMap.createMap(constructorSuggestion -> this.calculateOccurrenceCount(element, (boolean)constructorSuggestion)), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT, this}))).get(isConstructorSuggestion);
        }
        catch (RuntimeException e) {
            return (Integer)this.onException(e, "weighting for completion");
        }
    }

    private Integer calculateOccurrenceCount(@NotNull PsiElement element, boolean isConstructorSuggestion) {
        if (element == null) {
            CompilerReferenceServiceBase.$$$reportNull$$$0(10);
        }
        LanguageCompilerRefAdapter adapter = null;
        if (isConstructorSuggestion && ((adapter = (LanguageCompilerRefAdapter)ReadAction.compute(() -> LanguageCompilerRefAdapter.findAdapter(element))) == null || !adapter.isClass(element))) {
            return null;
        }
        CompilerElementInfo searchElementInfo = this.asCompilerElements(element, false, false);
        if (searchElementInfo == null) {
            return null;
        }
        if (!this.myReadDataLock.tryLock()) {
            return null;
        }
        try {
            if (this.myReader == null) {
                Integer n = null;
                return n;
            }
            if (isConstructorSuggestion) {
                int constructorOccurrences = 0;
                for (PsiElement constructor : adapter.getInstantiableConstructors(element)) {
                    CompilerRef constructorRef = adapter.asCompilerRef(constructor, ((CompilerReferenceReader)this.myReader).getNameEnumerator());
                    if (constructorRef == null) continue;
                    constructorOccurrences += ((CompilerReferenceReader)this.myReader).getOccurrenceCount(constructorRef);
                }
                Integer anonymousCount = ((CompilerReferenceReader)this.myReader).getAnonymousCount((CompilerRef.CompilerClassHierarchyElementDef)searchElementInfo.searchElements.get(0), searchElementInfo.place == ElementPlace.SRC);
                Integer n = anonymousCount == null ? constructorOccurrences : constructorOccurrences + anonymousCount;
                return n;
            }
            Integer constructorOccurrences = ((CompilerReferenceReader)this.myReader).getOccurrenceCount(searchElementInfo.searchElements.get(0));
            return constructorOccurrences;
        }
        finally {
            this.myReadDataLock.unlock();
        }
    }

    @Nullable
    private CompilerHierarchyInfoImpl getHierarchyInfo(@NotNull PsiNamedElement aClass, @NotNull GlobalSearchScope searchScope, @NotNull FileType searchFileType, @NotNull CompilerHierarchySearchType searchType) {
        if (aClass == null) {
            CompilerReferenceServiceBase.$$$reportNull$$$0(11);
        }
        if (searchScope == null) {
            CompilerReferenceServiceBase.$$$reportNull$$$0(12);
        }
        if (searchFileType == null) {
            CompilerReferenceServiceBase.$$$reportNull$$$0(13);
        }
        if (searchType == null) {
            CompilerReferenceServiceBase.$$$reportNull$$$0(14);
        }
        if (!this.isServiceEnabledFor((PsiElement)aClass)) {
            return null;
        }
        try {
            Map candidatesPerFile = (Map)ReadAction.compute(() -> {
                if (this.project.isDisposed()) {
                    throw new ProcessCanceledException();
                }
                return (Map)((ConcurrentMap)CachedValuesManager.getCachedValue((PsiElement)aClass, () -> CachedValueProvider.Result.create((Object)ConcurrentFactoryMap.createMap(key -> this.calculateDirectInheritors((PsiElement)aClass, key.mySearchFileType, key.mySearchType)), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT, this}))).get(new HierarchySearchKey(searchType, searchFileType));
            });
            if (candidatesPerFile == null) {
                return null;
            }
            GlobalSearchScope dirtyScope = this.myDirtyScopeHolder.getDirtyScope();
            if (ElementPlace.LIB == ReadAction.compute(() -> ElementPlace.get(aClass.getContainingFile().getVirtualFile(), this.myProjectFileIndex))) {
                dirtyScope = dirtyScope.union((SearchScope)ProjectScope.getLibrariesScope((Project)this.project));
            }
            return new CompilerHierarchyInfoImpl(candidatesPerFile, aClass, dirtyScope, searchScope, this.project, searchFileType, searchType);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (RuntimeException e) {
            return (CompilerHierarchyInfoImpl)this.onException(e, "hierarchy");
        }
    }

    private boolean isServiceEnabledFor(PsiElement element) {
        if (!this.isActive() || this.isInsideLibraryScope()) {
            return false;
        }
        PsiFile file = (PsiFile)ReadAction.compute(() -> element.getContainingFile());
        return file != null && !InjectedLanguageManager.getInstance((Project)this.project).isInjectedFragment(file);
    }

    public boolean isActive() {
        return this.myReader != null && CompilerReferenceServiceBase.isEnabled();
    }

    private Map<VirtualFile, SearchId[]> calculateDirectInheritors(@NotNull PsiElement aClass, @NotNull FileType searchFileType, @NotNull CompilerHierarchySearchType searchType) {
        SearchScope scope;
        if (aClass == null) {
            CompilerReferenceServiceBase.$$$reportNull$$$0(15);
        }
        if (searchFileType == null) {
            CompilerReferenceServiceBase.$$$reportNull$$$0(16);
        }
        if (searchType == null) {
            CompilerReferenceServiceBase.$$$reportNull$$$0(17);
        }
        if (!((scope = aClass.getUseScope()) instanceof GlobalSearchScope)) {
            return null;
        }
        CompilerElementInfo searchElementInfo = this.asCompilerElements(aClass, false, true);
        if (searchElementInfo == null) {
            return null;
        }
        CompilerRef searchElement = searchElementInfo.searchElements.get(0);
        if (!this.myReadDataLock.tryLock()) {
            return null;
        }
        try {
            if (this.myReader == null) {
                Map<VirtualFile, SearchId[]> map = null;
                return map;
            }
            Map<VirtualFile, SearchId[]> map = ((CompilerReferenceReader)this.myReader).getDirectInheritors(searchElement, (GlobalSearchScope)scope, this.myDirtyScopeHolder.getDirtyScope(), searchFileType, searchType);
            return map;
        }
        finally {
            this.myReadDataLock.unlock();
        }
    }

    @Nullable
    private GlobalSearchScope buildScopeWithReferences(@Nullable Set<VirtualFile> referentFiles, @NotNull PsiElement element) {
        if (element == null) {
            CompilerReferenceServiceBase.$$$reportNull$$$0(18);
        }
        if (referentFiles == null) {
            return null;
        }
        GlobalSearchScope referencesScope = GlobalSearchScope.filesWithoutLibrariesScope((Project)this.project, referentFiles);
        GlobalSearchScope knownDirtyScope = this.myDirtyScopeHolder.getDirtyScope();
        GlobalSearchScope wholeClearScope = GlobalSearchScope.notScope((GlobalSearchScope)knownDirtyScope);
        GlobalSearchScope knownCleanScope = GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)wholeClearScope, (FileType[])this.myFileTypes.toArray(FileType.EMPTY_ARRAY));
        GlobalSearchScope wholeDirtyScope = GlobalSearchScope.notScope((GlobalSearchScope)knownCleanScope);
        GlobalSearchScope mayContainReferencesScope = referencesScope.uniteWith(wholeDirtyScope);
        return CompilerReferenceServiceBase.scopeWithLibraryIfNeeded(this.project, this.myProjectFileIndex, mayContainReferencesScope, element);
    }

    @NotNull
    public static GlobalSearchScope scopeWithLibraryIfNeeded(@NotNull Project project, @NotNull ProjectFileIndex fileIndex, @NotNull GlobalSearchScope baseScope, @NotNull PsiElement element) {
        VirtualFile file;
        if (project == null) {
            CompilerReferenceServiceBase.$$$reportNull$$$0(19);
        }
        if (fileIndex == null) {
            CompilerReferenceServiceBase.$$$reportNull$$$0(20);
        }
        if (baseScope == null) {
            CompilerReferenceServiceBase.$$$reportNull$$$0(21);
        }
        if (element == null) {
            CompilerReferenceServiceBase.$$$reportNull$$$0(22);
        }
        if ((file = PsiUtilCore.getVirtualFile((PsiElement)element)) == null || !fileIndex.isInLibrary(file)) {
            GlobalSearchScope globalSearchScope = baseScope;
            if (globalSearchScope == null) {
                CompilerReferenceServiceBase.$$$reportNull$$$0(23);
            }
            return globalSearchScope;
        }
        GlobalSearchScope globalSearchScope = baseScope.uniteWith(ProjectScope.getLibrariesScope((Project)project));
        if (globalSearchScope == null) {
            CompilerReferenceServiceBase.$$$reportNull$$$0(24);
        }
        return globalSearchScope;
    }

    @Nullable
    private Set<VirtualFile> getReferentFiles(@NotNull PsiElement element) {
        if (element == null) {
            CompilerReferenceServiceBase.$$$reportNull$$$0(25);
        }
        return this.getReferentFiles(element, true, (ref, elementPlace) -> ((CompilerReferenceReader)this.myReader).findReferentFileIds(ref, elementPlace == ElementPlace.SRC));
    }

    @TestOnly
    @Nullable
    public Set<VirtualFile> getReferentFilesForTests(@NotNull PsiElement element) {
        if (element == null) {
            CompilerReferenceServiceBase.$$$reportNull$$$0(26);
        }
        return this.getReferentFiles(element);
    }

    @TestOnly
    @Nullable
    public Set<VirtualFile> getReferentFilesForTests(@NotNull CompilerRef compilerRef, boolean checkBaseClassAmbiguity) throws StorageException {
        if (compilerRef == null) {
            CompilerReferenceServiceBase.$$$reportNull$$$0(27);
        }
        return ((CompilerReferenceReader)this.myReader).findReferentFileIds(compilerRef, checkBaseClassAmbiguity);
    }

    @TestOnly
    public @Nullable List<@NotNull CompilerRef> getCompilerRefsForTests(@NotNull PsiElement element) throws IOException {
        LanguageCompilerRefAdapter adapter;
        if (element == null) {
            CompilerReferenceServiceBase.$$$reportNull$$$0(28);
        }
        if ((adapter = LanguageCompilerRefAdapter.findAdapter(element, true)) == null) {
            return null;
        }
        return adapter.asCompilerRefs(element, ((CompilerReferenceReader)this.myReader).getNameEnumerator());
    }

    @Nullable
    private Set<VirtualFile> getReferentFileIdsViaImplicitToString(@NotNull PsiElement element) {
        if (element == null) {
            CompilerReferenceServiceBase.$$$reportNull$$$0(29);
        }
        return this.getReferentFiles(element, false, (ref, elementPlace) -> ((CompilerReferenceReader)this.myReader).findFileIdsWithImplicitToString(ref));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Set<VirtualFile> getReferentFiles(@NotNull PsiElement element, boolean buildHierarchyForLibraryElements, @NotNull ReferentFileSearcher referentFileSearcher) {
        CompilerElementInfo compilerElementInfo;
        if (element == null) {
            CompilerReferenceServiceBase.$$$reportNull$$$0(30);
        }
        if (referentFileSearcher == null) {
            CompilerReferenceServiceBase.$$$reportNull$$$0(31);
        }
        if ((compilerElementInfo = this.asCompilerElements(element, buildHierarchyForLibraryElements, true)) == null) {
            return null;
        }
        if (!this.myReadDataLock.tryLock()) {
            return null;
        }
        try {
            if (this.myReader == null) {
                Set<VirtualFile> set = null;
                return set;
            }
            VirtualFileSet referentFileIds = VfsUtilCore.createCompactVirtualFileSet();
            for (CompilerRef ref : compilerElementInfo.searchElements) {
                Set<VirtualFile> referents;
                block14: {
                    try {
                        referents = referentFileSearcher.findReferentFiles(ref, compilerElementInfo.place);
                        if (referents != null) break block14;
                        Set<VirtualFile> set = null;
                        return set;
                    }
                    catch (StorageException e) {
                        throw new RuntimeException(e);
                    }
                }
                referentFileIds.addAll(referents);
            }
            VirtualFileSet virtualFileSet = referentFileIds;
            return virtualFileSet;
        }
        finally {
            this.myReadDataLock.unlock();
        }
    }

    @Nullable
    private CompilerElementInfo asCompilerElements(@NotNull PsiElement psiElement, boolean buildHierarchyForLibraryElements, boolean checkNotDirty) {
        if (psiElement == null) {
            CompilerReferenceServiceBase.$$$reportNull$$$0(32);
        }
        if (!this.myReadDataLock.tryLock()) {
            return null;
        }
        try {
            if (this.myReader == null) {
                CompilerElementInfo compilerElementInfo = null;
                return compilerElementInfo;
            }
            VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)psiElement);
            if (file == null) {
                CompilerElementInfo compilerElementInfo = null;
                return compilerElementInfo;
            }
            ElementPlace place = ElementPlace.get(file, this.myProjectFileIndex);
            if (checkNotDirty && (place == null || place == ElementPlace.SRC && this.myDirtyScopeHolder.contains(file))) {
                CompilerElementInfo compilerElementInfo = null;
                return compilerElementInfo;
            }
            LanguageCompilerRefAdapter adapter = LanguageCompilerRefAdapter.findAdapter(psiElement, true);
            if (adapter == null) {
                CompilerElementInfo compilerElementInfo = null;
                return compilerElementInfo;
            }
            List<CompilerRef> refs = adapter.asCompilerRefs(psiElement, ((CompilerReferenceReader)this.myReader).getNameEnumerator());
            if (refs == null) {
                CompilerElementInfo compilerElementInfo = null;
                return compilerElementInfo;
            }
            if (place == ElementPlace.LIB && buildHierarchyForLibraryElements) {
                if (adapter.isTooCommonLibraryElement(psiElement)) {
                    CompilerElementInfo compilerElementInfo = null;
                    return compilerElementInfo;
                }
                CompilerElementInfo compilerElementInfo = (CompilerElementInfo)this.computeInLibraryScope(() -> {
                    GlobalSearchScope librariesScope = ProjectScope.getLibrariesScope((Project)this.project);
                    ArrayList<CompilerRef> resultList = new ArrayList<CompilerRef>(refs);
                    for (CompilerRef ref : refs) {
                        resultList.addAll(adapter.getHierarchyRestrictedToLibraryScope(ref, psiElement, ((CompilerReferenceReader)this.myReader).getNameEnumerator(), librariesScope));
                    }
                    return new CompilerElementInfo(place, resultList);
                });
                return compilerElementInfo;
            }
            CompilerElementInfo compilerElementInfo = new CompilerElementInfo(place, refs);
            return compilerElementInfo;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.myReadDataLock.unlock();
        }
    }

    public <T, E extends Throwable> T computeInLibraryScope(ThrowableComputable<T, E> action) throws E {
        this.myIsInsideLibraryScope.set(true);
        try {
            Object object = action.compute();
            return (T)object;
        }
        finally {
            this.myIsInsideLibraryScope.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @NotNull SearchId @Nullable [] getDirectInheritorsNames(@NotNull CompilerRefProvider compilerRefFunction) {
        if (compilerRefFunction == null) {
            CompilerReferenceServiceBase.$$$reportNull$$$0(33);
        }
        if (!this.myReadDataLock.tryLock()) {
            return null;
        }
        try {
            if (this.myReader == null) {
                SearchId[] searchIdArray = null;
                return searchIdArray;
            }
            CompilerRef hierarchyElement = compilerRefFunction.provide(((CompilerReferenceReader)this.myReader).getNameEnumerator());
            if (hierarchyElement == null) {
                SearchId[] searchIdArray = null;
                return searchIdArray;
            }
            SearchId[] searchIdArray = ((CompilerReferenceReader)this.myReader).getDirectInheritorsNames(hierarchyElement);
            return searchIdArray;
        }
        finally {
            this.myReadDataLock.unlock();
        }
    }

    public boolean isInsideLibraryScope() {
        return this.myIsInsideLibraryScope.get();
    }

    protected void closeReaderIfNeeded(IndexCloseReason reason) {
        this.myOpenCloseLock.lock();
        try {
            boolean myReaderIsNotNull;
            if (reason == IndexCloseReason.COMPILATION_STARTED) {
                ++this.myActiveBuilds;
                this.myDirtyScopeHolder.compilerActivityStarted();
            }
            boolean bl = myReaderIsNotNull = this.myReader != null;
            if (myReaderIsNotNull) {
                ((CompilerReferenceReader)this.myReader).close(reason == IndexCloseReason.AN_EXCEPTION);
                this.myReader = null;
            }
            LOG.info("backward reference index reader is closed" + (myReaderIsNotNull ? "" : " (didn't exist)"));
        }
        finally {
            this.myOpenCloseLock.unlock();
        }
    }

    protected void openReaderIfNeeded() {
        List compiledModules = (List)ReadAction.nonBlocking(() -> {
            ModuleManager moduleManager = ModuleManager.getInstance((Project)this.project);
            return ContainerUtil.mapNotNull(this.myDirtyScopeHolder.getCompilationAffectedModules(), arg_0 -> ((ModuleManager)moduleManager).findModuleByName(arg_0));
        }).expireWith((Disposable)this).executeSynchronously();
        Module[] allModules = this.initialized ? null : this.allModules();
        this.myCompilationCount.increment();
        this.myOpenCloseLock.lock();
        try {
            --this.myActiveBuilds;
            if (!this.initialized) {
                this.initialize(allModules, compiledModules);
            } else {
                this.myDirtyScopeHolder.compilerActivityFinished(compiledModules);
            }
            if (this.myActiveBuilds == 0 && this.project.isOpen()) {
                if (this.myReader != null) {
                    LOG.warn("already opened \u2013 will be overridden");
                    ((CompilerReferenceReader)this.myReader).close(false);
                }
                this.myReader = this.myReaderFactory.create(this.project);
                LOG.info("backward reference index reader " + (this.myReader == null ? "doesn't exist" : "is opened"));
            }
        }
        finally {
            this.myOpenCloseLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markAsUpToDate() {
        Object[] modules = this.allModules();
        if (modules == null) {
            return;
        }
        this.myOpenCloseLock.lock();
        try {
            long modificationCount = this.getModificationCount();
            LOG.info("MC: " + modificationCount + ", ABC: " + this.myActiveBuilds);
            if (this.myActiveBuilds == 0 && modificationCount == 1L) {
                this.myDirtyScopeHolder.compilerActivityFinished(ArraysKt.asList((Object[])modules));
                LOG.info("marked as up to date");
            }
        }
        finally {
            this.myOpenCloseLock.unlock();
        }
    }

    private void initialize(Module[] allModules, @Nullable Collection<@NotNull Module> compiledModules) {
        this.initialized = true;
        LOG.info("initialized");
        this.myDirtyScopeHolder.upToDateCheckFinished(allModules != null ? ArraysKt.asList((Object[])allModules) : null, compiledModules);
    }

    private Module[] allModules() {
        return (Module[])ReadAction.nonBlocking(() -> this.project.isDisposed() ? null : ModuleManager.getInstance((Project)this.project).getModules()).expireWith((Disposable)this).executeSynchronously();
    }

    public Set<FileType> getFileTypes() {
        return this.myFileTypes;
    }

    public Project getProject() {
        return this.project;
    }

    protected static void executeOnBuildThread(@NotNull Runnable compilationFinished) {
        if (compilationFinished == null) {
            CompilerReferenceServiceBase.$$$reportNull$$$0(34);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            compilationFinished.run();
        } else {
            BuildManager.getInstance().runCommand(compilationFinished);
        }
    }

    public long getModificationCount() {
        return this.myCompilationCount.longValue();
    }

    @NotNull
    @ApiStatus.Internal
    @VisibleForTesting
    public DirtyScopeHolder getDirtyScopeHolder() {
        DirtyScopeHolder dirtyScopeHolder = this.myDirtyScopeHolder;
        if (dirtyScopeHolder == null) {
            CompilerReferenceServiceBase.$$$reportNull$$$0(35);
        }
        return dirtyScopeHolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public CompilerReferenceFindUsagesTestInfo getTestFindUsages(@NotNull PsiElement element) {
        if (element == null) {
            CompilerReferenceServiceBase.$$$reportNull$$$0(36);
        }
        if (!this.myReadDataLock.tryLock()) {
            return null;
        }
        try {
            @Nullable Set<VirtualFile> referentFileIds = this.getReferentFiles(element);
            DirtyScopeTestInfo dirtyScopeInfo = this.myDirtyScopeHolder.getState();
            CompilerReferenceFindUsagesTestInfo compilerReferenceFindUsagesTestInfo = new CompilerReferenceFindUsagesTestInfo(referentFileIds, dirtyScopeInfo);
            return compilerReferenceFindUsagesTestInfo;
        }
        finally {
            this.myReadDataLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public CompilerReferenceHierarchyTestInfo getTestHierarchy(@NotNull PsiNamedElement element, @NotNull GlobalSearchScope scope, @NotNull FileType fileType) {
        if (element == null) {
            CompilerReferenceServiceBase.$$$reportNull$$$0(37);
        }
        if (scope == null) {
            CompilerReferenceServiceBase.$$$reportNull$$$0(38);
        }
        if (fileType == null) {
            CompilerReferenceServiceBase.$$$reportNull$$$0(39);
        }
        if (!this.myReadDataLock.tryLock()) {
            return null;
        }
        try {
            CompilerHierarchyInfoImpl hierarchyInfo = this.getHierarchyInfo(element, scope, fileType, CompilerHierarchySearchType.DIRECT_INHERITOR);
            DirtyScopeTestInfo dirtyScopeInfo = this.myDirtyScopeHolder.getState();
            CompilerReferenceHierarchyTestInfo compilerReferenceHierarchyTestInfo = new CompilerReferenceHierarchyTestInfo(hierarchyInfo, dirtyScopeInfo);
            return compilerReferenceHierarchyTestInfo;
        }
        finally {
            this.myReadDataLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public CompilerReferenceHierarchyTestInfo getTestFunExpressions(@NotNull PsiNamedElement element, @NotNull GlobalSearchScope scope, @NotNull FileType fileType) {
        if (element == null) {
            CompilerReferenceServiceBase.$$$reportNull$$$0(40);
        }
        if (scope == null) {
            CompilerReferenceServiceBase.$$$reportNull$$$0(41);
        }
        if (fileType == null) {
            CompilerReferenceServiceBase.$$$reportNull$$$0(42);
        }
        if (!this.myReadDataLock.tryLock()) {
            return null;
        }
        try {
            CompilerHierarchyInfoImpl hierarchyInfo = this.getHierarchyInfo(element, scope, fileType, CompilerHierarchySearchType.FUNCTIONAL_EXPRESSION);
            DirtyScopeTestInfo dirtyScopeInfo = this.myDirtyScopeHolder.getState();
            CompilerReferenceHierarchyTestInfo compilerReferenceHierarchyTestInfo = new CompilerReferenceHierarchyTestInfo(hierarchyInfo, dirtyScopeInfo);
            return compilerReferenceHierarchyTestInfo;
        }
        finally {
            this.myReadDataLock.unlock();
        }
    }

    public void dispose() {
        this.closeReaderIfNeeded(IndexCloseReason.SHUTDOWN);
    }

    @Nullable
    protected <T> T onException(@NotNull Exception e, @NotNull String actionName) {
        Throwable unwrapped;
        if (e == null) {
            CompilerReferenceServiceBase.$$$reportNull$$$0(43);
        }
        if (actionName == null) {
            CompilerReferenceServiceBase.$$$reportNull$$$0(44);
        }
        if (e instanceof ControlFlowException) {
            throw (RuntimeException)e;
        }
        LOG.error("an exception during " + actionName + " calculation", (Throwable)e);
        Throwable throwable = unwrapped = e instanceof RuntimeException ? e.getCause() : e;
        if (CompilerReferenceServiceBase.requireIndexRebuild(unwrapped)) {
            this.closeReaderIfNeeded(IndexCloseReason.AN_EXCEPTION);
        }
        return null;
    }

    @NotNull
    protected static IntSet intersection(@NotNull IntSet set1, @NotNull IntCollection set2) {
        if (set1 == null) {
            CompilerReferenceServiceBase.$$$reportNull$$$0(45);
        }
        if (set2 == null) {
            CompilerReferenceServiceBase.$$$reportNull$$$0(46);
        }
        if (set1.isEmpty()) {
            IntSet intSet = set1;
            if (intSet == null) {
                CompilerReferenceServiceBase.$$$reportNull$$$0(47);
            }
            return intSet;
        }
        IntOpenHashSet result = ((IntOpenHashSet)set1).clone();
        result.retainAll(set2);
        IntOpenHashSet intOpenHashSet = result;
        if (intOpenHashSet == null) {
            CompilerReferenceServiceBase.$$$reportNull$$$0(48);
        }
        return intOpenHashSet;
    }

    private static boolean requireIndexRebuild(@Nullable Throwable exception) {
        return exception instanceof StorageException || exception instanceof IOException;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 23, 24, 35, 47, 48 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 9: 
            case 10: 
            case 18: 
            case 22: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 36: 
            case 37: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 3: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 4: 
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 5: 
            case 8: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchFileType";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionalInterface";
                break;
            }
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchType";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileIndex";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseScope";
                break;
            }
            case 23: 
            case 24: 
            case 35: 
            case 47: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/compiler/backwardRefs/CompilerReferenceServiceBase";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compilerRef";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referentFileSearcher";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compilerRefFunction";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compilationFinished";
                break;
            }
            case 38: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 39: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionName";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set1";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/compiler/backwardRefs/CompilerReferenceServiceBase";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "scopeWithLibraryIfNeeded";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirtyScopeHolder";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "intersection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isCaseSensitiveFS";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getScopeWithCodeReferences";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getScopeWithImplicitToStringCodeReferences";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getDirectInheritors";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getFunExpressions";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getCompileTimeOccurrenceCount";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "calculateOccurrenceCount";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getHierarchyInfo";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "calculateDirectInheritors";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "buildScopeWithReferences";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "scopeWithLibraryIfNeeded";
                break;
            }
            case 23: 
            case 24: 
            case 35: 
            case 47: 
            case 48: {
                break;
            }
            case 25: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getReferentFiles";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getReferentFilesForTests";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getCompilerRefsForTests";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getReferentFileIdsViaImplicitToString";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "asCompilerElements";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getDirectInheritorsNames";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "executeOnBuildThread";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getTestFindUsages";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getTestHierarchy";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getTestFunExpressions";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "onException";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "intersection";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 23, 24, 35, 47, 48 -> new IllegalStateException(string);
        };
    }

    @ApiStatus.Experimental
    private static enum FsCompilerReferenceType {
        SENSITIVE,
        INSENSITIVE,
        BY_OS,
        BY_ROOT;


        @NotNull
        static FsCompilerReferenceType from(@Nullable String text) {
            for (FsCompilerReferenceType type : FsCompilerReferenceType.values()) {
                if (!type.name().equalsIgnoreCase(text)) continue;
                FsCompilerReferenceType fsCompilerReferenceType = type;
                if (fsCompilerReferenceType == null) {
                    FsCompilerReferenceType.$$$reportNull$$$0(0);
                }
                return fsCompilerReferenceType;
            }
            FsCompilerReferenceType fsCompilerReferenceType = BY_ROOT;
            if (fsCompilerReferenceType == null) {
                FsCompilerReferenceType.$$$reportNull$$$0(1);
            }
            return fsCompilerReferenceType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/backwardRefs/CompilerReferenceServiceBase$FsCompilerReferenceType", "from"));
        }
    }

    protected record CompilerElementInfo(ElementPlace place, @NotNull @NotNull List<@NotNull CompilerRef> searchElements) {
        @NotNull
        private final @NotNull List<@NotNull CompilerRef> searchElements;

        protected CompilerElementInfo(ElementPlace place, @NotNull @NotNull List<@NotNull CompilerRef> searchElements) {
            if (searchElements == null) {
                CompilerElementInfo.$$$reportNull$$$0(0);
            }
        }

        @NotNull
        public @NotNull List<@NotNull CompilerRef> searchElements() {
            List<CompilerRef> list = this.searchElements;
            if (list == null) {
                CompilerElementInfo.$$$reportNull$$$0(1);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "searchElements";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/compiler/backwardRefs/CompilerReferenceServiceBase$CompilerElementInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/compiler/backwardRefs/CompilerReferenceServiceBase$CompilerElementInfo";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "searchElements";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    protected static enum ElementPlace {
        SRC,
        LIB;


        public static ElementPlace get(VirtualFile file, ProjectFileIndex index) {
            if (file == null) {
                return null;
            }
            return index.isInSourceContent(file) ? SRC : (index.isInLibrary(file) ? LIB : null);
        }
    }

    @FunctionalInterface
    protected static interface ReferentFileSearcher {
        @Nullable
        public Set<VirtualFile> findReferentFiles(@NotNull CompilerRef var1, @NotNull ElementPlace var2) throws StorageException;
    }

    @FunctionalInterface
    public static interface CompilerRefProvider {
        @Nullable
        public CompilerRef provide(@NotNull NameEnumerator var1) throws IOException;
    }

    protected static enum IndexCloseReason {
        AN_EXCEPTION,
        COMPILATION_STARTED,
        SHUTDOWN;

    }

    protected static final class HierarchySearchKey {
        private final CompilerHierarchySearchType mySearchType;
        private final FileType mySearchFileType;

        public HierarchySearchKey(CompilerHierarchySearchType searchType, FileType searchFileType) {
            this.mySearchType = searchType;
            this.mySearchFileType = searchFileType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HierarchySearchKey key = (HierarchySearchKey)o;
            return this.mySearchType == key.mySearchType && this.mySearchFileType == key.mySearchFileType;
        }

        public int hashCode() {
            return 31 * this.mySearchType.hashCode() + this.mySearchFileType.hashCode();
        }
    }

    public static final class JCRIIsUpToDateConsumer
    implements IsUpToDateCheckConsumer {
        @Override
        public boolean isApplicable(@NotNull Project project) {
            CompilerReferenceServiceBase<?> serviceBase;
            if (project == null) {
                JCRIIsUpToDateConsumer.$$$reportNull$$$0(0);
            }
            return (serviceBase = CompilerReferenceServiceBase.getInstanceIfEnabled(project)) != null && serviceBase.hasIndex();
        }

        @Override
        public void isUpToDate(@NotNull Project project, boolean isUpToDate) {
            if (project == null) {
                JCRIIsUpToDateConsumer.$$$reportNull$$$0(1);
            }
            if (!isUpToDate) {
                return;
            }
            CompilerReferenceServiceBase<?> service = CompilerReferenceServiceBase.getInstanceIfEnabled(project);
            if (service != null) {
                CompilerReferenceServiceBase.executeOnBuildThread(service::markAsUpToDate);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "project";
            objectArray2[1] = "com/intellij/compiler/backwardRefs/CompilerReferenceServiceBase$JCRIIsUpToDateConsumer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isApplicable";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isUpToDate";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

