/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.backwardRefs;

import com.intellij.openapi.compiler.options.ExcludeEntryDescription;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

final class ExcludedFromCompileFilesUtil {
    ExcludedFromCompileFilesUtil() {
    }

    static GlobalSearchScope getExcludedFilesScope(ExcludeEntryDescription @NotNull [] descriptions, @NotNull Set<FileType> fileTypes, @NotNull Project project) {
        if (fileTypes == null) {
            ExcludedFromCompileFilesUtil.$$$reportNull$$$0(0);
        }
        if (project == null) {
            ExcludedFromCompileFilesUtil.$$$reportNull$$$0(1);
        }
        if (descriptions == null) {
            ExcludedFromCompileFilesUtil.$$$reportNull$$$0(2);
        }
        ManagingFS fs = ManagingFS.getInstance();
        Collection excludedFiles = Stream.of(descriptions).flatMap(description -> {
            VirtualFile file = description.getVirtualFile();
            if (file == null) {
                return Stream.empty();
            }
            if (description.isFile()) {
                return Stream.of(file);
            }
            if (description.isIncludeSubdirectories()) {
                Stream.Builder builder = Stream.builder();
                VfsUtilCore.iterateChildrenRecursively((VirtualFile)file, f -> !f.isDirectory() || fs.areChildrenLoaded(f), f -> {
                    builder.accept(f);
                    return true;
                });
                return builder.build();
            }
            return fs.areChildrenLoaded(file) ? Stream.of(file.getChildren()) : Stream.empty();
        }).filter(f -> !f.isDirectory() && fileTypes.contains(f.getFileType())).collect(Collectors.toList());
        return GlobalSearchScope.filesWithoutLibrariesScope((Project)project, (Collection)excludedFiles);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "fileTypes";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "descriptions";
                break;
            }
        }
        objectArray[1] = "com/intellij/compiler/backwardRefs/ExcludedFromCompileFilesUtil";
        objectArray[2] = "getExcludedFilesScope";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

