/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.backwardRefs;

import com.intellij.compiler.backwardRefs.SearchId;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.impl.source.PsiFileWithStubSupport;
import com.intellij.psi.search.GlobalSearchScope;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.backwardRefs.CompilerRef;
import org.jetbrains.jps.backwardRefs.NameEnumerator;

public interface LanguageCompilerRefAdapter {
    public static final ExtensionPointName<LanguageCompilerRefAdapter> EP_NAME = ExtensionPointName.create((String)"com.intellij.languageCompilerRefAdapter");

    @Nullable
    public static LanguageCompilerRefAdapter findAdapter(@NotNull VirtualFile file) {
        if (file == null) {
            LanguageCompilerRefAdapter.$$$reportNull$$$0(0);
        }
        FileType fileType = file.getFileType();
        return LanguageCompilerRefAdapter.findAdapter(fileType);
    }

    @Nullable
    public static LanguageCompilerRefAdapter findAdapter(@NotNull VirtualFile file, boolean includeExternalLanguageHelper) {
        if (file == null) {
            LanguageCompilerRefAdapter.$$$reportNull$$$0(1);
        }
        FileType fileType = file.getFileType();
        return LanguageCompilerRefAdapter.findAdapter(fileType, includeExternalLanguageHelper);
    }

    @Nullable
    public static LanguageCompilerRefAdapter findAdapter(@NotNull PsiFile file, boolean includeExternalLanguageHelper) {
        if (file == null) {
            LanguageCompilerRefAdapter.$$$reportNull$$$0(2);
        }
        FileType fileType = file.getFileType();
        return LanguageCompilerRefAdapter.findAdapter(fileType, includeExternalLanguageHelper);
    }

    @Nullable
    public static LanguageCompilerRefAdapter findAdapter(@NotNull FileType fileType) {
        if (fileType == null) {
            LanguageCompilerRefAdapter.$$$reportNull$$$0(3);
        }
        return LanguageCompilerRefAdapter.findAdapter(fileType, false);
    }

    @Nullable
    public static LanguageCompilerRefAdapter findAdapter(@NotNull FileType fileType, boolean includeExternalLanguageHelper) {
        if (fileType == null) {
            LanguageCompilerRefAdapter.$$$reportNull$$$0(4);
        }
        for (LanguageCompilerRefAdapter adapter : EP_NAME.getExtensionList()) {
            if (!adapter.getFileTypes().contains(fileType) && (!includeExternalLanguageHelper || !(adapter instanceof ExternalLanguageHelper) || !adapter.getAffectedFileTypes().contains(fileType))) continue;
            return adapter;
        }
        return null;
    }

    @Nullable
    public static LanguageCompilerRefAdapter findAdapter(@NotNull PsiElement element) {
        if (element == null) {
            LanguageCompilerRefAdapter.$$$reportNull$$$0(5);
        }
        return LanguageCompilerRefAdapter.findAdapter(element, false);
    }

    @Nullable
    public static LanguageCompilerRefAdapter findAdapter(@NotNull PsiElement element, boolean includeExternalLanguageHelper) {
        PsiFile file;
        if (element == null) {
            LanguageCompilerRefAdapter.$$$reportNull$$$0(6);
        }
        return (file = element.getContainingFile()) == null ? null : LanguageCompilerRefAdapter.findAdapter(file, includeExternalLanguageHelper);
    }

    @NotNull
    public Set<FileType> getFileTypes();

    @NotNull
    default public Set<FileType> getAffectedFileTypes() {
        Set<FileType> set = this.getFileTypes();
        if (set == null) {
            LanguageCompilerRefAdapter.$$$reportNull$$$0(7);
        }
        return set;
    }

    @Nullable
    public CompilerRef asCompilerRef(@NotNull PsiElement var1, @NotNull NameEnumerator var2) throws IOException;

    default public @Nullable List<@NotNull CompilerRef> asCompilerRefs(@NotNull PsiElement element, @NotNull NameEnumerator names) throws IOException {
        CompilerRef compilerRef;
        if (element == null) {
            LanguageCompilerRefAdapter.$$$reportNull$$$0(8);
        }
        if (names == null) {
            LanguageCompilerRefAdapter.$$$reportNull$$$0(9);
        }
        if ((compilerRef = this.asCompilerRef(element, names)) == null) {
            return null;
        }
        return Collections.singletonList(compilerRef);
    }

    default public boolean isTooCommonLibraryElement(@NotNull PsiElement element) {
        if (element == null) {
            LanguageCompilerRefAdapter.$$$reportNull$$$0(10);
        }
        return false;
    }

    @NotNull
    public List<CompilerRef> getHierarchyRestrictedToLibraryScope(@NotNull CompilerRef var1, @NotNull PsiElement var2, @NotNull NameEnumerator var3, @NotNull GlobalSearchScope var4) throws IOException;

    @NotNull
    public Class<? extends CompilerRef.CompilerClassHierarchyElementDef> getHierarchyObjectClass();

    @NotNull
    public Class<? extends CompilerRef> getFunExprClass();

    public PsiElement @NotNull [] findDirectInheritorCandidatesInFile(SearchId @NotNull [] var1, @NotNull PsiFileWithStubSupport var2);

    public PsiElement @NotNull [] findFunExpressionsInFile(SearchId @NotNull [] var1, @NotNull PsiFileWithStubSupport var2);

    public boolean isClass(@NotNull PsiElement var1);

    public PsiElement @NotNull [] getInstantiableConstructors(@NotNull PsiElement var1);

    public boolean isDirectInheritor(PsiElement var1, PsiNamedElement var2);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/compiler/backwardRefs/LanguageCompilerRefAdapter";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/compiler/backwardRefs/LanguageCompilerRefAdapter";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAffectedFileTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findAdapter";
                break;
            }
            case 7: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "asCompilerRefs";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isTooCommonLibraryElement";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7 -> new IllegalStateException(string);
        };
    }

    public static abstract class ExternalLanguageHelper
    implements LanguageCompilerRefAdapter {
        @Override
        @NotNull
        public final Set<FileType> getFileTypes() {
            Set<FileType> set = Collections.emptySet();
            if (set == null) {
                ExternalLanguageHelper.$$$reportNull$$$0(0);
            }
            return set;
        }

        @Override
        @NotNull
        public abstract Set<FileType> getAffectedFileTypes();

        @Override
        @NotNull
        public final Class<? extends CompilerRef.CompilerClassHierarchyElementDef> getHierarchyObjectClass() {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public final Class<? extends CompilerRef> getFunExprClass() {
            throw new UnsupportedOperationException();
        }

        @Override
        public final PsiElement @NotNull [] findDirectInheritorCandidatesInFile(SearchId @NotNull [] internalNames, @NotNull PsiFileWithStubSupport file) {
            if (file == null) {
                ExternalLanguageHelper.$$$reportNull$$$0(1);
            }
            if (internalNames == null) {
                ExternalLanguageHelper.$$$reportNull$$$0(2);
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public final PsiElement @NotNull [] findFunExpressionsInFile(SearchId @NotNull [] indices, @NotNull PsiFileWithStubSupport file) {
            if (file == null) {
                ExternalLanguageHelper.$$$reportNull$$$0(3);
            }
            if (indices == null) {
                ExternalLanguageHelper.$$$reportNull$$$0(4);
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean isClass(@NotNull PsiElement element) {
            if (element == null) {
                ExternalLanguageHelper.$$$reportNull$$$0(5);
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public final PsiElement @NotNull [] getInstantiableConstructors(@NotNull PsiElement aClass) {
            if (aClass == null) {
                ExternalLanguageHelper.$$$reportNull$$$0(6);
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean isDirectInheritor(PsiElement candidate, PsiNamedElement baseClass) {
            throw new UnsupportedOperationException();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4, 5, 6 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/compiler/backwardRefs/LanguageCompilerRefAdapter$ExternalLanguageHelper";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "internalNames";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indices";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aClass";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFileTypes";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/compiler/backwardRefs/LanguageCompilerRefAdapter$ExternalLanguageHelper";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "findDirectInheritorCandidatesInFile";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "findFunExpressionsInFile";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "isClass";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getInstantiableConstructors";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3, 4, 5, 6 -> new IllegalArgumentException(string);
            };
        }
    }
}

