/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.backwardRefs.view;

import com.intellij.compiler.CompilerDirectHierarchyInfo;
import com.intellij.compiler.backwardRefs.view.DirtyScopeTestInfo;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import java.util.stream.Stream;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompilerReferenceHierarchyTestInfo {
    @Nullable
    private final CompilerDirectHierarchyInfo myHierarchyInfo;
    @NotNull
    private final DirtyScopeTestInfo myDirtyScopeInfo;

    public CompilerReferenceHierarchyTestInfo(@Nullable CompilerDirectHierarchyInfo hierarchyInfo, @NotNull DirtyScopeTestInfo dirtyScopeTestInfo) {
        if (dirtyScopeTestInfo == null) {
            CompilerReferenceHierarchyTestInfo.$$$reportNull$$$0(0);
        }
        this.myHierarchyInfo = hierarchyInfo;
        this.myDirtyScopeInfo = dirtyScopeTestInfo;
    }

    @NotNull
    public Stream<PsiElement> getHierarchyChildren() {
        if (this.myHierarchyInfo == null) {
            throw new IllegalArgumentException();
        }
        Stream stream = this.myHierarchyInfo.getHierarchyChildren();
        if (stream == null) {
            CompilerReferenceHierarchyTestInfo.$$$reportNull$$$0(1);
        }
        return stream;
    }

    Module @NotNull [] getDirtyModules() {
        Module[] moduleArray = this.myDirtyScopeInfo.getDirtyModules();
        if (moduleArray == null) {
            CompilerReferenceHierarchyTestInfo.$$$reportNull$$$0(2);
        }
        return moduleArray;
    }

    Module @NotNull [] getDirtyUnsavedModules() {
        Module[] moduleArray = this.myDirtyScopeInfo.getDirtyUnsavedModules();
        if (moduleArray == null) {
            CompilerReferenceHierarchyTestInfo.$$$reportNull$$$0(3);
        }
        return moduleArray;
    }

    VirtualFile @NotNull [] getExcludedFiles() {
        VirtualFile[] virtualFileArray = this.myDirtyScopeInfo.getExcludedFiles();
        if (virtualFileArray == null) {
            CompilerReferenceHierarchyTestInfo.$$$reportNull$$$0(4);
        }
        return virtualFileArray;
    }

    boolean isEnabled() {
        return this.myHierarchyInfo != null;
    }

    DefaultMutableTreeNode asTree() {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode();
        if (this.isEnabled()) {
            DefaultMutableTreeNode knownOccurrences = new DefaultMutableTreeNode("Known hierarchy direct children");
            node.add(knownOccurrences);
            this.getHierarchyChildren().forEach(e -> knownOccurrences.add(new DefaultMutableTreeNode(e)));
            DefaultMutableTreeNode dirtyModules = new DefaultMutableTreeNode("Dirty modules");
            node.add(dirtyModules);
            for (Module module : this.getDirtyModules()) {
                dirtyModules.add(new DefaultMutableTreeNode(module));
            }
            DefaultMutableTreeNode unsavedDirtyModules = new DefaultMutableTreeNode("Unsaved dirty modules");
            node.add(unsavedDirtyModules);
            for (Module module : this.getDirtyUnsavedModules()) {
                unsavedDirtyModules.add(new DefaultMutableTreeNode(module));
            }
            DefaultMutableTreeNode excludedFiles = new DefaultMutableTreeNode("Current excluded files");
            node.add(excludedFiles);
            for (VirtualFile excludedFile : this.getExcludedFiles()) {
                excludedFiles.add(new DefaultMutableTreeNode(excludedFile));
            }
        } else {
            node.add(new DefaultMutableTreeNode("Service is not available"));
        }
        return node;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirtyScopeTestInfo";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/compiler/backwardRefs/view/CompilerReferenceHierarchyTestInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/compiler/backwardRefs/view/CompilerReferenceHierarchyTestInfo";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getHierarchyChildren";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirtyModules";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirtyUnsavedModules";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getExcludedFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4 -> new IllegalStateException(string);
        };
    }
}

