/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.cache;

import com.intellij.compiler.CompilerConfigurationSettings;
import com.intellij.compiler.cache.CompilerCacheLoadingSettings;
import com.intellij.compiler.cache.CompilerCacheStartupActivity;
import com.intellij.compiler.cache.client.CompilerCacheServerAuthService;
import com.intellij.compiler.cache.client.CompilerCachesServerClient;
import com.intellij.compiler.cache.git.GitCommitsIterator;
import com.intellij.compiler.cache.git.GitRepositoryUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.api.CmdlineRemoteProto;

public final class CompilerCacheConfigurator {
    private static final Logger LOG = Logger.getInstance(CompilerCacheConfigurator.class);

    @Nullable
    public static CmdlineRemoteProto.Message.ControllerMessage.CacheDownloadSettings getCacheDownloadSettings(@NotNull Project project) {
        if (project == null) {
            CompilerCacheConfigurator.$$$reportNull$$$0(0);
        }
        if (!Registry.is((String)"compiler.process.use.portable.caches")) {
            return null;
        }
        String serverUrl = CompilerCacheConfigurator.getServerUrl(project);
        if (serverUrl == null || !CompilerCacheStartupActivity.isLineEndingsConfiguredCorrectly()) {
            LOG.warn("Can't evaluate cache settings server URL: " + serverUrl + "; line ending is correct: " + CompilerCacheStartupActivity.isLineEndingsConfiguredCorrectly());
            return null;
        }
        Map<String, String> authHeaders = CompilerCacheServerAuthService.getInstance(project).getRequestHeaders(true);
        if (authHeaders.isEmpty()) {
            return null;
        }
        Pair<String, Integer> commit = CompilerCacheConfigurator.getCommitToDownload(project, serverUrl, CompilerCacheLoadingSettings.getForceUpdateValue());
        if (commit == null) {
            return null;
        }
        CmdlineRemoteProto.Message.ControllerMessage.CacheDownloadSettings.Builder builder = CmdlineRemoteProto.Message.ControllerMessage.CacheDownloadSettings.newBuilder();
        builder.setServerUrl(serverUrl);
        builder.setDownloadCommit((String)commit.first);
        builder.setCommitsCountLatestBuild(((Integer)commit.second).intValue());
        builder.putAllAuthHeaders(authHeaders);
        builder.setDecompressionSpeed(CompilerCacheLoadingSettings.getApproximateDecompressionSpeed());
        builder.setDeletionSpeed(CompilerCacheLoadingSettings.getApproximateDeletionSpeed());
        builder.setForceDownload(CompilerCacheLoadingSettings.getForceUpdateValue());
        builder.setDisableDownload(CompilerCacheLoadingSettings.getDisableUpdateValue());
        builder.setCleanupAsynchronously(CompilerCacheLoadingSettings.getCleanupAsynchronouslyValue());
        builder.setMaxDownloadDuration(CompilerCacheLoadingSettings.getMaxDownloadDuration());
        return (CmdlineRemoteProto.Message.ControllerMessage.CacheDownloadSettings)builder.build();
    }

    public static boolean isServerUrlConfigured(@NotNull Project project) {
        if (project == null) {
            CompilerCacheConfigurator.$$$reportNull$$$0(1);
        }
        return CompilerCacheConfigurator.getServerUrl(project) != null;
    }

    @Nullable
    private static Pair<String, Integer> getCommitToDownload(@NotNull Project project, @NotNull String serverUrl, boolean forceUpdate) {
        if (project == null) {
            CompilerCacheConfigurator.$$$reportNull$$$0(2);
        }
        if (serverUrl == null) {
            CompilerCacheConfigurator.$$$reportNull$$$0(3);
        }
        Map<String, Set<String>> availableCommitsPerRemote = CompilerCachesServerClient.getCacheKeysPerRemote(project, serverUrl);
        GitCommitsIterator commitsIterator = new GitCommitsIterator(project, "intellij.git");
        String latestDownloadedCommit = GitRepositoryUtil.getLatestDownloadedCommit();
        String latestBuiltCommit = GitRepositoryUtil.getLatestBuiltMasterCommitId();
        Set<String> availableCommitsForRemote = availableCommitsPerRemote.get(commitsIterator.getRemote());
        if (availableCommitsForRemote == null) {
            LOG.warn("Not found any caches for the remote: " + commitsIterator.getRemote());
            return null;
        }
        int commitsBehind = 0;
        int commitsCountBetweenCompilation = 0;
        String commitToDownload = "";
        boolean latestBuiltCommitFound = false;
        while (commitsIterator.hasNext()) {
            String commitId = commitsIterator.next();
            if (commitId.equals(latestBuiltCommit) && !latestBuiltCommitFound) {
                latestBuiltCommitFound = true;
            }
            if (!latestBuiltCommitFound) {
                ++commitsCountBetweenCompilation;
            }
            if (availableCommitsForRemote.contains(commitId) && commitToDownload.isEmpty()) {
                commitToDownload = commitId;
            }
            if (commitToDownload.isEmpty()) {
                ++commitsBehind;
            }
            if (!latestBuiltCommitFound || commitToDownload.isEmpty()) continue;
            break;
        }
        if (!forceUpdate && commitsCountBetweenCompilation == 0) {
            LOG.warn("No new commits since last success compilation");
            return null;
        }
        if (!availableCommitsForRemote.contains(commitToDownload)) {
            LOG.warn("Not found any caches for the latest commits in the branch");
            return null;
        }
        LOG.info("Project contains " + commitsCountBetweenCompilation + " non compiled commits. Cache will be downloaded for " + commitsBehind + " commits before the current master. The rest commits will be build locally. Commit hash for download: " + commitToDownload);
        if (!forceUpdate && commitsBehind >= commitsCountBetweenCompilation) {
            LOG.info("Caches available for already compiled commit. Skipping download");
            return null;
        }
        if (!forceUpdate && commitToDownload.equals(latestDownloadedCommit)) {
            LOG.info("The system contains up-to-date caches");
            return null;
        }
        if (!forceUpdate && commitToDownload.equals(latestBuiltCommit)) {
            LOG.info("Commit already compiled, thus caches for it won't be download");
            return null;
        }
        return Pair.create((Object)commitToDownload, (Object)commitsCountBetweenCompilation);
    }

    @Nullable
    private static String getServerUrl(@NotNull Project project) {
        if (project == null) {
            CompilerCacheConfigurator.$$$reportNull$$$0(4);
        }
        return CompilerConfigurationSettings.Companion.getInstance(project).getCacheServerUrl();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serverUrl";
                break;
            }
        }
        objectArray2[1] = "com/intellij/compiler/cache/CompilerCacheConfigurator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getCacheDownloadSettings";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isServerUrlConfigured";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getCommitToDownload";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getServerUrl";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

