/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.cache.git;

import com.intellij.compiler.cache.git.GitRepositoryUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.SmartList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;

public class GitCommitsIterator
implements Iterator<String> {
    private static final Logger LOG = Logger.getInstance(GitCommitsIterator.class);
    private static final int MAX_FETCH_SIZE = 1000;
    private List<String> repositoryCommits;
    private final Project myProject;
    private int fetchedCount;
    private int currentPosition;
    private final String remote;

    public GitCommitsIterator(@NotNull Project project, @NotNull String remoteUrl) {
        if (project == null) {
            GitCommitsIterator.$$$reportNull$$$0(0);
        }
        if (remoteUrl == null) {
            GitCommitsIterator.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.fetchedCount = 0;
        this.remote = remoteUrl;
        this.fetchOldCommits();
    }

    @Override
    public boolean hasNext() {
        if (!this.repositoryCommits.isEmpty()) {
            if (this.currentPosition < this.repositoryCommits.size()) {
                return true;
            }
            if (this.fetchedCount >= 1000) {
                LOG.info("Exceeded fetch limit for git commits");
                return false;
            }
            this.fetchOldCommits(this.repositoryCommits.get(this.currentPosition - 1));
            if (!this.repositoryCommits.isEmpty()) {
                this.currentPosition = 0;
                return true;
            }
        }
        return false;
    }

    @Override
    public String next() {
        if (this.repositoryCommits.isEmpty() || this.currentPosition >= this.repositoryCommits.size()) {
            throw new NoSuchElementException();
        }
        String result = this.repositoryCommits.get(this.currentPosition);
        ++this.currentPosition;
        return result;
    }

    @NotNull
    public String getRemote() {
        String string = this.remote;
        if (string == null) {
            GitCommitsIterator.$$$reportNull$$$0(2);
        }
        return string;
    }

    private void fetchOldCommits() {
        this.fetchOldCommits("");
    }

    private void fetchOldCommits(String latestCommit) {
        this.repositoryCommits = new SmartList();
        this.repositoryCommits = GitRepositoryUtil.fetchRepositoryCommits(this.myProject, latestCommit);
        this.fetchedCount += this.repositoryCommits.size();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteUrl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/compiler/cache/git/GitCommitsIterator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/compiler/cache/git/GitCommitsIterator";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemote";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

