/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.cache.git;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessAdapter;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public final class GitRepositoryUtil {
    private static final Logger LOG = Logger.getInstance(GitRepositoryUtil.class);
    private static final String LATEST_COMMIT_ID = "JpsOutputLoaderManager.latestCommitId";
    private static final String LATEST_BUILT_MASTER_COMMIT_ID = "JpsOutputLoaderManager.latestBuiltMasterCommitId";
    private static final int FETCH_SIZE = 100;

    private GitRepositoryUtil() {
    }

    public static @Unmodifiable @NotNull List<String> fetchRepositoryCommits(@NotNull Project project, @NotNull String latestCommit) {
        String projectBasePath;
        if (project == null) {
            GitRepositoryUtil.$$$reportNull$$$0(0);
        }
        if (latestCommit == null) {
            GitRepositoryUtil.$$$reportNull$$$0(1);
        }
        if ((projectBasePath = project.getBasePath()) == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                GitRepositoryUtil.$$$reportNull$$$0(2);
            }
            return list;
        }
        GeneralCommandLine commandLine = new GeneralCommandLine().withParentEnvironmentType(GeneralCommandLine.ParentEnvironmentType.CONSOLE).withWorkDirectory(projectBasePath).withExePath("git").withParameters(new String[]{"log"}).withParameters(new String[]{"--format=\"%H\""});
        if (!latestCommit.isEmpty()) {
            commandLine.addParameter(latestCommit);
        }
        commandLine.withParameters(new String[]{"-n"}).withParameters(new String[]{Integer.toString(100)});
        final StringBuilder processOutput = new StringBuilder();
        try {
            OSProcessHandler handler = new OSProcessHandler(commandLine.withCharset(StandardCharsets.UTF_8));
            handler.addProcessListener((ProcessListener)new CapturingProcessAdapter(){

                public void processTerminated(@NotNull ProcessEvent event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (event.getExitCode() != 0) {
                        LOG.warn("Couldn't fetch N commits from the current repository: " + this.getOutput().getStderr());
                    } else {
                        processOutput.append(this.getOutput().getStdout());
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/compiler/cache/git/GitRepositoryUtil$1", "processTerminated"));
                }
            });
            handler.startNotify();
            handler.waitFor();
        }
        catch (ExecutionException e) {
            LOG.warn("Can't execute command for getting commit hashes", (Throwable)e);
        }
        String result = processOutput.toString();
        if (result.isEmpty()) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                GitRepositoryUtil.$$$reportNull$$$0(3);
            }
            return list;
        }
        List list = ContainerUtil.map((Object[])processOutput.toString().split("\n"), commit -> commit.substring(1, commit.length() - 1));
        if (list == null) {
            GitRepositoryUtil.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    private static String getCurrentBranchName(@NotNull Project project) {
        String projectBasePath;
        if (project == null) {
            GitRepositoryUtil.$$$reportNull$$$0(5);
        }
        if ((projectBasePath = project.getBasePath()) == null) {
            return "";
        }
        GeneralCommandLine commandLine = new GeneralCommandLine().withParentEnvironmentType(GeneralCommandLine.ParentEnvironmentType.CONSOLE).withWorkDirectory(projectBasePath).withExePath("git").withParameters(new String[]{"rev-parse"}).withParameters(new String[]{"--abbrev-ref"}).withParameters(new String[]{"HEAD"});
        final StringBuilder processOutput = new StringBuilder();
        try {
            OSProcessHandler handler = new OSProcessHandler(commandLine.withCharset(StandardCharsets.UTF_8));
            handler.addProcessListener((ProcessListener)new CapturingProcessAdapter(){

                public void processTerminated(@NotNull ProcessEvent event) {
                    if (event == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (event.getExitCode() != 0) {
                        LOG.warn("Couldn't fetch current branch name: " + this.getOutput().getStderr());
                    } else {
                        processOutput.append(this.getOutput().getStdout());
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/compiler/cache/git/GitRepositoryUtil$2", "processTerminated"));
                }
            });
            handler.startNotify();
            handler.waitFor();
        }
        catch (ExecutionException e) {
            LOG.warn("Couldn't execute command for getting current branch name", (Throwable)e);
        }
        String branch = processOutput.toString();
        LOG.debug("Git current branch name: " + branch);
        String string = branch.lines().findFirst().orElse("");
        if (string == null) {
            GitRepositoryUtil.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    private static String getNearestRemoteMasterBranchCommit(@NotNull Project project) {
        String projectBasePath;
        if (project == null) {
            GitRepositoryUtil.$$$reportNull$$$0(7);
        }
        if ((projectBasePath = project.getBasePath()) == null) {
            return "";
        }
        String branchName = GitRepositoryUtil.getCurrentBranchName(project);
        if (branchName.isEmpty()) {
            return "";
        }
        String remoteName = GitRepositoryUtil.getRemoteName(project, branchName);
        Optional<String> optionalRemoteName = remoteName.lines().findFirst();
        if (optionalRemoteName.isEmpty()) {
            return "";
        }
        GeneralCommandLine commandLine = new GeneralCommandLine().withParentEnvironmentType(GeneralCommandLine.ParentEnvironmentType.CONSOLE).withWorkDirectory(projectBasePath).withExePath("git").withParameters(new String[]{"merge-base"}).withParameters(new String[]{"HEAD"}).withParameters(new String[]{optionalRemoteName.get() + "/" + branchName});
        final StringBuilder processOutput = new StringBuilder();
        try {
            OSProcessHandler handler = new OSProcessHandler(commandLine.withCharset(StandardCharsets.UTF_8));
            handler.addProcessListener((ProcessListener)new CapturingProcessAdapter(){

                public void processTerminated(@NotNull ProcessEvent event) {
                    if (event == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    if (event.getExitCode() != 0) {
                        LOG.warn("Couldn't get nearest commit from remote master: " + this.getOutput().getStderr());
                    } else {
                        processOutput.append(this.getOutput().getStdout());
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/compiler/cache/git/GitRepositoryUtil$3", "processTerminated"));
                }
            });
            handler.startNotify();
            handler.waitFor();
        }
        catch (ExecutionException e) {
            LOG.warn("Couldn't execute command for getting nearest commit from remote master", (Throwable)e);
        }
        String string = processOutput.toString().lines().findFirst().orElse("");
        if (string == null) {
            GitRepositoryUtil.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    private static String getRemoteName(@NotNull Project project, @NotNull String branchName) {
        String projectBasePath;
        if (project == null) {
            GitRepositoryUtil.$$$reportNull$$$0(9);
        }
        if (branchName == null) {
            GitRepositoryUtil.$$$reportNull$$$0(10);
        }
        if ((projectBasePath = project.getBasePath()) == null) {
            return "";
        }
        String gitParam = "branch." + branchName + ".remote";
        GeneralCommandLine commandLine = new GeneralCommandLine().withParentEnvironmentType(GeneralCommandLine.ParentEnvironmentType.CONSOLE).withWorkDirectory(projectBasePath).withExePath("git").withParameters(new String[]{"config"}).withParameters(new String[]{"--get"}).withParameters(new String[]{gitParam});
        final StringBuilder processOutput = new StringBuilder();
        try {
            OSProcessHandler handler = new OSProcessHandler(commandLine.withCharset(StandardCharsets.UTF_8));
            handler.addProcessListener((ProcessListener)new CapturingProcessAdapter(){

                public void processTerminated(@NotNull ProcessEvent event) {
                    if (event == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    if (event.getExitCode() != 0) {
                        LOG.warn("Couldn't fetch repository remote name: " + this.getOutput().getStderr());
                    } else {
                        processOutput.append(this.getOutput().getStdout());
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/compiler/cache/git/GitRepositoryUtil$4", "processTerminated"));
                }
            });
            handler.startNotify();
            handler.waitFor();
        }
        catch (ExecutionException e) {
            LOG.warn("Couldn't execute command for getting remote name", (Throwable)e);
        }
        String remote = processOutput.toString();
        LOG.debug("Git remote name for master: " + remote);
        String string = remote;
        if (string == null) {
            GitRepositoryUtil.$$$reportNull$$$0(11);
        }
        return string;
    }

    public static boolean isAutoCrlfSetRight(@NotNull Project project) {
        String projectBasePath;
        if (project == null) {
            GitRepositoryUtil.$$$reportNull$$$0(12);
        }
        if ((projectBasePath = project.getBasePath()) == null) {
            return true;
        }
        GeneralCommandLine commandLine = new GeneralCommandLine().withParentEnvironmentType(GeneralCommandLine.ParentEnvironmentType.CONSOLE).withWorkDirectory(projectBasePath).withExePath("git").withParameters(new String[]{"config"}).withParameters(new String[]{"--get"}).withParameters(new String[]{"core.autocrlf"});
        final StringBuilder processOutput = new StringBuilder();
        try {
            OSProcessHandler handler = new OSProcessHandler(commandLine.withCharset(StandardCharsets.UTF_8));
            handler.addProcessListener((ProcessListener)new CapturingProcessAdapter(){

                public void processTerminated(@NotNull ProcessEvent event) {
                    if (event == null) {
                        5.$$$reportNull$$$0(0);
                    }
                    if (event.getExitCode() != 0) {
                        LOG.warn("Couldn't fetch repository remote name: " + this.getOutput().getStderr());
                    } else {
                        processOutput.append(this.getOutput().getStdout());
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/compiler/cache/git/GitRepositoryUtil$5", "processTerminated"));
                }
            });
            handler.startNotify();
            handler.waitFor();
        }
        catch (ExecutionException e) {
            LOG.warn("Couldn't execute command for getting remote name", (Throwable)e);
        }
        String value = processOutput.toString().lines().findFirst().orElse("");
        LOG.info("CRLF configuration for " + project.getName() + " project: " + value);
        return value.equalsIgnoreCase("input");
    }

    public static void saveLatestDownloadedCommit(@NotNull String latestDownloadedCommit) {
        if (latestDownloadedCommit == null) {
            GitRepositoryUtil.$$$reportNull$$$0(13);
        }
        PropertiesComponent.getInstance().setValue(LATEST_COMMIT_ID, latestDownloadedCommit);
        LOG.info("Saving latest downloaded commit: " + latestDownloadedCommit);
    }

    @NotNull
    public static String getLatestDownloadedCommit() {
        String latestDownloadedCommit = PropertiesComponent.getInstance().getValue(LATEST_COMMIT_ID);
        LOG.info("Getting latest downloaded commit: " + latestDownloadedCommit);
        if (latestDownloadedCommit == null) {
            return "";
        }
        String string = latestDownloadedCommit;
        if (string == null) {
            GitRepositoryUtil.$$$reportNull$$$0(14);
        }
        return string;
    }

    public static void saveLatestBuiltMasterCommit(@NotNull Project project) {
        String latestBuiltRemoteMasterCommit;
        if (project == null) {
            GitRepositoryUtil.$$$reportNull$$$0(15);
        }
        if ((latestBuiltRemoteMasterCommit = GitRepositoryUtil.getNearestRemoteMasterBranchCommit(project)).isEmpty()) {
            return;
        }
        PropertiesComponent.getInstance().setValue(LATEST_BUILT_MASTER_COMMIT_ID, latestBuiltRemoteMasterCommit);
        LOG.info("Saving latest built commit from remote master: " + latestBuiltRemoteMasterCommit);
    }

    @NotNull
    public static String getLatestBuiltMasterCommitId() {
        String latestBuiltCommit = PropertiesComponent.getInstance().getValue(LATEST_BUILT_MASTER_COMMIT_ID);
        LOG.info("Getting latest built remote master commit: " + latestBuiltCommit);
        if (latestBuiltCommit == null) {
            return "";
        }
        String string = latestBuiltCommit;
        if (string == null) {
            GitRepositoryUtil.$$$reportNull$$$0(16);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 6, 8, 11, 14, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "latestCommit";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 11: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/compiler/cache/git/GitRepositoryUtil";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchName";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "latestDownloadedCommit";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/compiler/cache/git/GitRepositoryUtil";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "fetchRepositoryCommits";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentBranchName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getNearestRemoteMasterBranchCommit";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemoteName";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getLatestDownloadedCommit";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getLatestBuiltMasterCommitId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fetchRepositoryCommits";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 11: 
            case 14: 
            case 16: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentBranchName";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getNearestRemoteMasterBranchCommit";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getRemoteName";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isAutoCrlfSetRight";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "saveLatestDownloadedCommit";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "saveLatestBuiltMasterCommit";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 6, 8, 11, 14, 16 -> new IllegalStateException(string);
        };
    }
}

