/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.chainsSearch;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

public final class ChainRelevance
implements Comparable<ChainRelevance> {
    private final int myChainSize;
    private final int myUnreachableParameterCount;
    private final int myParametersInContext;

    public ChainRelevance(int chainSize, int unreachableParameterCount, int parametersInContext) {
        this.myChainSize = chainSize;
        this.myUnreachableParameterCount = unreachableParameterCount;
        this.myParametersInContext = parametersInContext;
    }

    @TestOnly
    public int getChainSize() {
        return this.myChainSize;
    }

    @TestOnly
    public int getUnreachableParameterCount() {
        return this.myUnreachableParameterCount;
    }

    @TestOnly
    public int getParametersInContext() {
        return this.myParametersInContext;
    }

    @Override
    public int compareTo(@NotNull ChainRelevance that) {
        int sub;
        if (that == null) {
            ChainRelevance.$$$reportNull$$$0(0);
        }
        if ((sub = Integer.compare(this.myChainSize, that.myChainSize)) != 0) {
            return sub;
        }
        sub = Integer.compare(this.myUnreachableParameterCount, that.myUnreachableParameterCount);
        if (sub != 0) {
            return sub;
        }
        return -Integer.compare(this.myParametersInContext, that.myParametersInContext);
    }

    public String toString() {
        return "{\"chain_size\": " + this.myChainSize + ", \"unreachable_params\": " + this.myUnreachableParameterCount + ", \"parameters_in_context\": " + this.myParametersInContext + "}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "that", "com/intellij/compiler/chainsSearch/ChainRelevance", "compareTo"));
    }
}

