/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.chainsSearch;

import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInsight.completion.CastingLookupElementDecorator;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.JavaChainLookupElement;
import com.intellij.codeInsight.completion.JavaMethodCallElement;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.ExpressionLookupItem;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.codeInsight.lookup.VariableLookupItem;
import com.intellij.compiler.chainsSearch.ChainOperation;
import com.intellij.compiler.chainsSearch.ChainRelevance;
import com.intellij.compiler.chainsSearch.MethodChainsSearchUtil;
import com.intellij.compiler.chainsSearch.OperationChain;
import com.intellij.compiler.chainsSearch.completion.lookup.ChainCompletionNewVariableLookupElement;
import com.intellij.compiler.chainsSearch.completion.lookup.JavaRelevantChainLookupElement;
import com.intellij.compiler.chainsSearch.context.ChainCompletionContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public final class MethodChainLookupRangingHelper {
    @NotNull
    public static LookupElement toLookupElement(OperationChain chain, ChainCompletionContext context) {
        int unreachableParametersCount = 0;
        int matchedParametersInContext = 0;
        LookupElement chainLookupElement = null;
        for (ChainOperation op : chain.getPath()) {
            if (op instanceof ChainOperation.MethodCall) {
                PsiMethod method = Objects.requireNonNull(MethodChainsSearchUtil.getMethodWithMinNotPrimitiveParameters(((ChainOperation.MethodCall)op).getCandidates(), context.getTarget().getTargetClass()));
                Couple<Integer> info = MethodChainLookupRangingHelper.calculateParameterInfo(method, context);
                unreachableParametersCount += ((Integer)info.getFirst()).intValue();
                matchedParametersInContext += ((Integer)info.getSecond()).intValue();
                if (chainLookupElement == null) {
                    LookupElement qualifierLookupElement = method.hasModifierProperty("static") ? null : MethodChainLookupRangingHelper.createQualifierLookupElement(chain.getQualifierClass(), context);
                    LookupElement headLookupElement = MethodChainLookupRangingHelper.createMethodLookupElement(method);
                    chainLookupElement = qualifierLookupElement == null ? headLookupElement : new JavaChainLookupElement(qualifierLookupElement, headLookupElement);
                    continue;
                }
                chainLookupElement = new JavaChainLookupElement(chainLookupElement, (LookupElement)new JavaMethodCallElement(method));
                continue;
            }
            if (chainLookupElement == null) {
                chainLookupElement = MethodChainLookupRangingHelper.createQualifierLookupElement(chain.getQualifierClass(), context);
            }
            PsiClass castClass = ((ChainOperation.TypeCast)op).getCastClass();
            PsiClassType type = JavaPsiFacade.getElementFactory((Project)castClass.getProject()).createType(castClass);
            chainLookupElement = PrioritizedLookupElement.withPriority((LookupElement)CastingLookupElementDecorator.createCastingElement((LookupElement)chainLookupElement, (PsiType)type), (double)-1.0);
        }
        if (context.getTarget().isIteratorAccess()) {
            chainLookupElement = MethodChainLookupRangingHelper.decorateWithIteratorAccess(chain.getFirst()[0], chainLookupElement);
        }
        return new JavaRelevantChainLookupElement(Objects.requireNonNull(chainLookupElement), new ChainRelevance(chain.length(), unreachableParametersCount, matchedParametersInContext));
    }

    @NotNull
    private static LookupElementDecorator<LookupElement> decorateWithIteratorAccess(final PsiMethod method, LookupElement chainLookupElement) {
        return new LookupElementDecorator<LookupElement>(chainLookupElement){

            public void handleInsert(@NotNull InsertionContext context) {
                if (context == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.handleInsert(context);
                Document document = context.getDocument();
                int tail = context.getTailOffset();
                PsiType tailReturnType = method.getReturnType();
                if (tailReturnType instanceof PsiArrayType) {
                    document.insertString(tail, (CharSequence)"[0]");
                    context.getEditor().getCaretModel().moveToOffset(tail + 1);
                } else {
                    PsiClass returnClass = Objects.requireNonNull(PsiUtil.resolveClassInClassTypeOnly((PsiType)tailReturnType));
                    PsiDocumentManager.getInstance((Project)context.getProject()).doPostponedOperationsAndUnblockDocument(document);
                    if (InheritanceUtil.isInheritor((PsiClass)returnClass, (String)"java.util.List")) {
                        document.insertString(tail, (CharSequence)".get(0)");
                        context.getEditor().getCaretModel().moveToOffset(tail + 5);
                    } else if (InheritanceUtil.isInheritor((PsiClass)returnClass, (String)"java.util.Collection")) {
                        document.insertString(tail, (CharSequence)".iterator().next()");
                    } else if (InheritanceUtil.isInheritor((PsiClass)returnClass, (String)"java.util.Iterator")) {
                        document.insertString(tail, (CharSequence)".next()");
                    } else if (InheritanceUtil.isInheritor((PsiClass)returnClass, (String)"java.util.stream.Stream")) {
                        document.insertString(tail, (CharSequence)".findFirst().get()");
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/compiler/chainsSearch/MethodChainLookupRangingHelper$1", "handleInsert"));
            }
        };
    }

    @NotNull
    private static LookupElement createQualifierLookupElement(@NotNull PsiClass qualifierClass, @NotNull ChainCompletionContext context) {
        PsiClassType type;
        PsiNamedElement element;
        if (qualifierClass == null) {
            MethodChainLookupRangingHelper.$$$reportNull$$$0(0);
        }
        if (context == null) {
            MethodChainLookupRangingHelper.$$$reportNull$$$0(1);
        }
        if ((element = context.getQualifierIfPresent((PsiType)(type = JavaPsiFacade.getElementFactory((Project)qualifierClass.getProject()).createType(qualifierClass)))) == null) {
            return new ChainCompletionNewVariableLookupElement(qualifierClass, context);
        }
        if (element instanceof PsiVariable) {
            PsiVariable var = (PsiVariable)element;
            return new VariableLookupItem(var);
        }
        if (element instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)element;
            return MethodChainLookupRangingHelper.createMethodLookupElement(method);
        }
        throw new AssertionError((Object)("unexpected element: " + String.valueOf(element)));
    }

    @NotNull
    private static Couple<Integer> calculateParameterInfo(@NotNull PsiMethod method, @NotNull ChainCompletionContext context) {
        if (method == null) {
            MethodChainLookupRangingHelper.$$$reportNull$$$0(2);
        }
        if (context == null) {
            MethodChainLookupRangingHelper.$$$reportNull$$$0(3);
        }
        int unreachableParametersCount = 0;
        int matchedParametersInContext = 0;
        for (PsiParameter parameter : method.getParameterList().getParameters()) {
            PsiType type = parameter.getType();
            if (ChainCompletionContext.isWidelyUsed(type)) continue;
            PsiNamedElement contextVariable = context.getQualifierIfPresent(type);
            if (contextVariable != null) {
                ++matchedParametersInContext;
                continue;
            }
            if (NullableNotNullManager.isNullable((PsiModifierListOwner)parameter)) continue;
            ++unreachableParametersCount;
        }
        Couple couple = Couple.of((Object)unreachableParametersCount, (Object)matchedParametersInContext);
        if (couple == null) {
            MethodChainLookupRangingHelper.$$$reportNull$$$0(4);
        }
        return couple;
    }

    @NotNull
    private static LookupElement createMethodLookupElement(@NotNull PsiMethod method) {
        JavaMethodCallElement result;
        if (method == null) {
            MethodChainLookupRangingHelper.$$$reportNull$$$0(5);
        }
        if (method.isConstructor()) {
            PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)method.getProject());
            result = new ExpressionLookupItem(elementFactory.createExpressionFromText("new " + method.getContainingClass().getQualifiedName() + "()", null));
        } else {
            result = method.hasModifierProperty("static") ? new JavaMethodCallElement(method, false, true) : new JavaMethodCallElement(method);
        }
        JavaMethodCallElement javaMethodCallElement = result;
        if (javaMethodCallElement == null) {
            MethodChainLookupRangingHelper.$$$reportNull$$$0(6);
        }
        return javaMethodCallElement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifierClass";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/compiler/chainsSearch/MethodChainLookupRangingHelper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/compiler/chainsSearch/MethodChainLookupRangingHelper";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateParameterInfo";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createMethodLookupElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createQualifierLookupElement";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "calculateParameterInfo";
                break;
            }
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createMethodLookupElement";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 6 -> new IllegalStateException(string);
        };
    }
}

