/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.chainsSearch.context;

import com.intellij.compiler.CompilerReferenceService;
import com.intellij.compiler.backwardRefs.CompilerReferenceServiceEx;
import com.intellij.compiler.chainsSearch.MethodCall;
import com.intellij.compiler.chainsSearch.context.ChainSearchTarget;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.backwardRefs.CompilerRef;

public final class ChainCompletionContext {
    private static final String[] WIDELY_USED_CLASS_NAMES = new String[]{"java.lang.String", "java.lang.Object", "java.lang.Class"};
    private static final Set<String> WIDELY_USED_SHORT_NAMES = Set.of("String", "Object", "Class");
    @NotNull
    private final ChainSearchTarget myTarget;
    @NotNull
    private final List<PsiNamedElement> myContextElements;
    @NotNull
    private final PsiElement myContext;
    @NotNull
    private final GlobalSearchScope myResolveScope;
    @NotNull
    private final Project myProject;
    @NotNull
    private final PsiResolveHelper myResolveHelper;
    @NotNull
    private final Int2ObjectMap<PsiClass> myQualifierClassResolver;
    @NotNull
    private final Map<MethodCall, PsiMethod[]> myResolver;
    @NotNull
    private final CompilerReferenceServiceEx myRefService;
    private final NotNullLazyValue<Set<CompilerRef>> myContextClassReferences;

    private ChainCompletionContext(@NotNull ChainSearchTarget target, @NotNull List<PsiNamedElement> contextElements, @NotNull PsiElement context, @NotNull CompilerReferenceServiceEx compilerReferenceService) {
        if (target == null) {
            ChainCompletionContext.$$$reportNull$$$0(0);
        }
        if (contextElements == null) {
            ChainCompletionContext.$$$reportNull$$$0(1);
        }
        if (context == null) {
            ChainCompletionContext.$$$reportNull$$$0(2);
        }
        if (compilerReferenceService == null) {
            ChainCompletionContext.$$$reportNull$$$0(3);
        }
        this.myTarget = target;
        this.myContextElements = contextElements;
        this.myContext = context;
        this.myResolveScope = context.getResolveScope();
        this.myProject = context.getProject();
        this.myResolveHelper = PsiResolveHelper.getInstance((Project)this.myProject);
        this.myQualifierClassResolver = new Int2ObjectOpenHashMap();
        this.myResolver = FactoryMap.create(sign -> sign.resolve());
        this.myRefService = compilerReferenceService;
        this.myContextClassReferences = NotNullLazyValue.createValue(() -> {
            HashSet<CompilerRef.JavaCompilerClassRef> set = new HashSet<CompilerRef.JavaCompilerClassRef>();
            for (PsiType type : this.getContextTypes()) {
                int n;
                String name;
                PsiClass c = PsiUtil.resolveClassInType((PsiType)type);
                if (c == null || (name = ClassUtil.getJVMClassName((PsiClass)c)) == null || (n = this.myRefService.getNameId(name)) == 0) continue;
                set.add(new CompilerRef.JavaCompilerClassRef(n));
            }
            return set;
        });
    }

    @NotNull
    public ChainSearchTarget getTarget() {
        ChainSearchTarget chainSearchTarget = this.myTarget;
        if (chainSearchTarget == null) {
            ChainCompletionContext.$$$reportNull$$$0(4);
        }
        return chainSearchTarget;
    }

    public boolean contains(@Nullable PsiType type) {
        if (type == null) {
            return false;
        }
        Set<PsiType> types = this.getContextTypes();
        if (types.contains(type)) {
            return true;
        }
        for (PsiType contextType : types) {
            if (!type.isAssignableFrom(contextType)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public CompilerReferenceServiceEx getRefService() {
        CompilerReferenceServiceEx compilerReferenceServiceEx = this.myRefService;
        if (compilerReferenceServiceEx == null) {
            ChainCompletionContext.$$$reportNull$$$0(5);
        }
        return compilerReferenceServiceEx;
    }

    @NotNull
    public PsiElement getContextPsi() {
        PsiElement psiElement = this.myContext;
        if (psiElement == null) {
            ChainCompletionContext.$$$reportNull$$$0(6);
        }
        return psiElement;
    }

    public PsiFile getContextFile() {
        return this.myContext.getContainingFile();
    }

    @NotNull
    public Set<PsiType> getContextTypes() {
        Set<PsiType> set = this.myContextElements.stream().map(PsiUtil::getTypeByPsiElement).collect(Collectors.toSet());
        if (set == null) {
            ChainCompletionContext.$$$reportNull$$$0(7);
        }
        return set;
    }

    @NotNull
    public Set<CompilerRef> getContextClassReferences() {
        Set set = (Set)this.myContextClassReferences.getValue();
        if (set == null) {
            ChainCompletionContext.$$$reportNull$$$0(8);
        }
        return set;
    }

    @NotNull
    public GlobalSearchScope getResolveScope() {
        GlobalSearchScope globalSearchScope = this.myResolveScope;
        if (globalSearchScope == null) {
            ChainCompletionContext.$$$reportNull$$$0(9);
        }
        return globalSearchScope;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            ChainCompletionContext.$$$reportNull$$$0(10);
        }
        return project;
    }

    public boolean hasQualifier(@Nullable PsiClass targetClass) {
        return targetClass != null && this.getQualifierIfPresent((PsiType)JavaPsiFacade.getElementFactory((Project)this.myProject).createType(targetClass)) != null;
    }

    @Nullable
    public PsiNamedElement getQualifierIfPresent(@NotNull PsiType targetType) {
        if (targetType == null) {
            ChainCompletionContext.$$$reportNull$$$0(11);
        }
        return (PsiNamedElement)DumbService.getInstance((Project)this.myProject).computeWithAlternativeResolveEnabled(() -> (PsiNamedElement)ContainerUtil.find(this.myContextElements, e -> {
            PsiType elementType = PsiUtil.getTypeByPsiElement((PsiElement)e);
            return elementType != null && targetType.isAssignableFrom(elementType);
        }));
    }

    @Nullable
    public PsiClass resolvePsiClass(@NotNull CompilerRef.NamedCompilerRef aClass) {
        int nameId;
        if (aClass == null) {
            ChainCompletionContext.$$$reportNull$$$0(12);
        }
        if (this.myQualifierClassResolver.containsKey(nameId = aClass.getName())) {
            return (PsiClass)this.myQualifierClassResolver.get(nameId);
        }
        PsiClass psiClass = null;
        String name = this.myRefService.getName(nameId);
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)this.getProject());
        PsiClass resolvedClass = (PsiClass)DumbService.getInstance((Project)this.myProject).computeWithAlternativeResolveEnabled(() -> facade.findClass(name, this.myResolveScope));
        if (resolvedClass != null && this.accessValidator().test((PsiMember)resolvedClass)) {
            psiClass = resolvedClass;
        }
        this.myQualifierClassResolver.put(nameId, psiClass);
        return psiClass;
    }

    public PsiMethod @NotNull [] resolve(MethodCall sign) {
        PsiMethod[] psiMethodArray = this.myResolver.get(sign);
        if (psiMethodArray == null) {
            ChainCompletionContext.$$$reportNull$$$0(13);
        }
        return psiMethodArray;
    }

    public Predicate<PsiMember> accessValidator() {
        return m -> this.myResolveHelper.isAccessible(m, this.myContext, null);
    }

    @Nullable
    public static ChainCompletionContext createContext(@Nullable PsiType targetType, @Nullable PsiElement containingElement, boolean suggestIterators) {
        ChainSearchTarget target;
        ChainSearchTarget chainSearchTarget = target = containingElement == null ? null : ChainSearchTarget.create(targetType);
        if (target == null) {
            return null;
        }
        CompilerReferenceServiceEx compilerReferenceService = (CompilerReferenceServiceEx)CompilerReferenceService.getInstanceIfEnabled((Project)containingElement.getProject());
        if (compilerReferenceService == null) {
            return null;
        }
        if (suggestIterators) {
            target = target.toIterators();
        }
        Set<? extends PsiVariable> excludedVariables = ChainCompletionContext.getEnclosingLocalVariables(containingElement);
        Project project = containingElement.getProject();
        ContextProcessor processor = new ContextProcessor(null, project, containingElement, excludedVariables);
        PsiScopesUtil.treeWalkUp((PsiScopeProcessor)processor, (PsiElement)containingElement, (PsiElement)containingElement.getContainingFile());
        List<PsiNamedElement> contextElements = processor.getContextElements();
        return new ChainCompletionContext(target, contextElements, containingElement, compilerReferenceService);
    }

    @NotNull
    private static Set<? extends PsiVariable> getEnclosingLocalVariables(@NotNull PsiElement place) {
        if (place == null) {
            ChainCompletionContext.$$$reportNull$$$0(14);
        }
        HashSet<PsiLocalVariable> result = new HashSet<PsiLocalVariable>();
        if (place instanceof PsiLocalVariable) {
            PsiLocalVariable variable = (PsiLocalVariable)place;
            result.add(variable);
        }
        for (PsiElement parent = place.getParent(); parent != null && !(parent instanceof PsiFileSystemItem); parent = parent.getParent()) {
            PsiLocalVariable variable;
            if (!(parent instanceof PsiLocalVariable) || !PsiTreeUtil.isAncestor((PsiElement)(variable = (PsiLocalVariable)parent).getInitializer(), (PsiElement)place, (boolean)false)) continue;
            result.add(variable);
        }
        HashSet<PsiLocalVariable> hashSet = result;
        if (hashSet == null) {
            ChainCompletionContext.$$$reportNull$$$0(15);
        }
        return hashSet;
    }

    public static boolean isWidelyUsed(@NotNull PsiType type) {
        if (type == null) {
            ChainCompletionContext.$$$reportNull$$$0(16);
        }
        if ((type = type.getDeepComponentType()) instanceof PsiPrimitiveType) {
            return true;
        }
        if (!(type instanceof PsiClassType)) {
            return false;
        }
        PsiClassType classType = (PsiClassType)type;
        String className = classType.getClassName();
        if (className != null && WIDELY_USED_SHORT_NAMES.contains(className)) {
            return false;
        }
        PsiClass resolvedClass = classType.resolve();
        if (resolvedClass == null) {
            return false;
        }
        String qName = resolvedClass.getQualifiedName();
        if (qName == null) {
            return false;
        }
        return ArrayUtil.contains((String)qName, (String[])WIDELY_USED_CLASS_NAMES);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7, 8, 9, 10, 13, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextElements";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compilerReferenceService";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/compiler/chainsSearch/context/ChainCompletionContext";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetType";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/compiler/chainsSearch/context/ChainCompletionContext";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTarget";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRefService";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextPsi";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextTypes";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextClassReferences";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolveScope";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "resolve";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnclosingLocalVariables";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 15: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getQualifierIfPresent";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "resolvePsiClass";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getEnclosingLocalVariables";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isWidelyUsed";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 7, 8, 9, 10, 13, 15 -> new IllegalStateException(string);
        };
    }

    private static final class ContextProcessor
    implements PsiScopeProcessor,
    ElementClassHint {
        private final List<PsiNamedElement> myContextElements;
        private final PsiVariable myCompletionVariable;
        private final PsiResolveHelper myResolveHelper;
        private final PsiElement myPlace;
        private final Set<? extends PsiVariable> myExcludedVariables;

        private ContextProcessor(@Nullable PsiVariable variable, @NotNull Project project, @NotNull PsiElement place, @NotNull Set<? extends PsiVariable> excludedVariables) {
            if (project == null) {
                ContextProcessor.$$$reportNull$$$0(0);
            }
            if (place == null) {
                ContextProcessor.$$$reportNull$$$0(1);
            }
            if (excludedVariables == null) {
                ContextProcessor.$$$reportNull$$$0(2);
            }
            this.myContextElements = new SmartList();
            this.myCompletionVariable = variable;
            this.myResolveHelper = PsiResolveHelper.getInstance((Project)project);
            this.myPlace = place;
            this.myExcludedVariables = excludedVariables;
        }

        public boolean shouldProcess(@NotNull ElementClassHint.DeclarationKind kind) {
            if (kind == null) {
                ContextProcessor.$$$reportNull$$$0(3);
            }
            return kind == ElementClassHint.DeclarationKind.ENUM_CONST || kind == ElementClassHint.DeclarationKind.FIELD || kind == ElementClassHint.DeclarationKind.METHOD || kind == ElementClassHint.DeclarationKind.VARIABLE;
        }

        public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
            PsiMember member;
            PsiMethod method;
            if (element == null) {
                ContextProcessor.$$$reportNull$$$0(4);
            }
            if (state == null) {
                ContextProcessor.$$$reportNull$$$0(5);
            }
            if (!(element instanceof PsiMethod && !PropertyUtilBase.isSimplePropertyAccessor((PsiMethod)(method = (PsiMethod)element)) || element instanceof PsiVariable && this.myExcludedVariables.contains(element) || element instanceof PsiMember && !this.myResolveHelper.isAccessible(member = (PsiMember)element, this.myPlace, null))) {
                PsiType type = PsiUtil.getTypeByPsiElement((PsiElement)element);
                if (type == null) {
                    return true;
                }
                if (ChainCompletionContext.isWidelyUsed(type)) {
                    return true;
                }
                this.myContextElements.add((PsiNamedElement)element);
            }
            return true;
        }

        public <T> T getHint(@NotNull Key<T> hintKey) {
            if (hintKey == null) {
                ContextProcessor.$$$reportNull$$$0(6);
            }
            if (hintKey == KEY) {
                return (T)this;
            }
            return null;
        }

        @NotNull
        public List<PsiNamedElement> getContextElements() {
            this.myContextElements.remove(this.myCompletionVariable);
            List<PsiNamedElement> list = this.myContextElements;
            if (list == null) {
                ContextProcessor.$$$reportNull$$$0(7);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 7 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "place";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "excludedVariables";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kind";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "hintKey";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/compiler/chainsSearch/context/ChainCompletionContext$ContextProcessor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/compiler/chainsSearch/context/ChainCompletionContext$ContextProcessor";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContextElements";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "shouldProcess";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "execute";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getHint";
                    break;
                }
                case 7: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 7 -> new IllegalStateException(string);
            };
        }
    }
}

