/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl;

import com.intellij.compiler.ModuleSourceSet;
import com.intellij.compiler.impl.CompileContextImpl;
import com.intellij.compiler.impl.CompositeScope;
import com.intellij.compiler.impl.FileSetCompileScope;
import com.intellij.compiler.impl.OneProjectItemCompileScope;
import com.intellij.compiler.impl.UpdateResourcesBuildContributor;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.util.containers.ContainerUtil;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.jps.api.CmdlineProtoUtil;
import org.jetbrains.jps.api.CmdlineRemoteProto;
import org.jetbrains.jps.builders.BuildTargetType;
import org.jetbrains.jps.builders.java.JavaModuleBuildTargetType;
import org.jetbrains.jps.builders.java.ResourcesTargetType;
import org.jetbrains.jps.incremental.artifacts.ArtifactBuildTargetType;

public final class CompileScopeUtil {
    private static final Key<List<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope>> BASE_SCOPE_FOR_EXTERNAL_BUILD = Key.create((String)"SCOPE_FOR_EXTERNAL_BUILD");

    public static void setBaseScopeForExternalBuild(@NotNull CompileScope scope, @NotNull List<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope> scopes) {
        if (scope == null) {
            CompileScopeUtil.$$$reportNull$$$0(0);
        }
        if (scopes == null) {
            CompileScopeUtil.$$$reportNull$$$0(1);
        }
        scope.putUserData(BASE_SCOPE_FOR_EXTERNAL_BUILD, scopes);
    }

    public static void setResourcesScopeForExternalBuild(@NotNull CompileScope scope, @NotNull List<String> moduleNames) {
        if (scope == null) {
            CompileScopeUtil.$$$reportNull$$$0(2);
        }
        if (moduleNames == null) {
            CompileScopeUtil.$$$reportNull$$$0(3);
        }
        ArrayList<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope> resourceScopes = new ArrayList<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope>();
        for (UpdateResourcesBuildContributor provider : UpdateResourcesBuildContributor.EP_NAME.getExtensionList()) {
            for (BuildTargetType buildTargetType : provider.getResourceTargetTypes()) {
                resourceScopes.add(CmdlineProtoUtil.createTargetsScope((String)buildTargetType.getTypeId(), moduleNames, (boolean)false));
            }
        }
        CompileScopeUtil.setBaseScopeForExternalBuild(scope, resourceScopes);
    }

    public static void addScopesForModules(Collection<? extends Module> modules, Collection<String> unloadedModules, List<? super CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope> scopes, boolean forceBuild) {
        if (!modules.isEmpty() || !unloadedModules.isEmpty()) {
            for (JavaModuleBuildTargetType type : JavaModuleBuildTargetType.ALL_TYPES) {
                CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope.Builder builder = CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope.newBuilder().setTypeId(type.getTypeId()).setForceBuild(forceBuild);
                for (Module module : modules) {
                    builder.addTargetId(module.getName());
                }
                for (String string : unloadedModules) {
                    builder.addTargetId(string);
                }
                scopes.add((CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope)builder.build());
            }
        }
    }

    public static void addScopesForSourceSets(Collection<? extends ModuleSourceSet> sets, Collection<String> unloadedModules, List<? super CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope> scopes, boolean forceBuild) {
        if (sets.isEmpty() && unloadedModules.isEmpty()) {
            return;
        }
        HashMap<BuildTargetType, Set> targetsByType = new HashMap<BuildTargetType, Set>();
        for (ModuleSourceSet moduleSourceSet : sets) {
            BuildTargetType<?> targetType = CompileScopeUtil.toTargetType(moduleSourceSet);
            assert (targetType != null);
            targetsByType.computeIfAbsent(targetType, tt -> new HashSet()).add(moduleSourceSet.getModule().getName());
        }
        if (!unloadedModules.isEmpty()) {
            for (JavaModuleBuildTargetType javaModuleBuildTargetType : JavaModuleBuildTargetType.ALL_TYPES) {
                targetsByType.computeIfAbsent((BuildTargetType)javaModuleBuildTargetType, tt -> new HashSet()).addAll(unloadedModules);
            }
        }
        for (Map.Entry entry : targetsByType.entrySet()) {
            CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope.Builder builder = CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope.newBuilder().setTypeId(((BuildTargetType)entry.getKey()).getTypeId()).setForceBuild(forceBuild);
            for (String targetId : (Set)entry.getValue()) {
                builder.addTargetId(targetId);
            }
            scopes.add((CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope)builder.build());
        }
    }

    private static BuildTargetType<?> toTargetType(ModuleSourceSet set) {
        return switch (set.getType()) {
            default -> throw new MatchException(null, null);
            case ModuleSourceSet.Type.TEST -> JavaModuleBuildTargetType.TEST;
            case ModuleSourceSet.Type.PRODUCTION -> JavaModuleBuildTargetType.PRODUCTION;
            case ModuleSourceSet.Type.RESOURCES -> ResourcesTargetType.PRODUCTION;
            case ModuleSourceSet.Type.RESOURCES_TEST -> ResourcesTargetType.TEST;
        };
    }

    public static List<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope> getBaseScopeForExternalBuild(@NotNull CompileScope scope) {
        if (scope == null) {
            CompileScopeUtil.$$$reportNull$$$0(4);
        }
        return (List)scope.getUserData(BASE_SCOPE_FOR_EXTERNAL_BUILD);
    }

    public static List<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope> mergeScopes(@NotNull List<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope> scopes1, @NotNull List<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope> scopes2) {
        if (scopes1 == null) {
            CompileScopeUtil.$$$reportNull$$$0(5);
        }
        if (scopes2 == null) {
            CompileScopeUtil.$$$reportNull$$$0(6);
        }
        if (scopes2.isEmpty()) {
            return scopes1;
        }
        if (scopes1.isEmpty()) {
            return scopes2;
        }
        HashMap<String, CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope> scopeById = new HashMap<String, CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope>();
        CompileScopeUtil.mergeScopes(scopeById, scopes1);
        CompileScopeUtil.mergeScopes(scopeById, scopes2);
        return new ArrayList<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope>(scopeById.values());
    }

    private static void mergeScopes(Map<String, CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope> scopeById, List<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope> scopes) {
        for (CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope scope : scopes) {
            String id = scope.getTypeId();
            CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope old = scopeById.get(id);
            if (old == null) {
                scopeById.put(id, scope);
                continue;
            }
            scopeById.put(id, CompileScopeUtil.mergeScope(old, scope));
        }
    }

    private static CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope mergeScope(CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope scope1, CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope scope2) {
        String typeId = scope1.getTypeId();
        if (scope1.getAllTargets()) {
            return !scope1.getForceBuild() && scope2.getForceBuild() ? CompileScopeUtil.createAllTargetForcedBuildScope(typeId) : scope1;
        }
        if (scope2.getAllTargets()) {
            return !scope2.getForceBuild() && scope1.getForceBuild() ? CompileScopeUtil.createAllTargetForcedBuildScope(typeId) : scope2;
        }
        return (CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope)CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope.newBuilder().setTypeId(typeId).setForceBuild(scope1.getForceBuild() || scope2.getForceBuild()).addAllTargetId((Iterable)scope1.getTargetIdList()).addAllTargetId((Iterable)scope2.getTargetIdList()).build();
    }

    private static CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope createAllTargetForcedBuildScope(String typeId) {
        return (CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope)CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope.newBuilder().setTypeId(typeId).setForceBuild(true).setAllTargets(true).build();
    }

    public static boolean allProjectModulesAffected(CompileContextImpl compileContext) {
        ObjectOpenHashSet allModules = new ObjectOpenHashSet((Object[])compileContext.getProjectCompileScope().getAffectedModules());
        for (Module module : compileContext.getCompileScope().getAffectedModules()) {
            allModules.remove(module);
        }
        return allModules.isEmpty();
    }

    public static @Unmodifiable List<String> fetchFiles(CompileContextImpl context) {
        if (context.isRebuild()) {
            return Collections.emptyList();
        }
        CompileScope scope = context.getCompileScope();
        if (CompileScopeUtil.shouldFetchFiles(scope)) {
            return ContainerUtil.map((Object[])scope.getFiles(null, true), VirtualFile::getPath);
        }
        return Collections.emptyList();
    }

    private static boolean shouldFetchFiles(CompileScope scope) {
        if (scope instanceof CompositeScope) {
            for (CompileScope compileScope : ((CompositeScope)scope).getScopes()) {
                if (!CompileScopeUtil.shouldFetchFiles(compileScope)) continue;
                return true;
            }
        }
        return scope instanceof OneProjectItemCompileScope || scope instanceof FileSetCompileScope;
    }

    public static CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope createScopeForArtifacts(Collection<? extends Artifact> artifacts, boolean forceBuild) {
        CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope.Builder builder = CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope.newBuilder().setTypeId(ArtifactBuildTargetType.INSTANCE.getTypeId()).setForceBuild(forceBuild);
        for (Artifact artifact : artifacts) {
            builder.addTargetId(artifact.getName());
        }
        return (CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope)builder.build();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopes";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleNames";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopes1";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopes2";
                break;
            }
        }
        objectArray2[1] = "com/intellij/compiler/impl/CompileScopeUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setBaseScopeForExternalBuild";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "setResourcesScopeForExternalBuild";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getBaseScopeForExternalBuild";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "mergeScopes";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

