/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl;

import com.intellij.compiler.CompilerEncodingService;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.openapi.vfs.encoding.EncodingProjectManagerImpl;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.containers.ContainerUtil;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

public final class CompilerEncodingServiceImpl
extends CompilerEncodingService {
    @NotNull
    private final Project myProject;
    private final CachedValue<Map<Module, Set<Charset>>> myModuleFileEncodings;

    public CompilerEncodingServiceImpl(@NotNull Project project) {
        if (project == null) {
            CompilerEncodingServiceImpl.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myModuleFileEncodings = CachedValuesManager.getManager((Project)project).createCachedValue(() -> {
            Map<Module, Set<Charset>> result = this.computeModuleCharsetMap();
            return CachedValueProvider.Result.create(result, (Object[])new Object[]{ProjectRootManager.getInstance((Project)this.myProject), ((EncodingProjectManagerImpl)EncodingProjectManager.getInstance((Project)this.myProject)).getModificationTracker()});
        }, false);
    }

    @NotNull
    private Map<Module, Set<Charset>> computeModuleCharsetMap() {
        HashMap<Module, Set<Charset>> map = new HashMap<Module, Set<Charset>>();
        Map mappings = ((EncodingProjectManagerImpl)EncodingProjectManager.getInstance((Project)this.myProject)).getAllMappings();
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
        CompilerManager compilerManager = CompilerManager.getInstance((Project)this.myProject);
        for (Map.Entry entry : mappings.entrySet()) {
            Module module;
            VirtualFile file = (VirtualFile)entry.getKey();
            Charset charset = (Charset)entry.getValue();
            if (file == null || charset == null || !file.isDirectory() && !compilerManager.isCompilableFileType(file.getFileType()) || !index.isUnderSourceRootOfType(file, JavaModuleSourceRootTypes.SOURCES) || (module = index.getModuleForFile(file)) == null) continue;
            LinkedHashSet<Charset> set = (LinkedHashSet<Charset>)map.get(module);
            if (set == null) {
                set = new LinkedHashSet<Charset>();
                map.put(module, set);
                VirtualFile sourceRoot = index.getSourceRootForFile(file);
                Charset parentCharset = null;
                for (VirtualFile current = file.getParent(); current != null; current = current.getParent()) {
                    Charset currentCharset = (Charset)mappings.get(current);
                    if (currentCharset != null) {
                        parentCharset = currentCharset;
                    }
                    if (current.equals(sourceRoot)) break;
                }
                if (parentCharset != null) {
                    set.add(parentCharset);
                }
            }
            set.add(charset);
        }
        for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            for (VirtualFile file : ModuleRootManager.getInstance((Module)module).getSourceRoots(true)) {
                Charset encoding = EncodingProjectManager.getInstance((Project)this.myProject).getEncoding(file, true);
                if (encoding == null) continue;
                LinkedHashSet<Charset> charsets = (LinkedHashSet<Charset>)map.get(module);
                if (charsets == null) {
                    charsets = new LinkedHashSet<Charset>();
                    map.put(module, charsets);
                }
                charsets.add(encoding);
            }
        }
        HashMap<Module, Set<Charset>> hashMap = map;
        if (hashMap == null) {
            CompilerEncodingServiceImpl.$$$reportNull$$$0(1);
        }
        return hashMap;
    }

    @Nullable
    public Charset getPreferredModuleEncoding(@NotNull Module module) {
        if (module == null) {
            CompilerEncodingServiceImpl.$$$reportNull$$$0(2);
        }
        Set encodings = (Set)((Map)this.myModuleFileEncodings.getValue()).get(module);
        return (Charset)ContainerUtil.getFirstItem((Collection)encodings, (Object)EncodingProjectManager.getInstance((Project)this.myProject).getDefaultCharset());
    }

    @NotNull
    public @Unmodifiable Collection<Charset> getAllModuleEncodings(@NotNull Module module) {
        Set encodings;
        if (module == null) {
            CompilerEncodingServiceImpl.$$$reportNull$$$0(3);
        }
        if ((encodings = (Set)((Map)this.myModuleFileEncodings.getValue()).get(module)) != null) {
            Set set = encodings;
            if (set == null) {
                CompilerEncodingServiceImpl.$$$reportNull$$$0(4);
            }
            return set;
        }
        List list = ContainerUtil.createMaybeSingletonList((Object)EncodingProjectManager.getInstance((Project)this.myProject).getDefaultCharset());
        if (list == null) {
            CompilerEncodingServiceImpl.$$$reportNull$$$0(5);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/compiler/impl/CompilerEncodingServiceImpl";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/compiler/impl/CompilerEncodingServiceImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "computeModuleCharsetMap";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllModuleEncodings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPreferredModuleEncoding";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getAllModuleEncodings";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 4, 5 -> new IllegalStateException(string);
        };
    }
}

