/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl;

import com.intellij.compiler.ModuleSourceSet;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.ExportableUserDataHolderBase;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SmartHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class CompositeScope
extends ExportableUserDataHolderBase
implements CompileScope {
    private final List<CompileScope> myScopes;

    public CompositeScope(@NotNull CompileScope scope1, @NotNull CompileScope scope2) {
        if (scope1 == null) {
            CompositeScope.$$$reportNull$$$0(0);
        }
        if (scope2 == null) {
            CompositeScope.$$$reportNull$$$0(1);
        }
        this.myScopes = new ArrayList<CompileScope>();
        this.addScope(scope1);
        this.addScope(scope2);
    }

    public CompositeScope(CompileScope @NotNull [] scopes) {
        if (scopes == null) {
            CompositeScope.$$$reportNull$$$0(2);
        }
        this.myScopes = new ArrayList<CompileScope>();
        for (CompileScope scope : scopes) {
            this.addScope(scope);
        }
    }

    private void addScope(@NotNull CompileScope scope) {
        if (scope == null) {
            CompositeScope.$$$reportNull$$$0(3);
        }
        if (scope instanceof CompositeScope) {
            CompositeScope compositeScope = (CompositeScope)scope;
            for (CompileScope childScope : compositeScope.myScopes) {
                this.addScope(childScope);
            }
        } else {
            this.myScopes.add(scope);
        }
    }

    public VirtualFile @NotNull [] getFiles(FileType fileType, boolean inSourceOnly) {
        HashSet allFiles = new HashSet();
        for (CompileScope scope : this.myScopes) {
            Object[] files = scope.getFiles(fileType, inSourceOnly);
            if (files.length <= 0) continue;
            ContainerUtil.addAll(allFiles, (Object[])files);
        }
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray(allFiles);
        if (virtualFileArray == null) {
            CompositeScope.$$$reportNull$$$0(4);
        }
        return virtualFileArray;
    }

    public boolean belongs(@NotNull String url) {
        if (url == null) {
            CompositeScope.$$$reportNull$$$0(5);
        }
        for (CompileScope scope : this.myScopes) {
            if (!scope.belongs(url)) continue;
            return true;
        }
        return false;
    }

    public Module @NotNull [] getAffectedModules() {
        HashSet modules = new HashSet();
        for (CompileScope compileScope : this.myScopes) {
            ContainerUtil.addAll(modules, (Object[])compileScope.getAffectedModules());
        }
        Module[] moduleArray = modules.toArray(Module.EMPTY_ARRAY);
        if (moduleArray == null) {
            CompositeScope.$$$reportNull$$$0(6);
        }
        return moduleArray;
    }

    public Collection<ModuleSourceSet> getAffectedSourceSets() {
        SmartHashSet sets = new SmartHashSet();
        for (CompileScope scope : this.myScopes) {
            sets.addAll(scope.getAffectedSourceSets());
        }
        return sets;
    }

    @NotNull
    public Collection<String> getAffectedUnloadedModules() {
        LinkedHashSet<String> unloadedModules = new LinkedHashSet<String>();
        for (CompileScope compileScope : this.myScopes) {
            unloadedModules.addAll(compileScope.getAffectedUnloadedModules());
        }
        LinkedHashSet<String> linkedHashSet = unloadedModules;
        if (linkedHashSet == null) {
            CompositeScope.$$$reportNull$$$0(7);
        }
        return linkedHashSet;
    }

    public <T> T getUserData(@NotNull Key<T> key) {
        if (key == null) {
            CompositeScope.$$$reportNull$$$0(8);
        }
        for (CompileScope compileScope : this.myScopes) {
            Object userData = compileScope.getUserData(key);
            if (userData == null) continue;
            return (T)userData;
        }
        return (T)super.getUserData(key);
    }

    @NotNull
    public Collection<CompileScope> getScopes() {
        List<CompileScope> list = Collections.unmodifiableList(this.myScopes);
        if (list == null) {
            CompositeScope.$$$reportNull$$$0(9);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 6, 7, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope1";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope2";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopes";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/compiler/impl/CompositeScope";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/compiler/impl/CompositeScope";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFiles";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAffectedModules";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAffectedUnloadedModules";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getScopes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addScope";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 9: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "belongs";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getUserData";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 6, 7, 9 -> new IllegalStateException(string);
        };
    }
}

