/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl.javaCompiler.eclipse;

import com.intellij.compiler.impl.javaCompiler.eclipse.EclipseCompilerConfigurableUi;
import com.intellij.compiler.options.ComparingUtils;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import javax.swing.JComponent;
import org.jetbrains.jps.model.java.compiler.EclipseCompilerOptions;

public class EclipseCompilerConfigurable
implements Configurable {
    private final Project myProject;
    private EclipseCompilerConfigurableUi myUi;
    private final EclipseCompilerOptions myCompilerSettings;

    public EclipseCompilerConfigurable(Project project, EclipseCompilerOptions options) {
        this.myProject = project;
        this.myCompilerSettings = options;
    }

    public String getDisplayName() {
        return null;
    }

    public JComponent createComponent() {
        this.myUi = new EclipseCompilerConfigurableUi(this.myProject);
        return this.myUi.getPanel();
    }

    public boolean isModified() {
        boolean isModified = false;
        isModified |= ComparingUtils.isModified(this.myUi.deprecationCb, this.myCompilerSettings.DEPRECATION);
        isModified |= ComparingUtils.isModified(this.myUi.debuggingInfoCb, this.myCompilerSettings.DEBUGGING_INFO);
        isModified |= ComparingUtils.isModified(this.myUi.generateNoWarningsCb, this.myCompilerSettings.GENERATE_NO_WARNINGS);
        isModified |= ComparingUtils.isModified(this.myUi.proceedOnErrorsCb, this.myCompilerSettings.PROCEED_ON_ERROR);
        isModified |= ComparingUtils.isModified(this.myUi.pathToEcjField, FileUtil.toSystemDependentName((String)this.myCompilerSettings.ECJ_TOOL_PATH));
        isModified |= ComparingUtils.isModified(this.myUi.additionalOptionsField, this.myCompilerSettings.ADDITIONAL_OPTIONS_STRING);
        return isModified |= !this.myUi.optionsOverrideComponent.getModuleOptionsMap().equals(this.myCompilerSettings.ADDITIONAL_OPTIONS_OVERRIDE);
    }

    public void apply() throws ConfigurationException {
        this.myCompilerSettings.DEPRECATION = this.myUi.deprecationCb.isSelected();
        this.myCompilerSettings.DEBUGGING_INFO = this.myUi.debuggingInfoCb.isSelected();
        this.myCompilerSettings.GENERATE_NO_WARNINGS = this.myUi.generateNoWarningsCb.isSelected();
        this.myCompilerSettings.PROCEED_ON_ERROR = this.myUi.proceedOnErrorsCb.isSelected();
        this.myCompilerSettings.ECJ_TOOL_PATH = FileUtil.toSystemIndependentName((String)this.myUi.pathToEcjField.getText().trim());
        this.myCompilerSettings.ADDITIONAL_OPTIONS_STRING = this.myUi.additionalOptionsField.getText();
        this.myCompilerSettings.ADDITIONAL_OPTIONS_OVERRIDE.clear();
        this.myCompilerSettings.ADDITIONAL_OPTIONS_OVERRIDE.putAll(this.myUi.optionsOverrideComponent.getModuleOptionsMap());
    }

    public void reset() {
        this.myUi.deprecationCb.setSelected(this.myCompilerSettings.DEPRECATION);
        this.myUi.debuggingInfoCb.setSelected(this.myCompilerSettings.DEBUGGING_INFO);
        this.myUi.generateNoWarningsCb.setSelected(this.myCompilerSettings.GENERATE_NO_WARNINGS);
        this.myUi.proceedOnErrorsCb.setSelected(this.myCompilerSettings.PROCEED_ON_ERROR);
        this.myUi.pathToEcjField.setText(FileUtil.toSystemDependentName((String)this.myCompilerSettings.ECJ_TOOL_PATH));
        this.myUi.additionalOptionsField.setText(this.myCompilerSettings.ADDITIONAL_OPTIONS_STRING);
        this.myUi.optionsOverrideComponent.setModuleOptionsMap(this.myCompilerSettings.ADDITIONAL_OPTIONS_OVERRIDE);
    }

    public void disposeUIResources() {
        this.myUi = null;
    }
}

