/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl.javaCompiler.javac;

import com.intellij.application.options.CodeStyle;
import com.intellij.compiler.OutputParser;
import com.intellij.compiler.impl.javaCompiler.javac.FilePathActionJavac;
import com.intellij.compiler.impl.javaCompiler.javac.JavacParserAction;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.compiler.JavaCompilerBundle;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavacOutputParser
extends OutputParser {
    private final int myTabSize;
    @NonNls
    private String WARNING_PREFIX = "warning:";

    public JavacOutputParser(Project project) {
        this.myTabSize = CodeStyle.getSettings((Project)project).getTabSize((FileType)JavaFileType.INSTANCE);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.addJavacPattern("MSG_PARSING_STARTED=[parsing started {0}]");
            this.addJavacPattern("MSG_PARSING_COMPLETED=[parsing completed {0}ms]");
            this.addJavacPattern("MSG_LOADING=[loading {0}]");
            this.addJavacPattern("MSG_CHECKING=[checking {0}]");
            this.addJavacPattern("MSG_WROTE=[wrote {0}]");
        }
    }

    @Override
    public boolean processMessageLine(OutputParser.Callback callback) {
        if (super.processMessageLine(callback)) {
            return true;
        }
        String line = callback.getCurrentLine();
        if (line == null) {
            return false;
        }
        if ("__patterns_start".equals(line)) {
            String patternLine;
            this.myParserActions.clear();
            while (!"__patterns_end".equals(patternLine = callback.getNextLine())) {
                this.addJavacPattern(patternLine);
            }
            return true;
        }
        int colonIndex1 = line.indexOf(58);
        if (colonIndex1 == 1) {
            colonIndex1 = line.indexOf(58, colonIndex1 + 1);
        }
        if (colonIndex1 >= 0) {
            @NonNls String part1 = line.substring(0, colonIndex1).trim();
            if (part1.equalsIgnoreCase("error") || part1.equalsIgnoreCase("Caused by")) {
                JavacOutputParser.addMessage(callback, CompilerMessageCategory.ERROR, line.substring(colonIndex1));
                return true;
            }
            if (part1.equalsIgnoreCase("warning")) {
                JavacOutputParser.addMessage(callback, CompilerMessageCategory.WARNING, line.substring(colonIndex1));
                return true;
            }
            if (part1.equals("javac")) {
                JavacOutputParser.addMessage(callback, CompilerMessageCategory.ERROR, line);
                return true;
            }
            int colonIndex2 = line.indexOf(58, colonIndex1 + 1);
            if (colonIndex2 >= 0) {
                String filePath = part1.replace(File.separatorChar, '/');
                Boolean fileExists = (Boolean)ReadAction.compute(() -> LocalFileSystem.getInstance().findFileByPath(filePath) != null);
                if (!fileExists.booleanValue()) {
                    return true;
                }
                try {
                    int colNum;
                    int lineNum = Integer.parseInt(line.substring(colonIndex1 + 1, colonIndex2).trim());
                    String message = line.substring(colonIndex2 + 1).trim();
                    CompilerMessageCategory category = CompilerMessageCategory.ERROR;
                    if (message.startsWith(this.WARNING_PREFIX)) {
                        message = message.substring(this.WARNING_PREFIX.length()).trim();
                        category = CompilerMessageCategory.WARNING;
                    }
                    ArrayList<String> messages = new ArrayList<String>();
                    messages.add(message);
                    String prevLine = null;
                    while (true) {
                        String nextLine;
                        if ((nextLine = callback.getNextLine()) == null) {
                            return false;
                        }
                        if (nextLine.trim().equals("^")) {
                            String chars = prevLine == null ? line : prevLine;
                            int offset = Math.max(0, Math.min(chars.length(), nextLine.indexOf(94)));
                            colNum = EditorUtil.calcColumnNumber(null, (CharSequence)chars, (int)0, (int)offset, (int)this.myTabSize);
                            String messageEnd = callback.getNextLine();
                            while (JavacOutputParser.isMessageEnd(messageEnd)) {
                                messages.add(messageEnd.trim());
                                messageEnd = callback.getNextLine();
                            }
                            if (messageEnd == null) break;
                            callback.pushBack(messageEnd);
                            break;
                        }
                        if (prevLine != null) {
                            messages.add(prevLine);
                        }
                        prevLine = nextLine;
                    }
                    if (colNum >= 0) {
                        JavacOutputParser.convertMessages(messages);
                        String text = StringUtil.join(messages, (String)"\n");
                        JavacOutputParser.addMessage(callback, category, text, VirtualFileManager.constructUrl((String)"file", (String)filePath), lineNum, colNum + 1);
                        return true;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        if (line.endsWith("java.lang.OutOfMemoryError")) {
            JavacOutputParser.addMessage(callback, CompilerMessageCategory.ERROR, JavaCompilerBundle.message((String)"error.javac.out.of.memory", (Object[])new Object[0]));
            return true;
        }
        JavacOutputParser.addMessage(callback, CompilerMessageCategory.INFORMATION, line);
        return true;
    }

    private static boolean isMessageEnd(String line) {
        return line != null && !line.isEmpty() && Character.isWhitespace(line.charAt(0));
    }

    private static void convertMessages(@NotNull List<String> messages) {
        String part1;
        if (messages == null) {
            JavacOutputParser.$$$reportNull$$$0(0);
        }
        if (messages.size() <= 1) {
            return;
        }
        String line0 = messages.get(0);
        String line1 = messages.get(1);
        int colonIndex = line1.indexOf(58);
        if (colonIndex > 0 && "symbol".equals(part1 = line1.substring(0, colonIndex).trim())) {
            String symbol = line1.substring(colonIndex + 1).trim();
            messages.remove(1);
            if (messages.size() >= 2) {
                messages.remove(1);
            }
            messages.set(0, line0 + " " + symbol);
        }
    }

    private void addJavacPattern(@NonNls String line) {
        int dividerIndex = line.indexOf("=");
        if (dividerIndex < 0) {
            return;
        }
        String category = line.substring(0, dividerIndex);
        String resourceBundleValue = line.substring(dividerIndex + 1);
        switch (category) {
            case "MSG_PARSING_COMPLETED": 
            case "MSG_PARSING_STARTED": 
            case "MSG_WROTE": {
                this.myParserActions.add(new FilePathActionJavac(JavacOutputParser.createMatcher(resourceBundleValue)));
                break;
            }
            case "MSG_CHECKING": {
                this.myParserActions.add(new JavacParserAction(this, JavacOutputParser.createMatcher(resourceBundleValue)){

                    @Override
                    protected void doExecute(String line, String parsedData, OutputParser.Callback callback) {
                        callback.setProgressText(JavaCompilerBundle.message((String)"progress.compiling.class", (Object[])new Object[]{parsedData}));
                    }
                });
                break;
            }
            case "MSG_LOADING": {
                this.myParserActions.add(new JavacParserAction(this, JavacOutputParser.createMatcher(resourceBundleValue)){

                    @Override
                    protected void doExecute(String line, @Nullable String parsedData, OutputParser.Callback callback) {
                        callback.setProgressText(JavaCompilerBundle.message((String)"progress.loading.classes", (Object[])new Object[0]));
                    }
                });
                break;
            }
            case "MSG_NOTE": {
                this.myParserActions.add(new JavacParserAction(this, JavacOutputParser.createMatcher(resourceBundleValue)){

                    @Override
                    protected void doExecute(String line, @Nullable String filePath, OutputParser.Callback callback) {
                        boolean fileExists;
                        boolean bl = fileExists = filePath != null && (Boolean)ReadAction.compute(() -> LocalFileSystem.getInstance().findFileByPath(filePath) != null) != false;
                        if (fileExists) {
                            JavacOutputParser.addMessage(callback, CompilerMessageCategory.WARNING, line, VirtualFileManager.constructUrl((String)"file", (String)filePath), -1, -1);
                        } else {
                            JavacOutputParser.addMessage(callback, CompilerMessageCategory.INFORMATION, line);
                        }
                    }
                });
                break;
            }
            case "MSG_WARNING": {
                this.WARNING_PREFIX = resourceBundleValue;
                break;
            }
            case "MSG_STATISTICS": 
            case "MSG_IGNORED": {
                this.myParserActions.add(new JavacParserAction(this, JavacOutputParser.createMatcher(resourceBundleValue)){

                    @Override
                    protected void doExecute(String line, @Nullable String parsedData, OutputParser.Callback callback) {
                    }
                });
            }
        }
    }

    public static Matcher createMatcher(@NonNls String resourceBundleValue) {
        @NonNls String regexp = resourceBundleValue.replaceAll("([\\[\\]\\(\\)\\.\\*])", "\\\\$1");
        regexp = regexp.replaceAll("\\{\\d+\\}", "(.+)");
        return Pattern.compile(regexp, 2).matcher("");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messages", "com/intellij/compiler/impl/javaCompiler/javac/JavacOutputParser", "convertMessages"));
    }
}

