/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.options;

import com.intellij.build.FileNavigatable;
import com.intellij.compiler.options.ValidationConfiguration;
import com.intellij.java.JavaPluginDisposable;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.compiler.JavaCompilerBundle;
import com.intellij.openapi.compiler.options.ExcludeEntryDescription;
import com.intellij.openapi.compiler.options.ExcludesConfiguration;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import java.lang.runtime.SwitchBootstraps;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExcludeFromValidationAction
extends AnAction {
    public ExcludeFromValidationAction() {
        super(JavaCompilerBundle.messagePointer((String)"action.name.exclude.from.validation", (Object[])new Object[0]));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            ExcludeFromValidationAction.$$$reportNull$$$0(0);
        }
        if ((project = (Project)e.getData(CommonDataKeys.PROJECT)) == null) {
            return;
        }
        Pair<ExcludesConfiguration, VirtualFile> pair = ExcludeFromValidationAction.getExcludedConfigurationAndFile(e, project);
        if (pair == null) {
            return;
        }
        ExcludeEntryDescription description = new ExcludeEntryDescription((VirtualFile)pair.getSecond(), false, true, (Disposable)JavaPluginDisposable.getInstance((Project)project));
        ((ExcludesConfiguration)pair.getFirst()).addExcludeEntryDescription(description);
    }

    @Nullable
    private static Pair<ExcludesConfiguration, VirtualFile> getExcludedConfigurationAndFile(AnActionEvent event, Project project) {
        Navigatable navigatable = (Navigatable)event.getData(CommonDataKeys.NAVIGATABLE);
        if (project == null) {
            return null;
        }
        VirtualFile file = ExcludeFromValidationAction.getTargetFile(navigatable);
        if (file == null) {
            return null;
        }
        ExcludesConfiguration configuration = ValidationConfiguration.getExcludedEntriesConfiguration(project);
        return Pair.create((Object)configuration, (Object)file);
    }

    @Nullable
    public static VirtualFile getTargetFile(@Nullable Navigatable navigatable) {
        Navigatable navigatable2 = navigatable;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{OpenFileDescriptor.class, FileNavigatable.class}, (Object)navigatable2, n)) {
            case 0 -> {
                OpenFileDescriptor descriptor = (OpenFileDescriptor)navigatable2;
                yield descriptor.getFile();
            }
            case 1 -> {
                FileNavigatable fileNavigatable = (FileNavigatable)navigatable2;
                OpenFileDescriptor fileDescriptor = fileNavigatable.getFileDescriptor();
                if (fileDescriptor != null) {
                    yield fileDescriptor.getFile();
                }
                yield null;
            }
            default -> null;
        };
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            ExcludeFromValidationAction.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            ExcludeFromValidationAction.$$$reportNull$$$0(2);
        }
        boolean applicable = ExcludeFromValidationAction.getExcludedConfigurationAndFile(e, project = e.getProject()) != null;
        e.getPresentation().setEnabledAndVisible(applicable);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/compiler/options/ExcludeFromValidationAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/compiler/options/ExcludeFromValidationAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

