/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.options;

import com.intellij.compiler.CompilerConfiguration;
import com.intellij.compiler.CompilerConfigurationImpl;
import com.intellij.compiler.impl.javaCompiler.BackendCompiler;
import com.intellij.compiler.options.JavaCompilersTabUi;
import com.intellij.compiler.server.BuildManager;
import com.intellij.openapi.compiler.JavaCompilerBundle;
import com.intellij.openapi.options.CompositeConfigurable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class JavaCompilersTab
extends CompositeConfigurable<Configurable>
implements SearchableConfigurable {
    private JavaCompilersTabUi myUi;
    private final Project myProject;
    private final CompilerConfigurationImpl myCompilerConfiguration;
    private final BackendCompiler myDefaultCompiler;
    private final Collection<BackendCompiler> myCompilers;
    private final List<Configurable> myConfigurables;
    private BackendCompiler mySelectedCompiler;

    public JavaCompilersTab(@NotNull Project project) {
        if (project == null) {
            JavaCompilersTab.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myCompilerConfiguration = (CompilerConfigurationImpl)CompilerConfiguration.getInstance((Project)project);
        this.myDefaultCompiler = this.myCompilerConfiguration.getDefaultCompiler();
        this.myCompilers = this.myCompilerConfiguration.getRegisteredJavaCompilers();
        this.myConfigurables = new ArrayList<Configurable>(this.myCompilers.size());
    }

    public String getDisplayName() {
        return JavaCompilerBundle.message((String)"java.compiler.description", (Object[])new Object[0]);
    }

    @NotNull
    public String getHelpTopic() {
        return "reference.projectsettings.compiler.javacompiler";
    }

    @NotNull
    public String getId() {
        String string = this.getHelpTopic();
        if (string == null) {
            JavaCompilersTab.$$$reportNull$$$0(1);
        }
        return string;
    }

    public JComponent createComponent() {
        this.myUi = new JavaCompilersTabUi(this.myProject, this.myCompilers, configurable -> this.myConfigurables.add((Configurable)configurable), compiler -> this.selectCompiler((BackendCompiler)compiler));
        return this.myUi.getPanel();
    }

    public boolean isModified() {
        return !Comparing.equal((Object)this.mySelectedCompiler, (Object)this.myCompilerConfiguration.getDefaultCompiler()) || this.myUi.useReleaseOptionCb.isSelected() != this.myCompilerConfiguration.useReleaseOption() || !Objects.equals(this.myUi.targetOptionsComponent.getProjectBytecodeTarget(), this.myCompilerConfiguration.getProjectBytecodeTarget()) || !Comparing.equal(this.myUi.targetOptionsComponent.getModulesBytecodeTargetMap(), this.myCompilerConfiguration.getModulesBytecodeTargetMap()) || super.isModified();
    }

    public void apply() throws ConfigurationException {
        try {
            this.myCompilerConfiguration.setDefaultCompiler(this.mySelectedCompiler);
            this.myCompilerConfiguration.setUseReleaseOption(this.myUi.useReleaseOptionCb.isSelected());
            this.myCompilerConfiguration.setProjectBytecodeTarget(this.myUi.targetOptionsComponent.getProjectBytecodeTarget());
            this.myCompilerConfiguration.setModulesBytecodeTargetMap(this.myUi.targetOptionsComponent.getModulesBytecodeTargetMap());
            super.apply();
            this.myUi.targetOptionsComponent.setProjectBytecodeTargetLevel(this.myCompilerConfiguration.getProjectBytecodeTarget());
            this.myUi.targetOptionsComponent.setModuleTargetLevels(this.myCompilerConfiguration.getModulesBytecodeTargetMap());
        }
        finally {
            if (!this.myProject.isDefault()) {
                BuildManager.getInstance().clearState(this.myProject);
            }
            PsiManager.getInstance((Project)this.myProject).dropPsiCaches();
        }
    }

    public void reset() {
        super.reset();
        this.selectCompiler(this.myCompilerConfiguration.getDefaultCompiler());
        this.myUi.useReleaseOptionCb.setSelected(this.myCompilerConfiguration.useReleaseOption());
        this.myUi.targetOptionsComponent.setProjectBytecodeTargetLevel(this.myCompilerConfiguration.getProjectBytecodeTarget());
        this.myUi.targetOptionsComponent.setModuleTargetLevels(this.myCompilerConfiguration.getModulesBytecodeTargetMap());
    }

    private void selectCompiler(BackendCompiler compiler) {
        if (compiler == null) {
            compiler = this.myDefaultCompiler;
        }
        this.myUi.compilerComboBox.setSelectedItem((Object)compiler);
        this.mySelectedCompiler = compiler;
        this.myUi.show(compiler.getId());
    }

    @NotNull
    protected List<Configurable> createConfigurables() {
        List<Configurable> list = this.myConfigurables;
        if (list == null) {
            JavaCompilersTab.$$$reportNull$$$0(2);
        }
        return list;
    }

    public void disposeUIResources() {
        this.myUi = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/compiler/options/JavaCompilersTab";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/compiler/options/JavaCompilersTab";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createConfigurables";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

