/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.server;

import com.intellij.compiler.CompilerMessageImpl;
import com.intellij.compiler.ProblemsView;
import com.intellij.compiler.impl.BuildUsageCollector;
import com.intellij.compiler.impl.CompileDriver;
import com.intellij.compiler.server.AutomakeCompileContext;
import com.intellij.compiler.server.DefaultMessageHandler;
import com.intellij.notification.Notification;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.compiler.CompilationStatusListener;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.compiler.CompilerMessage;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.compiler.CompilerTopics;
import com.intellij.openapi.compiler.JavaCompilerBundle;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.problems.Problem;
import com.intellij.problems.WolfTheProblemSolver;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.api.CmdlineRemoteProto;

final class AutoMakeMessageHandler
extends DefaultMessageHandler {
    private static final Key<Notification> LAST_AUTO_MAKE_NOTIFICATION = Key.create((String)"LAST_AUTO_MAKE_NOTIFICATION");
    private CmdlineRemoteProto.Message.BuilderMessage.BuildEvent.Status myBuildStatus;
    private final Project myProject;
    private final WolfTheProblemSolver myWolf;
    private volatile boolean myUnprocessedFSChangesDetected;
    private final AutomakeCompileContext myContext;
    private final Map<UUID, Long> myStartStamps;

    AutoMakeMessageHandler(@NotNull Project project) {
        if (project == null) {
            AutoMakeMessageHandler.$$$reportNull$$$0(0);
        }
        super(project);
        this.myUnprocessedFSChangesDetected = false;
        this.myStartStamps = Collections.synchronizedMap(new HashMap());
        this.myProject = project;
        this.myBuildStatus = CmdlineRemoteProto.Message.BuilderMessage.BuildEvent.Status.SUCCESS;
        this.myWolf = WolfTheProblemSolver.getInstance((Project)project);
        this.myContext = new AutomakeCompileContext(project);
        this.myContext.getProgressIndicator().start();
    }

    public boolean unprocessedFSChangesDetected() {
        return this.myUnprocessedFSChangesDetected;
    }

    @Override
    public void buildStarted(@NotNull UUID sessionId) {
        if (sessionId == null) {
            AutoMakeMessageHandler.$$$reportNull$$$0(1);
        }
        this.myStartStamps.put(sessionId, System.currentTimeMillis());
        ProblemsView view = ProblemsView.getInstanceIfCreated(this.myProject);
        if (view != null) {
            view.buildStarted(sessionId);
        }
    }

    @Override
    protected void handleBuildEvent(UUID sessionId, CmdlineRemoteProto.Message.BuilderMessage.BuildEvent event) {
        if (this.myProject.isDisposed()) {
            return;
        }
        switch (event.getEventType()) {
            case BUILD_COMPLETED: {
                this.myContext.getProgressIndicator().stop();
                if (event.hasCompletionStatus()) {
                    CmdlineRemoteProto.Message.BuilderMessage.BuildEvent.Status status = event.getCompletionStatus();
                    this.updateBuildStatus(status);
                    if (status == CmdlineRemoteProto.Message.BuilderMessage.BuildEvent.Status.CANCELED) {
                        this.myContext.getProgressIndicator().cancel();
                    }
                }
                int errors = this.myContext.getMessageCount(CompilerMessageCategory.ERROR);
                int warnings = this.myContext.getMessageCount(CompilerMessageCategory.WARNING);
                SwingUtilities.invokeLater(() -> {
                    if (this.myProject.isDisposed()) {
                        return;
                    }
                    CompilationStatusListener publisher = (CompilationStatusListener)this.myProject.getMessageBus().syncPublisher(CompilerTopics.COMPILATION_STATUS);
                    publisher.automakeCompilationFinished(errors, warnings, (CompileContext)this.myContext);
                });
                break;
            }
            case FILES_GENERATED: {
                CompilationStatusListener publisher = (CompilationStatusListener)this.myProject.getMessageBus().syncPublisher(CompilerTopics.COMPILATION_STATUS);
                for (CmdlineRemoteProto.Message.BuilderMessage.BuildEvent.GeneratedFile generatedFile : event.getGeneratedFilesList()) {
                    String root = FileUtil.toSystemIndependentName((String)generatedFile.getOutputRoot());
                    String relativePath = FileUtil.toSystemIndependentName((String)generatedFile.getRelativePath());
                    publisher.fileGenerated(root, relativePath);
                }
                break;
            }
            case CUSTOM_BUILDER_MESSAGE: {
                CmdlineRemoteProto.Message.BuilderMessage.BuildEvent.CustomBuilderMessage message;
                if (!event.hasCustomBuilderMessage() || !"JPS".equals((message = event.getCustomBuilderMessage()).getBuilderId()) || !"!unprocessed_fs_changes_detected!".equals(message.getMessageType())) break;
                this.myUnprocessedFSChangesDetected = true;
                break;
            }
        }
    }

    @Override
    protected void handleCompileMessage(UUID sessionId, CmdlineRemoteProto.Message.BuilderMessage.CompileMessage message) {
        if (this.myProject.isDisposed()) {
            return;
        }
        CmdlineRemoteProto.Message.BuilderMessage.CompileMessage.Kind kind = message.getKind();
        if (kind == CmdlineRemoteProto.Message.BuilderMessage.CompileMessage.Kind.PROGRESS) {
            ProblemsView view = ProblemsView.getInstance(this.myProject);
            if (message.hasDone()) {
                view.setProgress(message.getText(), message.getDone());
            } else {
                view.setProgress(message.getText());
            }
        } else {
            CompilerMessageCategory category = CompileDriver.convertToCategory(kind, null);
            if (category != null) {
                String sourceFilePath = message.hasSourceFilePath() ? message.getSourceFilePath() : null;
                String url = sourceFilePath != null ? VirtualFileManager.constructUrl((String)"file", (String)FileUtil.toSystemIndependentName((String)sourceFilePath)) : null;
                long line = message.hasLine() ? message.getLine() : -1L;
                long column = message.hasColumn() ? message.getColumn() : -1L;
                CompilerMessage msg = this.myContext.createAndAddMessage(category, message.getText(), url, (int)line, (int)column, null, message.getModuleNamesList());
                if (category == CompilerMessageCategory.ERROR || kind == CmdlineRemoteProto.Message.BuilderMessage.CompileMessage.Kind.JPS_INFO) {
                    if (category == CompilerMessageCategory.ERROR) {
                        ReadAction.run(() -> this.informWolf(message));
                    }
                    if (msg != null) {
                        ProblemsView.getInstance(this.myProject).addMessage(msg, sessionId);
                    }
                }
            }
        }
    }

    @Override
    public void handleFailure(@NotNull UUID sessionId, CmdlineRemoteProto.Message.Failure failure) {
        String descr;
        if (sessionId == null) {
            AutoMakeMessageHandler.$$$reportNull$$$0(2);
        }
        this.updateBuildStatus(CmdlineRemoteProto.Message.BuilderMessage.BuildEvent.Status.ERRORS);
        if (this.myProject.isDisposed()) {
            return;
        }
        String string = descr = failure.hasDescription() ? failure.getDescription() : null;
        if (descr == null) {
            descr = failure.hasStacktrace() ? failure.getStacktrace() : "";
        }
        String msg = JavaCompilerBundle.message((String)"notification.compiler.auto.build.failure", (Object[])new Object[]{descr});
        CompilerManager.getNotificationGroup().createNotification(msg, MessageType.INFO).notify(this.myProject);
        ProblemsView.getInstance(this.myProject).addMessage(new CompilerMessageImpl(this.myProject, CompilerMessageCategory.ERROR, msg), sessionId);
    }

    @Override
    public void sessionTerminated(@NotNull UUID sessionId) {
        ProblemsView view;
        if (sessionId == null) {
            AutoMakeMessageHandler.$$$reportNull$$$0(3);
        }
        String statusMessage = null;
        switch (this.myBuildStatus) {
            case SUCCESS: {
                Long startStamp = this.myStartStamps.remove(sessionId);
                if (startStamp == null) break;
                BuildUsageCollector.logBuildCompleted(Math.abs(System.currentTimeMillis() - startStamp), false, true);
                break;
            }
            case UP_TO_DATE: {
                break;
            }
            case ERRORS: {
                statusMessage = JavaCompilerBundle.message((String)"notification.compiler.auto.build.completed.with.errors", (Object[])new Object[0]);
                break;
            }
        }
        if (statusMessage != null) {
            notification = CompilerManager.getNotificationGroup().createNotification(statusMessage, MessageType.INFO);
            if (!this.myProject.isDisposed()) {
                notification.notify(this.myProject);
            }
            this.myProject.putUserData(LAST_AUTO_MAKE_NOTIFICATION, (Object)notification);
        } else {
            notification = (Notification)this.myProject.getUserData(LAST_AUTO_MAKE_NOTIFICATION);
            if (notification != null) {
                notification.expire();
                this.myProject.putUserData(LAST_AUTO_MAKE_NOTIFICATION, null);
            }
        }
        if (!this.myProject.isDisposed() && (view = ProblemsView.getInstanceIfCreated(this.myProject)) != null) {
            view.clearProgress();
            view.clearOldMessages(null, sessionId);
        }
    }

    @Override
    @NotNull
    public ProgressIndicator getProgressIndicator() {
        ProgressIndicator progressIndicator = this.myContext.getProgressIndicator();
        if (progressIndicator == null) {
            AutoMakeMessageHandler.$$$reportNull$$$0(4);
        }
        return progressIndicator;
    }

    private void informWolf(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull CmdlineRemoteProto.Message.BuilderMessage.CompileMessage message) {
        VirtualFile vFile;
        String srcPath;
        if (message == null) {
            AutoMakeMessageHandler.$$$reportNull$$$0(5);
        }
        if ((srcPath = message.getSourceFilePath()) != null && !this.myProject.isDisposed() && (vFile = LocalFileSystem.getInstance().findFileByPath(srcPath)) != null) {
            int line = (int)message.getLine();
            int column = (int)message.getColumn();
            if (line > 0 && column > 0) {
                Problem problem = this.myWolf.convertToProblem(vFile, line, column, new String[]{message.getText()});
                this.myWolf.weHaveGotProblems(vFile, Collections.singletonList(problem));
            } else {
                this.myWolf.queue(vFile);
            }
        }
    }

    private void updateBuildStatus(CmdlineRemoteProto.Message.BuilderMessage.BuildEvent.Status status) {
        switch (this.myBuildStatus) {
            case ERRORS: {
                if (!CmdlineRemoteProto.Message.BuilderMessage.BuildEvent.Status.CANCELED.equals((Object)status)) break;
                this.myBuildStatus = status;
                break;
            }
            case CANCELED: {
                break;
            }
            default: {
                this.myBuildStatus = status;
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sessionId";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/compiler/server/AutoMakeMessageHandler";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/compiler/server/AutoMakeMessageHandler";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProgressIndicator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildStarted";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "handleFailure";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "sessionTerminated";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "informWolf";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

