/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.server;

import com.intellij.compiler.server.BuilderMessageHandler;
import com.intellij.compiler.server.DelegatingMessageHandler;
import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.concurrency.ThreadContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.concurrency.ChildContext;
import com.intellij.util.concurrency.Propagation;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.AttributeKey;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.SimpleChannelInboundHandlerAdapter;
import org.jetbrains.jps.api.CmdlineProtoUtil;
import org.jetbrains.jps.api.CmdlineRemoteProto;
import org.jetbrains.jps.api.RequestFuture;

@ChannelHandler.Sharable
class BuildMessageDispatcher
extends SimpleChannelInboundHandlerAdapter<CmdlineRemoteProto.Message> {
    private static final Logger LOG = Logger.getInstance(BuildMessageDispatcher.class);
    private final Map<UUID, SessionData> mySessionDescriptors = new ConcurrentHashMap<UUID, SessionData>(16, 0.75f, 1);
    private final Set<UUID> myCanceledSessions = ConcurrentCollectionFactory.createConcurrentSet();

    BuildMessageDispatcher() {
    }

    public void registerBuildMessageHandler(final @NotNull RequestFuture<? extends BuilderMessageHandler> future, @Nullable CmdlineRemoteProto.Message.ControllerMessage params) {
        if (future == null) {
            BuildMessageDispatcher.$$$reportNull$$$0(0);
        }
        DelegatingMessageHandler wrappedHandler = new DelegatingMessageHandler(this){

            @Override
            protected BuilderMessageHandler getDelegateHandler() {
                return (BuilderMessageHandler)future.getMessageHandler();
            }

            @Override
            public void sessionTerminated(@NotNull UUID sessionId) {
                if (sessionId == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    super.sessionTerminated(sessionId);
                }
                finally {
                    future.setDone();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sessionId", "com/intellij/compiler/server/BuildMessageDispatcher$1", "sessionTerminated"));
            }
        };
        UUID sessionId = future.getRequestID();
        this.mySessionDescriptors.put(sessionId, new SessionData(sessionId, wrappedHandler, params));
    }

    @Nullable
    public BuilderMessageHandler unregisterBuildMessageHandler(UUID sessionId) {
        this.myCanceledSessions.remove(sessionId);
        SessionData data = this.mySessionDescriptors.remove(sessionId);
        if (data == null) {
            return null;
        }
        Channel channel = data.channel;
        if (channel != null) {
            channel.attr(Holder.SESSION_DATA).set(null);
        }
        return data.handler;
    }

    public void cancelSession(UUID sessionId) {
        Channel channel;
        if (this.myCanceledSessions.add(sessionId) && (channel = this.getConnectedChannel(sessionId)) != null) {
            channel.writeAndFlush((Object)CmdlineProtoUtil.toMessage((UUID)sessionId, (CmdlineRemoteProto.Message.ControllerMessage)CmdlineProtoUtil.createCancelCommand()));
        }
    }

    @Nullable
    public Channel getConnectedChannel(@NotNull UUID sessionId) {
        Channel channel;
        if (sessionId == null) {
            BuildMessageDispatcher.$$$reportNull$$$0(1);
        }
        return (channel = this.getAssociatedChannel(sessionId)) != null && channel.isActive() ? channel : null;
    }

    @Nullable
    public Channel getAssociatedChannel(@NotNull UUID sessionId) {
        SessionData data;
        if (sessionId == null) {
            BuildMessageDispatcher.$$$reportNull$$$0(2);
        }
        return (data = this.mySessionDescriptors.get(sessionId)) != null ? data.channel : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendBuildParameters(@NotNull UUID preloadedSessionId, @NotNull CmdlineRemoteProto.Message.ControllerMessage params) {
        if (preloadedSessionId == null) {
            BuildMessageDispatcher.$$$reportNull$$$0(3);
        }
        if (params == null) {
            BuildMessageDispatcher.$$$reportNull$$$0(4);
        }
        boolean succeeded = false;
        SessionData sessionData = this.mySessionDescriptors.get(preloadedSessionId);
        if (sessionData != null) {
            SessionData sessionData2 = sessionData;
            synchronized (sessionData2) {
                if (sessionData.state == SessionData.State.WAITING_PARAMS) {
                    sessionData.state = SessionData.State.RUNNING;
                    Channel channel = sessionData.channel;
                    if (channel != null && channel.isActive()) {
                        sessionData.handler.buildStarted(preloadedSessionId);
                        channel.writeAndFlush((Object)CmdlineProtoUtil.toMessage((UUID)preloadedSessionId, (CmdlineRemoteProto.Message.ControllerMessage)params));
                        succeeded = true;
                    }
                } else if (sessionData.state == SessionData.State.INITIAL) {
                    sessionData.params = params;
                    succeeded = true;
                }
            }
        }
        return succeeded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void messageReceived(ChannelHandlerContext context, CmdlineRemoteProto.Message message) {
        UUID sessionId;
        boolean isFirstMessage;
        SessionData sessionData = (SessionData)context.channel().attr(Holder.SESSION_DATA).get();
        boolean bl = isFirstMessage = sessionData == null;
        if (isFirstMessage) {
            CmdlineRemoteProto.Message.UUID id = message.getSessionId();
            sessionId = new UUID(id.getMostSigBits(), id.getLeastSigBits());
            sessionData = this.mySessionDescriptors.get(sessionId);
            if (sessionData != null) {
                sessionData.channel = context.channel();
                context.channel().attr(Holder.SESSION_DATA).set((Object)sessionData);
            }
        } else {
            sessionId = sessionData.sessionId;
        }
        BuilderMessageHandler handler = sessionData != null ? sessionData.handler : null;
        try {
            if (handler == null) {
                if (BuildMessageDispatcher.isBuilderEvent(message)) return;
                LOG.info("No message handler registered for session " + String.valueOf(sessionId));
                return;
            }
            CmdlineRemoteProto.Message.Type messageType = message.getType();
            switch (messageType) {
                case FAILURE: {
                    handler.handleFailure(sessionId, message.getFailure());
                    return;
                }
                case BUILDER_MESSAGE: {
                    CmdlineRemoteProto.Message.BuilderMessage builderMessage = message.getBuilderMessage();
                    CmdlineRemoteProto.Message.BuilderMessage.Type msgType = builderMessage.getType();
                    if (msgType == CmdlineRemoteProto.Message.BuilderMessage.Type.PARAM_REQUEST) {
                        SessionData sessionData2 = sessionData;
                        synchronized (sessionData2) {
                            CmdlineRemoteProto.Message.ControllerMessage params = sessionData.params;
                            if (params != null) {
                                sessionData.state = SessionData.State.RUNNING;
                                handler.buildStarted(sessionId);
                                sessionData.params = null;
                                context.writeAndFlush((Object)CmdlineProtoUtil.toMessage((UUID)sessionId, (CmdlineRemoteProto.Message.ControllerMessage)params));
                            } else if (sessionData.state == SessionData.State.INITIAL) {
                                sessionData.state = SessionData.State.WAITING_PARAMS;
                            } else {
                                this.cancelSession(sessionId);
                            }
                            return;
                        }
                    }
                    handler.handleBuildMessage(context.channel(), sessionId, builderMessage);
                    return;
                }
                default: {
                    LOG.info("Unsupported message type " + String.valueOf(messageType));
                    return;
                }
            }
        }
        finally {
            if (isFirstMessage && this.myCanceledSessions.contains(sessionId) || handler == null && !BuildMessageDispatcher.isBuilderEvent(message)) {
                context.channel().writeAndFlush((Object)CmdlineProtoUtil.toMessage((UUID)sessionId, (CmdlineRemoteProto.Message.ControllerMessage)CmdlineProtoUtil.createCancelCommand()));
            }
        }
    }

    private static boolean isBuilderEvent(CmdlineRemoteProto.Message message) {
        return message.hasBuilderMessage() && message.getBuilderMessage().getType() == CmdlineRemoteProto.Message.BuilderMessage.Type.BUILD_EVENT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelInactive(ChannelHandlerContext context) throws Exception {
        BuilderMessageHandler handler;
        try {
            super.channelInactive(context);
        }
        catch (Throwable throwable) {
            BuilderMessageHandler handler2;
            SessionData sessionData = (SessionData)context.channel().attr(Holder.SESSION_DATA).get();
            if (sessionData != null && (handler2 = this.unregisterBuildMessageHandler(sessionData.sessionId)) != null) {
                handler2.sessionTerminated(sessionData.sessionId);
            }
            throw throwable;
        }
        SessionData sessionData = (SessionData)context.channel().attr(Holder.SESSION_DATA).get();
        if (sessionData != null && (handler = this.unregisterBuildMessageHandler(sessionData.sessionId)) != null) {
            handler.sessionTerminated(sessionData.sessionId);
        }
    }

    public void exceptionCaught(ChannelHandlerContext context, Throwable cause) {
        if (cause != null) {
            LOG.info(cause);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "future";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sessionId";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preloadedSessionId";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
        }
        objectArray2[1] = "com/intellij/compiler/server/BuildMessageDispatcher";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "registerBuildMessageHandler";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getConnectedChannel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getAssociatedChannel";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "sendBuildParameters";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class SessionData {
        @NotNull
        final UUID sessionId;
        @NotNull
        final BuilderMessageHandler handler;
        volatile CmdlineRemoteProto.Message.ControllerMessage params;
        volatile Channel channel;
        State state;

        private SessionData(@NotNull UUID sessionId, @NotNull BuilderMessageHandler handler, CmdlineRemoteProto.Message.ControllerMessage params) {
            if (sessionId == null) {
                SessionData.$$$reportNull$$$0(0);
            }
            if (handler == null) {
                SessionData.$$$reportNull$$$0(1);
            }
            this.state = State.INITIAL;
            this.sessionId = sessionId;
            this.handler = new ContextAwareBuilderMessageHandler(handler);
            this.params = params;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "sessionId";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "handler";
                    break;
                }
            }
            objectArray[1] = "com/intellij/compiler/server/BuildMessageDispatcher$SessionData";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        static enum State {
            INITIAL,
            WAITING_PARAMS,
            RUNNING;

        }

        private static class ContextAwareBuilderMessageHandler
        implements BuilderMessageHandler {
            private final BuilderMessageHandler myDelegate;
            @NotNull
            private final ChildContext myCapturedContext;

            private ContextAwareBuilderMessageHandler(BuilderMessageHandler delegate) {
                this.myDelegate = delegate;
                this.myCapturedContext = Propagation.createChildContext((String)BuildMessageDispatcher.class.getSimpleName());
            }

            @Override
            public void buildStarted(@NotNull UUID sessionId) {
                if (sessionId == null) {
                    ContextAwareBuilderMessageHandler.$$$reportNull$$$0(0);
                }
                ThreadContext.resetThreadContext(() -> {
                    this.myCapturedContext.runInChildContext(() -> this.myDelegate.buildStarted(sessionId));
                    return null;
                });
            }

            @Override
            public void handleBuildMessage(Channel channel, UUID sessionId, CmdlineRemoteProto.Message.BuilderMessage msg) {
                ThreadContext.resetThreadContext(() -> {
                    this.myCapturedContext.runInChildContext(() -> this.myDelegate.handleBuildMessage(channel, sessionId, msg));
                    return null;
                });
            }

            @Override
            public void handleFailure(@NotNull UUID sessionId, CmdlineRemoteProto.Message.Failure failure) {
                if (sessionId == null) {
                    ContextAwareBuilderMessageHandler.$$$reportNull$$$0(1);
                }
                ThreadContext.resetThreadContext(() -> {
                    this.myCapturedContext.runInChildContext(() -> this.myDelegate.handleFailure(sessionId, failure));
                    return null;
                });
            }

            @Override
            public void sessionTerminated(@NotNull UUID sessionId) {
                if (sessionId == null) {
                    ContextAwareBuilderMessageHandler.$$$reportNull$$$0(2);
                }
                ThreadContext.resetThreadContext(() -> {
                    this.myCapturedContext.runInChildContext(() -> this.myDelegate.sessionTerminated(sessionId));
                    return null;
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "sessionId";
                objectArray2[1] = "com/intellij/compiler/server/BuildMessageDispatcher$SessionData$ContextAwareBuilderMessageHandler";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "buildStarted";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "handleFailure";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "sessionTerminated";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }

    private static class Holder {
        private static final AttributeKey<SessionData> SESSION_DATA = AttributeKey.valueOf((String)"BuildMessageDispatcher.sessionData");

        private Holder() {
        }
    }
}

