/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.server;

import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\n\u001a\u00020\u000bH\u0007J\u000f\u0010\f\u001a\u0004\u0018\u00010\u0005H\u0002\u00a2\u0006\u0002\u0010\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\t\u00a8\u0006\u000e"}, d2={"Lcom/intellij/compiler/server/CompilerConfigurationUtils;", "", "<init>", "()V", "MINIMUM_NUMBER_OF_CORES", "", "MINIMUM_RAM_SIZE_IN_GIB", "NUMBER_OF_CORES", "RAM_SIZE_IN_GIB", "Ljava/lang/Integer;", "isParallelCompilationAllowedWithCurrentSpecs", "", "getRAMSizeInGiB", "()Ljava/lang/Integer;", "intellij.java.compiler.impl"})
public final class CompilerConfigurationUtils {
    @NotNull
    public static final CompilerConfigurationUtils INSTANCE = new CompilerConfigurationUtils();
    private static final int MINIMUM_NUMBER_OF_CORES = 4;
    private static final int MINIMUM_RAM_SIZE_IN_GIB = 8;
    private static final int NUMBER_OF_CORES = Runtime.getRuntime().availableProcessors();
    @Nullable
    private static final Integer RAM_SIZE_IN_GIB = INSTANCE.getRAMSizeInGiB();

    private CompilerConfigurationUtils() {
    }

    @JvmStatic
    public static final boolean isParallelCompilationAllowedWithCurrentSpecs() {
        return NUMBER_OF_CORES >= 4 && RAM_SIZE_IN_GIB != null && RAM_SIZE_IN_GIB >= 8;
    }

    private final Integer getRAMSizeInGiB() {
        Integer n;
        try {
            java.lang.management.OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
            OperatingSystemMXBean operatingSystemMXBean2 = operatingSystemMXBean instanceof OperatingSystemMXBean ? (OperatingSystemMXBean)operatingSystemMXBean : null;
            if (operatingSystemMXBean2 == null) {
                return null;
            }
            OperatingSystemMXBean bean = operatingSystemMXBean2;
            long ramInBytes = bean.getTotalMemorySize();
            int bytesInGib = 0x40000000;
            n = MathKt.roundToInt((double)((double)ramInBytes / (double)bytesInGib));
        }
        catch (Exception exception) {
            n = null;
        }
        return n;
    }
}

